/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle;

import ru.m210projects.Build.Render.ModelHandle.MDModel.MDAnimation;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDSkinmap;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.filehandle.Entry;

public class MDInfo
extends ModelInfo {
    protected MDSkinmap skinmap;
    protected MDAnimation animations;
    protected String[] frames;
    protected int numframes;

    public MDInfo(Entry file, ModelInfo.Type type) {
        super(file, type);
    }

    public int getFrames() {
        return this.numframes;
    }

    public MDSkinmap getSkins() {
        return this.skinmap;
    }

    public MDAnimation getAnimations() {
        return this.animations;
    }

    public int getFrameIndex(String framename) {
        for (int i = 0; i < this.numframes; ++i) {
            String fr = this.frames[i];
            if (fr == null || !fr.equalsIgnoreCase(framename)) continue;
            return i;
        }
        return -3;
    }

    protected MDSkinmap getSkin(int palnum, int skinnum, int surfnum) {
        MDSkinmap sk = this.skinmap;
        while (sk != null) {
            if (sk.palette == palnum && skinnum == sk.skinnum && surfnum == sk.surfnum) {
                return sk;
            }
            sk = sk.next;
        }
        return null;
    }

    protected void addSkin(MDSkinmap sk) {
        sk.next = this.skinmap;
        this.skinmap = sk;
    }

    public int setSkin(String skinfn, int palnum, int skinnum, int surfnum, double param, double specpower, double specfactor) {
        MDSkinmap sk;
        if (skinfn == null) {
            return -2;
        }
        if (palnum >= 256) {
            return -3;
        }
        if (this.type == ModelInfo.Type.Md2) {
            surfnum = 0;
        }
        if ((sk = this.getSkin(palnum, skinnum, surfnum)) == null) {
            sk = new MDSkinmap();
            this.addSkin(sk);
        }
        sk.palette = palnum;
        sk.skinnum = skinnum;
        sk.surfnum = surfnum;
        sk.param = (float)param;
        sk.specpower = (float)specpower;
        sk.specfactor = (float)specfactor;
        sk.fn = skinfn;
        return 0;
    }

    public int setAnimation(String framestart, String frameend, int fpssc, int flags) {
        MDAnimation ma = new MDAnimation();
        int i = this.getFrameIndex(framestart);
        if (i == this.numframes) {
            return -2;
        }
        ma.startframe = i;
        i = this.getFrameIndex(frameend);
        if (i == this.numframes) {
            return -3;
        }
        ma.endframe = i;
        ma.fpssc = fpssc;
        ma.flags = flags;
        ma.next = this.animations;
        this.animations = ma;
        return 0;
    }
}

