/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.MDModel.MD2;

import java.io.IOException;
import java.io.InputStream;
import ru.m210projects.Build.Render.ModelHandle.MDInfo;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Header;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;

public class MD2Info
extends MDInfo {
    public final MD2Header header;

    public MD2Info(Entry res) throws Exception {
        super(res, ModelInfo.Type.Md2);
        this.header = this.loadHeader(res);
        if (this.header.ident != 844121161 || this.header.version != 8) {
            throw new Exception("Wrong file header IDP2");
        }
        try (InputStream is = res.getInputStream();){
            StreamUtils.skip(is, this.header.offsetFrames);
            this.frames = new String[this.header.numFrames];
            this.numframes = this.header.numFrames;
            for (int i = 0; i < this.header.numFrames; ++i) {
                StreamUtils.skip(is, 24);
                this.frames[i] = StreamUtils.readString(is, 16);
                StreamUtils.skip(is, this.header.numVertices * 4);
            }
        }
    }

    protected MD2Header loadHeader(Entry res) throws IOException {
        try (InputStream is = res.getInputStream();){
            MD2Header header = new MD2Header();
            header.ident = StreamUtils.readInt(is);
            header.version = StreamUtils.readInt(is);
            header.skinWidth = StreamUtils.readInt(is);
            header.skinHeight = StreamUtils.readInt(is);
            header.frameSize = StreamUtils.readInt(is);
            header.numSkins = StreamUtils.readInt(is);
            header.numVertices = StreamUtils.readInt(is);
            header.numTexCoords = StreamUtils.readInt(is);
            header.numTriangles = StreamUtils.readInt(is);
            header.numGLCommands = StreamUtils.readInt(is);
            header.numFrames = StreamUtils.readInt(is);
            header.offsetSkin = StreamUtils.readInt(is);
            header.offsetTexCoords = StreamUtils.readInt(is);
            header.offsetTriangles = StreamUtils.readInt(is);
            header.offsetFrames = StreamUtils.readInt(is);
            header.offsetGLCommands = StreamUtils.readInt(is);
            header.offsetEnd = StreamUtils.readInt(is);
            MD2Header mD2Header = header;
            return mD2Header;
        }
    }
}

