/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.MDModel.MD2;

import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Builder;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Frame;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Triangle;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDModel;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.Render.Types.GL10;

public abstract class MD2ModelGL10
extends MDModel {
    private final ShortBuffer indices;
    private final FloatBuffer vertices;
    private final FloatBuffer uv;
    private final MD2Frame[] frames;
    private final MD2Triangle[] tris;
    private final GL10 gl10;

    protected abstract int bindSkin(int var1, int var2);

    public MD2ModelGL10(GL10 gl10, MD2Info md) throws IOException {
        super(md);
        int j;
        int i;
        this.gl10 = gl10;
        MD2Builder builder = new MD2Builder(md);
        this.frames = builder.frames;
        this.tris = builder.triangles;
        int numTriangles = builder.header.numTriangles;
        this.indices = BufferUtils.newShortBuffer(numTriangles * 3);
        for (i = 0; i < numTriangles; ++i) {
            for (j = 0; j < 3; ++j) {
                this.indices.put((short)(i * 3 + j));
            }
        }
        this.indices.flip();
        this.vertices = BufferUtils.newFloatBuffer(numTriangles * 3 * 3);
        this.uv = BufferUtils.newFloatBuffer(numTriangles * 3 * 2);
        for (i = 0; i < numTriangles; ++i) {
            for (j = 0; j < 3; ++j) {
                short idx = builder.triangles[i].texCoords[j];
                this.uv.put(builder.texCoords[idx][0]);
                this.uv.put(builder.texCoords[idx][1]);
            }
        }
        this.uv.flip();
    }

    @Override
    public boolean render(int pal, int pad1, int skinnum, int pad2, float pad3) {
        boolean isRendered = false;
        int texunits = this.bindSkin(pal, skinnum);
        if (texunits != -1) {
            MD2Frame cframe = this.frames[this.cframe];
            MD2Frame nframe = this.frames[this.nframe];
            this.vertices.clear();
            for (MD2Triangle md2Triangle : this.tris) {
                for (int j = 0; j < 3; ++j) {
                    short idx = md2Triangle.vertices[j];
                    float x = cframe.vertices[idx][0] * this.cScale.x + nframe.vertices[idx][0] * this.nScale.x;
                    float y = cframe.vertices[idx][1] * this.cScale.y + nframe.vertices[idx][1] * this.nScale.y;
                    float z = cframe.vertices[idx][2] * this.cScale.z + nframe.vertices[idx][2] * this.nScale.z;
                    this.vertices.put(x);
                    this.vertices.put(z);
                    this.vertices.put(y);
                }
            }
            this.vertices.flip();
            int l = 33984;
            do {
                this.gl10.glClientActiveTexture(l++);
                this.gl10.glEnableClientState(32888);
                this.gl10.glTexCoordPointer(2, 5126, 0, this.uv);
            } while (l <= texunits);
            this.gl10.glEnableClientState(32884);
            this.gl10.glVertexPointer(3, 5126, 0, this.vertices);
            this.gl10.glDrawElements(4, 0, 5123, this.indices);
            while (texunits > 33984) {
                this.gl10.glMatrixMode(5890);
                this.gl10.glLoadIdentity();
                this.gl10.glMatrixMode(5888);
                this.gl10.glTexEnvf(8960, 34163, 1.0f);
                this.gl10.glDisable(3553);
                this.gl10.glDisableClientState(32888);
                this.gl10.glClientActiveTexture(texunits - 1);
                this.gl10.glActiveTexture(--texunits);
            }
            this.gl10.glDisableClientState(32884);
            isRendered = true;
        }
        if (this.usesalpha) {
            this.gl10.glDisable(3008);
        }
        this.gl10.glDisable(2884);
        this.gl10.glLoadIdentity();
        return isRendered;
    }

    @Override
    public void loadSkins(int pal, int skinnum) {
        this.getSkin(pal, skinnum, 0);
    }

    @Override
    public ModelInfo.Type getType() {
        return ModelInfo.Type.Md2;
    }

    @Override
    public ShaderProgram getShader() {
        return null;
    }
}

