/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.MDModel.MD2;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.badlogic.gdx.utils.ShortArray;
import java.io.IOException;
import java.nio.FloatBuffer;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Builder;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Frame;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Triangle;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDModel;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;

public abstract class MD2ModelGL20
extends MDModel {
    private final Mesh mesh;
    private final MD2Frame[] frames;
    private final MD2Triangle[] tris;
    private float oldinterpol;

    public MD2ModelGL20(MD2Info md) throws IOException {
        super(md);
        MD2Builder builder = new MD2Builder(md);
        this.frames = builder.frames;
        this.tris = builder.triangles;
        int numTriangles = builder.header.numTriangles;
        ShortArray indices = new ShortArray(numTriangles * 3);
        FloatArray vertices = new FloatArray(numTriangles * 3 * 6);
        for (int i = 0; i < numTriangles; ++i) {
            for (int j = 0; j < 3; ++j) {
                indices.add((short)(i * 3 + j));
            }
        }
        MD2Frame cframe = this.frames[this.cframe];
        for (int i = 0; i < this.tris.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                short idx = this.tris[i].vertices[j];
                float x = cframe.vertices[idx][0];
                float y = cframe.vertices[idx][1];
                float z = cframe.vertices[idx][2];
                vertices.add(x);
                vertices.add(z);
                vertices.add(y);
                vertices.add(NumberUtils.intToFloatColor(-1));
                idx = this.tris[i].texCoords[j];
                vertices.add(builder.texCoords[idx][0]);
                vertices.add(builder.texCoords[idx][1]);
            }
        }
        float[] va = vertices.toArray();
        short[] ia = indices.toArray();
        int size = 6;
        this.mesh = new Mesh(this.numframes < 2, va.length / size, ia.length, VertexAttribute.Position(), VertexAttribute.ColorPacked(), VertexAttribute.TexCoords(0));
        this.mesh.setVertices(va);
        this.mesh.setIndices(ia);
    }

    protected abstract int bindSkin(int var1, int var2);

    @Override
    public boolean render(int pal, int pad1, int skinnum, int pad2, float pad3) {
        int texunits;
        boolean isRendered = false;
        if (this.numframes > 2 && this.interpol != this.oldinterpol) {
            int pos = 0;
            this.oldinterpol = this.interpol;
            float f = this.interpol;
            float g = 1.0f - f;
            FloatBuffer vertices = this.mesh.getVerticesBuffer();
            MD2Frame cframe = this.frames[this.cframe];
            MD2Frame nframe = this.frames[this.nframe];
            for (int i = 0; i < this.tris.length; ++i) {
                for (int j = 0; j < 3; ++j) {
                    short idx = this.tris[i].vertices[j];
                    float x = cframe.vertices[idx][0] * g + nframe.vertices[idx][0] * f;
                    float y = cframe.vertices[idx][1] * g + nframe.vertices[idx][1] * f;
                    float z = cframe.vertices[idx][2] * g + nframe.vertices[idx][2] * f;
                    vertices.put(pos++, x);
                    vertices.put(pos++, z);
                    vertices.put(pos++, y);
                    pos += 3;
                }
            }
        }
        if ((texunits = this.bindSkin(pal, skinnum)) != -1) {
            this.mesh.render(this.getShader(), 4);
            isRendered = true;
        }
        return isRendered;
    }

    @Override
    public ModelInfo.Type getType() {
        return ModelInfo.Type.Md2;
    }

    @Override
    public void loadSkins(int pal, int skinnum) {
        this.getSkin(pal, skinnum, 0);
    }
}

