/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.MDModel;

import com.badlogic.gdx.math.Vector3;
import java.util.ArrayList;
import java.util.Iterator;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Render.ModelHandle.GLModel;
import ru.m210projects.Build.Render.ModelHandle.MDInfo;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDAnimation;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDSkinmap;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.Types.Tile2model;
import ru.m210projects.Build.Script.ModelsInfo;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public abstract class MDModel
implements GLModel {
    public MDSkinmap skinmap;
    public int numframes;
    public int cframe;
    public int nframe;
    public int fpssc;
    public boolean usesalpha;
    public float interpol;
    public MDAnimation animations;
    protected int flags;
    protected float yoffset;
    protected float zadd;
    protected float bscale;
    protected Vector3 cScale = new Vector3(1.0f, 1.0f, 1.0f);
    protected Vector3 nScale = new Vector3(1.0f, 1.0f, 1.0f);

    public MDModel(MDInfo md) {
        this.skinmap = md.getSkins();
        this.animations = md.getAnimations();
        this.numframes = md.getFrames();
        this.flags = md.getFlags();
        this.zadd = md.getYOffset(true);
        this.yoffset = md.getYOffset(false);
        this.bscale = md.getScale();
    }

    public abstract void loadSkins(int var1, int var2);

    protected abstract GLTile loadTexture(String var1, int var2);

    public GLTile getSkin(int pal, int skinnum, int surfnum) {
        String skinfile = null;
        GLTile texptr = null;
        MDSkinmap skzero = null;
        if (pal >= 256) {
            return null;
        }
        int i = -1;
        MDSkinmap sk = this.skinmap;
        while (sk != null) {
            if (sk.palette == pal && sk.skinnum == skinnum && sk.surfnum == surfnum) {
                skinfile = sk.fn;
                texptr = sk.texid;
                break;
            }
            if (sk.palette == 0 && sk.skinnum == skinnum && sk.surfnum == surfnum && i < 5) {
                i = 5;
                skzero = sk;
            } else if (sk.palette == pal && sk.skinnum == 0 && sk.surfnum == surfnum && i < 4) {
                i = 4;
                skzero = sk;
            } else if (sk.palette == 0 && sk.skinnum == 0 && sk.surfnum == surfnum && i < 3) {
                i = 3;
                skzero = sk;
            } else if (sk.palette == 0 && sk.skinnum == skinnum && i < 2) {
                i = 2;
                skzero = sk;
            } else if (sk.palette == pal && sk.skinnum == 0 && i < 1) {
                i = 1;
                skzero = sk;
            } else if (sk.palette == 0 && sk.skinnum == 0 && i < 0) {
                i = 0;
                skzero = sk;
            }
            sk = sk.next;
        }
        if (sk == null) {
            if (pal >= 252) {
                return null;
            }
            if (skzero != null) {
                sk = skzero;
                skinfile = skzero.fn;
                texptr = skzero.texid;
            } else {
                Console.out.println("Couldn't load skin", OsdColor.YELLOW);
                return null;
            }
        }
        if (skinfile == null) {
            return null;
        }
        if (texptr != null) {
            return texptr;
        }
        sk.texid = this.loadTexture(skinfile, pal);
        return sk.texid;
    }

    public MDModel setScale(Vector3 cScale, Vector3 nScale) {
        this.cScale.set(cScale);
        this.nScale.set(nScale);
        return this;
    }

    public float getYOffset(boolean yflipping) {
        return !yflipping ? this.yoffset : this.zadd;
    }

    public float getShadeOff() {
        return 0.0f;
    }

    @Override
    public boolean isRotating() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isTintAffected() {
        return (this.flags & 1) == 0;
    }

    public void updateanimation(ModelsInfo mdInfo, Sprite tspr, int timerticspersec, boolean animSmoothing) {
        if (this.numframes < 2) {
            this.interpol = 0.0f;
            return;
        }
        Tile2model t2m = mdInfo.getParams(tspr.getPicnum());
        if (t2m == null) {
            return;
        }
        this.cframe = this.nframe = t2m.framenum;
        boolean smoothdurationp = animSmoothing && t2m.smoothduration != 0.0f;
        ModelsInfo.Spritesmooth smooth = mdInfo.getSmoothParams(tspr.getOwner());
        ModelsInfo.SpriteAnim sprext = mdInfo.getAnimParams(tspr.getOwner());
        MDAnimation anim = this.animations;
        while (anim != null && anim.startframe != this.cframe) {
            anim = anim.next;
        }
        if (anim == null) {
            if (!smoothdurationp || smooth.mdoldframe == this.cframe && smooth.mdcurframe == this.cframe) {
                this.interpol = 0.0f;
                return;
            }
            if (smooth.mdoldframe != this.cframe) {
                if (smooth.mdsmooth == 0) {
                    sprext.mdanimtims = MDAnimation.mdtims;
                    this.interpol = 0.0f;
                    smooth.mdsmooth = 1;
                    smooth.mdcurframe = (short)this.cframe;
                }
                if (smooth.mdcurframe != this.cframe) {
                    sprext.mdanimtims = MDAnimation.mdtims;
                    this.interpol = 0.0f;
                    smooth.mdsmooth = 1;
                    smooth.mdoldframe = smooth.mdcurframe;
                    smooth.mdcurframe = (short)this.cframe;
                }
            } else {
                sprext.mdanimtims = MDAnimation.mdtims;
                this.interpol = 0.0f;
                smooth.mdsmooth = 1;
                smooth.mdoldframe = smooth.mdcurframe;
                smooth.mdcurframe = (short)this.cframe;
            }
        } else if (sprext.mdanimcur != anim.startframe) {
            sprext.mdanimcur = (short)anim.startframe;
            sprext.mdanimtims = MDAnimation.mdtims;
            this.interpol = 0.0f;
            if (!smoothdurationp) {
                this.cframe = this.nframe = anim.startframe;
                return;
            }
            this.nframe = anim.startframe;
            this.cframe = smooth.mdoldframe;
            if (this.cframe >= anim.endframe) {
                this.cframe = this.nframe;
            }
            smooth.mdsmooth = 1;
            return;
        }
        int fps = smooth.mdsmooth != 0 ? Math.round(1.0f / t2m.smoothduration * 66.0f) : anim.fpssc;
        int i = (int)((MDAnimation.mdtims - sprext.mdanimtims) * (long)(fps * timerticspersec / 120));
        int j = 65536;
        if (smooth.mdsmooth == 0) {
            j = anim.endframe + 1 - anim.startframe << 16;
        }
        if (i < 0) {
            i = 0;
            sprext.mdanimtims = MDAnimation.mdtims;
        }
        if (anim != null && i >= j + j && fps != 0 && MDAnimation.mdpause == 0) {
            sprext.mdanimtims += (long)j / ((long)fps * (long)timerticspersec / 120L);
        }
        int k = i;
        if (anim != null && (anim.flags & 1) != 0) {
            if (i > j - 65536) {
                i = j - 65536;
            }
        } else if (i >= j && (i -= j) >= j) {
            i %= j;
        }
        if (animSmoothing && smooth.mdsmooth != 0) {
            this.nframe = anim != null ? anim.startframe : (int)smooth.mdcurframe;
            this.cframe = smooth.mdoldframe;
            if (k > 65535) {
                sprext.mdanimtims = MDAnimation.mdtims;
                this.interpol = 0.0f;
                smooth.mdsmooth = 0;
                this.cframe = this.nframe;
                smooth.mdoldframe = (short)this.cframe;
                return;
            }
        } else {
            this.cframe = (i >> 16) + anim.startframe;
            this.nframe = this.cframe + 1;
            if (this.nframe > anim.endframe) {
                this.nframe = anim.startframe;
            }
            smooth.mdoldframe = (short)this.cframe;
        }
        this.interpol = Gameutils.BClipRange((float)(i & 0xFFFF) / 65536.0f, 0.0f, 1.0f);
        if (this.cframe < 0 || this.cframe >= this.numframes || this.nframe < 0 || this.nframe >= this.numframes) {
            if (this.cframe < 0) {
                this.cframe = 0;
            }
            if (this.cframe >= this.numframes) {
                this.cframe = this.numframes - 1;
            }
            if (this.nframe < 0) {
                this.nframe = 0;
            }
            if (this.nframe >= this.numframes) {
                this.nframe = this.numframes - 1;
            }
        }
    }

    @Override
    public void dispose() {
        this.clearSkins();
    }

    @Override
    public Iterator<GLTile> getSkins() {
        ArrayList<GLTile> list = new ArrayList<GLTile>();
        MDSkinmap sk = this.skinmap;
        while (sk != null) {
            if (sk.texid != null) {
                list.add(sk.texid);
            }
            sk = sk.next;
        }
        return list.iterator();
    }

    @Override
    public void clearSkins() {
        MDSkinmap sk = this.skinmap;
        while (sk != null) {
            if (sk.texid != null) {
                sk.texid.delete();
                sk.texid = null;
            }
            sk = sk.next;
        }
    }

    @Override
    public float getScale() {
        return this.bscale;
    }
}

