/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.ModelHandle.GLModel;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDModel;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.Render.ModelHandle.Voxel.GLVoxel;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelData;
import ru.m210projects.Build.Render.ModelHandle.VoxelInfo;
import ru.m210projects.Build.Render.TexFilter;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.Types.Tile2model;
import ru.m210projects.Build.Script.ModelsInfo;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public abstract class ModelManager {
    protected final Engine engine;
    protected ModelsInfo mdInfo;
    protected GLModel[] models = new GLModel[Engine.MAXTILES];
    protected HashMap<ModelInfo, GLModel> tile2model = new HashMap();

    public ModelManager(Engine engine) {
        this.engine = engine;
    }

    public ModelManager setModelsInfo(ModelsInfo mdInfo) {
        this.dispose();
        this.mdInfo = mdInfo;
        return this;
    }

    public Iterator<GLTile> getSkins(int tile) {
        GLModel model = this.models[tile];
        if (model != null) {
            return model.getSkins();
        }
        return null;
    }

    public void setTextureFilter(TexFilter filter) {
        if (this.mdInfo == null) {
            return;
        }
        for (GLModel model : this.tile2model.values()) {
            if (model == null || model.getType() == ModelInfo.Type.Voxel) continue;
            Iterator<GLTile> sk = model.getSkins();
            while (sk.hasNext()) {
                GLTile tex = sk.next();
                tex.bind();
                tex.setupTextureFilter(filter);
            }
        }
    }

    public void clearSkins(int tile, boolean bit8only) {
        GLModel model = this.models[tile];
        if (model != null && !bit8only) {
            model.clearSkins();
            Tile2model param = this.mdInfo.getParams(tile);
            if (param != null) {
                while (param.next != null) {
                    param = param.next;
                    model = this.tile2model.get(param.model);
                    if (model == null) continue;
                    model.clearSkins();
                }
            }
        }
    }

    public boolean hasModelInfo(int tile) {
        if (this.mdInfo == null) {
            return false;
        }
        return this.mdInfo.getModelInfo(tile) != null;
    }

    public boolean hasVoxelInfo(int tile) {
        if (this.mdInfo == null) {
            return false;
        }
        return this.mdInfo.getVoxelInfo(tile) != null;
    }

    public GLModel getModel(int tile, int pal) {
        if (this.mdInfo == null) {
            return null;
        }
        Tile2model param = this.mdInfo.getParams(tile);
        if (param == null) {
            return null;
        }
        ModelInfo model = param.model;
        if (model != null && model.getType() != ModelInfo.Type.Voxel) {
            GLModel glmodel;
            if (param.next != null && param.palette != pal) {
                while (param.next != null) {
                    param = param.next;
                    if (param.palette != pal) continue;
                    model = param.model;
                    GLModel glmodel2 = this.tile2model.get(model);
                    if (glmodel2 != null && glmodel2.getType() != ModelInfo.Type.Voxel) {
                        return glmodel2;
                    }
                    return this.loadModel(model);
                }
            }
            if ((glmodel = this.models[tile]) != null && glmodel.getType() != ModelInfo.Type.Voxel) {
                return glmodel;
            }
            glmodel = this.tile2model.get(model);
            if (glmodel != null && glmodel.getType() != ModelInfo.Type.Voxel) {
                this.models[tile] = glmodel;
                return glmodel;
            }
            GLModel out = this.loadModel(model);
            if (out != null) {
                this.models[tile] = out;
                return this.models[tile];
            }
            Console.out.println("Removing model of tile " + tile + " due to errors.", OsdColor.RED);
            this.mdInfo.removeModelInfo(model);
        }
        return null;
    }

    protected GLModel loadModel(ModelInfo model) {
        try {
            GLModel out = this.allocateModel(model);
            if (out != null) {
                this.tile2model.put(model, out);
                return out;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public GLModel getVoxel(int tile) {
        if (this.mdInfo == null) {
            return null;
        }
        VoxelInfo model = this.mdInfo.getVoxelInfo(tile);
        if (model != null) {
            GLModel glmodel = this.models[tile];
            if (glmodel != null && glmodel.getType() == ModelInfo.Type.Voxel) {
                return glmodel;
            }
            glmodel = this.tile2model.get(model);
            if (glmodel != null && glmodel.getType() == ModelInfo.Type.Voxel) {
                this.models[tile] = glmodel;
                return glmodel;
            }
            GLVoxel out = this.allocateVoxel(model.getData(), 0, model.getFlags());
            if (out != null) {
                this.tile2model.put(model, out);
                this.models[tile] = out;
                return this.models[tile];
            }
            Console.out.println("Removing voxel of tile " + tile + " due to errors.", OsdColor.RED);
            this.mdInfo.removeModelInfo(model);
        }
        return null;
    }

    public abstract GLVoxel allocateVoxel(VoxelData var1, int var2, int var3);

    public abstract GLModel allocateModel(ModelInfo var1);

    public void dispose() {
        for (GLModel glmodel : this.tile2model.values()) {
            glmodel.dispose();
        }
        Arrays.fill(this.models, null);
        this.tile2model.clear();
        this.mdInfo = null;
    }

    protected int getTile(GLModel model) {
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            GLModel glmodel = this.models[i];
            if (glmodel == null || glmodel != model) continue;
            return i;
        }
        return -1;
    }

    public int getNumModels() {
        return this.tile2model.values().size();
    }

    public void preload(int picnum, int pal, boolean skinPreload) {
        GLVoxel voxel;
        GLModel model;
        if (this.engine.getConfig().isUseModels() && this.hasModelInfo(picnum) && (model = this.getModel(picnum, pal)) != null && skinPreload) {
            Tile2model t2m;
            if (model instanceof MDModel && (t2m = this.mdInfo.getParams(picnum)) != null) {
                int skinnum = t2m.skinnum;
                ((MDModel)model).loadSkins(pal, skinnum);
            }
            return;
        }
        if (this.engine.getConfig().isUseVoxels() && this.hasVoxelInfo(picnum) && (voxel = (GLVoxel)this.getVoxel(picnum)) != null && skinPreload) {
            voxel.getSkin(pal);
        }
    }
}

