/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.Voxel;

import com.badlogic.gdx.graphics.Color;
import java.util.ArrayList;
import java.util.Iterator;
import ru.m210projects.Build.Render.ModelHandle.GLModel;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Types.Tile;

public abstract class GLVoxel
implements GLModel {
    protected Tile skinData;
    protected GLTile[] texid;
    public int xsiz;
    public int ysiz;
    public int zsiz;
    public float xpiv;
    public float ypiv;
    public float zpiv;
    protected final Color color = new Color();
    protected int flags;

    public GLVoxel(int flags) {
        this.texid = new GLTile[256];
        this.flags = flags;
    }

    public abstract GLTile getSkin(int var1);

    public abstract void setTextureParameters(GLTile var1, int var2, int var3, int var4, float var5);

    @Override
    public ModelInfo.Type getType() {
        return ModelInfo.Type.Voxel;
    }

    @Override
    public boolean isRotating() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isTintAffected() {
        return false;
    }

    @Override
    public float getScale() {
        return 1.0f;
    }

    public GLVoxel setColor(float r, float g, float b, float a) {
        this.color.set(r, g, b, a);
        return this;
    }

    @Override
    public Iterator<GLTile> getSkins() {
        ArrayList<GLTile> list = new ArrayList<GLTile>();
        for (int i = 0; i < this.texid.length; ++i) {
            GLTile tex = this.texid[i];
            if (tex == null) continue;
            list.add(tex);
        }
        return list.iterator();
    }

    @Override
    public void clearSkins() {
        for (int i = 0; i < this.texid.length; ++i) {
            GLTile tex = this.texid[i];
            if (tex == null) continue;
            tex.delete();
            this.texid[i] = null;
        }
    }
}

