/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.Voxel;

import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.badlogic.gdx.utils.ShortArray;
import java.util.Arrays;
import java.util.HashMap;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelData;
import ru.m210projects.Build.Types.Tile;

public class VoxelBuilder {
    protected int xsiz;
    protected int ysiz;
    protected int zsiz;
    protected int yzsiz;
    protected HashMap<Integer, Byte> vcol;
    protected Vector2[] shp;
    protected int[] shcntmal;
    protected int shcnt;
    protected int shcntp;
    protected int mytexo5;
    protected int[] zbit;
    protected int gmaxx;
    protected int gmaxy;
    protected int garea;
    protected int[] pow2m1;
    protected int[] pal;
    protected int mytexx;
    protected int mytexy;
    protected byte[] mytex;
    protected Rectangle[] quad;
    protected int qcnt;
    protected int[] qfacind = new int[7];
    private final FloatArray vertices = new FloatArray();
    private final ShortArray indices = new ShortArray();
    private final Tile texture;
    private final int vertexSize;
    public static final byte FILL_COLOR = 0;
    public static final int MARGIN_SIZE = 0;

    public VoxelBuilder(VoxelData vox, int voxmip) {
        this.pal = vox.pal;
        this.vox2poly(vox, voxmip);
        this.texture = new Tile().setWidth(this.mytexx).setHeight(this.mytexy);
        this.texture.data = this.mytex;
        this.vertexSize = 6;
    }

    public Tile getTexture() {
        return this.texture;
    }

    public int getVertexSize() {
        return this.vertexSize;
    }

    public VertexAttribute[] getAttributes() {
        return new VertexAttribute[]{VertexAttribute.Position(), VertexAttribute.ColorPacked(), VertexAttribute.TexCoords(0)};
    }

    public float[] getVertices() {
        return this.vertices.toArray();
    }

    public short[] getIndices() {
        return this.indices.toArray();
    }

    private void putvox(int x, int y, int z, byte col) {
        this.vcol.put(z += x * this.yzsiz + y * this.zsiz, col);
    }

    private byte getvox(int x, int y, int z) {
        Byte col = this.vcol.get(z += x * this.yzsiz + y * this.zsiz);
        if (col == null) {
            return 0;
        }
        return (byte)(((long)this.pal[col & 0xFF] & 0xFFFFFFFFL) >> 24);
    }

    private void setzrange1(int[] lptr, int z0, int z1) {
        if (((z0 ^ z1) & 0xFFFFFFE0) == 0) {
            int n = z0 >> 5;
            lptr[n] = lptr[n] | ~(-1 << (z1 & 0x1F)) & -1 << (z0 & 0x1F);
            return;
        }
        int z = z0 >> 5;
        int ze = z1 >> 5;
        int n = z++;
        lptr[n] = lptr[n] | -1 << (z0 & 0x1F);
        while (z < ze) {
            lptr[z] = -1;
            ++z;
        }
        int n2 = z;
        lptr[n2] = lptr[n2] | ~(-1 << (z1 & 0x1F));
    }

    private void setrect(int x0, int y0, int dx, int dy) {
        int i = y0 * this.mytexo5 + (x0 >> 5);
        int c = ((dx += x0 - 1) >> 5) - (x0 >> 5);
        int m = ~this.pow2m1[x0 & 0x1F];
        int m1 = this.pow2m1[(dx & 0x1F) + 1];
        if (c == 0) {
            m &= m1;
            while (dy != 0) {
                int n = i;
                this.zbit[n] = this.zbit[n] | m;
                --dy;
                i += this.mytexo5;
            }
        } else {
            while (dy != 0) {
                int x;
                int n = i;
                this.zbit[n] = this.zbit[n] | m;
                for (x = 1; x < c; ++x) {
                    this.zbit[i + x] = -1;
                }
                int n2 = i + x;
                this.zbit[n2] = this.zbit[n2] | m1;
                --dy;
                i += this.mytexo5;
            }
        }
    }

    private int isolid(int[] vbit, int x, int y, int z) {
        if (((long)x & 0xFFFFFFFFL) >= ((long)this.xsiz & 0xFFFFFFFFL)) {
            return 0;
        }
        if (((long)y & 0xFFFFFFFFL) >= ((long)this.ysiz & 0xFFFFFFFFL)) {
            return 0;
        }
        if (((long)z & 0xFFFFFFFFL) >= ((long)this.zsiz & 0xFFFFFFFFL)) {
            return 0;
        }
        return vbit[(z += x * this.yzsiz + y * this.zsiz) >> 5] & 1 << (z & 0x1F);
    }

    private void daquad(int i, int x0, int y0, int z0, int x1, int y1, int z1, int x2, int y2, int z2, int face) {
        if (i == 0) {
            this.cntquad(x0, y0, z0, x1, y1, z1, x2, y2, z2, face);
        } else {
            this.addquad(x0, y0, z0, x1, y1, z1, x2, y2, z2, face);
        }
    }

    private void cntquad(int x0, int y0, int z0, int x1, int y1, int z1, int x2, int y2, int z2, int face) {
        int x = Pragmas.klabs(x2 - x0);
        int y = Pragmas.klabs(y2 - y0);
        int z = Pragmas.klabs(z2 - z0);
        if (x == 0) {
            x = z;
        } else if (y == 0) {
            y = z;
        }
        if (x < y) {
            z = x;
            x = y;
            y = z;
        }
        int n = this.shcnt + y * this.shcntp + x;
        this.shcntmal[n] = this.shcntmal[n] + 1;
        if (x > this.gmaxx) {
            this.gmaxx = x;
        }
        if (y > this.gmaxy) {
            this.gmaxy = y;
        }
        this.garea += x * y;
        ++this.qcnt;
    }

    private void addquad(int x0, int y0, int z0, int x1, int y1, int z1, int x2, int y2, int z2, int face) {
        int i;
        int nx = 0;
        int ny = 0;
        int nz = 0;
        int x = Pragmas.klabs(x2 - x0);
        int y = Pragmas.klabs(y2 - y0);
        int z = Pragmas.klabs(z2 - z0);
        if (x == 0) {
            x = y;
            y = z;
            i = 0;
        } else if (y == 0) {
            y = z;
            i = 1;
        } else {
            i = 2;
        }
        if (x < y) {
            z = x;
            x = y;
            y = z;
            i += 3;
        }
        int n = this.shcnt + y * this.shcntp + x;
        int n2 = this.shcntmal[n];
        this.shcntmal[n] = n2 + 1;
        z = n2;
        int lptr = (int)(this.shp[z].y * (float)this.mytexx + this.shp[z].x);
        switch (face) {
            case 0: {
                ny = y1;
                x2 = x0;
                x0 = x1;
                x1 = x2;
                break;
            }
            case 1: {
                ny = y0++;
                ++y1;
                ++y2;
                break;
            }
            case 2: {
                nz = z1++;
                y0 = y2;
                y2 = y1;
                y1 = y0;
                ++z0;
                ++z2;
                break;
            }
            case 3: {
                nz = z0;
                break;
            }
            case 4: {
                nx = x1++;
                y2 = y0;
                y0 = y1;
                y1 = y2;
                ++x0;
                ++x2;
                break;
            }
            case 5: {
                nx = x0;
            }
        }
        int yy = 0;
        while (yy < y) {
            for (int xx = 0; xx < x; ++xx) {
                switch (face) {
                    case 0: {
                        if (i < 3) {
                            nx = x1 + x - 1 - xx;
                            nz = z1 + yy;
                            break;
                        }
                        nx = x1 + y - 1 - yy;
                        nz = z1 + xx;
                        break;
                    }
                    case 1: {
                        if (i < 3) {
                            nx = x0 + xx;
                            nz = z0 + yy;
                            break;
                        }
                        nx = x0 + yy;
                        nz = z0 + xx;
                        break;
                    }
                    case 2: {
                        if (i < 3) {
                            nx = x1 - x + xx;
                            ny = y1 - 1 - yy;
                            break;
                        }
                        nx = x1 - 1 - yy;
                        ny = y1 - 1 - xx;
                        break;
                    }
                    case 3: {
                        if (i < 3) {
                            nx = x0 + xx;
                            ny = y0 + yy;
                            break;
                        }
                        nx = x0 + yy;
                        ny = y0 + xx;
                        break;
                    }
                    case 4: {
                        if (i < 3) {
                            ny = y1 + x - 1 - xx;
                            nz = z1 + yy;
                            break;
                        }
                        ny = y1 + y - 1 - yy;
                        nz = z1 + xx;
                        break;
                    }
                    case 5: {
                        if (i < 3) {
                            ny = y0 + xx;
                            nz = z0 + yy;
                            break;
                        }
                        ny = y0 + yy;
                        nz = z0 + xx;
                    }
                }
                this.mytex[lptr + xx] = this.getvox(nx, ny, nz);
            }
            ++yy;
            lptr += this.mytexx;
        }
        Rectangle qptr = this.quad[this.qcnt];
        qptr.v[0].x = x0;
        qptr.v[0].y = y0;
        qptr.v[0].z = z0;
        qptr.v[1].x = x1;
        qptr.v[1].y = y1;
        qptr.v[1].z = z1;
        qptr.v[2].x = x2;
        qptr.v[2].y = y2;
        qptr.v[2].z = z2;
        for (int j = 0; j < 3; ++j) {
            qptr.v[j].u = (int)this.shp[z].x;
            qptr.v[j].v = (int)this.shp[z].y;
        }
        if (i < 3) {
            qptr.v[1].u += x;
        } else {
            qptr.v[1].v += y;
        }
        qptr.v[2].u += x;
        qptr.v[2].v += y;
        qptr.v[3].u = qptr.v[0].u - qptr.v[1].u + qptr.v[2].u;
        qptr.v[3].v = qptr.v[0].v - qptr.v[1].v + qptr.v[2].v;
        qptr.v[3].x = qptr.v[0].x - qptr.v[1].x + qptr.v[2].x;
        qptr.v[3].y = qptr.v[0].y - qptr.v[1].y + qptr.v[2].y;
        qptr.v[3].z = qptr.v[0].z - qptr.v[1].z + qptr.v[2].z;
        if (this.qfacind[face] < 0) {
            this.qfacind[face] = this.qcnt;
        }
        int vertexOffset = this.vertices.size / 6;
        for (i = 0; i < 4; ++i) {
            this.vertices.addAll((float)qptr.v[i].x / 64.0f, (float)qptr.v[i].y / 64.0f, (float)qptr.v[i].z / 64.0f);
            this.vertices.add(NumberUtils.intToFloatColor(-1));
            this.vertices.addAll((float)qptr.v[i].u / (float)this.mytexx, (float)qptr.v[i].v / (float)this.mytexy);
        }
        this.indices.addAll((short)vertexOffset, (short)(vertexOffset + 1), (short)(vertexOffset + 2), (short)vertexOffset, (short)(vertexOffset + 2), (short)(vertexOffset + 3));
        ++this.qcnt;
    }

    private void vox2poly(VoxelData vox, int mip) {
        int z;
        int j;
        int y;
        int x;
        int oz = 0;
        this.xsiz = vox.xsiz[mip];
        this.ysiz = vox.ysiz[mip];
        this.zsiz = vox.zsiz[mip];
        this.yzsiz = this.ysiz * this.zsiz;
        int[] vbit = new int[(this.xsiz * this.yzsiz + 31 >> 3) + 1];
        this.vcol = new HashMap();
        this.pow2m1 = new int[33];
        int cptr = 0;
        for (x = 0; x < this.xsiz; ++x) {
            y = 0;
            j = x * this.yzsiz;
            while (y < this.ysiz) {
                int zleng;
                short voxend = vox.xyoffs[mip][x][y + 1];
                int z1 = 0;
                for (int voxptr = vox.xyoffs[mip][x][y]; voxptr < voxend; voxptr += zleng + 3) {
                    int ztop = vox.data[mip][cptr] & 0xFF;
                    zleng = vox.data[mip][cptr + 1] & 0xFF;
                    if ((vox.data[mip][cptr + 2] & 0x10) == 0) {
                        this.setzrange1(vbit, j + z1, j + ztop);
                    }
                    z1 = ztop + zleng;
                    this.setzrange1(vbit, j + ztop, j + z1);
                    cptr += 3;
                    for (z = ztop; z < z1 && cptr < vox.data[mip].length; ++z) {
                        this.putvox(x, y, z, vox.data[mip][cptr++]);
                    }
                }
                ++y;
                j += this.zsiz;
            }
        }
        x = this.xsiz;
        y = this.ysiz;
        z = this.zsiz;
        if (x < y && x < z) {
            x = z;
        } else if (y < z) {
            y = z;
        }
        if (x < y) {
            z = x;
            x = y;
            y = z;
        }
        this.shcntp = x;
        int i = x * y;
        this.shcntmal = new int[i];
        this.shcnt = -this.shcntp - 1;
        this.garea = 0;
        this.gmaxy = 0;
        this.gmaxx = 0;
        if (this.pow2m1[32] != -1) {
            for (i = 0; i < 32; ++i) {
                this.pow2m1[i] = (1 << i) - 1;
            }
            this.pow2m1[32] = -1;
        }
        for (i = 0; i < 7; ++i) {
            this.qfacind[i] = -1;
        }
        i = Math.max(this.ysiz, this.zsiz) + 1 << 2;
        int[] bx0 = new int[i << 1];
        int[] by0 = new int[i << 1];
        for (int cnt = 0; cnt < 2; ++cnt) {
            int ov;
            this.qcnt = 0;
            Arrays.fill(by0, -1);
            int v = 0;
            for (i = -1; i <= 1; i += 2) {
                for (y = 0; y < this.ysiz; ++y) {
                    for (x = 0; x <= this.xsiz; ++x) {
                        for (z = 0; z <= this.zsiz; ++z) {
                            ov = v;
                            int n = v = this.isolid(vbit, x, y, z) != 0 && this.isolid(vbit, x, y + i, z) == 0 ? 1 : 0;
                            if (by0[z] >= 0 && (by0[z] != oz || v >= ov)) {
                                this.daquad(cnt, bx0[z], y, by0[z], x, y, by0[z], x, y, z, i >= 0 ? 1 : 0);
                                by0[z] = -1;
                            }
                            if (v > ov) {
                                oz = z;
                                continue;
                            }
                            if (v >= ov || by0[z] == oz) continue;
                            bx0[z] = x;
                            by0[z] = oz;
                        }
                    }
                }
            }
            for (i = -1; i <= 1; i += 2) {
                for (z = 0; z < this.zsiz; ++z) {
                    for (x = 0; x <= this.xsiz; ++x) {
                        for (y = 0; y <= this.ysiz; ++y) {
                            ov = v;
                            int n = v = this.isolid(vbit, x, y, z) != 0 && this.isolid(vbit, x, y, z - i) == 0 ? 1 : 0;
                            if (by0[y] >= 0 && (by0[y] != oz || v >= ov)) {
                                this.daquad(cnt, bx0[y], by0[y], z, x, by0[y], z, x, y, z, (i >= 0 ? 1 : 0) + 2);
                                by0[y] = -1;
                            }
                            if (v > ov) {
                                oz = y;
                                continue;
                            }
                            if (v >= ov || by0[y] == oz) continue;
                            bx0[y] = x;
                            by0[y] = oz;
                        }
                    }
                }
            }
            for (i = -1; i <= 1; i += 2) {
                for (x = 0; x < this.xsiz; ++x) {
                    for (y = 0; y <= this.ysiz; ++y) {
                        for (z = 0; z <= this.zsiz; ++z) {
                            ov = v;
                            int n = v = this.isolid(vbit, x, y, z) != 0 && this.isolid(vbit, x - i, y, z) == 0 ? 1 : 0;
                            if (by0[z] >= 0 && (by0[z] != oz || v >= ov)) {
                                this.daquad(cnt, x, bx0[z], by0[z], x, y, by0[z], x, y, z, (i >= 0 ? 1 : 0) + 4);
                                by0[z] = -1;
                            }
                            if (v > ov) {
                                oz = z;
                                continue;
                            }
                            if (v >= ov || by0[z] == oz) continue;
                            bx0[z] = y;
                            by0[z] = oz;
                        }
                    }
                }
            }
            if (cnt != 0) continue;
            this.shp = new Vector2[this.qcnt];
            for (int vc = 0; vc < this.qcnt; ++vc) {
                this.shp[vc] = new Vector2();
            }
            int sc = 0;
            for (y = this.gmaxy; y != 0; --y) {
                for (x = this.gmaxx; x >= y; --x) {
                    this.shcntmal[this.shcnt + y * this.shcntp + x] = sc;
                    for (i = this.shcntmal[this.shcnt + y * this.shcntp + x]; i > 0; --i) {
                        this.shp[sc].x = x;
                        this.shp[sc].y = y;
                        ++sc;
                    }
                }
            }
            this.mytexx = 32;
            while (this.mytexx < this.gmaxx) {
                this.mytexx <<= 1;
            }
            this.mytexy = 32;
            while (this.mytexy < this.gmaxy) {
                this.mytexy <<= 1;
            }
            while (this.mytexx * this.mytexy * 8 < this.garea * 9) {
                if (this.mytexx <= this.mytexy) {
                    this.mytexx <<= 1;
                    continue;
                }
                this.mytexy <<= 1;
            }
            this.mytexo5 = this.mytexx >> 5;
            i = this.mytexx * this.mytexy + 31 >> 5 << 2;
            this.zbit = new int[i];
            v = this.mytexx * this.mytexy;
            block26: for (z = 0; z < sc; ++z) {
                int y0;
                int x0;
                int dx = (int)this.shp[z].x;
                int dy = (int)this.shp[z].y;
                i = v;
                do {
                    int a = (int)(Math.random() * 32767.0);
                    int b = (int)(Math.random() * 32767.0);
                    x0 = a * (this.mytexx + 1 - dx) >> 15;
                    if (--i >= 0) continue;
                    Arrays.fill(this.zbit, 0);
                    j = 0;
                    for (y = this.gmaxy; y != 0; --y) {
                        x = this.gmaxx;
                        while (x >= y) {
                            i = this.shcntmal[this.shcnt + y * this.shcntp + x];
                            while (j < i) {
                                this.shp[j].x = x0;
                                this.shp[j].y = y0;
                                ++j;
                            }
                            x0 = x--;
                            y0 = y;
                        }
                    }
                    while (j < sc) {
                        this.shp[j].x = x0;
                        this.shp[j].y = y0;
                        ++j;
                    }
                    if (this.mytexx <= this.mytexy) {
                        this.mytexx <<= 1;
                    } else {
                        this.mytexy <<= 1;
                    }
                    this.mytexo5 = this.mytexx >> 5;
                    i = this.mytexx * this.mytexy + 31 >> 5 << 2;
                    v = this.mytexx * this.mytexy;
                    z = -1;
                    continue block26;
                } while (this.isrectfree(x0, y0, dx, dy) == 0);
                for (y0 = b * (this.mytexy + 1 - dy) >> 15; y0 != 0 && this.isrectfree(x0, y0 - 1, dx, 1) != 0; --y0) {
                }
                while (x0 != 0 && this.isrectfree(x0 - 1, y0, 1, dy) != 0) {
                    --x0;
                }
                this.setrect(x0, y0, dx, dy);
                this.shp[z].x = x0;
                this.shp[z].y = y0;
            }
            this.quad = new Rectangle[this.qcnt];
            for (int vx = 0; vx < this.qcnt; ++vx) {
                this.quad[vx] = new Rectangle();
            }
            this.mytex = new byte[this.mytexx * this.mytexy];
            Arrays.fill(this.mytex, (byte)0);
        }
    }

    private int isrectfree(int x0, int y0, int dx, int dy) {
        int i = (y0 += 0) * this.mytexo5 + ((x0 += 0) >> 5);
        if (i < 0 || i >= this.zbit.length) {
            return 0;
        }
        dy += 0;
        int c = ((dx += x0 - 1 + 0) >> 5) - (x0 >> 5);
        int m = ~this.pow2m1[x0 & 0x1F];
        int m1 = this.pow2m1[(dx & 0x1F) + 1];
        if (c == 0) {
            m &= m1;
            while (dy != 0) {
                if ((this.zbit[i] & m) != 0) {
                    return 0;
                }
                --dy;
                i += this.mytexo5;
            }
        } else {
            while (dy != 0) {
                int x;
                if ((this.zbit[i] & m) != 0) {
                    return 0;
                }
                for (x = 1; x < c; ++x) {
                    if (this.zbit[i + x] == 0) continue;
                    return 0;
                }
                if ((this.zbit[i + x] & m1) != 0) {
                    return 0;
                }
                --dy;
                i += this.mytexo5;
            }
        }
        return 1;
    }

    public static class Rectangle {
        private final Vertex[] v = new Vertex[]{new Vertex(), new Vertex(), new Vertex(), new Vertex()};

        public int getX(int num) {
            return this.v[num].x;
        }

        public int getY(int num) {
            return this.v[num].y;
        }

        public int getZ(int num) {
            return this.v[num].z;
        }

        public int getU(int num) {
            return this.v[num].u;
        }

        public int getV(int num) {
            return this.v[num].v;
        }
    }

    private static class Vertex {
        private int x;
        private int y;
        private int z;
        private int u;
        private int v;

        private Vertex() {
        }
    }
}

