/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.Voxel;

import java.io.IOException;
import java.io.InputStream;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;

public class VoxelData {
    public static final int MAXVOXMIPS = 5;
    public int[] xsiz;
    public int[] ysiz;
    public int[] zsiz;
    public int[] xpiv;
    public int[] ypiv;
    public int[] zpiv;
    public short[][][] xyoffs;
    public int[][] slabxoffs;
    public byte[][] data;
    public int[] pal;

    public VoxelData(Entry entry) throws Exception {
        int mip = 0;
        this.xsiz = new int[5];
        this.ysiz = new int[5];
        this.zsiz = new int[5];
        this.xpiv = new int[5];
        this.ypiv = new int[5];
        this.zpiv = new int[5];
        this.xyoffs = new short[5][][];
        this.slabxoffs = new int[5][];
        this.data = new byte[5][];
        try (InputStream is = entry.getInputStream();){
            long size = entry.getSize();
            if ((long)is.available() != size) {
                throw new IOException("Can't read the voxel");
            }
            while (is.available() > 768) {
                int i;
                int mip1leng = StreamUtils.readInt(is);
                int xs = this.xsiz[mip] = StreamUtils.readInt(is);
                int ys = this.ysiz[mip] = StreamUtils.readInt(is);
                this.zsiz[mip] = StreamUtils.readInt(is);
                this.xpiv[mip] = StreamUtils.readInt(is);
                this.ypiv[mip] = StreamUtils.readInt(is);
                this.zpiv[mip] = StreamUtils.readInt(is);
                int offset = (xs + 1 << 2) + (xs * (ys + 1) << 1);
                this.slabxoffs[mip] = new int[xs + 1];
                for (i = 0; i <= xs; ++i) {
                    this.slabxoffs[mip][i] = StreamUtils.readInt(is) - offset;
                }
                this.xyoffs[mip] = new short[xs][ys + 1];
                for (i = 0; i < xs; ++i) {
                    for (int j = 0; j <= ys; ++j) {
                        this.xyoffs[mip][i][j] = StreamUtils.readShort(is);
                    }
                }
                i = is.available() - 768;
                if (i < mip1leng - (24 + offset)) break;
                this.data[mip] = StreamUtils.readBytes(is, mip1leng - (24 + offset));
                ++mip;
            }
            if (mip == 0) {
                throw new Exception("Can't load voxel");
            }
            this.pal = new int[256];
            if (is.available() != 768) {
                int skip = is.available() - 768;
                StreamUtils.skip(is, skip);
            }
            byte[] buf = StreamUtils.readBytes(is, 768);
            for (int i = 0; i < 256; ++i) {
                this.pal[i] = (buf[3 * i + 0] << 18) + (buf[3 * i + 1] << 10) + (buf[3 * i + 2] << 2) + (i << 24);
            }
        }
    }
}

