/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.Voxel;

import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import ru.m210projects.Build.Render.ModelHandle.Voxel.GLVoxel;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelBuilder;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelData;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.Types.GL10;

public abstract class VoxelGL10
extends GLVoxel {
    protected VoxelBuilder.Rectangle[] quad;
    protected int qcnt;
    protected int[] qfacind;
    private final float[] dvoxphack = new float[]{0.0f, 0.00390625f};
    private final float[] dvoxclut = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private final boolean isVertexArray;
    private ShortBuffer indices;
    private FloatBuffer vertices;
    private FloatBuffer uv;
    private final GL10 gl10;

    public VoxelGL10(GL10 gl10, VoxelData vox, int voxmip, int flags, boolean isVertexArray) {
        super(flags);
        this.gl10 = gl10;
        this.isVertexArray = isVertexArray;
        VoxelBuilder builder = new VoxelBuilder(vox, voxmip);
        this.skinData = builder.getTexture();
        this.xsiz = builder.xsiz;
        this.ysiz = builder.ysiz;
        this.zsiz = builder.zsiz;
        this.xpiv = (float)vox.xpiv[voxmip] / 256.0f;
        this.ypiv = (float)vox.ypiv[voxmip] / 256.0f;
        this.zpiv = (float)vox.zpiv[voxmip] / 256.0f;
        if (isVertexArray) {
            float[] va = builder.getVertices();
            short[] ia = builder.getIndices();
            int verSize = builder.getVertexSize();
            int size = va.length / verSize;
            this.vertices = BufferUtils.newFloatBuffer(size * 3);
            this.uv = BufferUtils.newFloatBuffer(size * 2);
            this.indices = BufferUtils.newShortBuffer(ia.length);
            for (int i = 0; i < va.length; i += verSize) {
                this.vertices.put(va[i] * 64.0f);
                this.vertices.put(va[i + 1] * 64.0f);
                this.vertices.put(va[i + 2] * 64.0f);
                this.uv.put(va[i + 4]);
                this.uv.put(va[i + 5]);
            }
            this.vertices.flip();
            this.uv.flip();
            this.indices.put(ia).flip();
        } else {
            this.quad = builder.quad;
            this.qcnt = builder.qcnt;
            this.qfacind = builder.qfacind;
        }
    }

    @Override
    public boolean render(int pal, int shade, int surfnum, int visibility, float alpha) {
        GLTile skin = this.getSkin(pal);
        if (skin == null) {
            return false;
        }
        if (alpha != 1.0f) {
            this.gl10.glEnable(3042);
        } else {
            this.gl10.glDisable(3042);
        }
        skin.bind();
        this.setTextureParameters(skin, pal, shade, visibility, alpha);
        if (this.isVertexArray) {
            this.gl10.glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
            this.gl10.glEnableClientState(32884);
            this.gl10.glEnableClientState(32888);
            this.gl10.glVertexPointer(3, 5126, 0, this.vertices);
            this.gl10.glTexCoordPointer(2, 5126, 0, this.uv);
            this.gl10.glDrawElements(4, 0, 5123, this.indices);
            this.gl10.glDisableClientState(32884);
            this.gl10.glDisableClientState(32888);
            return true;
        }
        float ru = 1.0f / (float)this.skinData.getWidth();
        float rv = 1.0f / (float)this.skinData.getHeight();
        this.gl10.glBegin(7);
        int fi = 0;
        for (int i = 0; i < this.qcnt; ++i) {
            if (i == this.qfacind[fi]) {
                float f = this.dvoxclut[fi++];
                this.gl10.glColor4f(this.color.r * f, this.color.g * f, this.color.b * f, this.color.a * f);
            }
            VoxelBuilder.Rectangle rec = this.quad[i];
            float xx = rec.getX(0) + rec.getX(2);
            float yy = rec.getY(0) + rec.getY(2);
            float zz = rec.getZ(0) + rec.getZ(2);
            for (int j = 0; j < 4; ++j) {
                this.gl10.glTexCoord2d((float)rec.getU(j) * ru, (float)rec.getV(j) * rv);
                float vertx = (float)rec.getX(j) - this.dvoxphack[xx > (float)(rec.getX(j) * 2) ? 1 : 0] + this.dvoxphack[xx < (float)(rec.getX(j) * 2) ? 1 : 0];
                float verty = (float)rec.getY(j) - this.dvoxphack[yy > (float)(rec.getY(j) * 2) ? 1 : 0] + this.dvoxphack[yy < (float)(rec.getY(j) * 2) ? 1 : 0];
                float vertz = (float)rec.getZ(j) - this.dvoxphack[zz > (float)(rec.getZ(j) * 2) ? 1 : 0] + this.dvoxphack[zz < (float)(rec.getZ(j) * 2) ? 1 : 0];
                this.gl10.glVertex3d(vertx, verty, vertz);
            }
        }
        this.gl10.glEnd();
        return true;
    }

    @Override
    public void dispose() {
        this.clearSkins();
    }

    @Override
    public ShaderProgram getShader() {
        return null;
    }
}

