/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.Voxel;

import ru.m210projects.Build.Render.TextureHandle.DummyTileData;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Types.Palette;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.Types.Tile;

public class VoxelSkin
extends DummyTileData {
    public VoxelSkin(TileData.PixelFormat fmt, PaletteManager paletteManager, Tile tile, int dapal) {
        super(fmt, tile.getWidth(), tile.getHeight());
        if (fmt != TileData.PixelFormat.Pal8) {
            byte[][] palookup = paletteManager.getPalookupBuffer();
            Palette curpalette = paletteManager.getCurrentPalette();
            for (int y = 0; y < this.height; ++y) {
                int wpptr = y * this.width;
                int x = 0;
                while (x < this.width) {
                    int wp = wpptr << 2;
                    int dacol = tile.data[wpptr] & 0xFF;
                    dacol = palookup[dapal][dacol] & 0xFF;
                    this.data.putInt(wp, curpalette.getRGB(dacol) + -16777216);
                    ++x;
                    ++wpptr;
                }
            }
        } else {
            this.data.put(tile.data, 0, this.width * this.height);
        }
    }

    @Override
    public boolean isClamped() {
        return true;
    }

    @Override
    public boolean hasAlpha() {
        return false;
    }
}

