/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render;

import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.AbstractRenderer;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.net.Mmulti;

public abstract class OrphoRenderer {
    protected final AbstractRenderer renderer;
    protected IOverheadMapSettings mapSettings;
    protected int xdim;
    protected int ydim;

    public OrphoRenderer(AbstractRenderer renderer, IOverheadMapSettings mapSettings) {
        this.renderer = renderer;
        this.mapSettings = mapSettings;
        this.xdim = renderer.getWidth();
        this.ydim = renderer.getHeight();
    }

    public abstract void init();

    public abstract void uninit();

    public abstract int printext(Font var1, int var2, int var3, char[] var4, float var5, int var6, int var7, TextAlign var8, Transparent var9, boolean var10);

    public abstract void drawline256(int var1, int var2, int var3, int var4, int var5);

    public abstract void rotatesprite(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    public abstract void nextpage();

    public abstract void drawmapview(int var1, int var2, int var3, int var4);

    protected int getclipmask(int a, int b, int c, int d) {
        int bA = a < 0 ? 1 : 0;
        int bB = b < 0 ? 1 : 0;
        int bC = c < 0 ? 1 : 0;
        int bD = d < 0 ? 1 : 0;
        d = bA * 8 + bB * 4 + bC * 2 + bD;
        return d << 4 ^ 0xF0 | d;
    }

    public void drawoverheadmap(BoardService boardService, int cposx, int cposy, int czoom, short cang) {
        int k;
        int y1;
        int x1;
        int oy;
        int ox;
        Wall wal;
        int j;
        int endwall;
        int startwall;
        int i;
        int x2 = 0;
        int y2 = 0;
        int numsectors = boardService.getSectorCount();
        int xvect = EngineUtils.sin(-cang) * czoom;
        int yvect = EngineUtils.sin(1536 - cang) * czoom;
        int xvect2 = Pragmas.mulscale(xvect, this.renderer.yxaspect, 16);
        int yvect2 = Pragmas.mulscale(yvect, this.renderer.yxaspect, 16);
        for (i = 0; i < numsectors; ++i) {
            Sector sec;
            if (!this.mapSettings.isFullMap() && !Engine.show2dsector.getBit(i) || !boardService.isValidSector(i) || !boardService.isValidWall((sec = boardService.getSector(i)).getWallptr()) || sec.getWallnum() < 3) continue;
            startwall = sec.getWallptr();
            endwall = sec.getWallptr() + sec.getWallnum();
            if (startwall < 0 || endwall < 0) continue;
            for (j = (int)startwall; j < endwall; ++j) {
                if (!boardService.isValidWall(j) || !boardService.isValidWall(boardService.getWall(j).getPoint2())) continue;
                wal = boardService.getWall(j);
                if (!this.mapSettings.isShowRedWalls() || !boardService.isValidWall(wal.getNextwall()) || !boardService.isValidSector(wal.getNextsector()) || !this.mapSettings.isWallVisible(j, i)) continue;
                ox = this.mapSettings.getWallX(j) - cposx;
                oy = this.mapSettings.getWallY(j) - cposy;
                x1 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (this.xdim << 11);
                y1 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (this.ydim << 11);
                ox = this.mapSettings.getWallX(wal.getPoint2()) - cposx;
                oy = this.mapSettings.getWallY(wal.getPoint2()) - cposy;
                x2 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (this.xdim << 11);
                y2 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (this.ydim << 11);
                int col = this.mapSettings.getWallColor(j, i);
                if (col < 0) continue;
                this.drawline256(x1, y1, x2, y2, col);
            }
        }
        if (this.mapSettings.isShowSprites(IOverheadMapSettings.MapView.Lines)) {
            for (i = 0; i < numsectors; ++i) {
                if (!this.mapSettings.isFullMap() && !Engine.show2dsector.getBit(i)) continue;
                block8: for (ListNode<Sprite> node = boardService.getSectNode(i); node != null; node = node.getNext()) {
                    j = node.getIndex();
                    Sprite spr = node.get();
                    if ((spr.getCstat() & 0x8000) != 0 || spr.getXrepeat() == 0 || spr.getYrepeat() == 0 || !this.mapSettings.isSpriteVisible(IOverheadMapSettings.MapView.Lines, j)) continue;
                    switch (spr.getCstat() & 0x30) {
                        case 0: {
                            if (!this.mapSettings.isShowSprites(IOverheadMapSettings.MapView.Lines) || !this.renderer.gotSector(i) || czoom <= 96) continue block8;
                            ox = this.mapSettings.getSpriteX(j) - cposx;
                            oy = this.mapSettings.getSpriteY(j) - cposy;
                            x1 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16);
                            y1 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16);
                            int daang = spr.getAng() - cang & 0x7FF;
                            this.rotatesprite((x1 << 4) + (this.xdim << 15), (y1 << 4) + (this.ydim << 15), Pragmas.mulscale((long)czoom * (long)spr.getYrepeat(), this.renderer.yxaspect, 16), daang, spr.getPicnum(), spr.getShade(), spr.getPal(), (spr.getCstat() & 2) >> 1, this.renderer.windowx1, this.renderer.windowy1, this.renderer.windowx2, this.renderer.windowy2);
                            continue block8;
                        }
                        case 16: {
                            ArtEntry pic = this.renderer.getTile(spr.getPicnum());
                            x1 = this.mapSettings.getSpriteX(j);
                            y1 = this.mapSettings.getSpriteY(j);
                            byte xoff = (byte)(pic.getOffsetX() + spr.getXoffset());
                            if ((spr.getCstat() & 4) > 0) {
                                xoff = -xoff;
                            }
                            k = spr.getAng();
                            int l = spr.getXrepeat();
                            int dax = EngineUtils.cos(k - 512) * l;
                            int day = EngineUtils.sin(k - 512) * l;
                            l = pic.getWidth();
                            k = (l >> 1) + xoff;
                            x2 = (x1 -= Pragmas.mulscale(dax, k, 16)) + Pragmas.mulscale(dax, l, 16);
                            y2 = (y1 -= Pragmas.mulscale(day, k, 16)) + Pragmas.mulscale(day, l, 16);
                            ox = x1 - cposx;
                            oy = y1 - cposy;
                            x1 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16);
                            y1 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16);
                            ox = x2 - cposx;
                            oy = y2 - cposy;
                            x2 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16);
                            y2 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16);
                            int col = this.mapSettings.getSpriteColor(j);
                            if (col < 0) continue block8;
                            this.drawline256(x1 + (this.xdim << 11), y1 + (this.ydim << 11), x2 + (this.xdim << 11), y2 + (this.ydim << 11), col);
                            continue block8;
                        }
                        case 32: {
                            ArtEntry pic = this.renderer.getTile(spr.getPicnum());
                            byte xoff = (byte)(pic.getOffsetX() + spr.getXoffset());
                            byte yoff = (byte)(pic.getOffsetY() + spr.getYoffset());
                            if ((spr.getCstat() & 4) > 0) {
                                xoff = -xoff;
                            }
                            if ((spr.getCstat() & 8) > 0) {
                                yoff = -yoff;
                            }
                            k = spr.getAng();
                            int cosang = EngineUtils.cos(k);
                            int sinang = EngineUtils.sin(k);
                            int xspan = pic.getWidth();
                            short xrepeat = spr.getXrepeat();
                            int yspan = pic.getHeight();
                            short yrepeat = spr.getYrepeat();
                            int dax = ((xspan >> 1) + xoff) * xrepeat;
                            int day = ((yspan >> 1) + yoff) * yrepeat;
                            x1 = this.mapSettings.getSpriteX(j) + Pragmas.dmulscale(sinang, dax, cosang, day, 16);
                            y1 = this.mapSettings.getSpriteY(j) + Pragmas.dmulscale(sinang, day, -cosang, dax, 16);
                            int l = xspan * xrepeat;
                            x2 = x1 - Pragmas.mulscale(sinang, l, 16);
                            y2 = y1 + Pragmas.mulscale(cosang, l, 16);
                            l = yspan * yrepeat;
                            k = -Pragmas.mulscale(cosang, l, 16);
                            int x3 = x2 + k;
                            int x4 = x1 + k;
                            k = -Pragmas.mulscale(sinang, l, 16);
                            int y3 = y2 + k;
                            int y4 = y1 + k;
                            ox = x1 - cposx;
                            oy = y1 - cposy;
                            x1 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16);
                            y1 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16);
                            ox = x2 - cposx;
                            oy = y2 - cposy;
                            x2 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16);
                            y2 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16);
                            ox = x3 - cposx;
                            oy = y3 - cposy;
                            x3 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16);
                            y3 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16);
                            ox = x4 - cposx;
                            oy = y4 - cposy;
                            x4 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16);
                            y4 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16);
                            int col = this.mapSettings.getSpriteColor(j);
                            if (col < 0) continue block8;
                            this.drawline256(x1 + (this.xdim << 11), y1 + (this.ydim << 11), x2 + (this.xdim << 11), y2 + (this.ydim << 11), col);
                            this.drawline256(x2 + (this.xdim << 11), y2 + (this.ydim << 11), x3 + (this.xdim << 11), y3 + (this.ydim << 11), col);
                            this.drawline256(x3 + (this.xdim << 11), y3 + (this.ydim << 11), x4 + (this.xdim << 11), y4 + (this.ydim << 11), col);
                            this.drawline256(x4 + (this.xdim << 11), y4 + (this.ydim << 11), x1 + (this.xdim << 11), y1 + (this.ydim << 11), col);
                        }
                    }
                }
            }
        }
        for (i = 0; i < numsectors; ++i) {
            if (!this.mapSettings.isFullMap() && !Engine.show2dsector.getBit(i) || !boardService.isValidSector(i)) continue;
            startwall = boardService.getSector(i).getWallptr();
            endwall = boardService.getSector(i).getWallptr() + boardService.getSector(i).getWallnum();
            if (startwall < 0 || endwall < 0) continue;
            k = -1;
            for (int j2 = startwall; j2 < endwall; ++j2) {
                ArtEntry pic;
                wal = boardService.getWall(j2);
                if (!boardService.isValidWall(j2) || !boardService.isValidWall(boardService.getWall(j2).getPoint2()) || wal.getNextwall() >= 0 || !(pic = this.renderer.getTile(wal.getPicnum())).hasSize()) continue;
                if (j2 == k) {
                    x1 = x2;
                    y1 = y2;
                } else {
                    ox = this.mapSettings.getWallX(j2) - cposx;
                    oy = this.mapSettings.getWallY(j2) - cposy;
                    x1 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (this.xdim << 11);
                    y1 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (this.ydim << 11);
                }
                k = wal.getPoint2();
                if (boardService.getWall(k) == null) continue;
                ox = this.mapSettings.getWallX(k) - cposx;
                oy = this.mapSettings.getWallY(k) - cposy;
                x2 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (this.xdim << 11);
                y2 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (this.ydim << 11);
                int col = this.mapSettings.getWallColor(j2, i);
                if (col < 0) continue;
                this.drawline256(x1, y1, x2, y2, col);
            }
        }
        i = Mmulti.connecthead;
        while (i >= 0) {
            int spr = this.mapSettings.getPlayerSprite(i);
            if (spr != -1 && boardService.isValidSector(boardService.getSprite(spr).getSectnum())) {
                Sprite pPlayer = boardService.getSprite(spr);
                ox = this.mapSettings.getSpriteX(spr) - cposx;
                oy = this.mapSettings.getSpriteY(spr) - cposy;
                int dx = Pragmas.mulscale(ox, xvect, 16) - Pragmas.mulscale(oy, yvect, 16);
                int dy = Pragmas.mulscale(oy, xvect2, 16) + Pragmas.mulscale(ox, yvect2, 16);
                int dang = pPlayer.getAng() - cang & 0x7FF;
                int viewindex = this.mapSettings.getViewPlayer();
                if (i == viewindex && !this.mapSettings.isScrollMode()) {
                    dx = 0;
                    dy = viewindex ^ i;
                    dang = 0;
                }
                if (i == viewindex || this.mapSettings.isShowAllPlayers()) {
                    int picnum = this.mapSettings.getPlayerPicnum(i);
                    if (picnum == -1) {
                        x2 = 0;
                        y2 = -(this.mapSettings.getPlayerZoom(i, czoom) << 1);
                        int x3 = Pragmas.mulscale(x2, this.renderer.yxaspect, 16);
                        int y3 = Pragmas.mulscale(y2, this.renderer.yxaspect, 16);
                        int col = this.mapSettings.getSpriteColor(spr);
                        if (col >= 0) {
                            this.drawline256(dx - x2 + (this.xdim << 11), dy - y3 + (this.ydim << 11), dx + x2 + (this.xdim << 11), dy + y3 + (this.ydim << 11), col);
                            this.drawline256(dx - y2 + (this.xdim << 11), dy + x3 + (this.ydim << 11), dx + x2 + (this.xdim << 11), dy + y3 + (this.ydim << 11), col);
                            this.drawline256(dx + y2 + (this.xdim << 11), dy - x3 + (this.ydim << 11), dx + x2 + (this.xdim << 11), dy + y3 + (this.ydim << 11), col);
                        }
                    } else {
                        int nZoom = this.mapSettings.getPlayerZoom(i, czoom);
                        int sx = (dx << 4) + (this.xdim << 15);
                        int sy = (dy << 4) + (this.ydim << 15);
                        this.rotatesprite(sx, sy, nZoom, (short)dang, this.mapSettings.getPlayerPicnum(i), pPlayer.getShade(), pPlayer.getPal(), (pPlayer.getCstat() & 2) >> 1, this.renderer.windowx1, this.renderer.windowy1, this.renderer.windowx2, this.renderer.windowy2);
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    public void resize(int width, int height) {
        this.xdim = width;
        this.ydim = height;
    }
}

