/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.Polymost;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.AbstractRenderer;
import ru.m210projects.Build.Render.DefaultMapSettings;
import ru.m210projects.Build.Render.GLFog;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Render.ModelHandle.GLModel;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDAnimation;
import ru.m210projects.Build.Render.ModelHandle.ModelManager;
import ru.m210projects.Build.Render.ModelHandle.Voxel.GLVoxel;
import ru.m210projects.Build.Render.OrphoRenderer;
import ru.m210projects.Build.Render.Polymost.PolyClipper;
import ru.m210projects.Build.Render.Polymost.Polygon;
import ru.m210projects.Build.Render.Polymost.Polymost2D;
import ru.m210projects.Build.Render.Polymost.PolymostModelManager;
import ru.m210projects.Build.Render.Polymost.PolymostModelRenderer;
import ru.m210projects.Build.Render.Polymost.PolymostVideoContext;
import ru.m210projects.Build.Render.Polymost.Surface;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.RenderingType;
import ru.m210projects.Build.Render.TexFilter;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.IndexedShader;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.Color;
import ru.m210projects.Build.Render.Types.GL10;
import ru.m210projects.Build.Render.Types.ScreenFade;
import ru.m210projects.Build.Render.Types.Spriteext;
import ru.m210projects.Build.Render.listeners.PaletteListener;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.Render.listeners.TileListener;
import ru.m210projects.Build.Render.listeners.WorldListener;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Script.ModelsInfo;
import ru.m210projects.Build.Types.AnimType;
import ru.m210projects.Build.Types.FastColorLookup;
import ru.m210projects.Build.Types.Palette;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.Variable;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.DynamicArray;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameConfig;

public class Polymost
extends AbstractRenderer
implements PaletteListener,
WorldListener,
TileListener,
PrecacheListener {
    protected static final float[] vertices = new float[]{-2.5f, 1.0f, 2.5f, 1.0f, 0.0f, -2.5f};
    protected static final int MAXWALLSB = (Engine.MAXWALLS >> 2) + (Engine.MAXWALLS >> 3);
    private static final Vector2 projPoint = new Vector2();
    private static final Vector3 drawmasks_maskeq = new Vector3();
    private static final Vector3 drawmasks_p1eq = new Vector3();
    private static final Vector3 drawmasks_p2eq = new Vector3();
    private static final Vector2 drawmasks_dot = new Vector2();
    private static final Vector2 drawmasks_dot2 = new Vector2();
    private static final Vector2 drawmasks_middle = new Vector2();
    private static final Vector2 drawmasks_pos = new Vector2();
    private static final Vector2 drawmasks_spr = new Vector2();
    public static float MAXDRUNKANGLE = 2.5f;
    public static int r_parallaxskyclamping = 1;
    public static int r_parallaxskypanning = 0;
    public static int r_vertexarrays = 1;
    public static int r_vbos = 1;
    private static float dceilzsofslope;
    private static float dfloorzsofslope;
    protected final com.badlogic.gdx.graphics.Color polyColor = new com.badlogic.gdx.graphics.Color();
    protected final float[][] matrix = new float[4][4];
    private final int[] spritesx = new int[1025];
    private final int[] spritesy = new int[1025];
    private final int[] spritesz = new int[1025];
    private final short[] p2 = new short[MAXWALLSB];
    private final short[] thesector = new short[MAXWALLSB];
    private final short[] thewall = new short[MAXWALLSB];
    private final short[] maskwall = new short[MAXWALLSB];
    private final short[] bunchfirst = new short[MAXWALLSB];
    private final short[] bunchlast = new short[MAXWALLSB];
    private final int[] sectorborder = new int[256];
    private final double[] dxb1 = new double[MAXWALLSB];
    private final double[] dxb2 = new double[MAXWALLSB];
    private final byte[] ptempbuf = new byte[MAXWALLSB << 1];
    private final float SCISDIST = 1.0f;
    private final PolyClipper clipper;
    private final Polygon[] drawpoly = new Polygon[16];
    private final double[] nonparallaxed_ft = new double[4];
    private final double[] nonparallaxed_px = new double[3];
    private final double[] nonparallaxed_py = new double[3];
    private final double[] nonparallaxed_dd = new double[3];
    private final double[] nonparallaxed_uu = new double[3];
    private final double[] nonparallaxed_vv = new double[3];
    private final double[] drawalls_dd = new double[3];
    private final double[] drawalls_vv = new double[3];
    private final double[] drawalls_ft = new double[4];
    private final Wall drawalls_nwal = new Wall();
    private final int[] skywalx = new int[]{-512, 512, 512, -512};
    private final int[] skywaly = new int[]{-512, -512, 512, 512};
    private final double[] drawrooms_px = new double[6];
    private final double[] drawrooms_py = new double[6];
    private final double[] drawrooms_pz = new double[6];
    private final double[] drawrooms_px2 = new double[6];
    private final double[] drawrooms_py2 = new double[6];
    private final double[] drawrooms_pz2 = new double[6];
    private final double[] drawrooms_sx = new double[6];
    private final double[] drawrooms_sy = new double[6];
    private final Surface[] dmaskwall = new Surface[8];
    private final float[] drawmaskwall_csy = new float[4];
    private final float[] drawmaskwall_fsy = new float[4];
    private final int[] drawmaskwall_cz = new int[4];
    private final int[] drawmaskwall_fz = new int[4];
    private final float TSPR_OFFSET_FACTOR = 8.0E-6f;
    private final Surface[] dsprite = new Surface[6];
    private final float[] drawsprite_ft = new float[4];
    private final Array<Vector2> dsin = new DynamicArray<Vector2>(4096, Vector2.class);
    private final Array<Vector2> dcoord = new DynamicArray<Vector2>(4096, Vector2.class);
    private final Array<AtomicBoolean> spritewall = new DynamicArray<AtomicBoolean>(4096, AtomicBoolean.class);
    public RenderingType renderingType = RenderingType.Nothing;
    public GLFog globalfog;
    public int gltexcacnum = -1;
    public double defznear = 0.1;
    public double defzfar = 0.9;
    protected float fovFactor = 1.0f;
    protected short globalpicnum;
    protected int globalorientation;
    protected Sprite[] tspriteptr = new Sprite[1025];
    protected float[] alphahackarray = new float[Engine.MAXTILES];
    protected float shadescale = 1.1f;
    protected int shadescale_unbounded = 0;
    protected float curpolygonoffset;
    protected float gyxscale;
    protected float gviewxrange;
    protected float ghalfx;
    protected float grhalfxdown10;
    protected float grhalfxdown10x;
    protected double gxyaspect;
    protected float ghoriz;
    protected float gcosang;
    protected float gsinang;
    protected float gcosang2;
    protected float gsinang2;
    protected float gchang;
    protected float gshang;
    protected float ogshang;
    protected float gctang;
    protected float gstang;
    protected float gtang = 0.0f;
    protected double guo;
    protected double gux;
    protected double guy;
    protected double gvo;
    protected double gvx;
    protected double gvy;
    protected double gdo;
    protected double gdx;
    protected double gdy;
    protected DefScript defs;
    protected GL10 gl;
    protected OrphoRenderer ortho;
    protected PolymostModelRenderer mdrenderer;
    protected boolean isInited = false;
    protected TextureManager textureCache;
    protected ModelManager modelManager;
    protected IndexedShader texshader;
    float glox1;
    float gloy1;
    float glox2;
    float gloy2;
    int pow2xsplit = 0;
    int skyclamphack = 0;
    private boolean drawRooms;
    private int numscans;
    private int numbunches;
    private int maskwallcnt;
    private int global_cf_z;
    private float global_cf_xpanning;
    private float global_cf_ypanning;
    private float global_cf_heinum;
    private int global_cf_shade;
    private int global_cf_pal;
    private int srepeat = 0;
    private int trepeat = 0;
    private int glmultisample;
    private int glnvmultisamplehint;

    public Polymost(GameConfig config) {
        super(config);
        config.setVideoContext(new PolymostVideoContext(this));
        this.clipper = new PolyClipper(this);
        IntStream.range(0, this.drawpoly.length).forEach(i -> {
            this.drawpoly[i] = new Polygon();
        });
        IntStream.range(0, this.dmaskwall.length).forEach(i -> {
            this.dmaskwall[i] = new Surface();
        });
        IntStream.range(0, this.dsprite.length).forEach(i -> {
            this.dsprite[i] = new Surface();
        });
        this.globalfog = new GLFog();
    }

    public static void equation(Vector3 ret, float x1, float y1, float x2, float y2) {
        if (x2 - x1 != 0.0f) {
            ret.x = (y2 - y1) / (x2 - x1);
            ret.y = -1.0f;
            ret.z = y1 - ret.x * x1;
        } else {
            ret.x = 1.0f;
            ret.y = 0.0f;
            ret.z = -x1;
        }
    }

    @Override
    public boolean isInited() {
        return this.isInited;
    }

    @Override
    public void uninit() {
        if (this.gltexcacnum < 0) {
            this.gltexcacnum = 0;
            this.gcosang2 = 0.0625f;
            this.gcosang = 0.0625f;
            this.gsinang2 = 0.0f;
            this.gsinang = 0.0f;
        }
        this.gl.glDisable(3008);
        this.gl.glDisable(32925);
        this.gl.glDisable(2912);
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.gl.glMatrixMode(5890);
        this.gl.glLoadIdentity();
        this.paletteManager.setListener(PaletteListener.DUMMY_PALETTE_CHANGE_LISTENER);
        this.boardService.setListener(WorldListener.DUMMY_LISTENER);
        this.tileManager.setTileListener(TileListener.DUMMY_LISTENER);
        this.textureCache.uninit();
        this.modelManager.dispose();
        this.clearskins(false);
        this.ortho.uninit();
        this.isInited = false;
    }

    @Override
    public void init(Engine engine) {
        super.init(engine);
        try {
            this.gl = GL10.instance;
            this.textureCache = this.getTextureManager();
            this.paletteManager.setListener(this);
            this.boardService.setListener(this);
            this.tileManager.setTileListener(this);
            this.modelManager = new PolymostModelManager(this);
            this.mdrenderer = new PolymostModelRenderer(this);
            this.ortho = this.allocOrphoRenderer(engine);
            this.setDefs(engine.getDefs());
            this.ortho.init();
            this.mdrenderer.init();
            this.globalfog.init(this.gl, this.paletteManager);
            GLInfo.init(this.gl);
            this.gl.glShadeModel(7425);
            this.gl.glHint(3152, 4354);
            this.gl.glHint(3154, 4354);
            this.gl.glBlendFunc(770, 771);
            this.gl.glPixelStorei(3333, 1);
            if (this.glmultisample > 0 && GLInfo.multisample != 0) {
                if (GLInfo.nvmultisamplehint != 0) {
                    this.gl.glHint(34100, this.glnvmultisamplehint != 0 ? 4354 : 4353);
                }
                this.gl.glEnable(32925);
            }
            if (r_vbos != 0 && GLInfo.vbos == 0) {
                Console.out.println("Your OpenGL implementation doesn't support Vertex Buffer Objects. Disabling...");
                r_vbos = 0;
            }
            Console.out.println("Polymost renderer is initialized", OsdColor.GREEN);
            Console.out.println(Gdx.graphics.getGLVersion().getRendererString() + " " + this.gl.glGetString(7938), OsdColor.YELLOW);
            this.config.setGlfilter(this.config.getGlfilter());
            this.config.setPaletteEmulation(this.config.isPaletteEmulation());
            this.config.setUseHighTiles(this.config.isUseHighTiles());
            this.config.setDetailMapping(this.config.isDetailMapping());
            this.config.setGlowMapping(this.config.isGlowMapping());
            this.isInited = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.isInited = false;
            Console.out.println("Polymost renderer initialization error!", OsdColor.RED);
        }
    }

    @Override
    public void resize(int width, int height) {
        if (width == this.xdim && height == this.ydim) {
            return;
        }
        this.xdim = width;
        this.ydim = height;
        this.ortho.resize(width, height);
        this.config.setgFov(this.config.getgFov());
        this.setview(0, 0, this.xdim - 1, this.ydim - 1);
        this.resizeglcheck();
    }

    @Override
    public void setviewtotile(DynamicArtEntry pic) {
        this.bakwindowx1[this.setviewcnt] = this.windowx1;
        this.bakwindowy1[this.setviewcnt] = this.windowy1;
        this.bakwindowx2[this.setviewcnt] = this.windowx2;
        this.bakwindowy2[this.setviewcnt] = this.windowy2;
        if (this.setviewcnt == 0) {
            this.baktile = pic;
        }
        this.offscreenrendering = true;
        ++this.setviewcnt;
        this.setview(0, 0, pic.getHeight() - 1, pic.getWidth() - 1);
    }

    @Override
    public void setviewback() {
        if (this.setviewcnt <= 0) {
            this.offscreenrendering = false;
            this.setaspect();
            return;
        }
        --this.setviewcnt;
        boolean bl = this.offscreenrendering = this.setviewcnt > 0;
        if (this.setviewcnt == 0 && this.baktile.exists()) {
            this.baktile.copyData(this.setviewbuf());
        }
        this.setview(this.bakwindowx1[this.setviewcnt], this.bakwindowy1[this.setviewcnt], this.bakwindowx2[this.setviewcnt], this.bakwindowy2[this.setviewcnt]);
    }

    public BoardService getBoardService() {
        return this.engine.getBoardService();
    }

    protected byte[] setviewbuf() {
        int width = this.baktile.getWidth();
        int heigth = this.baktile.getHeight();
        byte[] data = this.baktile.getBytes();
        ByteBuffer frame = this.getFrame(TileData.PixelFormat.Pal8, width, heigth);
        int sptr = 0;
        for (int i = width - 1; i >= 0; --i) {
            int dptr = i;
            for (int j = 0; j < heigth; ++j) {
                data[dptr] = frame.get(sptr++);
                dptr += width;
            }
        }
        return data;
    }

    @Override
    public int getWidth() {
        return this.xdim;
    }

    @Override
    public int getHeight() {
        return this.ydim;
    }

    protected TextureManager newTextureManager(Engine engine) {
        return new TextureManager(engine, TextureManager.ExpandTexture.Both);
    }

    public void setTextureParameters(GLTile tile, ArtEntry artEntry, int pal, int shade, int skybox, int method) {
        if (tile.getPixelFormat() == TileData.PixelFormat.Pal8) {
            if (!this.texshader.isBinded()) {
                Gdx.gl.glActiveTexture(33984);
                this.texshader.bind();
            }
            this.texshader.setTextureParams(pal, shade);
            float alpha = 1.0f;
            switch (method & 3) {
                case 2: {
                    alpha = this.TRANSLUSCENT1;
                    break;
                }
                case 3: {
                    alpha = this.TRANSLUSCENT2;
                }
            }
            if (!artEntry.exists()) {
                alpha = 0.01f;
            }
            this.texshader.setTextureSize(tile.getWidth(), tile.getHeight());
            this.texshader.setPaletteFiltered(this.config.getPaletteFiltered());
            this.texshader.setSoftShading(this.config.getSoftShading());
            this.texshader.setDrawLastIndex((method & 3) == 0 || !this.textureCache.alphaMode(method));
            this.texshader.setTransparent(alpha);
        } else {
            if (tile.isHighTile() && (tile.getHiresXScale() != 1.0f || tile.getHiresYScale() != 1.0f) && RenderingType.Skybox.getIndex() == 0) {
                this.gl.glMatrixMode(5890);
                this.gl.glLoadIdentity();
                this.gl.glScalef(tile.getHiresXScale(), tile.getHiresYScale(), 1.0f);
                this.gl.glMatrixMode(5888);
            }
            if (GLInfo.multisample != 0 && this.config.isUseHighTiles() && RenderingType.Skybox.getIndex() == 0) {
                GLTile glow;
                GLTile detail;
                if (this.config.isDetailMapping() && (detail = this.textureCache.get(tile.getPixelFormat(), artEntry, 255, 0, method)) != null) {
                    this.textureCache.bind(detail);
                    this.setupTextureDetail(detail);
                    this.gl.glMatrixMode(5890);
                    this.gl.glLoadIdentity();
                    if (detail.isHighTile() && detail.getHiresXScale() != 1.0f || detail.getHiresYScale() != 1.0f) {
                        this.gl.glScalef(detail.getHiresXScale(), detail.getHiresYScale(), 1.0f);
                    }
                    this.gl.glMatrixMode(5888);
                }
                if (this.config.isGlowMapping() && (glow = this.textureCache.get(tile.getPixelFormat(), artEntry, 254, 0, method)) != null) {
                    this.textureCache.bind(glow);
                    this.setupTextureGlow(glow);
                }
            }
            com.badlogic.gdx.graphics.Color c = this.getshadefactor(shade, method);
            if (this.defs != null && tile.isHighTile() && this.defs.texInfo != null) {
                if (tile.getPal() != pal) {
                    Color p = this.defs.texInfo.getTints(pal);
                    c.r *= (float)p.r / 255.0f;
                    c.g *= (float)p.g / 255.0f;
                    c.b *= (float)p.b / 255.0f;
                }
                Color pdetail = this.defs.texInfo.getTints(255);
                if (pdetail.r != 255 || pdetail.g != 255 || pdetail.b != 255) {
                    c.r *= (float)pdetail.r / 255.0f;
                    c.g *= (float)pdetail.g / 255.0f;
                    c.b *= (float)pdetail.b / 255.0f;
                }
            }
            if (!artEntry.exists()) {
                c.a = 0.01f;
            }
            this.gl.glColor4f(c.r, c.g, c.b, c.a);
        }
    }

    public com.badlogic.gdx.graphics.Color getshadefactor(int shade, int method) {
        float f;
        int numshades = this.paletteManager.getShadeCount();
        float fshade = Math.min(Math.max((float)shade * 1.04f, 0.0f), (float)numshades);
        this.polyColor.g = this.polyColor.b = (f = ((float)numshades - fshade) / (float)numshades);
        this.polyColor.r = this.polyColor.b;
        switch (method & 3) {
            default: {
                this.polyColor.a = 1.0f;
                break;
            }
            case 2: {
                this.polyColor.a = this.TRANSLUSCENT1;
                break;
            }
            case 3: {
                this.polyColor.a = this.TRANSLUSCENT2;
            }
        }
        return this.polyColor;
    }

    protected GLTile bind(ArtEntry dapicnum, int dapalnum, int dashade, int skybox, int method) {
        GLTile pth = this.textureCache.get(this.texshader != null ? TileData.PixelFormat.Pal8 : TileData.PixelFormat.Rgba, dapicnum, dapalnum, skybox, method);
        if (pth == null) {
            return null;
        }
        this.bind(pth);
        this.setTextureParameters(pth, dapicnum, dapalnum, dashade, skybox, method);
        return pth;
    }

    protected void bind(GLTile tile) {
        GLTile bindedTile = this.textureCache.getLastBinded();
        boolean res = tile != bindedTile && (bindedTile == null || tile.getPixelFormat() == TileData.PixelFormat.Pal8 && bindedTile.getPixelFormat() != TileData.PixelFormat.Pal8 || tile.getPixelFormat() != TileData.PixelFormat.Pal8 && bindedTile.getPixelFormat() == TileData.PixelFormat.Pal8);
        this.textureCache.bind(tile);
        if (res && this.texshader != null) {
            this.gl.glActiveTexture(33984);
            if (tile.getPixelFormat() != TileData.PixelFormat.Pal8) {
                this.texshader.unbind();
            } else {
                this.texshader.bind();
            }
        }
    }

    public TextureManager getTextureManager() {
        if (this.textureCache == null) {
            return this.newTextureManager(this.engine);
        }
        return this.textureCache;
    }

    protected boolean enableIndexedShader(boolean enable) {
        boolean isChanged = false;
        if (enable) {
            if (this.texshader == null) {
                this.texshader = this.allocIndexedShader();
                if (this.texshader != null) {
                    this.textureCache.changePalette(this.paletteManager.getCurrentPalette().getBytes());
                    isChanged = true;
                }
            }
        } else if (this.texshader != null) {
            this.texshader.dispose();
            this.texshader = null;
            this.textureCache.disposePalette();
            isChanged = true;
        }
        if (isChanged && this.isInited) {
            this.textureCache.uninit();
            this.clearskins(false);
        }
        return !enable || this.texshader != null;
    }

    @Override
    public void setDefs(DefScript defs) {
        this.textureCache.setTextureInfo(defs != null ? defs.texInfo : null);
        this.modelManager.setModelsInfo(defs != null ? defs.mdInfo : null);
        if (this.defs != null) {
            this.textureCache.uninit();
            this.gltexinvalidateall();
        }
        this.defs = defs;
    }

    protected boolean beginShowFade() {
        boolean hasShader;
        this.gl.glMatrixMode(5889);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glMatrixMode(5888);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glDisable(2929);
        this.gl.glDisable(3008);
        this.gl.glDisable(3553);
        this.globalfog.disable();
        this.gl.glEnable(3042);
        boolean bl = hasShader = this.texshader != null && this.texshader.isBinded();
        if (hasShader) {
            this.texshader.unbind();
        }
        return hasShader;
    }

    protected void endShowFade(boolean hasShader) {
        if (hasShader) {
            this.texshader.bind();
        }
        this.gl.glMatrixMode(5888);
        this.gl.glPopMatrix();
        this.gl.glMatrixMode(5889);
        this.gl.glPopMatrix();
        this.gl.glBlendFunc(770, 771);
        this.globalfog.enable();
    }

    @Override
    public void showScreenFade(ScreenFade screenFade) {
        int count = screenFade.getIntensive();
        int r = screenFade.getRed();
        int g = screenFade.getGreen();
        int b = screenFade.getBlue();
        int fr = 0;
        int fg = 0;
        int fb = 0;
        if (r > 0) {
            fr = Math.min(count - 128, r / 2);
        }
        if (g > 0) {
            fg = Math.min(count - 128, g / 2);
        }
        if (b > 0) {
            fb = Math.min(count - 128, b / 2);
        }
        boolean hasShader = this.beginShowFade();
        this.gl.glBlendFunc(771, 771);
        this.gl.glColor4ub(Math.min(63, fr) << 2, Math.min(63, fg) << 2, Math.min(63, fb) << 2, 4);
        this.gl.glBegin(4);
        for (int i = 0; i < 6; i += 2) {
            this.gl.glVertex2f(vertices[i], vertices[i + 1]);
        }
        this.gl.glEnd();
        this.endShowFade(hasShader);
    }

    public void invalidatetile(int tilenume, int pal, int how) {
        int firstpal;
        int numpal;
        TileData.PixelFormat fmt = this.textureCache.getFmt(tilenume);
        if (fmt == TileData.PixelFormat.Pal8) {
            numpal = 1;
            firstpal = 0;
        } else if (pal < 0) {
            numpal = 256;
            firstpal = 0;
        } else {
            numpal = 1;
            firstpal = pal % 256;
        }
        for (int hp = 0; hp < 8; hp += 4) {
            if ((how & Engine.pow2long[hp]) == 0) continue;
            for (int np = firstpal; np < firstpal + numpal; ++np) {
                this.textureCache.invalidate(tilenume, np, this.textureCache.clampingMode(hp));
            }
        }
    }

    public void gltexinvalidateall() {
        this.textureCache.invalidateall();
        this.clearskins(true);
    }

    @Override
    public void changepalette(byte[] palette) {
        super.changepalette(palette);
        this.gltexinvalidateall();
        if (this.texshader != null) {
            this.textureCache.changePalette(palette);
        }
        DEFAULT_SCREEN_FADE.set(0, 0, 0, 0);
    }

    public void clearskins(boolean bit8only) {
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            this.modelManager.clearSkins(i, bit8only);
        }
    }

    public void gltexapplyprops() {
        TexFilter filter = this.config.getGlfilter();
        this.textureCache.setFilter(filter);
        this.modelManager.setTextureFilter(filter);
    }

    public void setupTextureGlow(GLTile tex) {
        if (!tex.isGlowTexture()) {
            return;
        }
        this.gl.glTexEnvf(8960, 8704, 34160.0f);
        this.gl.glTexEnvf(8960, 34161, 34165.0f);
        this.gl.glTexEnvf(8960, 34176, 34168.0f);
        this.gl.glTexEnvf(8960, 34192, 768.0f);
        this.gl.glTexEnvf(8960, 34177, 5890.0f);
        this.gl.glTexEnvf(8960, 34193, 768.0f);
        this.gl.glTexEnvf(8960, 34178, 5890.0f);
        this.gl.glTexEnvf(8960, 34194, 771.0f);
        this.gl.glTexEnvf(8960, 34162, 7681.0f);
        this.gl.glTexEnvf(8960, 34184, 34168.0f);
        this.gl.glTexEnvf(8960, 34200, 770.0f);
        tex.setupTextureWrap(Texture.TextureWrap.Repeat);
    }

    public void setupTextureDetail(GLTile tex) {
        if (!tex.isDetailTexture()) {
            return;
        }
        this.gl.glTexEnvf(8960, 8704, 34160.0f);
        this.gl.glTexEnvf(8960, 34161, 8448.0f);
        this.gl.glTexEnvf(8960, 34176, 34168.0f);
        this.gl.glTexEnvf(8960, 34192, 768.0f);
        this.gl.glTexEnvf(8960, 34177, 5890.0f);
        this.gl.glTexEnvf(8960, 34193, 768.0f);
        this.gl.glTexEnvf(8960, 34162, 7681.0f);
        this.gl.glTexEnvf(8960, 34184, 34168.0f);
        this.gl.glTexEnvf(8960, 34200, 770.0f);
        this.gl.glTexEnvf(8960, 34163, 2.0f);
        tex.setupTextureWrap(Texture.TextureWrap.Repeat);
    }

    protected void glViewport(float x, float y, float x2, float y2) {
        this.gl.glViewport((int)(x *= this.backBufferScale), (int)(y *= this.backBufferScale), (int)(x2 *= this.backBufferScale), (int)(y2 *= this.backBufferScale));
    }

    public void resizeglcheck() {
        if (this.glox1 != (float)this.windowx1 || this.gloy1 != (float)this.windowy1 || this.glox2 != (float)this.windowx2 || this.gloy2 != (float)this.windowy2) {
            this.glox1 = this.windowx1;
            this.gloy1 = this.windowy1;
            this.glox2 = this.windowx2;
            this.gloy2 = this.windowy2;
            this.glViewport(this.windowx1, this.ydim - (this.windowy2 + 1), this.windowx2 - this.windowx1 + 1, this.windowy2 - this.windowy1 + 1);
            this.gl.glMatrixMode(5889);
            this.gl.glLoadIdentity();
            float ang = (87.0f - 24.0f * this.gshang * this.gshang) * 320.0f / (float)this.xdimen;
            this.glPerspective(ang / 256.0f, (float)this.xdimen / (float)this.ydimen, -this.ydimen, this.ydimen);
            this.gl.glMatrixMode(5888);
            this.gl.glLoadIdentity();
            this.globalfog.enable();
        }
    }

    public void glPerspective(float fovyInDegrees, float aspectRatio, float znear, float zfar) {
        float ymax = (float)((double)znear * Math.tan((double)fovyInDegrees * Math.PI / 360.0));
        float xmax = ymax * aspectRatio;
        this.glFrustumf(-xmax, xmax, -ymax, ymax, znear, zfar);
    }

    public void glFrustumf(float left, float right, float bottom, float top, float znear, float zfar) {
        float A2 = (right + left) / (right - left);
        float B = (top + bottom) / (top - bottom);
        float C = -(zfar + znear) / (zfar - znear);
        float D = -(2.0f * zfar * znear) / (zfar - znear);
        this.matrix[0][0] = 2.0f * znear / (right - left);
        this.matrix[0][1] = 0.0f;
        this.matrix[0][2] = A2;
        this.matrix[0][3] = 0.0f;
        this.matrix[1][0] = 0.0f;
        this.matrix[1][1] = 2.0f * znear / (top - bottom);
        this.matrix[1][2] = B;
        this.matrix[1][3] = 0.0f;
        this.matrix[2][0] = 0.0f;
        this.matrix[2][1] = 0.0f;
        this.matrix[2][2] = C;
        this.matrix[2][3] = D;
        this.matrix[3][0] = 0.0f;
        this.matrix[3][1] = 0.0f;
        this.matrix[3][2] = -1.0f;
        this.matrix[3][3] = 0.0f;
        this.gl.glLoadMatrixf(this.matrix);
    }

    private int drawpoly_math(int nn, int i, int j, double ngux, double ngdx, double nguy, double ngdy, double nguo, double ngdo, double var) {
        double f = -(this.drawpoly[i].px * (ngux - ngdx * var) + this.drawpoly[i].py * (nguy - ngdy * var) + (nguo - ngdo * var)) / ((this.drawpoly[j].px - this.drawpoly[i].px) * (ngux - ngdx * var) + (this.drawpoly[j].py - this.drawpoly[i].py) * (nguy - ngdy * var));
        this.drawpoly[nn].uu = (this.drawpoly[j].px - this.drawpoly[i].px) * f + this.drawpoly[i].px;
        this.drawpoly[nn].vv = (this.drawpoly[j].py - this.drawpoly[i].py) * f + this.drawpoly[i].py;
        return ++nn;
    }

    protected void drawpoly(Surface[] dm, int n, int method) {
        int yy;
        int xx;
        GLTile pth;
        double r;
        double oy2;
        double ox2;
        double oz;
        double oy;
        double ox;
        boolean dorot;
        int j;
        int i;
        double f;
        double du0 = 0.0;
        double du1 = 0.0;
        if (method == -1) {
            return;
        }
        if (n == 3) {
            if ((dm[0].px - dm[1].px) * (dm[2].py - dm[1].py) >= (dm[2].px - dm[1].px) * (dm[0].py - dm[1].py)) {
                return;
            }
        } else {
            f = 0.0;
            i = n - 2;
            j = n - 1;
            int k = 0;
            while (k < n) {
                if (i < 0) {
                    return;
                }
                f += (dm[i].px - dm[k].px) * dm[j].py;
                i = j;
                j = k++;
            }
            if (f <= 0.0) {
                return;
            }
        }
        if (this.globalpicnum >= Engine.MAXTILES) {
            this.globalpicnum = 0;
        }
        this.setgotpic(this.globalpicnum);
        ArtEntry pic = this.getTile(this.globalpicnum);
        int tsizx = pic.getWidth();
        int tsizy = pic.getHeight();
        if (!this.paletteManager.isValidPalette(this.globalpal)) {
            this.globalpal = 0;
        }
        boolean HOM = false;
        if (!pic.exists()) {
            tsizy = 1;
            tsizx = 1;
            HOM = true;
        }
        j = 0;
        boolean bl = dorot = (double)this.gchang != 1.0 || (double)this.gctang != 1.0;
        if (dorot) {
            for (i = 0; i < n; ++i) {
                ox = dm[i].px - (double)this.ghalfx;
                oy = dm[i].py - (double)this.ghoriz;
                oz = this.ghalfx;
                ox2 = ox;
                oy2 = oy * (double)this.gchang - oz * (double)this.gshang;
                double oz2 = oy * (double)this.gshang + oz * (double)this.gchang;
                ox = ox2 * (double)this.gctang - oy2 * (double)this.gstang;
                oy = ox2 * (double)this.gstang + oy2 * (double)this.gctang;
                oz = oz2;
                r = (double)this.ghalfx / oz;
                this.drawpoly[j].dd = (dm[i].px * this.gdx + dm[i].py * this.gdy + this.gdo) * r;
                this.drawpoly[j].uu = (dm[i].px * this.gux + dm[i].py * this.guy + this.guo) * r;
                this.drawpoly[j].vv = (dm[i].px * this.gvx + dm[i].py * this.gvy + this.gvo) * r;
                this.drawpoly[j].px = ox * r + (double)this.ghalfx;
                this.drawpoly[j].py = oy * r + (double)this.ghoriz;
                if (j != 0 && this.drawpoly[j].px == this.drawpoly[j - 1].px && this.drawpoly[j].py == this.drawpoly[j - 1].py) continue;
                ++j;
            }
        } else {
            for (i = 0; i < n; ++i) {
                this.drawpoly[j].px = dm[i].px;
                this.drawpoly[j].py = dm[i].py;
                if (j != 0 && this.drawpoly[j].px == this.drawpoly[j - 1].px && this.drawpoly[j].py == this.drawpoly[j - 1].py) continue;
                ++j;
            }
        }
        while (j >= 3 && this.drawpoly[j - 1].px == this.drawpoly[0].px && this.drawpoly[j - 1].py == this.drawpoly[0].py) {
            --j;
        }
        if (j < 3) {
            return;
        }
        n = j;
        if (this.skyclamphack != 0) {
            method |= 4;
        }
        if ((pth = this.bind(pic, this.globalpal, this.globalshade, RenderingType.Skybox.getIndex(), method)) == null) {
            return;
        }
        int texunits = this.textureCache.getTextureUnits();
        if (this.srepeat != 0) {
            this.gl.glTexParameteri(3553, 10242, 10497);
        }
        if (this.trepeat != 0) {
            this.gl.glTexParameteri(3553, 10243, 10497);
        }
        float hackscx = 1.0f;
        float hackscy = 1.0f;
        if (pth.isHighTile()) {
            hackscx = pth.getXScale();
            hackscy = pth.getYScale();
            tsizx = pth.getWidth();
            tsizy = pth.getHeight();
            HOM = false;
        }
        if (GLInfo.texnpot == 0) {
            for (xx = 1; xx < tsizx; xx += xx) {
            }
            ox2 = 1.0 / (double)xx;
            for (yy = 1; yy < tsizy; yy += yy) {
            }
            oy2 = 1.0 / (double)yy;
        } else {
            xx = tsizx;
            ox2 = 1.0 / (double)xx;
            yy = tsizy;
            oy2 = 1.0 / (double)yy;
        }
        if ((method & 3) == 0 && !HOM) {
            this.gl.glDisable(3042);
            this.gl.glDisable(3008);
        } else {
            float al = 0.0f;
            if (pth != null && pth.getAlphaCut() >= 0.0f) {
                al = pth.getAlphaCut();
            }
            if (this.alphahackarray[this.globalpicnum] != 0.0f) {
                al = this.alphahackarray[this.globalpicnum];
            }
            if (HOM) {
                al = 0.0f;
            }
            this.gl.glAlphaFunc(516, al);
            this.gl.glEnable(3042);
            this.gl.glEnable(3008);
        }
        if (!dorot) {
            for (i = n - 1; i >= 0; --i) {
                this.drawpoly[i].dd = this.drawpoly[i].px * this.gdx + this.drawpoly[i].py * this.gdy + this.gdo;
                this.drawpoly[i].uu = this.drawpoly[i].px * this.gux + this.drawpoly[i].py * this.guy + this.guo;
                this.drawpoly[i].vv = this.drawpoly[i].px * this.gvx + this.drawpoly[i].py * this.gvy + this.gvo;
            }
        }
        if (pth.getPixelFormat() == TileData.PixelFormat.Pal8) {
            this.texshader.setVisibility((int)this.globalfog.combvis);
        }
        this.globalfog.apply();
        if (this.pow2xsplit != 0 && tsizx != xx) {
            double ngvo;
            double ngvy;
            double ngvx;
            double nguo;
            double nguy;
            double ngux;
            double ngdo;
            double ngdy;
            double ngdx;
            if (!dorot) {
                ngdx = this.gdx;
                ngdy = this.gdy;
                ngdo = this.gdo + (ngdx + ngdy) * 0.5;
                ngux = this.gux;
                nguy = this.guy;
                nguo = this.guo + (ngux + nguy) * 0.5;
                ngvx = this.gvx;
                ngvy = this.gvy;
                ngvo = this.gvo + (ngvx + ngvy) * 0.5;
            } else {
                ox = this.drawpoly[1].py - this.drawpoly[2].py;
                oy = this.drawpoly[2].py - this.drawpoly[0].py;
                oz = this.drawpoly[0].py - this.drawpoly[1].py;
                r = 1.0 / (ox * this.drawpoly[0].px + oy * this.drawpoly[1].px + oz * this.drawpoly[2].px);
                ngdx = (ox * this.drawpoly[0].dd + oy * this.drawpoly[1].dd + oz * this.drawpoly[2].dd) * r;
                ngux = (ox * this.drawpoly[0].uu + oy * this.drawpoly[1].uu + oz * this.drawpoly[2].uu) * r;
                ngvx = (ox * this.drawpoly[0].vv + oy * this.drawpoly[1].vv + oz * this.drawpoly[2].vv) * r;
                ox = this.drawpoly[2].px - this.drawpoly[1].px;
                oy = this.drawpoly[0].px - this.drawpoly[2].px;
                oz = this.drawpoly[1].px - this.drawpoly[0].px;
                ngdy = (ox * this.drawpoly[0].dd + oy * this.drawpoly[1].dd + oz * this.drawpoly[2].dd) * r;
                nguy = (ox * this.drawpoly[0].uu + oy * this.drawpoly[1].uu + oz * this.drawpoly[2].uu) * r;
                ngvy = (ox * this.drawpoly[0].vv + oy * this.drawpoly[1].vv + oz * this.drawpoly[2].vv) * r;
                ox = this.drawpoly[0].px - 0.5;
                oy = this.drawpoly[0].py - 0.5;
                ngdo = this.drawpoly[0].dd - ox * ngdx - oy * ngdy;
                nguo = this.drawpoly[0].uu - ox * ngux - oy * nguy;
                ngvo = this.drawpoly[0].vv - ox * ngvx - oy * ngvy;
            }
            ngux *= (double)hackscx;
            nguy *= (double)hackscx;
            nguo *= (double)hackscx;
            ngvx *= (double)hackscy;
            ngvy *= (double)hackscy;
            ngvo *= (double)hackscy;
            double uoffs = (double)(xx - tsizx) * 0.5;
            ngux -= ngdx * uoffs;
            nguy -= ngdy * uoffs;
            nguo -= ngdo * uoffs;
            for (i = 0; i < n; ++i) {
                ox = this.drawpoly[i].px;
                oy = this.drawpoly[i].py;
                f = (ox * ngux + oy * nguy + nguo) / (ox * ngdx + oy * ngdy + ngdo);
                if (i == 0) {
                    du0 = du1 = f;
                    continue;
                }
                if (f < du0) {
                    du0 = f;
                    continue;
                }
                if (!(f > du1)) continue;
                du1 = f;
            }
            if (tsizx != 0) {
                f = 1.0 / (double)tsizx;
                double ix1 = Math.floor(du1 * f);
                for (double ix0 = Math.floor(du0 * f); ix0 <= ix1; ix0 += 1.0) {
                    du0 = ix0 * (double)tsizx;
                    du1 = (ix0 + 1.0) * (double)tsizx;
                    i = 0;
                    int nn = 0;
                    double duj = (this.drawpoly[i].px * ngux + this.drawpoly[i].py * nguy + nguo) / (this.drawpoly[i].px * ngdx + this.drawpoly[i].py * ngdy + ngdo);
                    do {
                        if ((j = i + 1) == n) {
                            j = 0;
                        }
                        double dui = duj;
                        duj = (this.drawpoly[j].px * ngux + this.drawpoly[j].py * nguy + nguo) / (this.drawpoly[j].px * ngdx + this.drawpoly[j].py * ngdy + ngdo);
                        if (du0 <= dui && dui <= du1) {
                            this.drawpoly[nn].uu = this.drawpoly[i].px;
                            this.drawpoly[nn].vv = this.drawpoly[i].py;
                            ++nn;
                        }
                        if (duj <= dui) {
                            if (du1 < duj != du1 < dui) {
                                nn = this.drawpoly_math(nn, i, j, ngux, ngdx, nguy, ngdy, nguo, ngdo, du1);
                            }
                            if (du0 < duj == du0 < dui) continue;
                            nn = this.drawpoly_math(nn, i, j, ngux, ngdx, nguy, ngdy, nguo, ngdo, du0);
                            continue;
                        }
                        if (du0 < duj != du0 < dui) {
                            nn = this.drawpoly_math(nn, i, j, ngux, ngdx, nguy, ngdy, nguo, ngdo, du0);
                        }
                        if (du1 < duj == du1 < dui) continue;
                        nn = this.drawpoly_math(nn, i, j, ngux, ngdx, nguy, ngdy, nguo, ngdo, du1);
                    } while ((i = j) != 0);
                    if (nn < 3) continue;
                    if (HOM) {
                        this.gl.glDisable(3553);
                    }
                    this.gl.glBegin(6);
                    for (i = 0; i < nn; ++i) {
                        Polygon dpoly = this.drawpoly[i];
                        ox = dpoly.uu;
                        oy = dpoly.vv;
                        double dp = ox * ngdx + oy * ngdy + ngdo;
                        double up = ox * ngux + oy * nguy + nguo;
                        double vp = ox * ngvx + oy * ngvy + ngvo;
                        r = 1.0 / dp;
                        if (texunits > 0) {
                            j = 0;
                            while (j <= texunits) {
                                this.gl.glMultiTexCoord2d(33984 + j++, (up * r - du0 + uoffs) * ox2, vp * r * oy2);
                            }
                        } else {
                            this.gl.glTexCoord2d((up * r - du0 + uoffs) * ox2, vp * r * oy2);
                        }
                        this.gl.glVertex3d((ox - (double)this.ghalfx) * r * (double)this.grhalfxdown10x, ((double)this.ghoriz - oy) * r * (double)this.grhalfxdown10, r * 9.765625E-4);
                    }
                    this.gl.glEnd();
                    if (!HOM) continue;
                    this.gl.glEnable(3553);
                }
            }
        } else {
            ox2 *= (double)hackscx;
            oy2 *= (double)hackscy;
            if (HOM) {
                this.gl.glDisable(3553);
            }
            this.gl.glBegin(6);
            for (i = 0; i < n; ++i) {
                Polygon dpoly = this.drawpoly[i];
                r = 1.0 / dpoly.dd;
                if (texunits > 0) {
                    j = 0;
                    while (j <= texunits) {
                        this.gl.glMultiTexCoord2d(33984 + j++, dpoly.uu * r * ox2, dpoly.vv * r * oy2);
                    }
                } else {
                    this.gl.glTexCoord2d(dpoly.uu * r * ox2, dpoly.vv * r * oy2);
                }
                this.gl.glVertex3d((dpoly.px - (double)this.ghalfx) * r * (double)this.grhalfxdown10x, ((double)this.ghoriz - dpoly.py) * r * (double)this.grhalfxdown10, r * 9.765625E-4);
            }
            this.gl.glEnd();
            if (HOM) {
                this.gl.glEnable(3553);
            }
        }
        this.textureCache.deactivateEffects(this.gl);
        if (this.srepeat != 0) {
            this.gl.glTexParameteri(3553, 10242, 33071);
        }
        if (this.trepeat != 0) {
            this.gl.glTexParameteri(3553, 10243, 33071);
        }
    }

    private void nonparallaxed(double nx0, double ny0, double nx1, double ny1, double ryp0, double ryp1, float x0, float x1, float cf_y0, float cf_y1, int have_floor, int sectnum, boolean floor) {
        double r;
        double fy;
        double fx;
        BoardService boardService = this.engine.getBoardService();
        Sector sec = boardService.getSector(sectnum);
        if ((this.globalorientation & 0x40) == 0) {
            this.nonparallaxed_ft[0] = this.globalposx;
            this.nonparallaxed_ft[1] = this.globalposy;
            this.nonparallaxed_ft[2] = this.cosglobalang;
            this.nonparallaxed_ft[3] = this.singlobalang;
        } else {
            fx = boardService.getWall(boardService.getWall(sec.getWallptr()).getPoint2()).getX() - boardService.getWall(sec.getWallptr()).getX();
            fy = boardService.getWall(boardService.getWall(sec.getWallptr()).getPoint2()).getY() - boardService.getWall(sec.getWallptr()).getY();
            r = 1.0 / Math.sqrt(fx * fx + fy * fy);
            this.nonparallaxed_ft[2] = (double)this.cosglobalang * (fx *= r) + (double)this.singlobalang * (fy *= r);
            this.nonparallaxed_ft[3] = (double)this.singlobalang * fx - (double)this.cosglobalang * fy;
            this.nonparallaxed_ft[0] = (double)(this.globalposx - boardService.getWall(sec.getWallptr()).getX()) * fx + (double)(this.globalposy - boardService.getWall(sec.getWallptr()).getY()) * fy;
            this.nonparallaxed_ft[1] = (double)(this.globalposy - boardService.getWall(sec.getWallptr()).getY()) * fx - (double)(this.globalposx - boardService.getWall(sec.getWallptr()).getX()) * fy;
            this.globalorientation = (this.globalorientation & 4) == 0 ? (this.globalorientation ^= 0x20) : (this.globalorientation ^= 0x10);
        }
        this.gdx = 0.0;
        this.gdy = this.gxyaspect;
        if ((this.globalorientation & 2) == 0 && this.global_cf_z - this.globalposz != 0) {
            this.gdy /= (double)(this.global_cf_z - this.globalposz);
        }
        this.gdo = (double)(-this.ghoriz) * this.gdy;
        if ((this.globalorientation & 8) != 0) {
            this.nonparallaxed_ft[0] = this.nonparallaxed_ft[0] / 8.0;
            this.nonparallaxed_ft[1] = this.nonparallaxed_ft[1] / -8.0;
            this.nonparallaxed_ft[2] = this.nonparallaxed_ft[2] / 2097152.0;
            this.nonparallaxed_ft[3] = this.nonparallaxed_ft[3] / 2097152.0;
        } else {
            this.nonparallaxed_ft[0] = this.nonparallaxed_ft[0] / 16.0;
            this.nonparallaxed_ft[1] = this.nonparallaxed_ft[1] / -16.0;
            this.nonparallaxed_ft[2] = this.nonparallaxed_ft[2] / 4194304.0;
            this.nonparallaxed_ft[3] = this.nonparallaxed_ft[3] / 4194304.0;
        }
        this.gux = this.nonparallaxed_ft[3] * (double)this.viewingrange / -65536.0;
        this.gvx = this.nonparallaxed_ft[2] * (double)this.viewingrange / -65536.0;
        this.guy = this.nonparallaxed_ft[0] * this.gdy;
        this.gvy = this.nonparallaxed_ft[1] * this.gdy;
        this.guo = this.nonparallaxed_ft[0] * this.gdo;
        this.gvo = this.nonparallaxed_ft[1] * this.gdo;
        this.guo += (this.nonparallaxed_ft[2] - this.gux) * (double)this.ghalfx;
        this.gvo -= (this.nonparallaxed_ft[3] + this.gvx) * (double)this.ghalfx;
        if ((this.globalorientation & 4) != 0) {
            r = this.gux;
            this.gux = this.gvx;
            this.gvx = r;
            r = this.guy;
            this.guy = this.gvy;
            this.gvy = r;
            r = this.guo;
            this.guo = this.gvo;
            this.gvo = r;
        }
        if ((this.globalorientation & 0x10) != 0) {
            this.gux = -this.gux;
            this.guy = -this.guy;
            this.guo = -this.guo;
        }
        if ((this.globalorientation & 0x20) != 0) {
            this.gvx = -this.gvx;
            this.gvy = -this.gvy;
            this.gvo = -this.gvo;
        }
        ArtEntry art = this.getTile(this.globalpicnum);
        fx = (double)(this.global_cf_xpanning * (float)(1 << art.getSizex())) / 256.0;
        fy = (double)(this.global_cf_ypanning * (float)(1 << art.getSizey())) / 256.0;
        if ((this.globalorientation & 0x42) == 66) {
            r = (double)this.global_cf_heinum / 4096.0;
            r = 1.0 / Math.sqrt(r * r + 1.0);
            if ((this.globalorientation & 4) == 0) {
                fy *= r;
            } else {
                fx *= r;
            }
        }
        this.guy += this.gdy * fx;
        this.guo += this.gdo * fx;
        this.gvy += this.gdy * fy;
        this.gvo += this.gdo * fy;
        if ((this.globalorientation & 2) != 0) {
            this.nonparallaxed_px[0] = x0;
            this.nonparallaxed_py[0] = ryp0 + (double)this.ghoriz;
            this.nonparallaxed_px[1] = x1;
            this.nonparallaxed_py[1] = ryp1 + (double)this.ghoriz;
            double ox = nx0 + (ny1 - ny0);
            double oy = ny0 + (nx0 - nx1);
            double ox2 = (oy - (double)this.globalposy) * (double)this.gcosang - (ox - (double)this.globalposx) * (double)this.gsinang;
            double oy2 = (ox - (double)this.globalposx) * (double)this.gcosang2 + (oy - (double)this.globalposy) * (double)this.gsinang2;
            oy2 = 1.0 / oy2;
            this.nonparallaxed_px[2] = (double)this.ghalfx * ox2 * oy2 + (double)this.ghalfx;
            this.nonparallaxed_py[2] = (oy2 *= (double)this.gyxscale) + (double)this.ghoriz;
            for (int i = 0; i < 3; ++i) {
                this.nonparallaxed_dd[i] = this.nonparallaxed_px[i] * this.gdx + this.nonparallaxed_py[i] * this.gdy + this.gdo;
                this.nonparallaxed_uu[i] = this.nonparallaxed_px[i] * this.gux + this.nonparallaxed_py[i] * this.guy + this.guo;
                this.nonparallaxed_vv[i] = this.nonparallaxed_px[i] * this.gvx + this.nonparallaxed_py[i] * this.gvy + this.gvo;
            }
            this.nonparallaxed_py[0] = cf_y0;
            this.nonparallaxed_py[1] = cf_y1;
            this.nonparallaxed_py[2] = floor ? (this.polymost_getflorzofslope(sectnum, ox, oy) - (double)this.globalposz) * oy2 + (double)this.ghoriz : (this.polymost_getceilzofslope(sectnum, ox, oy) - (double)this.globalposz) * oy2 + (double)this.ghoriz;
            ox = this.nonparallaxed_py[1] - this.nonparallaxed_py[2];
            oy = this.nonparallaxed_py[2] - this.nonparallaxed_py[0];
            double oz = this.nonparallaxed_py[0] - this.nonparallaxed_py[1];
            r = 1.0 / (ox * this.nonparallaxed_px[0] + oy * this.nonparallaxed_px[1] + oz * this.nonparallaxed_px[2]);
            this.gdx = (ox * this.nonparallaxed_dd[0] + oy * this.nonparallaxed_dd[1] + oz * this.nonparallaxed_dd[2]) * r;
            this.gux = (ox * this.nonparallaxed_uu[0] + oy * this.nonparallaxed_uu[1] + oz * this.nonparallaxed_uu[2]) * r;
            this.gvx = (ox * this.nonparallaxed_vv[0] + oy * this.nonparallaxed_vv[1] + oz * this.nonparallaxed_vv[2]) * r;
            ox = this.nonparallaxed_px[2] - this.nonparallaxed_px[1];
            oy = this.nonparallaxed_px[0] - this.nonparallaxed_px[2];
            oz = this.nonparallaxed_px[1] - this.nonparallaxed_px[0];
            this.gdy = (ox * this.nonparallaxed_dd[0] + oy * this.nonparallaxed_dd[1] + oz * this.nonparallaxed_dd[2]) * r;
            this.guy = (ox * this.nonparallaxed_uu[0] + oy * this.nonparallaxed_uu[1] + oz * this.nonparallaxed_uu[2]) * r;
            this.gvy = (ox * this.nonparallaxed_vv[0] + oy * this.nonparallaxed_vv[1] + oz * this.nonparallaxed_vv[2]) * r;
            this.gdo = this.nonparallaxed_dd[0] - this.nonparallaxed_px[0] * this.gdx - this.nonparallaxed_py[0] * this.gdy;
            this.guo = this.nonparallaxed_uu[0] - this.nonparallaxed_px[0] * this.gux - this.nonparallaxed_py[0] * this.guy;
            this.gvo = this.nonparallaxed_vv[0] - this.nonparallaxed_px[0] * this.gvx - this.nonparallaxed_py[0] * this.gvy;
            if ((this.globalorientation & 0x40) != 0) {
                r = (double)this.global_cf_heinum / 4096.0;
                r = Math.sqrt(r * r + 1.0);
                if ((this.globalorientation & 4) == 0) {
                    this.gvx *= r;
                    this.gvy *= r;
                    this.gvo *= r;
                } else {
                    this.gux *= r;
                    this.guy *= r;
                    this.guo *= r;
                }
            }
        }
        this.clipper.setMethod(this.globalorientation >> 7 & 3);
        if (have_floor != 0) {
            if ((double)this.globalposz >= this.polymost_getflorzofslope(sectnum, this.globalposx, this.globalposy)) {
                this.clipper.setMethod(-1);
            }
        } else if ((double)this.globalposz <= this.polymost_getceilzofslope(sectnum, this.globalposx, this.globalposy)) {
            this.clipper.setMethod(-1);
        }
        this.calc_and_apply_fog(this.global_cf_shade, sec.getVisibility(), this.global_cf_pal);
        this.pow2xsplit = 0;
        if (have_floor != 0) {
            this.clipper.domost(x0, cf_y0, x1, cf_y1);
        } else {
            this.clipper.domost(x1, cf_y1, x0, cf_y0);
        }
        this.clipper.setMethod(0);
    }

    private void calc_ypanning(int refposz, double ryp0, double ryp1, double x0, double x1, short ypan, short yrepeat, boolean dopancor) {
        double t0 = (double)(refposz - this.globalposz) * ryp0 + (double)this.ghoriz;
        double t1 = (double)(refposz - this.globalposz) * ryp1 + (double)this.ghoriz;
        double t = (this.gdx * x0 + this.gdo) * (double)yrepeat / ((x1 - x0) * ryp0 * 2048.0);
        ArtEntry pic = this.getTile(this.globalpicnum);
        int i = 1 << pic.getSizey();
        if (i < pic.getHeight()) {
            i <<= 1;
        }
        if (GLInfo.texnpot != 0) {
            if (!dopancor) {
                t *= (double)((float)pic.getHeight() / (float)i);
            }
            i = pic.getHeight();
        }
        float fy = (float)(ypan * i) / 256.0f;
        this.gvx = (t0 - t1) * t;
        this.gvy = (x1 - x0) * t;
        this.gvo = -this.gvx * x0 - this.gvy * t0 + (double)fy * this.gdo;
        this.gvx += (double)fy * this.gdx;
        this.gvy += (double)fy * this.gdy;
    }

    private void drawalls(int bunch) {
        BoardService boardService = this.engine.getBoardService();
        short sectnum = this.thesector[this.bunchfirst[bunch]];
        Sector sec = boardService.getSector(sectnum);
        this.calc_and_apply_fog(sec.getFloorshade(), sec.getVisibility(), sec.getFloorpal());
        short z = this.bunchfirst[bunch];
        while (z >= 0) {
            block33: {
                float ny1;
                float nx1;
                float t1;
                float ny0;
                float nx0;
                float t0;
                float oyp0;
                float oxp0;
                float yp1;
                float xp1;
                float yp0;
                float xp0;
                float fwalxrepeat;
                Sector nextsec;
                short nextsectnum;
                Wall wal2;
                Wall wal;
                short wallnum;
                block34: {
                    block32: {
                        wallnum = this.thewall[z];
                        wal = boardService.getWall(wallnum);
                        wal2 = boardService.getWall(wal.getPoint2());
                        nextsectnum = wal.getNextsector();
                        nextsec = nextsectnum >= 0 ? boardService.getSector(nextsectnum) : null;
                        fwalxrepeat = wal.getXrepeat() & 0xFF;
                        int x = wal.getX() - this.globalposx;
                        int y = wal.getY() - this.globalposy;
                        xp0 = (float)y * this.gcosang - (float)x * this.gsinang;
                        yp0 = (float)x * this.gcosang2 + (float)y * this.gsinang2;
                        x = wal2.getX() - this.globalposx;
                        y = wal2.getY() - this.globalposy;
                        xp1 = (float)y * this.gcosang - (float)x * this.gsinang;
                        yp1 = (float)x * this.gcosang2 + (float)y * this.gsinang2;
                        oxp0 = xp0;
                        oyp0 = yp0;
                        if (!(yp0 < 1.0f)) break block32;
                        if (yp1 < 1.0f) break block33;
                        t0 = (1.0f - yp0) / (yp1 - yp0);
                        xp0 = (xp1 - xp0) * t0 + xp0;
                        yp0 = 1.0f;
                        nx0 = (float)(wal2.getX() - wal.getX()) * t0 + (float)wal.getX();
                        ny0 = (float)(wal2.getY() - wal.getY()) * t0 + (float)wal.getY();
                        break block34;
                    }
                    t0 = 0.0f;
                    nx0 = wal.getX();
                    ny0 = wal.getY();
                }
                if (yp1 < 1.0f) {
                    t1 = (1.0f - oyp0) / (yp1 - oyp0);
                    xp1 = (xp1 - oxp0) * t1 + oxp0;
                    yp1 = 1.0f;
                    nx1 = (float)(wal2.getX() - wal.getX()) * t1 + (float)wal.getX();
                    ny1 = (float)(wal2.getY() - wal.getY()) * t1 + (float)wal.getY();
                } else {
                    t1 = 1.0f;
                    nx1 = wal2.getX();
                    ny1 = wal2.getY();
                }
                float ryp0 = 1.0f / yp0;
                float ryp1 = 1.0f / yp1;
                float x0 = this.ghalfx * xp0 * ryp0 + this.ghalfx;
                float x1 = this.ghalfx * xp1 * ryp1 + this.ghalfx;
                if (!(x1 <= x0)) {
                    float t;
                    int i;
                    this.polymost_getzsofslope(sectnum, nx0, ny0);
                    float cy0 = (dceilzsofslope - (float)this.globalposz) * (ryp0 *= this.gyxscale) + this.ghoriz;
                    float fy0 = (dfloorzsofslope - (float)this.globalposz) * ryp0 + this.ghoriz;
                    this.polymost_getzsofslope(sectnum, nx1, ny1);
                    float cy1 = (dceilzsofslope - (float)this.globalposz) * (ryp1 *= this.gyxscale) + this.ghoriz;
                    float fy1 = (dfloorzsofslope - (float)this.globalposz) * ryp1 + this.ghoriz;
                    this.renderingType = RenderingType.Floor.setIndex(sectnum);
                    this.globalpicnum = sec.getFloorpicnum();
                    this.globalshade = sec.getFloorshade();
                    this.globalpal = sec.getFloorpal();
                    this.globalorientation = sec.getFloorstat();
                    if (this.getTile(this.globalpicnum).getType() != AnimType.NONE) {
                        this.globalpicnum = (short)(this.globalpicnum + this.animateoffs(this.globalpicnum, sectnum));
                    }
                    this.global_cf_shade = sec.getFloorshade();
                    this.global_cf_pal = sec.getFloorpal();
                    this.global_cf_z = sec.getFloorz();
                    this.global_cf_xpanning = sec.getFloorxpanning();
                    this.global_cf_ypanning = sec.getFloorypanning();
                    this.global_cf_heinum = sec.getFloorheinum();
                    if ((this.globalorientation & 1) == 0) {
                        this.nonparallaxed(nx0, ny0, nx1, ny1, ryp0, ryp1, x0, x1, fy0, fy1, 1, sectnum, true);
                    } else if (nextsectnum < 0 || (boardService.getSector(nextsectnum).getFloorstat() & 1) == 0) {
                        this.drawbackground(sectnum, x0, x1, fy0, fy1, true);
                    }
                    this.renderingType = RenderingType.Ceiling.setIndex(sectnum);
                    this.globalpicnum = sec.getCeilingpicnum();
                    this.globalshade = sec.getCeilingshade();
                    this.globalpal = sec.getCeilingpal() & 0xFF;
                    this.globalorientation = sec.getCeilingstat();
                    if (this.getTile(this.globalpicnum).getType() != AnimType.NONE) {
                        this.globalpicnum = (short)(this.globalpicnum + this.animateoffs(this.globalpicnum, sectnum));
                    }
                    this.global_cf_shade = sec.getCeilingshade();
                    this.global_cf_pal = sec.getCeilingpal();
                    this.global_cf_z = sec.getCeilingz();
                    this.global_cf_xpanning = sec.getCeilingxpanning();
                    this.global_cf_ypanning = sec.getCeilingypanning();
                    this.global_cf_heinum = sec.getCeilingheinum();
                    if ((this.globalorientation & 1) == 0) {
                        this.nonparallaxed(nx0, ny0, nx1, ny1, ryp0, ryp1, x0, x1, cy0, cy1, 0, sectnum, false);
                    } else if (nextsectnum < 0 || (boardService.getSector(nextsectnum).getCeilingstat() & 1) == 0) {
                        this.drawbackground(sectnum, x0, x1, cy0, cy1, false);
                    }
                    this.renderingType = RenderingType.Wall.setIndex(wallnum);
                    this.gdx = (double)(ryp0 - ryp1) * this.gxyaspect / (double)(x0 - x1);
                    this.gdy = 0.0;
                    this.gdo = (double)ryp0 * this.gxyaspect - this.gdx * (double)x0;
                    this.gux = (double)(t0 * ryp0 - t1 * ryp1) * this.gxyaspect * (double)fwalxrepeat * 8.0 / (double)(x0 - x1);
                    this.guo = (double)(t0 * ryp0) * this.gxyaspect * (double)fwalxrepeat * 8.0 - this.gux * (double)x0;
                    this.guo += (double)wal.getXpanning() * this.gdo;
                    this.gux += (double)wal.getXpanning() * this.gdx;
                    this.guy = 0.0;
                    double ogux = this.gux;
                    double oguy = this.guy;
                    double oguo = this.guo;
                    if (nextsectnum >= 0) {
                        byte shade;
                        this.polymost_getzsofslope(nextsectnum, nx0, ny0);
                        float ocy0 = (dceilzsofslope - (float)this.globalposz) * ryp0 + this.ghoriz;
                        float ofy0 = (dfloorzsofslope - (float)this.globalposz) * ryp0 + this.ghoriz;
                        this.polymost_getzsofslope(nextsectnum, nx1, ny1);
                        float ocy1 = (dceilzsofslope - (float)this.globalposz) * ryp1 + this.ghoriz;
                        float ofy1 = (dfloorzsofslope - (float)this.globalposz) * ryp1 + this.ghoriz;
                        if ((wal.getCstat() & 0x30) == 16) {
                            this.maskwall[this.maskwallcnt++] = z;
                        }
                        if ((cy0 < ocy0 || cy1 < ocy1) && (sec.getCeilingstat() & boardService.getSector(nextsectnum).getCeilingstat() & 1) == 0) {
                            this.globalpicnum = wal.getPicnum();
                            this.globalshade = wal.getShade();
                            this.globalpal = wal.getPal() & 0xFF;
                            if (this.getTile(this.globalpicnum).getType() != AnimType.NONE) {
                                this.globalpicnum = (short)(this.globalpicnum + this.animateoffs(this.globalpicnum, wallnum + 16384));
                            }
                            i = !wal.isBottomAligned() ? boardService.getSector(nextsectnum).getCeilingz() : sec.getCeilingz();
                            this.calc_ypanning(i, ryp0, ryp1, x0, x1, wal.getYpanning(), wal.getYrepeat(), wal.isBottomAligned());
                            if (wal.isXFlip()) {
                                t = fwalxrepeat * 8.0f + (float)(wal.getXpanning() * 2);
                                this.gux = this.gdx * (double)t - this.gux;
                                this.guy = this.gdy * (double)t - this.guy;
                                this.guo = this.gdo * (double)t - this.guo;
                            }
                            if (wal.isYFlip()) {
                                this.gvx = -this.gvx;
                                this.gvy = -this.gvy;
                                this.gvo = -this.gvo;
                            }
                            shade = wal.getShade();
                            this.calc_and_apply_fog(shade, sec.getVisibility(), sec.getFloorpal());
                            this.pow2xsplit = 1;
                            this.clipper.domost(x1, ocy1, x0, ocy0);
                            if (wal.isXFlip()) {
                                this.gux = ogux;
                                this.guy = oguy;
                                this.guo = oguo;
                            }
                        }
                        if ((ofy0 < fy0 || ofy1 < fy1) && (sec.getFloorstat() & boardService.getSector(nextsectnum).getFloorstat() & 1) == 0) {
                            if (!wal.isSwapped()) {
                                this.drawalls_nwal.set(wal);
                            } else {
                                this.drawalls_nwal.set(boardService.getWall(wal.getNextwall()));
                                this.guo += (double)(this.drawalls_nwal.getXpanning() - wal.getXpanning()) * this.gdo;
                                this.gux += (double)(this.drawalls_nwal.getXpanning() - wal.getXpanning()) * this.gdx;
                                this.guy += (double)(this.drawalls_nwal.getXpanning() - wal.getXpanning()) * this.gdy;
                            }
                            this.globalpicnum = this.drawalls_nwal.getPicnum();
                            this.globalshade = this.drawalls_nwal.getShade();
                            this.globalpal = this.drawalls_nwal.getPal() & 0xFF;
                            if (this.getTile(this.globalpicnum).getType() != AnimType.NONE) {
                                this.globalpicnum = (short)(this.globalpicnum + this.animateoffs(this.globalpicnum, wallnum + 16384));
                            }
                            i = !this.drawalls_nwal.isBottomAligned() ? boardService.getSector(nextsectnum).getFloorz() : sec.getCeilingz();
                            this.calc_ypanning(i, ryp0, ryp1, x0, x1, this.drawalls_nwal.getYpanning(), wal.getYrepeat(), !this.drawalls_nwal.isBottomAligned());
                            if (wal.isXFlip()) {
                                t = fwalxrepeat * 8.0f + (float)(this.drawalls_nwal.getXpanning() * 2);
                                this.gux = this.gdx * (double)t - this.gux;
                                this.guy = this.gdy * (double)t - this.guy;
                                this.guo = this.gdo * (double)t - this.guo;
                            }
                            if (this.drawalls_nwal.isYFlip()) {
                                this.gvx = -this.gvx;
                                this.gvy = -this.gvy;
                                this.gvo = -this.gvo;
                            }
                            shade = this.drawalls_nwal.getShade();
                            this.calc_and_apply_fog(shade, sec.getVisibility(), sec.getFloorpal());
                            this.pow2xsplit = 1;
                            this.clipper.domost(x0, ofy0, x1, ofy1);
                            if ((wal.getCstat() & 0xA) != 0) {
                                this.guo = oguo;
                                this.gux = ogux;
                                this.guy = oguy;
                            }
                        }
                    }
                    if (nextsectnum < 0 || wal.isOneWay()) {
                        boolean maskingOneWay;
                        boolean bl = maskingOneWay = nextsectnum >= 0 && wal.isOneWay();
                        if (!maskingOneWay || this.getclosestpointonwall(this.globalposx, this.globalposy, wallnum, projPoint) != 0 || Pragmas.klabs(this.globalposx - (int)Polymost.projPoint.x) + Pragmas.klabs(this.globalposy - (int)Polymost.projPoint.y) > 128) {
                            boolean nwcs4;
                            this.globalpicnum = nextsectnum < 0 ? wal.getPicnum() : wal.getOverpicnum();
                            this.globalshade = wal.getShade();
                            this.globalpal = wal.getPal() & 0xFF;
                            if (this.getTile(this.globalpicnum).getType() != AnimType.NONE) {
                                this.globalpicnum = (short)(this.globalpicnum + this.animateoffs(this.globalpicnum, wallnum + 16384));
                            }
                            boolean bl2 = nwcs4 = !wal.isBottomAligned();
                            i = nextsectnum >= 0 ? (nwcs4 ? nextsec.getCeilingz() : sec.getCeilingz()) : (nwcs4 ? sec.getCeilingz() : sec.getFloorz());
                            this.calc_ypanning(i, ryp0, ryp1, x0, x1, wal.getYpanning(), wal.getYrepeat(), nwcs4 && !maskingOneWay);
                            if (wal.isXFlip()) {
                                t = fwalxrepeat * 8.0f + (float)(wal.getXpanning() * 2);
                                this.gux = this.gdx * (double)t - this.gux;
                                this.guy = this.gdy * (double)t - this.guy;
                                this.guo = this.gdo * (double)t - this.guo;
                            }
                            if (wal.isYFlip()) {
                                this.gvx = -this.gvx;
                                this.gvy = -this.gvy;
                                this.gvo = -this.gvo;
                            }
                            byte shade = wal.getShade();
                            this.calc_and_apply_fog(shade, sec.getVisibility(), sec.getFloorpal());
                            this.pow2xsplit = 1;
                            this.clipper.domost(x0, cy0, x1, cy1);
                        }
                    }
                    if (nextsectnum >= 0 && (this.gotsector[nextsectnum >> 3] & Engine.pow2char[nextsectnum & 7]) == 0 && this.clipper.testvisiblemost(x0, x1) != 0) {
                        this.scansector(nextsectnum);
                    }
                }
            }
            z = this.p2[z];
        }
    }

    private int polymost_bunchfront(int b1, int b2) {
        short b1f = this.bunchfirst[b1];
        double x1b1 = this.dxb1[b1f];
        double x2b2 = this.dxb2[this.bunchlast[b2]];
        if (x1b1 >= x2b2) {
            return -1;
        }
        short b2f = this.bunchfirst[b2];
        double x1b2 = this.dxb1[b2f];
        double x2b1 = this.dxb2[this.bunchlast[b1]];
        if (x1b2 >= x2b1) {
            return -1;
        }
        if (x1b1 >= x1b2) {
            short i = b2f;
            while (this.dxb2[i] <= x1b1 && this.p2[i] != -1) {
                i = this.p2[i];
            }
            return this.wallfront(b1f, i);
        }
        short i = b1f;
        while (this.dxb2[i] <= x1b2 && this.p2[i] != -1) {
            i = this.p2[i];
        }
        return this.wallfront(i, b2f);
    }

    protected int wallfront(int l1, int l2) {
        BoardService boardService = this.engine.getBoardService();
        Wall wal = boardService.getWall(this.thewall[l1]);
        int x11 = wal.getX();
        int y11 = wal.getY();
        wal = boardService.getWall(wal.getPoint2());
        int x21 = wal.getX();
        int y21 = wal.getY();
        wal = boardService.getWall(this.thewall[l2]);
        int x12 = wal.getX();
        int y12 = wal.getY();
        wal = boardService.getWall(wal.getPoint2());
        int x22 = wal.getX();
        int y22 = wal.getY();
        int dx = x21 - x11;
        int dy = y21 - y11;
        int t1 = Pragmas.dmulscale(x12 - x11, dy, -dx, y12 - y11, 2);
        int t2 = Pragmas.dmulscale(x22 - x11, dy, -dx, y22 - y11, 2);
        if (t1 == 0 && (t1 = t2) == 0) {
            return -1;
        }
        if (t2 == 0) {
            t2 = t1;
        }
        if ((t1 ^ t2) >= 0) {
            t2 = Pragmas.dmulscale(this.globalposx - x11, dy, -dx, this.globalposy - y11, 2);
            return (t2 ^ t1) >= 0 ? 1 : 0;
        }
        dx = x22 - x12;
        dy = y22 - y12;
        t1 = Pragmas.dmulscale(x11 - x12, dy, -dx, y11 - y12, 2);
        t2 = Pragmas.dmulscale(x21 - x12, dy, -dx, y21 - y12, 2);
        if (t1 == 0 && (t1 = t2) == 0) {
            return -1;
        }
        if (t2 == 0) {
            t2 = t1;
        }
        if ((t1 ^ t2) >= 0) {
            t2 = Pragmas.dmulscale(this.globalposx - x12, dy, -dx, this.globalposy - y12, 2);
            return (t2 ^ t1) < 0 ? 1 : 0;
        }
        return -2;
    }

    private void scansector(int sectnum) {
        if (sectnum < 0) {
            return;
        }
        if (Engine.automapping == 1) {
            Engine.show2dsector.setBit(sectnum);
        }
        BoardService boardService = this.engine.getBoardService();
        this.sectorborder[0] = sectnum;
        int sectorbordercnt = 1;
        do {
            int z;
            sectnum = this.sectorborder[--sectorbordercnt];
            for (ListNode<Sprite> node = boardService.getSectNode(sectnum); node != null; node = node.getNext()) {
                z = node.getIndex();
                Sprite spr = node.get();
                if ((spr.getCstat() & 0x8000) != 0 && !this.showinvisibility || spr.getXrepeat() <= 0 || spr.getYrepeat() <= 0) continue;
                int xs = spr.getX() - this.globalposx;
                int ys = spr.getY() - this.globalposy;
                if ((spr.getCstat() & 0x30) == 0 && !((float)xs * this.gcosang + (float)ys * this.gsinang > 0.0f) && (!this.config.isUseModels() || !this.modelManager.hasModelInfo(spr.getPicnum())) || (spr.getCstat() & 0x70) == 80 && Pragmas.dmulscale(EngineUtils.cos(spr.getAng()), -xs, EngineUtils.sin(spr.getAng()), -ys, 6) <= 0) continue;
                this.addRenderedSprite(z);
            }
            int n = sectnum >> 3;
            this.gotsector[n] = (byte)(this.gotsector[n] | Engine.pow2char[sectnum & 7]);
            int bunchfrst = this.numbunches;
            int numscansbefore = this.numscans;
            if (boardService.getSector(sectnum) == null) continue;
            Sector sec = boardService.getSector(sectnum);
            int scanfirst = this.numscans;
            double xp2 = 0.0;
            double yp2 = 0.0;
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                double yp1;
                double xp1;
                double d;
                Wall wal = wn.get();
                int wallid = wn.getIndex();
                Wall wal2 = wal.getWall2();
                int x1 = wal.getX() - this.globalposx;
                int y1 = wal.getY() - this.globalposy;
                int x2 = wal2.getX() - this.globalposx;
                int y2 = wal2.getY() - this.globalposy;
                short nextsectnum = wal.getNextsector();
                if (nextsectnum >= 0 && !wal.isOneWay() && sectorbordercnt < this.sectorborder.length && (this.gotsector[nextsectnum >> 3] & Engine.pow2char[nextsectnum & 7]) == 0 && (d = (double)(x1 * y2 - x2 * y1)) * d <= ((xp1 = (double)(x2 - x1)) * xp1 + (yp1 = (double)(y2 - y1)) * yp1) * 260.0) {
                    this.sectorborder[sectorbordercnt++] = nextsectnum;
                    int n2 = nextsectnum >> 3;
                    this.gotsector[n2] = (byte)(this.gotsector[n2] | Engine.pow2char[nextsectnum & 7]);
                }
                if (wallid == sec.getWallptr() || boardService.getWall(wallid - 1).getPoint2() != wallid) {
                    xp1 = ((double)y1 * (double)this.cosglobalang - (double)x1 * (double)this.singlobalang) / 64.0;
                    yp1 = ((double)x1 * (double)this.cosviewingrangeglobalang + (double)y1 * (double)this.sinviewingrangeglobalang) / 64.0;
                } else {
                    xp1 = xp2;
                    yp1 = yp2;
                }
                xp2 = ((double)y2 * (double)this.cosglobalang - (double)x2 * (double)this.singlobalang) / 64.0;
                yp2 = ((double)x2 * (double)this.cosviewingrangeglobalang + (double)y2 * (double)this.sinviewingrangeglobalang) / 64.0;
                if ((yp1 >= 1.0 || yp2 >= 1.0) && xp1 * yp2 < xp2 * yp1 && this.inviewingrange(xp1, yp1, xp2, yp2)) {
                    if (this.numscans >= MAXWALLSB - 1) {
                        return;
                    }
                    this.thesector[this.numscans] = (short)sectnum;
                    this.thewall[this.numscans] = (short)wallid;
                    this.p2[this.numscans] = (short)(this.numscans + 1);
                    ++this.numscans;
                }
                if (wal.getPoint2() >= wallid || scanfirst >= this.numscans) continue;
                this.p2[this.numscans - 1] = (short)scanfirst;
                scanfirst = this.numscans;
            }
            for (z = numscansbefore; z < this.numscans; ++z) {
                if (boardService.getWall(this.thewall[z]).getPoint2() == this.thewall[this.p2[z]] && !(this.dxb2[z] > this.dxb1[this.p2[z]])) continue;
                this.bunchfirst[this.numbunches++] = this.p2[z];
                this.p2[z] = -1;
            }
            for (z = bunchfrst; z < this.numbunches; ++z) {
                short zz = this.bunchfirst[z];
                while (this.p2[zz] >= 0) {
                    zz = this.p2[zz];
                }
                this.bunchlast[z] = zz;
            }
        } while (sectorbordercnt > 0);
    }

    protected boolean inviewingrange(double xp1, double yp1, double xp2, double yp2) {
        this.dxb1[this.numscans] = yp1 >= 1.0 ? xp1 * (double)this.ghalfx / yp1 + (double)this.ghalfx : -1.0E32;
        this.dxb2[this.numscans] = yp2 >= 1.0 ? xp2 * (double)this.ghalfx / yp2 + (double)this.ghalfx : 1.0E32;
        return this.dxb1[this.numscans] < this.dxb2[this.numscans];
    }

    private void drawpapersky(int sectnum, double x0, double x1, double y0, double y1, boolean floor) {
        double ox;
        double oy;
        short[] dapskyoff = Engine.zeropskyoff;
        short dapskybits = Engine.pskybits;
        if (dapskybits < 0) {
            dapskybits = 0;
        }
        for (int i = (1 << dapskybits) - 1; i > 0; --i) {
            if (dapskyoff[i] == dapskyoff[i - 1]) continue;
            this.skyclamphack = r_parallaxskyclamping;
            break;
        }
        BoardService boardService = this.engine.getBoardService();
        ArtEntry pic = this.getTile(this.globalpicnum);
        Sector sec = boardService.getSector(sectnum);
        this.drawalls_dd[0] = (double)this.xdimen * 1.0E-7;
        double t = pic.getWidth() << dapskybits;
        this.drawalls_vv[1] = this.drawalls_dd[0] * ((double)this.xdimscale * (double)this.viewingrange) / 4.294967296E9;
        this.drawalls_vv[0] = this.drawalls_dd[0] * (double)((pic.getHeight() >> 1) + (floor && r_parallaxskypanning == 1 ? this.parallaxyoffs - pic.getHeight() : this.parallaxyoffs)) - this.drawalls_vv[1] * (double)this.ghoriz;
        int i = 1 << pic.getSizey();
        if (i != pic.getHeight()) {
            i += i;
        }
        this.gdx = 0.0;
        this.gdy = floor ? this.gxyaspect / 262144.0 : this.gxyaspect / -262144.0;
        this.gdo = (double)(-this.ghoriz) * this.gdy;
        this.gux = 0.0;
        this.guy = 0.0;
        this.guo = 0.0;
        this.gvx = 0.0;
        this.gvy = 0.0;
        this.gvo = 0.0;
        int oskyclamphack = this.skyclamphack;
        this.skyclamphack = 0;
        if (floor) {
            oy = ((double)pic.getHeight() * this.drawalls_dd[0] - this.drawalls_vv[0]) / this.drawalls_vv[1];
            if (oy > y0 && oy > y1) {
                this.clipper.domost((float)x0, (float)oy, (float)x1, (float)oy);
            } else if (oy > y0 != oy > y1) {
                ox = (oy - y0) * (x1 - x0) / (y1 - y0) + x0;
                if (oy > y0) {
                    this.clipper.domost((float)x0, (float)oy, (float)ox, (float)oy);
                    this.clipper.domost((float)ox, (float)oy, (float)x1, (float)y1);
                } else {
                    this.clipper.domost((float)x0, (float)y0, (float)ox, (float)oy);
                    this.clipper.domost((float)ox, (float)oy, (float)x1, (float)oy);
                }
            } else {
                this.clipper.domost((float)x0, (float)y0, (float)x1, (float)y1);
            }
        } else {
            oy = -this.drawalls_vv[0] / this.drawalls_vv[1];
            if (oy < y0 && oy < y1) {
                this.clipper.domost((float)x1, (float)oy, (float)x0, (float)oy);
            } else if (oy < y0 != oy < y1) {
                ox = (oy - y0) * (x1 - x0) / (y1 - y0) + x0;
                if (oy < y0) {
                    this.clipper.domost((float)ox, (float)oy, (float)x0, (float)oy);
                    this.clipper.domost((float)x1, (float)y1, (float)ox, (float)oy);
                } else {
                    this.clipper.domost((float)ox, (float)oy, (float)x0, (float)y0);
                    this.clipper.domost((float)x1, (float)oy, (float)ox, (float)oy);
                }
            } else {
                this.clipper.domost((float)x1, (float)y1, (float)x0, (float)y0);
            }
        }
        this.skyclamphack = oskyclamphack;
        double panning = sec.getCeilingypanning();
        if (floor) {
            panning = sec.getFloorypanning();
        }
        if (r_parallaxskypanning != 0) {
            this.drawalls_vv[0] = this.drawalls_vv[0] + this.drawalls_dd[0] * panning * (double)i / 256.0;
        }
        this.gdx = 0.0;
        this.gdy = 0.0;
        this.gdo = this.drawalls_dd[0];
        this.gux = this.gdo * (t * (double)this.xdimscale * (double)this.yxaspect * (double)this.viewingrange) / 3.602879701896397E17;
        this.guy = 0.0;
        this.gvx = 0.0;
        this.gvy = this.drawalls_vv[1];
        this.gvo = this.drawalls_vv[0];
        i = this.globalpicnum;
        double r = (y1 - y0) / (x1 - x0);
        oy = (double)this.viewingrange / ((double)this.ghalfx * 256.0);
        double oz = 1.0 / oy;
        int y = (int)((x0 - (double)this.ghalfx) * oy + (double)this.globalang) >> 11 - dapskybits;
        panning = sec.getCeilingxpanning();
        if (floor) {
            panning = sec.getFloorxpanning();
        }
        double fx = x0;
        do {
            this.globalpicnum = (short)(dapskyoff[y & (1 << dapskybits) - 1] + i);
            this.guo = this.gdo * (t * (double)(this.globalang - (float)(y << 11 - dapskybits)) / 2048.0 + (r_parallaxskypanning != 0 ? panning : 0.0)) - this.gux * (double)this.ghalfx;
            ox = fx;
            if ((fx = (double)((float)(++y << 11 - dapskybits) - this.globalang) * oz + (double)this.ghalfx) > x1) {
                fx = x1;
                i = -1;
            }
            this.pow2xsplit = 0;
            if (floor) {
                this.clipper.domost((float)ox, (float)((ox - x0) * r + y0), (float)fx, (float)((fx - x0) * r + y0));
                continue;
            }
            this.clipper.domost((float)fx, (float)((fx - x0) * r + y0), (float)ox, (float)((ox - x0) * r + y0));
        } while (i >= 0);
    }

    private void drawskybox(double x0, double x1, double y0, double y1, boolean floor) {
        this.pow2xsplit = 0;
        this.skyclamphack = 1;
        for (int i = 0; i < 4; ++i) {
            double oy;
            double ox;
            double t;
            double _t1;
            double _t0;
            int x = this.skywalx[i & 3];
            int y = this.skywaly[i & 3];
            double _xp0 = (double)y * (double)this.gcosang - (double)x * (double)this.gsinang;
            double _yp0 = (double)x * (double)this.gcosang2 + (double)y * (double)this.gsinang2;
            x = this.skywalx[i + 1 & 3];
            y = this.skywaly[i + 1 & 3];
            double _xp1 = (double)y * (double)this.gcosang - (double)x * (double)this.gsinang;
            double _yp1 = (double)x * (double)this.gcosang2 + (double)y * (double)this.gsinang2;
            double _oxp0 = _xp0;
            double _oyp0 = _yp0;
            if (_yp0 < 1.0) {
                if (_yp1 < 1.0) continue;
                _t0 = (1.0 - _yp0) / (_yp1 - _yp0);
                _xp0 = (_xp1 - _xp0) * _t0 + _xp0;
                _yp0 = 1.0;
            } else {
                _t0 = 0.0;
            }
            if (_yp1 < 1.0) {
                _t1 = (1.0 - _oyp0) / (_yp1 - _oyp0);
                _xp1 = (_xp1 - _oxp0) * _t1 + _oxp0;
                _yp1 = 1.0;
            } else {
                _t1 = 1.0;
            }
            double _ryp0 = 1.0 / _yp0;
            double _ryp1 = 1.0 / _yp1;
            double _x0 = (double)this.ghalfx * _xp0 * _ryp0 + (double)this.ghalfx;
            double _x1 = (double)this.ghalfx * _xp1 * _ryp1 + (double)this.ghalfx;
            if (_x1 <= _x0 || _x0 >= x1 || x0 >= _x1) continue;
            double _cy0 = -8192.0 * (_ryp0 *= (double)this.gyxscale) + (double)this.ghoriz;
            double _fy0 = 8192.0 * _ryp0 + (double)this.ghoriz;
            double _cy1 = -8192.0 * (_ryp1 *= (double)this.gyxscale) + (double)this.ghoriz;
            double _fy1 = 8192.0 * _ryp1 + (double)this.ghoriz;
            double _ox0 = _x0;
            double _ox1 = _x1;
            double ny0 = y0;
            double ny1 = y1;
            if (_x0 < x0) {
                t = (x0 - _x0) / (_x1 - _x0);
                _cy0 += (_cy1 - _cy0) * t;
                _fy0 += (_fy1 - _fy0) * t;
                _x0 = x0;
            } else if (_x0 > x0) {
                ny0 += (_x0 - x0) * (y1 - y0) / (x1 - x0);
            }
            if (_x1 > x1) {
                t = (x1 - _x1) / (_x1 - _x0);
                _cy1 += (_cy1 - _cy0) * t;
                _fy1 += (_fy1 - _fy0) * t;
                _x1 = x1;
            } else if (_x1 < x1) {
                ny1 += (_x1 - x1) * (y1 - y0) / (x1 - x0);
            }
            this.drawalls_ft[0] = 32.0;
            this.drawalls_ft[1] = 32.0;
            if (floor) {
                this.drawalls_ft[1] = -32.0;
            }
            this.drawalls_ft[2] = (float)this.cosglobalang * 4.656613E-10f;
            this.drawalls_ft[3] = (float)this.singlobalang * 4.656613E-10f;
            this.gdx = 0.0;
            this.gdy = this.gxyaspect * -2.384185791015625E-7;
            if (floor) {
                this.gdy = this.gxyaspect * 2.384185791015625E-7;
            }
            this.gdo = (double)(-this.ghoriz) * this.gdy;
            this.gux = this.drawalls_ft[3] * (double)this.viewingrange / -65536.0;
            this.gvx = this.drawalls_ft[2] * (double)this.viewingrange / -65536.0;
            this.guy = this.drawalls_ft[0] * this.gdy;
            this.gvy = this.drawalls_ft[1] * this.gdy;
            this.guo = this.drawalls_ft[0] * this.gdo;
            this.gvo = this.drawalls_ft[1] * this.gdo;
            this.guo += (this.drawalls_ft[2] - this.gux) * (double)this.ghalfx;
            this.gvo -= (this.drawalls_ft[3] + this.gvx) * (double)this.ghalfx;
            if (floor) {
                this.gvx = -this.gvx;
                this.gvy = -this.gvy;
                this.gvo = -this.gvo;
                RenderingType.Skybox.setIndex(6);
                if (_fy0 > ny0 && _fy1 > ny1) {
                    this.clipper.domost((float)_x0, (float)_fy0, (float)_x1, (float)_fy1);
                } else if (_fy0 > ny0 != _fy1 > ny1) {
                    t = (_fy0 - ny0) / (ny1 - ny0 - _fy1 + _fy0);
                    ox = _x0 + (_x1 - _x0) * t;
                    oy = _fy0 + (_fy1 - _fy0) * t;
                    if (ny0 > _fy0) {
                        this.clipper.domost((float)_x0, (float)ny0, (float)ox, (float)oy);
                        this.clipper.domost((float)ox, (float)oy, (float)_x1, (float)_fy1);
                    } else {
                        this.clipper.domost((float)_x0, (float)_fy0, (float)ox, (float)oy);
                        this.clipper.domost((float)ox, (float)oy, (float)_x1, (float)ny1);
                    }
                } else {
                    this.clipper.domost((float)_x0, (float)ny0, (float)_x1, (float)ny1);
                }
            } else {
                RenderingType.Skybox.setIndex(5);
                if (_cy0 < ny0 && _cy1 < ny1) {
                    this.clipper.domost((float)_x1, (float)_cy1, (float)_x0, (float)_cy0);
                } else if (_cy0 < ny0 != _cy1 < ny1) {
                    t = (_cy0 - ny0) / (ny1 - ny0 - _cy1 + _cy0);
                    ox = _x0 + (_x1 - _x0) * t;
                    oy = _cy0 + (_cy1 - _cy0) * t;
                    if (ny0 < _cy0) {
                        this.clipper.domost((float)ox, (float)oy, (float)_x0, (float)ny0);
                        this.clipper.domost((float)_x1, (float)_cy1, (float)ox, (float)oy);
                    } else {
                        this.clipper.domost((float)ox, (float)oy, (float)_x0, (float)_cy0);
                        this.clipper.domost((float)_x1, (float)ny1, (float)ox, (float)oy);
                    }
                } else {
                    this.clipper.domost((float)_x1, (float)ny1, (float)_x0, (float)ny0);
                }
            }
            RenderingType.Skybox.setIndex(i + 1);
            this.gdx = (_ryp0 - _ryp1) * this.gxyaspect * 0.001953125 / (_ox0 - _ox1);
            this.gdy = 0.0;
            this.gdo = _ryp0 * this.gxyaspect * 0.001953125 - this.gdx * _ox0;
            this.gux = (_t0 * _ryp0 - _t1 * _ryp1) * this.gxyaspect * 0.125 / (_ox0 - _ox1);
            this.guo = _t0 * _ryp0 * this.gxyaspect * 0.125 - this.gux * _ox0;
            this.guy = 0.0;
            _t0 = -8192.0 * _ryp0 + (double)this.ghoriz;
            _t1 = -8192.0 * _ryp1 + (double)this.ghoriz;
            t = (this.gdx * _ox0 + this.gdo) * 8.0 / ((_ox1 - _ox0) * _ryp0 * 2048.0);
            this.gvx = (_t0 - _t1) * t;
            this.gvy = (_ox1 - _ox0) * t;
            this.gvo = -this.gvx * _ox0 - this.gvy * _t0;
            if (floor) {
                if (_cy0 > ny0 && _cy1 > ny1) {
                    this.clipper.domost((float)_x0, (float)_cy0, (float)_x1, (float)_cy1);
                    continue;
                }
                if (_cy0 > ny0 != _cy1 > ny1) {
                    t = (_cy0 - ny0) / (ny1 - ny0 - _cy1 + _cy0);
                    ox = _x0 + (_x1 - _x0) * t;
                    oy = _cy0 + (_cy1 - _cy0) * t;
                    if (ny0 > _cy0) {
                        this.clipper.domost((float)_x0, (float)ny0, (float)ox, (float)oy);
                        this.clipper.domost((float)ox, (float)oy, (float)_x1, (float)_cy1);
                        continue;
                    }
                    this.clipper.domost((float)_x0, (float)_cy0, (float)ox, (float)oy);
                    this.clipper.domost((float)ox, (float)oy, (float)_x1, (float)ny1);
                    continue;
                }
                this.clipper.domost((float)_x0, (float)ny0, (float)_x1, (float)ny1);
                continue;
            }
            if (_fy0 < ny0 && _fy1 < ny1) {
                this.clipper.domost((float)_x1, (float)_fy1, (float)_x0, (float)_fy0);
                continue;
            }
            if (_fy0 < ny0 != _fy1 < ny1) {
                t = (_fy0 - ny0) / (ny1 - ny0 - _fy1 + _fy0);
                ox = _x0 + (_x1 - _x0) * t;
                oy = _fy0 + (_fy1 - _fy0) * t;
                if (ny0 < _fy0) {
                    this.clipper.domost((float)ox, (float)oy, (float)_x0, (float)ny0);
                    this.clipper.domost((float)_x1, (float)_fy1, (float)ox, (float)oy);
                    continue;
                }
                this.clipper.domost((float)ox, (float)oy, (float)_x0, (float)_fy0);
                this.clipper.domost((float)_x1, (float)ny1, (float)ox, (float)oy);
                continue;
            }
            this.clipper.domost((float)_x1, (float)ny1, (float)_x0, (float)ny0);
        }
        RenderingType.Skybox.setIndex(6);
        if (floor) {
            RenderingType.Skybox.setIndex(5);
        }
        this.drawalls_ft[0] = 32.0;
        this.drawalls_ft[1] = -32.0;
        if (floor) {
            this.drawalls_ft[1] = 32.0;
        }
        this.drawalls_ft[2] = (float)this.cosglobalang * 4.656613E-10f;
        this.drawalls_ft[3] = (float)this.singlobalang * 4.656613E-10f;
        this.gdx = 0.0;
        this.gdy = this.gxyaspect * 2.384185791015625E-7;
        if (floor) {
            this.gdy = this.gxyaspect * -2.384185791015625E-7;
        }
        this.gdo = (double)(-this.ghoriz) * this.gdy;
        this.gux = this.drawalls_ft[3] * (double)this.viewingrange / -65536.0;
        this.gvx = this.drawalls_ft[2] * (double)this.viewingrange / -65536.0;
        this.guy = this.drawalls_ft[0] * this.gdy;
        this.gvy = this.drawalls_ft[1] * this.gdy;
        this.guo = this.drawalls_ft[0] * this.gdo;
        this.gvo = this.drawalls_ft[1] * this.gdo;
        this.guo += (this.drawalls_ft[2] - this.gux) * (double)this.ghalfx;
        this.gvo -= (this.drawalls_ft[3] + this.gvx) * (double)this.ghalfx;
        if (floor) {
            this.clipper.domost((float)x0, (float)y0, (float)x1, (float)y1);
        } else {
            this.gvx = -this.gvx;
            this.gvy = -this.gvy;
            this.gvo = -this.gvo;
            this.clipper.domost((float)x1, (float)y1, (float)x0, (float)y0);
        }
        this.skyclamphack = 0;
        RenderingType.Skybox.setIndex(0);
    }

    private void drawbackground(int sectnum, double x0, double x1, double y0, double y1, boolean floor) {
        BoardService boardService = this.engine.getBoardService();
        Sector sec = boardService.getSector(sectnum);
        byte shade = sec.getFloorshade();
        short pal = sec.getFloorpal();
        if (!floor) {
            shade = sec.getCeilingshade();
            pal = sec.getCeilingpal();
        }
        this.calc_and_apply_skyfog(shade, pal);
        if (!this.config.isUseHighTiles() || this.defs == null || this.defs.texInfo.findTexture(this.globalpicnum, this.globalpal, 1) == null) {
            this.drawpapersky(sectnum, x0, x1, y0, y1, floor);
        } else {
            this.drawskybox(x0, x1, y0, y1, floor);
        }
        this.skyclamphack = 0;
        this.calc_and_apply_fog(shade, sec.getVisibility(), pal);
    }

    @Override
    public void drawrooms() {
        int j;
        int i;
        this.globalvisibility = Pragmas.scale((long)Engine.visibility << 2, this.xdimen, 1027L);
        this.globalhoriz = this.globalhoriz * (float)this.xdimenscale / (float)this.viewingrange + (float)(this.ydimen >> 1);
        if (this.offscreenrendering) {
            if (this.setviewcnt == 1) {
                this.ogshang = this.gshang;
            }
        } else if (this.ogshang != -1.0f) {
            this.gshang = this.ogshang;
        }
        this.resizeglcheck();
        this.gl.glClear(256);
        this.gl.glDisable(3042);
        this.gl.glEnable(3553);
        this.gl.glEnable(2929);
        this.gl.glDepthFunc(515);
        this.gl.glDepthRange(this.defznear, this.defzfar);
        this.renderingType = RenderingType.Nothing;
        this.gyxscale = (float)this.xdimenscale / 131072.0f;
        this.gxyaspect = (double)this.viewingrange / 65536.0 * (double)this.xyaspect * 5.0 / 262144.0;
        this.gviewxrange = (float)(this.viewingrange * this.xdimen) / 3.3554432E7f;
        this.gcosang = (float)this.cosglobalang / 262144.0f;
        this.gsinang = (float)this.singlobalang / 262144.0f;
        this.gcosang2 = (float)this.cosviewingrangeglobalang / 262144.0f;
        this.gsinang2 = (float)this.sinviewingrangeglobalang / 262144.0f;
        this.ghalfx = this.xdimen >> 1;
        this.grhalfxdown10 = 1.0f / (this.ghalfx * 1024.0f);
        this.ghoriz = this.ydimen >> 1;
        double r = this.ghoriz - this.globalhoriz;
        this.gshang = (float)(r / Math.sqrt(r * r + (double)(this.ghalfx * this.ghalfx)));
        this.gchang = (float)Math.sqrt(1.0f - this.gshang * this.gshang);
        this.gctang = (float)Math.cos(this.gtang);
        this.gstang = (float)Math.sin(this.gtang);
        if ((double)Math.abs(this.gstang) < 0.001) {
            this.gstang = 0.0f;
            this.gctang = this.gctang > 0.0f ? 1.0f : -1.0f;
        }
        if (this.inpreparemirror) {
            this.gstang = -this.gstang;
        }
        this.drawrooms_px[3] = -1.0;
        this.drawrooms_px[0] = -1.0;
        this.drawrooms_px[1] = this.drawrooms_px[2] = (double)(this.windowx2 + 1 - this.windowx1 + 2);
        this.drawrooms_py[1] = -1.0;
        this.drawrooms_py[0] = -1.0;
        this.drawrooms_py[2] = this.drawrooms_py[3] = (double)(this.windowy2 + 1 - this.windowy1 + 2);
        int n = 4;
        for (i = 0; i < n; ++i) {
            double ox = this.drawrooms_px[i] - (double)this.ghalfx;
            double oy = this.drawrooms_py[i] - (double)this.ghoriz;
            double oz = this.ghalfx;
            double ox2 = ox * (double)this.gctang + oy * (double)this.gstang;
            double oy2 = oy * (double)this.gctang - ox * (double)this.gstang;
            double oz2 = oz;
            this.drawrooms_px[i] = ox2;
            this.drawrooms_py[i] = oy2 * (double)this.gchang + oz2 * (double)this.gshang;
            this.drawrooms_pz[i] = oz2 * (double)this.gchang - oy2 * (double)this.gshang;
        }
        int n2 = 0;
        for (i = 0; i < n; ++i) {
            j = i + 1;
            if (j >= n) {
                j = 0;
            }
            if (this.drawrooms_pz[i] >= 1.0) {
                this.drawrooms_px2[n2] = this.drawrooms_px[i];
                this.drawrooms_py2[n2] = this.drawrooms_py[i];
                this.drawrooms_pz2[n2] = this.drawrooms_pz[i];
                ++n2;
            }
            if (this.drawrooms_pz[i] >= 1.0 == this.drawrooms_pz[j] >= 1.0) continue;
            r = (1.0 - this.drawrooms_pz[i]) / (this.drawrooms_pz[j] - this.drawrooms_pz[i]);
            this.drawrooms_px2[n2] = (this.drawrooms_px[j] - this.drawrooms_px[i]) * r + this.drawrooms_px[i];
            this.drawrooms_py2[n2] = (this.drawrooms_py[j] - this.drawrooms_py[i]) * r + this.drawrooms_py[i];
            this.drawrooms_pz2[n2] = 1.0;
            ++n2;
        }
        if (n2 < 3) {
            return;
        }
        for (i = 0; i < n2; ++i) {
            r = (double)this.ghalfx / this.drawrooms_pz2[i];
            this.drawrooms_sx[i] = this.drawrooms_px2[i] * r + (double)this.ghalfx;
            this.drawrooms_sy[i] = this.drawrooms_py2[i] * r + (double)this.ghoriz;
        }
        this.clipper.initmosts(this.drawrooms_sx, this.drawrooms_sy, n2);
        this.numbunches = 0;
        this.numscans = 0;
        this.maskwallcnt = 0;
        if (this.globalcursectnum >= this.boardService.getSectorCount()) {
            this.globalcursectnum -= this.boardService.getSectorCount();
        } else {
            i = this.globalcursectnum;
            this.globalcursectnum = (short)this.engine.updatesectorz(this.globalposx, this.globalposy, this.globalposz, this.globalcursectnum);
            if (this.globalcursectnum < 0) {
                this.globalcursectnum = (short)i;
            }
        }
        this.scansector(this.globalcursectnum);
        this.grhalfxdown10x = this.grhalfxdown10;
        if (this.inpreparemirror) {
            this.grhalfxdown10x = -this.grhalfxdown10;
            this.inpreparemirror = false;
            if (this.numbunches > 0) {
                this.drawalls(0);
                --this.numbunches;
                this.bunchfirst[0] = this.bunchfirst[this.numbunches];
                this.bunchlast[0] = this.bunchlast[this.numbunches];
            }
        }
        while (this.numbunches > 0) {
            Arrays.fill(this.ptempbuf, 0, this.numbunches + 3, (byte)0);
            this.ptempbuf[0] = 1;
            int closest = 0;
            for (i = 1; i < this.numbunches; ++i) {
                j = this.polymost_bunchfront(i, closest);
                if (j < 0) continue;
                this.ptempbuf[i] = 1;
                if (j != 0) continue;
                this.ptempbuf[closest] = 1;
                closest = i;
            }
            for (i = 0; i < this.numbunches; ++i) {
                if (this.ptempbuf[i] != 0 || (j = this.polymost_bunchfront(i, closest)) < 0) continue;
                this.ptempbuf[i] = 1;
                if (j != 0) continue;
                this.ptempbuf[closest] = 1;
                closest = i;
                i = 0;
            }
            this.drawalls(closest);
            --this.numbunches;
            this.bunchfirst[closest] = this.bunchfirst[this.numbunches];
            this.bunchlast[closest] = this.bunchlast[this.numbunches];
        }
    }

    public void drawmaskwall(int damaskwallcnt) {
        float r;
        int j;
        int i;
        BoardService boardService = this.engine.getBoardService();
        short z = this.maskwall[damaskwallcnt];
        Wall wal = boardService.getWall(this.thewall[z]);
        Wall wal2 = boardService.getWall(wal.getPoint2());
        short sectnum = this.thesector[z];
        if (sectnum == -1 || wal.getNextsector() == -1) {
            return;
        }
        this.renderingType = RenderingType.MaskWall.setIndex(this.thewall[z]);
        Sector sec = boardService.getSector(sectnum);
        Sector nsec = boardService.getSector(wal.getNextsector());
        this.globalpicnum = wal.getOverpicnum();
        if (this.globalpicnum >= Engine.MAXTILES) {
            this.globalpicnum = 0;
        }
        if (this.getTile(this.globalpicnum).getType() != AnimType.NONE) {
            this.globalpicnum = (short)(this.globalpicnum + this.animateoffs(this.globalpicnum, this.thewall[z] + 16384));
        }
        this.globalshade = wal.getShade();
        this.globalpal = wal.getPal() & 0xFF;
        this.globalorientation = wal.getCstat();
        float sx0 = wal.getX() - this.globalposx;
        float sx1 = wal2.getX() - this.globalposx;
        float sy0 = wal.getY() - this.globalposy;
        float sy1 = wal2.getY() - this.globalposy;
        float yp0 = sx0 * this.gcosang2 + sy0 * this.gsinang2;
        float yp1 = sx1 * this.gcosang2 + sy1 * this.gsinang2;
        if (yp0 < 1.0f && yp1 < 1.0f) {
            return;
        }
        float xp0 = sy0 * this.gcosang - sx0 * this.gsinang;
        float xp1 = sy1 * this.gcosang - sx1 * this.gsinang;
        float oxp0 = xp0;
        float oyp0 = yp0;
        float t0 = 0.0f;
        if (yp0 < 1.0f) {
            t0 = (1.0f - yp0) / (yp1 - yp0);
            xp0 = (xp1 - xp0) * t0 + xp0;
            yp0 = 1.0f;
        }
        float t1 = 1.0f;
        if (yp1 < 1.0f) {
            t1 = (1.0f - oyp0) / (yp1 - oyp0);
            xp1 = (xp1 - oxp0) * t1 + oxp0;
            yp1 = 1.0f;
        }
        int m0 = (int)((float)(wal2.getX() - wal.getX()) * t0 + (float)wal.getX());
        int m1 = (int)((float)(wal2.getY() - wal.getY()) * t0 + (float)wal.getY());
        this.polymost_getzsofslope(sectnum, m0, m1);
        this.drawmaskwall_cz[0] = (int)dceilzsofslope;
        this.drawmaskwall_fz[0] = (int)dfloorzsofslope;
        this.polymost_getzsofslope(wal.getNextsector(), m0, m1);
        this.drawmaskwall_cz[1] = (int)dceilzsofslope;
        this.drawmaskwall_fz[1] = (int)dfloorzsofslope;
        m0 = (int)((float)(wal2.getX() - wal.getX()) * t1 + (float)wal.getX());
        m1 = (int)((float)(wal2.getY() - wal.getY()) * t1 + (float)wal.getY());
        this.polymost_getzsofslope(sectnum, m0, m1);
        this.drawmaskwall_cz[2] = (int)dceilzsofslope;
        this.drawmaskwall_fz[2] = (int)dfloorzsofslope;
        this.polymost_getzsofslope(wal.getNextsector(), m0, m1);
        this.drawmaskwall_cz[3] = (int)dceilzsofslope;
        this.drawmaskwall_fz[3] = (int)dfloorzsofslope;
        float ryp0 = 1.0f / yp0;
        float ryp1 = 1.0f / yp1;
        float x0 = this.ghalfx * xp0 * ryp0 + this.ghalfx;
        float x1 = this.ghalfx * xp1 * ryp1 + this.ghalfx;
        if (x1 <= x0) {
            return;
        }
        this.gdx = (double)((ryp0 *= this.gyxscale) - (ryp1 *= this.gyxscale)) * this.gxyaspect / (double)(x0 - x1);
        this.gdy = 0.0;
        this.gdo = (double)ryp0 * this.gxyaspect - this.gdx * (double)x0;
        this.gux = (double)(t0 * ryp0 - t1 * ryp1) * this.gxyaspect * ((double)(wal.getXrepeat() & 0xFF) * 8.0) / (double)(x0 - x1);
        this.guo = (double)(t0 * ryp0) * this.gxyaspect * ((double)(wal.getXrepeat() & 0xFF) * 8.0) - this.gux * (double)x0;
        this.guo += (double)wal.getXpanning() * this.gdo;
        this.gux += (double)wal.getXpanning() * this.gdx;
        this.guy = 0.0;
        this.calc_ypanning(!wal.isBottomAligned() ? Math.max(nsec.getCeilingz(), sec.getCeilingz()) : Math.min(nsec.getFloorz(), sec.getFloorz()), ryp0, ryp1, x0, x1, wal.getYpanning(), wal.getYrepeat(), false);
        if (wal.isXFlip()) {
            float t = (wal.getXrepeat() & 0xFF) * 8 + wal.getXpanning() * 2;
            this.gux = this.gdx * (double)t - this.gux;
            this.guy = this.gdy * (double)t - this.guy;
            this.guo = this.gdo * (double)t - this.guo;
        }
        if (wal.isYFlip()) {
            this.gvx = -this.gvx;
            this.gvy = -this.gvy;
            this.gvo = -this.gvo;
        }
        int method = 1;
        this.pow2xsplit = 1;
        if (wal.isTransparent()) {
            method = !wal.isTransparent2() ? 2 : 3;
        }
        byte shade = wal.getShade();
        this.calc_and_apply_fog(shade, sec.getVisibility(), sec.getFloorpal());
        this.drawmaskwall_csy[0] = (float)(this.drawmaskwall_cz[0] - this.globalposz) * ryp0 + this.ghoriz;
        this.drawmaskwall_csy[1] = (float)(this.drawmaskwall_cz[1] - this.globalposz) * ryp0 + this.ghoriz;
        this.drawmaskwall_csy[2] = (float)(this.drawmaskwall_cz[2] - this.globalposz) * ryp1 + this.ghoriz;
        this.drawmaskwall_csy[3] = (float)(this.drawmaskwall_cz[3] - this.globalposz) * ryp1 + this.ghoriz;
        this.drawmaskwall_fsy[0] = (float)(this.drawmaskwall_fz[0] - this.globalposz) * ryp0 + this.ghoriz;
        this.drawmaskwall_fsy[1] = (float)(this.drawmaskwall_fz[1] - this.globalposz) * ryp0 + this.ghoriz;
        this.drawmaskwall_fsy[2] = (float)(this.drawmaskwall_fz[2] - this.globalposz) * ryp1 + this.ghoriz;
        this.drawmaskwall_fsy[3] = (float)(this.drawmaskwall_fz[3] - this.globalposz) * ryp1 + this.ghoriz;
        this.dmaskwall[0].px = x0;
        this.dmaskwall[0].py = this.drawmaskwall_csy[1];
        this.dmaskwall[1].px = x1;
        this.dmaskwall[1].py = this.drawmaskwall_csy[3];
        this.dmaskwall[2].px = x1;
        this.dmaskwall[2].py = this.drawmaskwall_fsy[3];
        this.dmaskwall[3].px = x0;
        this.dmaskwall[3].py = this.drawmaskwall_fsy[1];
        int n = 4;
        int n2 = 0;
        t1 = (float)(-((this.dmaskwall[0].px - (double)x0) * (double)(this.drawmaskwall_csy[2] - this.drawmaskwall_csy[0]) - (this.dmaskwall[0].py - (double)this.drawmaskwall_csy[0]) * (double)(x1 - x0)));
        for (i = 0; i < n; ++i) {
            j = i + 1;
            if (j >= n) {
                j = 0;
            }
            t0 = t1;
            t1 = (float)(-((this.dmaskwall[j].px - (double)x0) * (double)(this.drawmaskwall_csy[2] - this.drawmaskwall_csy[0]) - (this.dmaskwall[j].py - (double)this.drawmaskwall_csy[0]) * (double)(x1 - x0)));
            if (t0 >= 0.0f) {
                this.dmaskwall[n2].px2 = this.dmaskwall[i].px;
                this.dmaskwall[n2].py2 = this.dmaskwall[i].py;
                ++n2;
            }
            if (t0 >= 0.0f == t1 >= 0.0f) continue;
            r = t0 / (t0 - t1);
            this.dmaskwall[n2].px2 = (this.dmaskwall[j].px - this.dmaskwall[i].px) * (double)r + this.dmaskwall[i].px;
            this.dmaskwall[n2].py2 = (this.dmaskwall[j].py - this.dmaskwall[i].py) * (double)r + this.dmaskwall[i].py;
            ++n2;
        }
        if (n2 < 3) {
            return;
        }
        n = 0;
        t1 = (float)(-((this.dmaskwall[0].px2 - (double)x1) * (double)(this.drawmaskwall_fsy[0] - this.drawmaskwall_fsy[2]) - (this.dmaskwall[0].py2 - (double)this.drawmaskwall_fsy[2]) * (double)(x0 - x1)));
        for (i = 0; i < n2; ++i) {
            j = i + 1;
            if (j >= n2) {
                j = 0;
            }
            t0 = t1;
            t1 = (float)(-((this.dmaskwall[j].px2 - (double)x1) * (double)(this.drawmaskwall_fsy[0] - this.drawmaskwall_fsy[2]) - (this.dmaskwall[j].py2 - (double)this.drawmaskwall_fsy[2]) * (double)(x0 - x1)));
            if (t0 >= 0.0f) {
                this.dmaskwall[n].px = this.dmaskwall[i].px2;
                this.dmaskwall[n].py = this.dmaskwall[i].py2;
                ++n;
            }
            if (t0 >= 0.0f == t1 >= 0.0f) continue;
            r = t0 / (t0 - t1);
            this.dmaskwall[n].px = (this.dmaskwall[j].px2 - this.dmaskwall[i].px2) * (double)r + this.dmaskwall[i].px2;
            this.dmaskwall[n].py = (this.dmaskwall[j].py2 - this.dmaskwall[i].py2) * (double)r + this.dmaskwall[i].py2;
            ++n;
        }
        if (n < 3) {
            return;
        }
        this.gl.glDepthRange(this.defznear + 1.0E-6, this.defzfar - 1.0E-5);
        this.drawpoly(this.dmaskwall, n, method);
        this.gl.glDepthRange(this.defznear, this.defzfar);
    }

    private int getclosestpointonwall(int posx, int posy, int dawall, Vector2 n) {
        BoardService boardService = this.engine.getBoardService();
        Wall w = boardService.getWall(dawall);
        Wall p2 = boardService.getWall(boardService.getWall(dawall).getPoint2());
        int dx = p2.getX() - w.getX();
        int dy = p2.getY() - w.getY();
        float i = dx * (posx - w.getX()) + dy * (posy - w.getY());
        if (i < 0.0f) {
            return 1;
        }
        float j = dx * dx + dy * dy;
        if (i > j) {
            return 1;
        }
        n.set((float)dx * (i /= j) + (float)w.getX(), (float)dy * i + (float)w.getY());
        return 0;
    }

    private float TSPR_OFFSET(Sprite tspr, long dist) {
        float offset = (8.0E-6f + (float)(tspr.getOwner() != -1 ? tspr.getOwner() & 0x1F : 1) * 8.0E-6f) * (float)dist * 0.025f;
        return -offset;
    }

    private void drawsprite(int snum) {
        Spriteext sprext;
        int xoff = 0;
        int yoff = 0;
        Sprite tspr = this.tspriteptr[snum];
        BoardService boardService = this.engine.getBoardService();
        if (tspr.getOwner() < 0 || tspr.getPicnum() < 0 || tspr.getPicnum() >= Engine.MAXTILES || tspr.getSectnum() < 0) {
            return;
        }
        this.globalpicnum = tspr.getPicnum();
        this.globalshade = tspr.getShade();
        this.globalpal = tspr.getPal() & 0xFF;
        this.globalorientation = tspr.getCstat();
        short spritenum = tspr.getOwner();
        ArtEntry pic = this.getTile(this.globalpicnum);
        if ((this.globalorientation & 0x30) != 48) {
            if (pic.getType() != AnimType.NONE) {
                this.globalpicnum = (short)(this.globalpicnum + this.animateoffs(this.globalpicnum, spritenum + 32768));
                pic = this.getTile(this.globalpicnum);
            }
            boolean flag = false;
            xoff = tspr.getXoffset();
            yoff = tspr.getYoffset();
            xoff += pic.getOffsetX();
            yoff += pic.getOffsetY();
        }
        int method = 5;
        if ((tspr.getCstat() & 2) != 0) {
            method = (tspr.getCstat() & 0x200) == 0 ? 6 : 7;
        }
        if ((sprext = this.defs.mapInfo.getSpriteInfo(tspr.getOwner())) != null) {
            // empty if block
        }
        int posx = tspr.getX();
        int posy = tspr.getY();
        int shade = (int)((float)this.globalshade / 1.5f);
        if (sprext == null || !sprext.isNotModel()) {
            GLVoxel vox;
            int dist;
            GLModel md;
            this.renderingType = RenderingType.Model.setIndex(snum);
            if (this.config.isUseModels() && (md = this.modelManager.getModel(this.globalpicnum, this.globalpal)) != null) {
                this.calc_and_apply_fog(shade, boardService.getSector(tspr.getSectnum()).getVisibility(), boardService.getSector(tspr.getSectnum()).getFloorpal());
                if (boardService.isValidSprite(tspr.getOwner()) ? this.mdrenderer.mddraw(md, tspr, xoff, yoff) != 0 : this.mdrenderer.mddraw(md, tspr, xoff, yoff) != 0) {
                    return;
                }
            } else if (this.engine.getConfig().isUseVoxels() && (long)(dist = (posx - this.globalposx) * (posx - this.globalposx) + (posy - this.globalposy) * (posy - this.globalposy)) < 2304000000L && (vox = (GLVoxel)this.modelManager.getVoxel(this.globalpicnum)) != null) {
                this.calc_and_apply_fog(shade, boardService.getSector(tspr.getSectnum()).getVisibility(), boardService.getSector(tspr.getSectnum()).getFloorpal());
                if ((tspr.getCstat() & 0x30) != 48) {
                    if (this.mdrenderer.voxdraw(vox, tspr) != 0) {
                        return;
                    }
                } else if ((tspr.getCstat() & 0x30) == 48) {
                    this.mdrenderer.voxdraw(vox, tspr);
                    return;
                }
            }
        }
        this.renderingType = RenderingType.Sprite.setIndex(snum);
        this.calc_and_apply_fog(shade, boardService.getSector(tspr.getSectnum()).getVisibility(), boardService.getSector(tspr.getSectnum()).getFloorpal());
        int tsizx = pic.getWidth();
        int tsizy = pic.getHeight();
        if (tsizx <= 0 || tsizy <= 0) {
            return;
        }
        switch (this.globalorientation >> 4 & 3) {
            case 0: {
                if ((this.globalorientation & 4) != 0) {
                    xoff = -xoff;
                }
                long dist = EngineUtils.qdist(this.globalposx - tspr.getX(), this.globalposy - tspr.getY());
                int ang = EngineUtils.getAngle(tspr.getX() - this.globalposx, tspr.getY() - this.globalposy) + 1024 & 0x7FF;
                float foffs = this.TSPR_OFFSET(tspr, dist);
                dist *= dist >> 7;
                float offsx = (float)(EngineUtils.cos(ang) >> 6) * foffs;
                float offsy = (float)(EngineUtils.sin(ang) >> 6) * foffs;
                float sx0 = (float)(tspr.getX() - this.globalposx) - offsx;
                float sy0 = (float)(tspr.getY() - this.globalposy) - offsy;
                float xp0 = sy0 * this.gcosang - sx0 * this.gsinang;
                float yp0 = sx0 * this.gcosang2 + sy0 * this.gsinang2;
                if (yp0 <= 1.0f) {
                    return;
                }
                float ryp0 = 1.0f / yp0;
                sx0 = this.ghalfx * xp0 * ryp0 + this.ghalfx;
                sy0 = (float)(tspr.getZ() - this.globalposz) * this.gyxscale * ryp0 + this.ghoriz;
                float f = ryp0 * (float)this.xdimen * 0.00625f;
                float fx = (float)tspr.getXrepeat() * f;
                float fy = (float)tspr.getYrepeat() * f * ((float)this.yxaspect * 1.5258789E-5f);
                sx0 -= fx * (float)xoff;
                if ((tsizx & 1) != 0) {
                    sx0 += fx * 0.5f;
                }
                sy0 -= fy * (float)yoff;
                if ((this.globalorientation & 0x80) != 0 && (tsizy & 1) != 0) {
                    sy0 += fy * 0.5f;
                }
                fy *= (float)tsizy;
                this.dsprite[0].px = this.dsprite[3].px = (double)(sx0 - (fx *= (float)tsizx) * 0.5f);
                this.dsprite[1].px = this.dsprite[2].px = (double)(sx0 + fx * 0.5f);
                if ((this.globalorientation & 0x80) == 0) {
                    this.dsprite[0].py = this.dsprite[1].py = (double)(sy0 - fy);
                    this.dsprite[2].py = this.dsprite[3].py = (double)sy0;
                } else {
                    this.dsprite[0].py = this.dsprite[1].py = (double)(sy0 - fy * 0.5f);
                    this.dsprite[2].py = this.dsprite[3].py = (double)(sy0 + fy * 0.5f);
                }
                this.gvx = 0.0;
                this.guy = 0.0;
                this.gdy = 0.0;
                this.gdx = 0.0;
                this.gdo = ryp0 * this.gviewxrange;
                if ((this.globalorientation & 4) == 0) {
                    this.gux = (double)tsizx * this.gdo / (this.dsprite[1].px - this.dsprite[0].px + 0.002);
                    this.guo = -this.gux * (this.dsprite[0].px - 0.001);
                } else {
                    this.gux = (double)tsizx * this.gdo / (this.dsprite[0].px - this.dsprite[1].px - 0.002);
                    this.guo = -this.gux * (this.dsprite[1].px + 0.001);
                }
                if ((this.globalorientation & 8) == 0) {
                    this.gvy = (double)tsizy * this.gdo / (this.dsprite[3].py - this.dsprite[0].py + 0.002);
                    this.gvo = -this.gvy * (this.dsprite[0].py - 0.001);
                } else {
                    this.gvy = (double)tsizy * this.gdo / (this.dsprite[0].py - this.dsprite[3].py - 0.002);
                    this.gvo = -this.gvy * (this.dsprite[3].py + 0.001);
                }
                if (sprext != null) {
                    if (sprext.xpanning != 0) {
                        this.guy -= this.gdy * (double)((float)sprext.xpanning / 255.0f) * (double)tsizx;
                        this.guo -= this.gdo * (double)((float)sprext.xpanning / 255.0f) * (double)tsizx;
                        this.srepeat = 1;
                    }
                    if (sprext.ypanning != 0) {
                        this.gvy -= this.gdy * (double)((float)sprext.ypanning / 255.0f) * (double)tsizy;
                        this.gvo -= this.gdo * (double)((float)sprext.ypanning / 255.0f) * (double)tsizy;
                        this.trepeat = 1;
                    }
                }
                if ((boardService.getSector(tspr.getSectnum()).getCeilingstat() & 3) == 0 && this.dsprite[0].py < (double)(sy0 = (float)(boardService.getSector(tspr.getSectnum()).getCeilingz() - this.globalposz) * this.gyxscale * ryp0 + this.ghoriz)) {
                    this.dsprite[0].py = this.dsprite[1].py = (double)sy0;
                }
                if ((boardService.getSector(tspr.getSectnum()).getFloorstat() & 3) == 0 && this.dsprite[2].py > (double)(sy0 = (float)(boardService.getSector(tspr.getSectnum()).getFloorz() - this.globalposz) * this.gyxscale * ryp0 + this.ghoriz)) {
                    this.dsprite[2].py = this.dsprite[3].py = (double)sy0;
                }
                this.gl.glDepthRange(this.defznear, this.defzfar - (double)(10.0f / (float)(dist + 1L)));
                this.pow2xsplit = 0;
                this.drawpoly(this.dsprite, 4, method);
                this.gl.glDepthRange(this.defznear, this.defzfar);
                this.srepeat = 0;
                this.trepeat = 0;
                break;
            }
            case 1: {
                int dang;
                float t1;
                float t0;
                if ((this.globalorientation & 4) != 0) {
                    xoff = -xoff;
                }
                if ((this.globalorientation & 8) != 0) {
                    yoff = -yoff;
                }
                Vector2 vec2 = this.dcoord.get(tspr.getOwner());
                posx += (int)vec2.x;
                posy += (int)vec2.y;
                Vector2 sin2 = this.dsin.get(tspr.getOwner());
                float xv = (float)tspr.getXrepeat() * ((float)EngineUtils.cos(tspr.getAng() - 512) * 1.5258789E-5f - sin2.x);
                float yv = (float)tspr.getXrepeat() * ((float)EngineUtils.sin(tspr.getAng() - 512) * 1.5258789E-5f - sin2.y);
                float f = (float)(tsizx >> 1) + (float)xoff;
                float x0 = (float)(posx - this.globalposx) - xv * f;
                float x1 = xv * (float)tsizx + x0;
                float y0 = (float)(posy - this.globalposy) - yv * f;
                float y1 = yv * (float)tsizx + y0;
                float yp0 = x0 * this.gcosang2 + y0 * this.gsinang2;
                float yp1 = x1 * this.gcosang2 + y1 * this.gsinang2;
                if (yp0 <= 1.0f && yp1 <= 1.0f) {
                    return;
                }
                float xp0 = y0 * this.gcosang - x0 * this.gsinang;
                float xp1 = y1 * this.gcosang - x1 * this.gsinang;
                float oxp0 = xp0;
                float oyp0 = yp0;
                if (yp0 < 1.0f) {
                    t0 = (1.0f - yp0) / (yp1 - yp0);
                    xp0 = (xp1 - xp0) * t0 + xp0;
                    yp0 = 1.0f;
                } else {
                    t0 = 0.0f;
                }
                if (yp1 < 1.0f) {
                    t1 = (1.0f - oyp0) / (yp1 - oyp0);
                    xp1 = (xp1 - oxp0) * t1 + oxp0;
                    yp1 = 1.0f;
                } else {
                    t1 = 1.0f;
                }
                f = (float)tspr.getYrepeat() * (float)tsizy * 4.0f;
                float ryp0 = 1.0f / yp0;
                float ryp1 = 1.0f / yp1;
                float sx0 = this.ghalfx * xp0 * ryp0 + this.ghalfx;
                float sx1 = this.ghalfx * xp1 * ryp1 + this.ghalfx;
                ryp0 *= this.gyxscale;
                ryp1 *= this.gyxscale;
                tspr.setZ(tspr.getZ() - (yoff * tspr.getYrepeat() << 2));
                if ((this.globalorientation & 0x80) != 0) {
                    tspr.setZ(tspr.getZ() + (tsizy * tspr.getYrepeat() << 1));
                    if ((tsizy & 1) != 0) {
                        tspr.setZ(tspr.getZ() + (tspr.getYrepeat() << 1));
                    }
                }
                float sc0 = ((float)(tspr.getZ() - this.globalposz) - f) * ryp0 + this.ghoriz;
                float sc1 = ((float)(tspr.getZ() - this.globalposz) - f) * ryp1 + this.ghoriz;
                float sf0 = (float)(tspr.getZ() - this.globalposz) * ryp0 + this.ghoriz;
                float sf1 = (float)(tspr.getZ() - this.globalposz) * ryp1 + this.ghoriz;
                this.gdx = (double)(ryp0 - ryp1) * this.gxyaspect / (double)(sx0 - sx1);
                this.gdy = 0.0;
                this.gdo = (double)ryp0 * this.gxyaspect - this.gdx * (double)sx0;
                if ((this.globalorientation & 4) != 0) {
                    t0 = 1.0f - t0;
                    t1 = 1.0f - t1;
                }
                if (sprext != null && sprext.xpanning != 0) {
                    t0 -= (float)sprext.xpanning / 255.0f;
                    t1 -= (float)sprext.xpanning / 255.0f;
                    this.srepeat = 1;
                }
                this.gux = (double)(t0 * ryp0 - t1 * ryp1) * this.gxyaspect * (double)tsizx / (double)(sx0 - sx1);
                this.guy = 0.0;
                this.guo = (double)(t0 * ryp0) * this.gxyaspect * (double)tsizx - this.gux * (double)sx0;
                f = (float)((double)tsizy * (this.gdx * (double)sx0 + this.gdo) / (double)((sx0 - sx1) * (sc0 - sf0)));
                if ((this.globalorientation & 8) == 0) {
                    this.gvx = (sc0 - sc1) * f;
                    this.gvy = (sx1 - sx0) * f;
                    this.gvo = -this.gvx * (double)sx0 - this.gvy * (double)sc0;
                } else {
                    this.gvx = (sf1 - sf0) * f;
                    this.gvy = (sx0 - sx1) * f;
                    this.gvo = -this.gvx * (double)sx0 - this.gvy * (double)sf0;
                }
                if (sprext != null && sprext.ypanning != 0) {
                    this.gvx -= this.gdx * (double)((float)sprext.ypanning / 255.0f) * (double)tsizy;
                    this.gvy -= this.gdy * (double)((float)sprext.ypanning / 255.0f) * (double)tsizy;
                    this.gvo -= this.gdo * (double)((float)sprext.ypanning / 255.0f) * (double)tsizy;
                    this.trepeat = 1;
                }
                if (tspr.getSectnum() != -1 && (boardService.getSector(tspr.getSectnum()).getCeilingstat() & 1) == 0) {
                    f = (float)tspr.getYrepeat() * (float)tsizy * 4.0f;
                    if ((float)boardService.getSector(tspr.getSectnum()).getCeilingz() > (float)tspr.getZ() - f) {
                        sc0 = (float)(boardService.getSector(tspr.getSectnum()).getCeilingz() - this.globalposz) * ryp0 + this.ghoriz;
                        sc1 = (float)(boardService.getSector(tspr.getSectnum()).getCeilingz() - this.globalposz) * ryp1 + this.ghoriz;
                    }
                }
                if (tspr.getSectnum() != -1 && (boardService.getSector(tspr.getSectnum()).getFloorstat() & 1) == 0 && boardService.getSector(tspr.getSectnum()).getFloorz() < tspr.getZ()) {
                    sf0 = (float)(boardService.getSector(tspr.getSectnum()).getFloorz() - this.globalposz) * ryp0 + this.ghoriz;
                    sf1 = (float)(boardService.getSector(tspr.getSectnum()).getFloorz() - this.globalposz) * ryp1 + this.ghoriz;
                }
                if (sx0 > sx1) {
                    if ((this.globalorientation & 0x40) != 0) {
                        return;
                    }
                    f = sx0;
                    sx0 = sx1;
                    sx1 = f;
                    f = sc0;
                    sc0 = sc1;
                    sc1 = f;
                    f = sf0;
                    sf0 = sf1;
                    sf1 = f;
                }
                this.dsprite[0].px = sx0;
                this.dsprite[0].py = sc0;
                this.dsprite[1].px = sx1;
                this.dsprite[1].py = sc1;
                this.dsprite[2].px = sx1;
                this.dsprite[2].py = sf1;
                this.dsprite[3].px = sx0;
                this.dsprite[3].py = sf0;
                boolean spriteWall = this.spritewall.get(tspr.getOwner()).get();
                if (spriteWall && (tspr.getCstat() & 2) != 0) {
                    this.gl.glDepthMask(false);
                }
                long dist = EngineUtils.qdist(this.globalposx - tspr.getX(), this.globalposy - tspr.getY());
                dist *= dist >> 7;
                if (spriteWall && dist > 0L && (dang = ((int)this.globalang - tspr.getAng() & 0x7FF) - 1024) >= -512 && dang <= 512) {
                    this.gl.glDepthRange(this.defznear, this.defzfar - (double)(Math.min((float)dist / 16384.0f, 40.0f) / (float)dist));
                }
                this.curpolygonoffset += 0.01f;
                this.gl.glPolygonOffset(-this.curpolygonoffset, -this.curpolygonoffset);
                this.pow2xsplit = 0;
                this.drawpoly(this.dsprite, 4, method);
                this.gl.glPolygonOffset(0.0f, 0.0f);
                this.gl.glDepthRange(this.defznear, this.defzfar);
                if (spriteWall && (tspr.getCstat() & 2) != 0) {
                    this.gl.glDepthMask(true);
                }
                this.srepeat = 0;
                this.trepeat = 0;
                break;
            }
            case 2: {
                float f;
                int j;
                if ((this.globalorientation & 0x40) != 0 && this.globalposz > tspr.getZ() == ((this.globalorientation & 8) == 0)) {
                    return;
                }
                if ((this.globalorientation & 4) > 0) {
                    xoff = -xoff;
                }
                if ((this.globalorientation & 8) > 0) {
                    yoff = -yoff;
                }
                int i = tspr.getAng() & 0x7FF;
                float c = (float)((double)EngineUtils.cos(i) / 65536.0);
                float s = (float)((double)EngineUtils.sin(i) / 65536.0);
                float x0 = (float)((tsizx >> 1) - xoff) * (float)tspr.getXrepeat();
                float y0 = (float)((tsizy >> 1) - yoff) * (float)tspr.getYrepeat();
                float x1 = (float)((tsizx >> 1) + xoff) * (float)tspr.getXrepeat();
                float y1 = (float)((tsizy >> 1) + yoff) * (float)tspr.getYrepeat();
                for (j = 0; j < 4; ++j) {
                    float sx0 = tspr.getX() - this.globalposx;
                    float sy0 = tspr.getY() - this.globalposy;
                    if ((j + 0 & 2) != 0) {
                        sy0 -= s * y0;
                        sx0 -= c * y0;
                    } else {
                        sy0 += s * y1;
                        sx0 += c * y1;
                    }
                    if ((j + 1 & 2) != 0) {
                        sx0 -= s * x0;
                        sy0 += c * x0;
                    } else {
                        sx0 += s * x1;
                        sy0 -= c * x1;
                    }
                    this.dsprite[j].px = sy0 * this.gcosang - sx0 * this.gsinang;
                    this.dsprite[j].py = sx0 * this.gcosang2 + sy0 * this.gsinang2;
                }
                if (tspr.getZ() < this.globalposz) {
                    f = (float)this.dsprite[0].px;
                    this.dsprite[0].px = this.dsprite[1].px;
                    this.dsprite[1].px = f;
                    f = (float)this.dsprite[0].py;
                    this.dsprite[0].py = this.dsprite[1].py;
                    this.dsprite[1].py = f;
                    f = (float)this.dsprite[2].px;
                    this.dsprite[2].px = this.dsprite[3].px;
                    this.dsprite[3].px = f;
                    f = (float)this.dsprite[2].py;
                    this.dsprite[2].py = this.dsprite[3].py;
                    this.dsprite[3].py = f;
                }
                int npoints = 0;
                for (i = 0; i < 4; ++i) {
                    j = i + 1 & 3;
                    if (this.dsprite[i].py >= 1.0) {
                        this.dsprite[npoints].px2 = this.dsprite[i].px;
                        this.dsprite[npoints].py2 = this.dsprite[i].py;
                        ++npoints;
                    }
                    if (this.dsprite[i].py >= 1.0 == this.dsprite[j].py >= 1.0) continue;
                    f = (float)((1.0 - this.dsprite[i].py) / (this.dsprite[j].py - this.dsprite[i].py));
                    this.dsprite[npoints].px2 = (float)((this.dsprite[j].px - this.dsprite[i].px) * (double)f + this.dsprite[i].px);
                    this.dsprite[npoints].py2 = (float)((this.dsprite[j].py - this.dsprite[i].py) * (double)f + this.dsprite[i].py);
                    ++npoints;
                }
                if (npoints < 3) {
                    return;
                }
                f = (float)(tspr.getZ() - this.globalposz) * this.gyxscale;
                for (j = 0; j < npoints; ++j) {
                    float ryp0 = (float)(1.0 / this.dsprite[j].py2);
                    this.dsprite[j].px = (double)this.ghalfx * this.dsprite[j].px2 * (double)ryp0 + (double)this.ghalfx;
                    this.dsprite[j].py = f * ryp0 + this.ghoriz;
                }
                this.gdx = 0.0;
                this.gdy = this.gxyaspect / (double)(tspr.getZ() - this.globalposz);
                this.gdo = (double)(-this.ghoriz) * this.gdy;
                float xv = (float)tspr.getX() + s * x1 + c * y1;
                float fx = -(x0 + x1) * s;
                float yv = (float)tspr.getY() + s * y1 - c * x1;
                float fy = (x0 + x1) * c;
                f = (float)(1.0 / Math.sqrt(fx * fx + fy * fy));
                this.drawsprite_ft[2] = (float)this.singlobalang * (fy *= f) + (float)this.cosglobalang * (fx *= f);
                this.drawsprite_ft[3] = (float)this.singlobalang * fx - (float)this.cosglobalang * fy;
                this.drawsprite_ft[0] = ((float)this.globalposy - yv) * fy + ((float)this.globalposx - xv) * fx;
                this.drawsprite_ft[1] = ((float)this.globalposx - xv) * fy - ((float)this.globalposy - yv) * fx;
                this.gux = (double)this.drawsprite_ft[3] * (double)this.viewingrange / -1.7179869184E10;
                this.gvx = (double)this.drawsprite_ft[2] * (double)this.viewingrange / -1.7179869184E10;
                this.guy = (double)this.drawsprite_ft[0] * this.gdy;
                this.gvy = (double)this.drawsprite_ft[1] * this.gdy;
                this.guo = (double)this.drawsprite_ft[0] * this.gdo;
                this.gvo = (double)this.drawsprite_ft[1] * this.gdo;
                this.guo += ((double)this.drawsprite_ft[2] / 262144.0 - this.gux) * (double)this.ghalfx;
                this.gvo -= ((double)this.drawsprite_ft[3] / 262144.0 + this.gvx) * (double)this.ghalfx;
                f = 4.0f / (float)tspr.getXrepeat();
                this.gux *= (double)f;
                this.guy *= (double)f;
                this.guo *= (double)f;
                f = -4.0f / (float)tspr.getYrepeat();
                this.gvx *= (double)f;
                this.gvy *= (double)f;
                this.gvo *= (double)f;
                if ((this.globalorientation & 4) != 0) {
                    this.gux = (double)tsizx * this.gdx - this.gux;
                    this.guy = (double)tsizx * this.gdy - this.guy;
                    this.guo = (double)tsizx * this.gdo - this.guo;
                }
                if (sprext != null) {
                    if (sprext.xpanning != 0) {
                        this.guy -= this.gdy * (double)((float)sprext.xpanning / 255.0f) * (double)tsizx;
                        this.guo -= this.gdo * (double)((float)sprext.xpanning / 255.0f) * (double)tsizx;
                        this.srepeat = 1;
                    }
                    if (sprext.ypanning != 0) {
                        this.gvy -= this.gdy * (double)((float)sprext.ypanning / 255.0f) * (double)tsizy;
                        this.gvo -= this.gdo * (double)((float)sprext.ypanning / 255.0f) * (double)tsizy;
                        this.trepeat = 1;
                    }
                }
                if ((tspr.getCstat() & 2) != 0) {
                    this.gl.glDepthMask(false);
                }
                this.gl.glDepthRange(this.defznear + 1.0E-6, this.defzfar - 1.0E-5);
                this.curpolygonoffset += 0.01f;
                this.gl.glPolygonOffset(-this.curpolygonoffset, -this.curpolygonoffset);
                this.pow2xsplit = 0;
                this.drawpoly(this.dsprite, npoints, method);
                this.gl.glDepthRange(this.defznear, this.defzfar);
                if ((tspr.getCstat() & 2) != 0) {
                    this.gl.glDepthMask(true);
                }
                this.srepeat = 0;
                this.trepeat = 0;
                break;
            }
        }
        if (Engine.automapping == 1) {
            Engine.show2dsprite.setBit(snum);
        }
    }

    protected void calc_and_apply_fog(int shade, int vis, int pal) {
        this.globalfog.shade = shade;
        this.globalfog.combvis = this.globalvisibility;
        if (vis != 0) {
            this.globalfog.combvis = Pragmas.mulscale(this.globalvisibility, vis + 16 & 0xFF, 4);
        }
        this.globalfog.pal = pal;
        this.globalfog.calc();
    }

    protected void calc_and_apply_skyfog(int shade, int pal) {
        this.globalfog.shade = shade;
        this.globalfog.combvis = 0.0f;
        this.globalfog.pal = pal;
        this.globalfog.calc();
    }

    public boolean sameside(Vector3 eq, Vector2 p1, Vector2 p2) {
        float sign1 = eq.x * p1.x + eq.y * p1.y + eq.z;
        float sign2 = eq.x * p2.x + eq.y * p2.y + eq.z;
        return (sign1 *= sign2) > 0.0f;
    }

    public void swapsprite(int k, int l, boolean z) {
        Sprite stmp = this.tspriteptr[k];
        this.tspriteptr[k] = this.tspriteptr[l];
        this.tspriteptr[l] = stmp;
        int tmp = this.spritesx[k];
        this.spritesx[k] = this.spritesx[l];
        this.spritesx[l] = tmp;
        tmp = this.spritesy[k];
        this.spritesy[k] = this.spritesy[l];
        this.spritesy[l] = tmp;
        if (z) {
            tmp = this.spritesz[k];
            this.spritesz[k] = this.spritesz[l];
            this.spritesz[l] = tmp;
        }
    }

    @Override
    public void drawmasks() {
        int l;
        int ys;
        int i;
        int spritesortcnt = Math.min(this.tspriteptr.length - 1, this.tSpriteList.getSize());
        for (i = spritesortcnt - 1; i >= 0; --i) {
            boolean modelp;
            this.tspriteptr[i] = (Sprite)this.tSpriteList.get(i);
            if (this.tspriteptr[i].getPicnum() < 0 || this.tspriteptr[i].getPicnum() >= Engine.MAXTILES) continue;
            int xs = this.tspriteptr[i].getX() - this.globalposx;
            ys = this.tspriteptr[i].getY() - this.globalposy;
            int yp = Pragmas.dmulscale(xs, this.cosviewingrangeglobalang, ys, this.sinviewingrangeglobalang, 6);
            boolean bl = modelp = this.config.isUseModels() && this.defs != null && this.defs.mdInfo.getModelInfo(this.tspriteptr[i].getPicnum()) != null;
            if (yp > 1024) {
                int xp = Pragmas.dmulscale(ys, this.cosglobalang, -xs, this.singlobalang, 6);
                if (Pragmas.mulscale(Math.abs(xp + yp), this.xdimen, 24) >= yp) {
                    if (i == --spritesortcnt) continue;
                    this.tspriteptr[i] = this.tspriteptr[spritesortcnt];
                    this.spritesx[i] = this.spritesx[spritesortcnt];
                    this.spritesy[i] = this.spritesy[spritesortcnt];
                    continue;
                }
                this.spritesx[i] = Pragmas.scale(xp + yp, (long)this.xdimen << 7, yp);
            } else if ((this.tspriteptr[i].getCstat() & 0x30) == 0 && !modelp) {
                if (i == --spritesortcnt) continue;
                this.tspriteptr[i] = this.tspriteptr[spritesortcnt];
                this.spritesx[i] = this.spritesx[spritesortcnt];
                this.spritesy[i] = this.spritesy[spritesortcnt];
                continue;
            }
            this.spritesy[i] = yp;
        }
        int gap = 1;
        while (gap < spritesortcnt) {
            gap = (gap << 1) + 1;
        }
        gap >>= 1;
        while (gap > 0) {
            for (i = 0; i < spritesortcnt - gap; ++i) {
                for (l = i; l >= 0 && this.spritesy[l] > this.spritesy[l + gap]; l -= gap) {
                    this.swapsprite(l, l + gap, false);
                }
            }
            gap >>= 1;
        }
        if (spritesortcnt > 0) {
            this.spritesy[spritesortcnt] = this.spritesy[spritesortcnt - 1] ^ 1;
        }
        ys = this.spritesy[0];
        i = 0;
        for (int j = 1; j <= spritesortcnt; ++j) {
            if (this.spritesy[j] == ys) continue;
            ys = this.spritesy[j];
            if (j > i + 1) {
                int k;
                for (k = i; k < j; ++k) {
                    this.spritesz[k] = this.tspriteptr[k].getZ();
                    if (this.tspriteptr[k].getPicnum() < 0 || this.tspriteptr[k].getPicnum() > Engine.MAXTILES || (this.tspriteptr[k].getCstat() & 0x30) == 32) continue;
                    ArtEntry pic = this.getTile(this.tspriteptr[k].getPicnum());
                    byte yoff = (byte)(pic.getOffsetY() + this.tspriteptr[k].getYoffset());
                    int n = k;
                    this.spritesz[n] = this.spritesz[n] - (yoff * this.tspriteptr[k].getYrepeat() << 2);
                    int yspan = pic.getHeight() * this.tspriteptr[k].getYrepeat() << 2;
                    if ((this.tspriteptr[k].getCstat() & 0x80) == 0) {
                        int n2 = k;
                        this.spritesz[n2] = this.spritesz[n2] - (yspan >> 1);
                    }
                    if (Pragmas.klabs(this.spritesz[k] - this.globalposz) >= yspan >> 1) continue;
                    this.spritesz[k] = this.globalposz;
                }
                for (k = i + 1; k < j; ++k) {
                    for (l = i; l < k; ++l) {
                        if (Pragmas.klabs(this.spritesz[k] - this.globalposz) >= Pragmas.klabs(this.spritesz[l] - this.globalposz)) continue;
                        this.swapsprite(k, l, true);
                    }
                }
                for (k = i + 1; k < j; ++k) {
                    for (l = i; l < k; ++l) {
                        if (this.tspriteptr[k].getStatnum() < this.tspriteptr[l].getStatnum()) {
                            this.swapsprite(k, l, false);
                        }
                        if ((this.tspriteptr[k].getCstat() & 2) == 0) continue;
                        this.swapsprite(k, l, true);
                    }
                }
            }
            i = j;
        }
        this.curpolygonoffset = 0.0f;
        Polymost.drawmasks_pos.x = this.globalposx;
        Polymost.drawmasks_pos.y = this.globalposy;
        this.gl.glEnable(32823);
        BoardService boardService = this.engine.getBoardService();
        while (this.maskwallcnt != 0) {
            --this.maskwallcnt;
            Polymost.drawmasks_dot.x = boardService.getWall(this.thewall[this.maskwall[this.maskwallcnt]]).getX();
            Polymost.drawmasks_dot.y = boardService.getWall(this.thewall[this.maskwall[this.maskwallcnt]]).getY();
            Polymost.drawmasks_dot2.x = boardService.getWall(boardService.getWall(this.thewall[this.maskwall[this.maskwallcnt]]).getPoint2()).getX();
            Polymost.drawmasks_dot2.y = boardService.getWall(boardService.getWall(this.thewall[this.maskwall[this.maskwallcnt]]).getPoint2()).getY();
            Polymost.equation(drawmasks_maskeq, Polymost.drawmasks_dot.x, Polymost.drawmasks_dot.y, Polymost.drawmasks_dot2.x, Polymost.drawmasks_dot2.y);
            Polymost.equation(drawmasks_p1eq, Polymost.drawmasks_pos.x, Polymost.drawmasks_pos.y, Polymost.drawmasks_dot.x, Polymost.drawmasks_dot.y);
            Polymost.equation(drawmasks_p2eq, Polymost.drawmasks_pos.x, Polymost.drawmasks_pos.y, Polymost.drawmasks_dot2.x, Polymost.drawmasks_dot2.y);
            Polymost.drawmasks_middle.x = (Polymost.drawmasks_dot.x + Polymost.drawmasks_dot2.x) / 2.0f;
            Polymost.drawmasks_middle.y = (Polymost.drawmasks_dot.y + Polymost.drawmasks_dot2.y) / 2.0f;
            i = spritesortcnt;
            while (i != 0) {
                if (this.tspriteptr[--i] == null) continue;
                Polymost.drawmasks_spr.x = this.tspriteptr[i].getX();
                Polymost.drawmasks_spr.y = this.tspriteptr[i].getY();
                if (this.sameside(drawmasks_maskeq, drawmasks_spr, drawmasks_pos) || !this.sameside(drawmasks_p1eq, drawmasks_middle, drawmasks_spr) || !this.sameside(drawmasks_p2eq, drawmasks_middle, drawmasks_spr)) continue;
                this.drawsprite(i);
                this.tspriteptr[i] = null;
            }
            this.drawmaskwall(this.maskwallcnt);
        }
        while (spritesortcnt != 0) {
            if (this.tspriteptr[--spritesortcnt] == null) continue;
            this.drawsprite(spritesortcnt);
        }
        this.gl.glDisable(32823);
        this.gl.glPolygonOffset(0.0f, 0.0f);
    }

    @Override
    public void clearview(int dacol) {
        Palette curpalette = this.paletteManager.getCurrentPalette();
        this.gl.glClearColor((float)curpalette.getRed(dacol) / 255.0f, (float)curpalette.getGreen(dacol) / 255.0f, (float)curpalette.getBlue(dacol) / 255.0f, 0.0f);
        this.gl.glClear(16384);
    }

    @Override
    public void nextpage() {
        this.drawRooms = true;
        MDAnimation.omdtims = MDAnimation.mdtims;
        MDAnimation.mdtims = this.engine.getCurrentTimeMillis();
        if (this.boardService.getBoard() != null) {
            for (int i = 0; i < this.boardService.getSpriteCount(); ++i) {
                ModelsInfo.SpriteAnim sprext;
                if (MDAnimation.mdpause == 0 || (sprext = this.defs.mdInfo.getAnimParams(i)) == null) continue;
                boolean isAnimationDisabled = false;
                Spriteext inf = this.defs.mapInfo.getSpriteInfo(i);
                if (inf != null) {
                    isAnimationDisabled = inf.isAnimationDisabled();
                }
                if ((MDAnimation.mdpause == 0 || sprext.mdanimtims == 0L) && !isAnimationDisabled) continue;
                sprext.mdanimtims += MDAnimation.mdtims - MDAnimation.omdtims;
            }
        }
        this.beforedrawrooms = 1;
        this.ogshang = -1.0f;
        super.nextpage();
        this.gl.glFlush();
    }

    @Override
    public ByteBuffer getFrame(TileData.PixelFormat format, int xsiz, int ysiz) {
        boolean reverse = false;
        if (ysiz < 0) {
            ysiz *= -1;
            reverse = true;
        }
        int byteperpixel = 3;
        int fmt = 6407;
        if (Gdx.app.getType() == Application.ApplicationType.Android) {
            byteperpixel = 4;
            fmt = 6408;
        }
        ByteBuffer frameBuffer = ByteBuffer.allocateDirect(xsiz * ysiz * byteperpixel);
        this.gl.glPixelStorei(3333, 1);
        this.gl.glReadPixels(0, this.ydim - ysiz, xsiz, ysiz, fmt, 5121, frameBuffer);
        if (format == TileData.PixelFormat.Rgb) {
            if (reverse) {
                int b2 = 0;
                for (int y = 0; y < ysiz / 2; ++y) {
                    int b1 = byteperpixel * (ysiz - y - 1) * xsiz;
                    for (int x = 0; x < xsiz; ++x) {
                        for (int p = 0; p < byteperpixel; ++p) {
                            byte tmp = frameBuffer.get(b1 + p);
                            frameBuffer.put(b1 + p, frameBuffer.get(b2 + p));
                            frameBuffer.put(b2 + p, tmp);
                        }
                        b1 += byteperpixel;
                        b2 += byteperpixel;
                    }
                }
            }
            frameBuffer.rewind();
            return frameBuffer;
        }
        ByteBuffer pix8Buffer = ByteBuffer.allocateDirect(xsiz * ysiz);
        byte[] basePalette = this.paletteManager.getBasePalette();
        FastColorLookup fastColorLookup = this.paletteManager.getFastColorLookup();
        int base = 0;
        if (reverse) {
            for (int y = 0; y < ysiz; ++y) {
                base = byteperpixel * (ysiz - y - 1) * xsiz;
                for (int x = 0; x < xsiz; ++x) {
                    int r = (frameBuffer.get(base++) & 0xFF) >> 2;
                    int g = (frameBuffer.get(base++) & 0xFF) >> 2;
                    int b = (frameBuffer.get(base++) & 0xFF) >> 2;
                    pix8Buffer.put(fastColorLookup.getClosestColorIndex(basePalette, r, g, b));
                }
            }
        } else {
            for (int i = 0; i < pix8Buffer.capacity(); ++i) {
                int r = (frameBuffer.get(base++) & 0xFF) >> 2;
                int g = (frameBuffer.get(base++) & 0xFF) >> 2;
                int b = (frameBuffer.get(base++) & 0xFF) >> 2;
                if (byteperpixel == 4) {
                    ++base;
                }
                pix8Buffer.put(fastColorLookup.getClosestColorIndex(basePalette, r, g, b));
            }
        }
        pix8Buffer.rewind();
        return pix8Buffer;
    }

    public int nearwall(int i, int range) {
        BoardService boardService = this.engine.getBoardService();
        Vector2 dcoord = this.dcoord.get(i);
        Sprite spr = boardService.getSprite(i);
        short sectnum = spr.getSectnum();
        int xs = spr.getX();
        int ys = spr.getY();
        int vx = Pragmas.mulscale(EngineUtils.cos(spr.getAng()), range, 14);
        int xe = xs + vx;
        int vy = Pragmas.mulscale(EngineUtils.sin(spr.getAng()), range, 14);
        int ye = ys + vy;
        int startwall = boardService.getSector(sectnum).getWallptr();
        int endwall = startwall + boardService.getSector(sectnum).getWallnum() - 1;
        for (int z = startwall; z <= endwall; ++z) {
            Variable vvz;
            Variable vvy;
            Variable vvx;
            Wall wal = boardService.getWall(z);
            Wall wal2 = boardService.getWall(wal.getPoint2());
            int x1 = wal.getX();
            int y1 = wal.getY();
            int x2 = wal2.getX();
            int y2 = wal2.getY();
            if ((x1 - xs) * (y2 - ys) < (x2 - xs) * (y1 - ys)) continue;
            if (wal.getNextsector() != -1) {
                int daz = this.engine.getflorzofslope(sectnum, xs, ys);
                int daz2 = this.engine.getflorzofslope(wal.getNextsector(), xs, ys);
                ArtEntry pic = this.getTile(spr.getPicnum());
                boolean clipyou = false;
                int z1 = spr.getZ();
                int z2 = spr.getZ();
                byte yoff = pic.getOffsetY();
                if ((spr.getCstat() & 0x80) != 0) {
                    z1 -= (yoff + pic.getHeight() / 2) * (spr.getYrepeat() << 2);
                    z2 += (pic.getHeight() - (pic.getHeight() / 2 + yoff)) * (spr.getYrepeat() << 2);
                } else {
                    z1 -= (yoff + pic.getHeight()) * (spr.getYrepeat() << 2);
                }
                if (daz2 < daz - 256 && z2 >= daz2) {
                    clipyou = true;
                }
                if (!clipyou) {
                    daz = this.engine.getceilzofslope(sectnum, xs, ys);
                    daz2 = this.engine.getceilzofslope(wal.getNextsector(), xs, ys);
                    if (daz2 > daz + 256 && z1 <= daz2) {
                        clipyou = true;
                    }
                }
                if (!clipyou) continue;
            }
            if (!this.engine.lIntersect(xs, ys, 0, xe, ye, 0, x1, y1, x2, y2, vvx = new Variable(), vvy = new Variable(), vvz = new Variable())) continue;
            int dist = Pragmas.dmulscale(vvx.get() - xs, EngineUtils.cos(spr.getAng()), vvy.get() - ys, EngineUtils.sin(spr.getAng()), 14);
            if (Pragmas.klabs(dist) <= 8) {
                int wallang = EngineUtils.getAngle(boardService.getWall(wal.getPoint2()).getX() - wal.getX(), boardService.getWall(wal.getPoint2()).getY() - wal.getY()) - 512;
                int nx = vvx.get() - Pragmas.mulscale(EngineUtils.cos(wallang), 4L, 14);
                int ny = vvy.get() - Pragmas.mulscale(EngineUtils.sin(wallang), 4L, 14);
                dcoord.x = nx - spr.getX();
                dcoord.y = ny - spr.getY();
            }
            return z;
        }
        return -1;
    }

    @Override
    public void loadModels() {
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            int pal = 0;
            this.modelManager.preload(i, pal, true);
        }
    }

    @Override
    public void onPrecacheTile(int dapicnum, boolean ifSprite) {
        int dapalnum = 0;
        int datype = ifSprite ? 4 : 0;
        this.textureCache.precache(this.texshader != null ? TileData.PixelFormat.Pal8 : TileData.PixelFormat.Rgba, this.getTile(dapicnum), dapalnum, datype);
    }

    public void addSpriteCorr(int snum) {
        BoardService boardService = this.engine.getBoardService();
        Sprite spr = boardService.getSprite(snum);
        if (spr == null || spr.getStatnum() == 1024) {
            this.removeSpriteCorr(snum);
            return;
        }
        int spr_wall = this.nearwall(snum, -64);
        if (spr_wall == -1 && ((spr.getCstat() & 0x40) != 0 || (spr_wall = this.nearwall(snum, 64)) == -1)) {
            return;
        }
        this.spritewall.get(snum).set(true);
        float sang = (float)(spr.getAng() * 360) / 2048.0f;
        int wdx = boardService.getWall(spr_wall).getX() - boardService.getWall(boardService.getWall(spr_wall).getPoint2()).getX();
        int wdy = boardService.getWall(spr_wall).getY() - boardService.getWall(boardService.getWall(spr_wall).getPoint2()).getY();
        float wang = new Vector2(wdx, wdy).angleDeg() - 90.0f;
        if (wang < 0.0f) {
            wang += 360.0f;
        }
        if (Math.abs((wang = Gameutils.BClipRange(wang, 0.0f, 360.0f)) - sang) > 10.0f) {
            return;
        }
        Vector2 dsin = this.dsin.get(snum);
        dsin.x = (float)EngineUtils.cos(spr.getAng() - 512) / 65536.0f - (float)(Math.sin(Math.toRadians(wang)) / 4.0);
        dsin.y = (float)EngineUtils.sin(spr.getAng() - 512) / 65536.0f - (float)(Math.sin(Math.toRadians(wang + 270.0f)) / 4.0);
    }

    public IndexedShader getShader() {
        return this.texshader;
    }

    public TileData.PixelFormat getTextureFormat() {
        return this.texshader != null ? TileData.PixelFormat.Pal8 : TileData.PixelFormat.Rgba;
    }

    public void removeSpriteCorr(int snum) {
        this.dcoord.get(snum).setZero();
        this.dsin.get(snum).setZero();
        this.spritewall.get(snum).set(false);
    }

    @Override
    public void settiltang(int tilt) {
        this.gtang = tilt == 0 ? 0.0f : (float)(Math.PI * (double)tilt / 1024.0);
    }

    public double polymost_getflorzofslope(int sectnum, double dax, double day) {
        int dy;
        BoardService boardService = this.engine.getBoardService();
        if (boardService.getSector(sectnum) == null) {
            return 0.0;
        }
        if ((boardService.getSector(sectnum).getFloorstat() & 2) == 0) {
            return boardService.getSector(sectnum).getFloorz();
        }
        Wall wal = boardService.getWall(boardService.getSector(sectnum).getWallptr());
        int dx = boardService.getWall(wal.getPoint2()).getX() - wal.getX();
        long i = (long)EngineUtils.sqrt(dx * dx + (dy = boardService.getWall(wal.getPoint2()).getY() - wal.getY()) * dy) << 5;
        if (i == 0L) {
            return boardService.getSector(sectnum).getFloorz();
        }
        double j = ((double)dx * (day - (double)wal.getY()) - (double)dy * (dax - (double)wal.getX())) / 8.0;
        return (double)boardService.getSector(sectnum).getFloorz() + (double)boardService.getSector(sectnum).getFloorheinum() * j / (double)i;
    }

    public double polymost_getceilzofslope(int sectnum, double dax, double day) {
        int dy;
        BoardService boardService = this.engine.getBoardService();
        if ((boardService.getSector(sectnum).getCeilingstat() & 2) == 0) {
            return boardService.getSector(sectnum).getCeilingz();
        }
        Wall wal = boardService.getWall(boardService.getSector(sectnum).getWallptr());
        int dx = boardService.getWall(wal.getPoint2()).getX() - wal.getX();
        long i = (long)EngineUtils.sqrt(dx * dx + (dy = boardService.getWall(wal.getPoint2()).getY() - wal.getY()) * dy) << 5;
        if (i == 0L) {
            return boardService.getSector(sectnum).getCeilingz();
        }
        double j = ((double)dx * (day - (double)wal.getY()) - (double)dy * (dax - (double)wal.getX())) / 8.0;
        return (double)boardService.getSector(sectnum).getCeilingz() + (double)boardService.getSector(sectnum).getCeilingheinum() * j / (double)i;
    }

    public void polymost_getzsofslope(int sectnum, double dax, double day) {
        BoardService boardService = this.engine.getBoardService();
        Sector sec = boardService.getSector(sectnum);
        if (sec == null) {
            return;
        }
        dceilzsofslope = sec.getCeilingz();
        dfloorzsofslope = sec.getFloorz();
        if (((sec.getCeilingstat() | sec.getFloorstat()) & 2) != 0) {
            int dy;
            Wall wal = boardService.getWall(sec.getWallptr());
            Wall wal2 = boardService.getWall(wal.getPoint2());
            int dx = wal2.getX() - wal.getX();
            long i = (long)EngineUtils.sqrt(dx * dx + (dy = wal2.getY() - wal.getY()) * dy) << 5;
            if (i == 0L) {
                return;
            }
            double j = ((double)dx * (day - (double)wal.getY()) - (double)dy * (dax - (double)wal.getX())) / 8.0;
            if ((sec.getCeilingstat() & 2) != 0) {
                dceilzsofslope = (float)((double)dceilzsofslope + (double)boardService.getSector(sectnum).getCeilingheinum() * j / (double)i);
            }
            if ((sec.getFloorstat() & 2) != 0) {
                dfloorzsofslope = (float)((double)dfloorzsofslope + (double)boardService.getSector(sectnum).getFloorheinum() * j / (double)i);
            }
        }
    }

    private void checkDrawRoomsComplete() {
        if (this.drawRooms) {
            this.onRoomsRenderingComplete();
            this.drawRooms = false;
        }
    }

    public void onRoomsRenderingComplete() {
    }

    @Override
    public void rotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        this.checkDrawRoomsComplete();
        this.globalfog.disable();
        this.ortho.rotatesprite(sx, sy, z, a, picnum, dashade, dapalnum, dastat, cx1, cy1, cx2, cy2);
        this.globalfog.enable();
    }

    @Override
    public void drawmapview(int dax, int day, int zoome, int ang) {
        this.checkDrawRoomsComplete();
        this.globalfog.disable();
        Arrays.fill(this.gotsector, (byte)0);
        this.ortho.drawmapview(dax, day, zoome, ang);
        this.globalfog.enable();
    }

    @Override
    public void drawoverheadmap(int cposx, int cposy, int czoom, short cang) {
        this.checkDrawRoomsComplete();
        this.globalfog.disable();
        this.ortho.drawoverheadmap(this.engine.getBoardService(), cposx, cposy, czoom, cang);
        this.globalfog.enable();
    }

    @Override
    public int printext(Font font, int x, int y, char[] text, float scale, int shade, int palnum, TextAlign align, Transparent transparent, boolean shadow) {
        this.checkDrawRoomsComplete();
        this.globalfog.disable();
        int width = this.ortho.printext(font, x, y, text, scale, shade, palnum, align, transparent, shadow);
        this.globalfog.enable();
        return width;
    }

    @Override
    public void drawline256(int x1, int y1, int x2, int y2, int col) {
        this.checkDrawRoomsComplete();
        this.globalfog.disable();
        this.ortho.drawline256(x1, y1, x2, y2, col);
        this.globalfog.enable();
    }

    private IndexedShader allocIndexedShader() {
        try {
            String ver = Gdx.gl.glGetString(35724);
            if (ver == null) {
                return null;
            }
            return new IndexedShader(Gdx.files.classpath("ru/m210projects/Build/Render/Polymost/shaders/vertex.glsl").readString(), Gdx.files.classpath("ru/m210projects/Build/Render/GdxRender/Shaders/world_fragment.glsl").readString(), this.engine.getPaletteManager().getShadeCount()){

                @Override
                public void bindPalette(int unit) {
                    Gdx.gl.glActiveTexture(unit);
                    Polymost.this.textureCache.getPalette().bind(0);
                }

                @Override
                public void bindPalookup(int unit, int pal) {
                    Gdx.gl.glActiveTexture(unit);
                    Polymost.this.textureCache.getPalookup(pal).bind(0);
                }
            };
        }
        catch (Throwable e) {
            Console.out.println("AllocIndexedShader error: " + e, OsdColor.RED);
            return null;
        }
    }

    protected Polymost2D allocOrphoRenderer(Engine engine) {
        return new Polymost2D(this, (IOverheadMapSettings)new DefaultMapSettings(engine.getBoardService()));
    }

    @Override
    public Renderer.RenderType getType() {
        return Renderer.RenderType.Polymost;
    }

    @Override
    public TileData.PixelFormat getTexFormat() {
        return TileData.PixelFormat.Rgb;
    }

    @Override
    public void completemirror() {
    }

    @Override
    public void setview(int x1, int y1, int x2, int y2) {
        this.xdimen = x2 - x1 + 1;
        this.ydimen = y2 - y1 + 1;
        super.setview(x1, y1, x2, y2);
    }

    @Override
    public void setFieldOfView(int fovDegrees) {
        this.fovFactor = (float)Math.tan((double)fovDegrees * Math.PI / 360.0);
        this.setaspect();
    }

    protected void setaspect(int daxrange, int daaspect) {
        this.viewingrange = this.offscreenrendering ? daxrange : (int)((float)daxrange * this.fovFactor);
        this.yxaspect = daaspect;
        this.xyaspect = Pragmas.divscale(1L, this.yxaspect, 32);
        this.xdimenscale = Pragmas.scale(this.xdimen, this.yxaspect, 320L);
        this.xdimscale = Pragmas.scale(320L, this.xyaspect, this.xdimen);
    }

    @Override
    public void setaspect() {
        if (this.offscreenrendering) {
            this.setaspect(65536, 65536);
            return;
        }
        if (this.config.getWidescreen() == 1 && 4 * this.xdim / 5 != this.ydim) {
            int yx = 81664;
            int vr = Pragmas.divscale((long)this.xdim * 3L, (long)this.ydim * 4L, 16);
            this.setaspect(vr, yx);
        } else {
            this.setaspect(65536, Pragmas.divscale((long)this.ydim * 320L, (long)this.xdim * 200L, 16));
        }
    }

    @Override
    public void onPalookupChanged(int palnum) {
        System.out.println("palette changed " + palnum);
        if (this.texshader != null) {
            this.textureCache.invalidatepalookup(palnum);
        } else {
            for (int j = Engine.MAXTILES - 1; j >= 0; --j) {
                this.invalidatetile(j, palnum, -1);
            }
        }
    }

    @Override
    public void onChangePalette(byte[] palette) {
        this.changepalette(palette);
    }

    @Override
    public void onLoadBoard(Board board) {
        for (int i = 0; i < board.getSpriteCount(); ++i) {
            this.removeSpriteCorr(i);
            Sprite spr = board.getSprite(i);
            if (spr == null || (spr.getCstat() >> 4 & 3) != 1 || spr.getStatnum() == 1024) continue;
            this.addSpriteCorr(i);
        }
    }

    @Override
    public void onAddSprite(int spriteNum) {
        this.addSpriteCorr(spriteNum);
    }

    @Override
    public void onRemoveSprite(int spriteNum) {
        this.removeSpriteCorr(spriteNum);
    }

    @Override
    public void onInvalidate(int tileNum) {
        this.invalidatetile(tileNum, -1, -1);
    }

    @Override
    public PaletteManager getPaletteManager() {
        return this.engine.getPaletteManager();
    }
}

