/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.Software;

import java.util.Objects;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Render.OrphoRenderer;
import ru.m210projects.Build.Render.RenderedSpriteList;
import ru.m210projects.Build.Render.Software.PermFifo;
import ru.m210projects.Build.Render.Software.Software;
import ru.m210projects.Build.Types.AnimType;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.font.AtlasCharInfo;
import ru.m210projects.Build.Types.font.BitmapFont;
import ru.m210projects.Build.Types.font.CharInfo;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.FontType;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class SoftwareOrpho
extends OrphoRenderer {
    protected final int MAXNODESPERLINE = 42;
    protected final int MAXWALLSB = (Engine.MAXWALLS >> 2) + (Engine.MAXWALLS >> 3);
    protected final BoardService boardService;
    private final Software parent;
    private final int MAXPERMS;
    public int[] nrx1 = new int[8];
    public int[] nry1 = new int[8];
    public int[] nrx2 = new int[8];
    public int[] nry2 = new int[8];
    protected int numpages;
    protected int[] dotp1 = new int[3072];
    protected int[] dotp2 = new int[3072];
    protected short[] p2 = new short[this.MAXWALLSB];
    protected int[] xb1 = new int[this.MAXWALLSB];
    protected int[] xb2 = new int[this.MAXWALLSB];
    protected int[] rx1 = new int[this.MAXWALLSB];
    protected int[] rx2 = new int[this.MAXWALLSB];
    protected int[] ry1 = new int[this.MAXWALLSB];
    protected int[] ry2 = new int[this.MAXWALLSB];
    protected short globalpicnum;
    protected int globalorientation;
    protected int globalx1;
    protected int globaly1;
    protected int globalx2;
    protected int globaly2;
    protected int asm1;
    protected int asm2;
    protected int globalpolytype;
    protected boolean drawtext = false;

    public SoftwareOrpho(Software parent, IOverheadMapSettings settings) {
        super(parent, settings);
        this.parent = parent;
        Objects.requireNonNull(parent);
        this.MAXPERMS = 512;
        this.boardService = parent.getBoardService();
    }

    @Override
    public int printext(Font font, int xpos, int ypos, char[] text, float scale, int shade, int palnum, TextAlign textAlign, Transparent transparent, boolean shadow) {
        CharInfo charInfo;
        if (font == null || text == null || text.length == 0) {
            return 0;
        }
        if (shadow) {
            this.printext(font, xpos + (int)scale, ypos + (int)scale, text, scale, 127, palnum, textAlign, transparent, false);
        }
        float scaleyf = scale;
        if (font.isVerticalScaled()) {
            scaleyf *= 1.2f;
        }
        this.parent.globalpal = palnum;
        this.parent.globalshade = shade;
        int alignx = 0;
        if (textAlign != TextAlign.Left) {
            int width = 0;
            for (int pos = 0; pos < text.length && text[pos] != '\u0000'; ++pos) {
                charInfo = font.getCharInfo(text[pos]);
                width += (int)((float)charInfo.getCellSize() * scale);
            }
            if (textAlign == TextAlign.Center) {
                width >>= 1;
            }
            xpos -= width;
        }
        int currentTile = -1;
        for (int c = 0; c < text.length && text[c] != '\u0000'; ++c) {
            charInfo = font.getCharInfo(text[c]);
            int tile = charInfo.tile;
            float cellsizx = scale * (float)charInfo.getCellSize();
            this.globalpicnum = (short)tile;
            if (tile != -1) {
                int charsizex = (int)(scale * (float)charInfo.getWidth());
                int charsizey = (int)(scaleyf * (float)charInfo.getHeight());
                int xoffset = (int)(scale * (float)charInfo.xOffset);
                int yoffset = (int)(scaleyf * (float)charInfo.yOffset);
                if (currentTile != tile) {
                    if (charInfo.getFontType() != FontType.BITMAP_FONT) {
                        ArtEntry charTile;
                        if (!this.parent.getPaletteManager().isValidPalette(palnum)) {
                            palnum = 0;
                        }
                        if (!(charTile = this.parent.getTile(tile)).exists()) {
                            continue;
                        }
                    } else {
                        palnum = this.parent.getPaletteManager().getColorIndex(0, palnum, shade);
                    }
                    currentTile = tile;
                }
                int vx1 = xpos + xoffset;
                int vy1 = ypos + yoffset;
                int vx2 = vx1 + charsizex;
                int vy2 = vy1 + charsizey;
                if (charInfo instanceof AtlasCharInfo) {
                    AtlasCharInfo atlasCharInfo = (AtlasCharInfo)charInfo;
                    int ptr = this.parent.bytesperline * vy2 + vx1;
                    if (ptr < 0) continue;
                    if (charInfo.getFontType() == FontType.BITMAP_FONT) {
                        BitmapFont bitmapFont = (BitmapFont)charInfo.getParent();
                        if (text[c] < '\u0100') {
                            byte[] fontptr = bitmapFont.getData();
                            float tileScaleX = scale * charInfo.getTileScale();
                            float tileScaleY = scaleyf * charInfo.getTileScale();
                            for (int y = charsizey - 1; y >= 0; --y) {
                                for (int x = charsizex - 1; x >= 0; --x) {
                                    int index = (int)((float)y / tileScaleY) + (text[c] << 3);
                                    if ((fontptr[index] & Engine.pow2char[7 - (int)((float)x / tileScaleX)]) == 0) continue;
                                    this.parent.getA().drawpixel(ptr + x, (byte)palnum);
                                }
                                ptr -= this.parent.bytesperline;
                            }
                        }
                    } else {
                        ArtEntry charTile = this.parent.getTile(tile);
                        if (!charTile.hasSize()) continue;
                        if (text[c] < '\u0100') {
                            int flags = 0;
                            if (transparent == Transparent.Bit1) {
                                flags = 1;
                            } else if (transparent == Transparent.Bit2) {
                                flags = 33;
                            }
                            int mscale = (int)(scaleyf * 65536.0f * charInfo.getTileScale());
                            int ctx = Pragmas.mulscale((long)(atlasCharInfo.getTx1() * (float)charTile.getWidth()), mscale, 16);
                            int cty = Pragmas.mulscale((long)(atlasCharInfo.getTy1() * (float)charTile.getHeight()), mscale, 16);
                            this.rotatesprite(vx1 - ctx << 16, vy1 - cty << 16, mscale, 0, currentTile, shade, palnum, 0x18 | flags, xpos, ypos, vx2 - 1, vy2 - 1);
                        }
                    }
                } else {
                    int flags = 0;
                    if (transparent == Transparent.Bit1) {
                        flags = 1;
                    } else if (transparent == Transparent.Bit2) {
                        flags = 33;
                    }
                    this.drawtext = true;
                    this.rotatesprite(vx1 << 16, vy1 << 16, (int)(scaleyf * 65536.0f * charInfo.getTileScale()), 0, currentTile, shade, palnum, 0x18 | flags, 0, 0, this.xdim - 1, this.ydim - 1);
                    this.drawtext = false;
                }
            }
            xpos = (int)((float)xpos + cellsizx);
            alignx = (int)((float)alignx + cellsizx);
        }
        return (int)((float)alignx / scale);
    }

    @Override
    public void drawline256(int x1, int y1, int x2, int y2, int c) {
        int wx1 = this.parent.wx1;
        int wx2 = this.parent.wx2;
        int wy1 = this.parent.wy1;
        int wy2 = this.parent.wy2;
        byte col = (byte)this.parent.getPaletteManager().getColorIndex(0, c);
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (dx >= 0) {
            if (x1 >= wx2 || x2 < wx1) {
                return;
            }
            if (x1 < wx1) {
                y1 += Pragmas.scale(wx1 - x1, dy, dx);
                x1 = wx1;
            }
            if (x2 > wx2) {
                y2 += Pragmas.scale(wx2 - x2, dy, dx);
                x2 = wx2;
            }
        } else {
            if (x2 >= wx2 || x1 < wx1) {
                return;
            }
            if (x2 < wx1) {
                y2 += Pragmas.scale(wx1 - x2, dy, dx);
                x2 = wx1;
            }
            if (x1 > wx2) {
                y1 += Pragmas.scale(wx2 - x1, dy, dx);
                x1 = wx2;
            }
        }
        if (dy >= 0) {
            if (y1 >= wy2 || y2 < wy1) {
                return;
            }
            if (y1 < wy1) {
                x1 += Pragmas.scale(wy1 - y1, dx, dy);
                y1 = wy1;
            }
            if (y2 > wy2) {
                x2 += Pragmas.scale(wy2 - y2, dx, dy);
                y2 = wy2;
            }
        } else {
            if (y2 >= wy2 || y1 < wy1) {
                return;
            }
            if (y2 < wy1) {
                x2 += Pragmas.scale(wy1 - y2, dx, dy);
                y2 = wy1;
            }
            if (y1 > wy2) {
                x1 += Pragmas.scale(wy2 - y1, dx, dy);
                y1 = wy2;
            }
        }
        if (Pragmas.klabs(dx) >= Pragmas.klabs(dy)) {
            int i;
            if (dx == 0) {
                return;
            }
            if (dx < 0) {
                i = x1;
                x1 = x2;
                x2 = i;
                i = y1;
                y1 = y2;
                y2 = i;
            }
            int inc = Pragmas.divscale(dy, dx, 12);
            int plc = y1 + Pragmas.mulscale(2047 - x1 & 0xFFF, inc, 12);
            int daend = x2 + 2048 >> 12;
            for (i = x1 + 2048 >> 12; i < daend; ++i) {
                int j = plc >> 12;
                if (j >= this.parent.startumost[i] && j < this.parent.startdmost[i]) {
                    this.parent.getA().drawpixel(this.parent.ylookup[j] + i, col);
                }
                plc += inc;
            }
        } else {
            int i;
            if (dy < 0) {
                i = x1;
                x1 = x2;
                x2 = i;
                i = y1;
                y1 = y2;
                y2 = i;
            }
            int inc = Pragmas.divscale(dx, dy, 12);
            int plc = x1 + Pragmas.mulscale(2047 - y1 & 0xFFF, inc, 12);
            int daend = y2 + 2048 >> 12;
            int p = this.parent.ylookup[i];
            for (i = y1 + 2048 >> 12; i < daend; ++i) {
                int j = plc >> 12;
                if (i >= this.parent.startumost[j] && i < this.parent.startdmost[j]) {
                    this.parent.getA().drawpixel(p + j, col);
                }
                plc += inc;
                p += this.parent.ylookup[1];
            }
        }
    }

    @Override
    public void drawmapview(int dax, int day, int zoome, int ang) {
        int baky1;
        int bakx1;
        int y;
        int x;
        int oy;
        int ox;
        int j;
        int i;
        int npoints;
        int s;
        Sector sec = null;
        this.parent.beforedrawrooms = 0;
        BoardService service = this.parent.getBoardService();
        int numsectors = service.getSectorCount();
        int cx1 = this.parent.windowx1 << 12;
        int cy1 = this.parent.windowy1 << 12;
        int cx2 = (this.parent.windowx2 + 1 << 12) - 1;
        int cy2 = (this.parent.windowy2 + 1 << 12) - 1;
        int bakgxvect = Pragmas.divscale(EngineUtils.sin(1536 - ang), zoome <<= 8, 28);
        int bakgyvect = Pragmas.divscale(EngineUtils.sin(2048 - ang), zoome, 28);
        int xvect = Pragmas.mulscale(EngineUtils.sin(2048 - ang), zoome, 8);
        int yvect = Pragmas.mulscale(EngineUtils.sin(1536 - ang), zoome, 8);
        int xvect2 = Pragmas.mulscale(xvect, this.parent.yxaspect, 16);
        int yvect2 = Pragmas.mulscale(yvect, this.parent.yxaspect, 16);
        for (s = 0; s < numsectors; ++s) {
            int startwall;
            sec = this.boardService.getSector(s);
            if (!this.mapSettings.isFullMap() && !Engine.show2dsector.getBit(s)) continue;
            npoints = 0;
            i = 0;
            j = startwall = sec.getWallptr();
            if (startwall < 0) continue;
            int w = sec.getWallnum();
            while (w > 0) {
                Wall wal = this.boardService.getWall(j);
                if (wal != null) {
                    ox = wal.getX() - dax;
                    oy = wal.getY() - day;
                    x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (this.xdim << 11);
                    y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (this.ydim << 11);
                    i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                    this.rx1[npoints] = x;
                    this.ry1[npoints] = y;
                    this.xb1[npoints] = wal.getPoint2() - startwall;
                    if (this.xb1[npoints] < 0) {
                        this.xb1[npoints] = 0;
                    }
                    ++npoints;
                }
                --w;
                ++j;
            }
            if ((i & 0xF0) != 240) continue;
            bakx1 = this.rx1[0];
            baky1 = Pragmas.mulscale((long)this.ry1[0] - ((long)this.ydim << 11), this.parent.xyaspect, 16) + (this.ydim << 11);
            if ((i & 0xF) != 0 && (npoints = this.clippoly(npoints, i)) < 3) continue;
            if (this.mapSettings.isShowFloorSprites()) {
                for (ListNode<Sprite> node = service.getSectNode(s); node != null; node = node.getNext()) {
                    int i1 = node.getIndex();
                    if ((node.get().getCstat() & 0x30) != 32 || (this.boardService.getSprite(i1).getCstat() & 0x48) == 72) continue;
                    this.parent.addRenderedSprite(i1);
                }
            }
            int n = s >> 3;
            this.parent.gotsector[n] = (byte)(this.parent.gotsector[n] | Engine.pow2char[s & 7]);
            this.globalorientation = sec.getFloorstat();
            if ((this.globalorientation & 1) != 0) continue;
            this.parent.globalpal = sec.getFloorpal();
            if (sec.getFloorpal() != this.parent.globalpalwritten) {
                this.parent.globalpalwritten = sec.getFloorpal();
                this.parent.getA().setpalookupaddress(this.parent.getPaletteManager().getPalookupBuffer()[this.parent.globalpalwritten]);
            }
            this.globalpicnum = sec.getFloorpicnum();
            if (this.globalpicnum >= Engine.MAXTILES) {
                this.globalpicnum = 0;
            }
            this.parent.setgotpic(this.globalpicnum);
            ArtEntry pic = this.parent.getTile(this.globalpicnum);
            if (!pic.hasSize()) continue;
            if (pic.getType() != AnimType.NONE) {
                this.globalpicnum = (short)(this.globalpicnum + (short)this.parent.animateoffs(this.globalpicnum, s));
                pic = this.parent.getTile(this.globalpicnum);
            }
            this.parent.globalbufplc = this.parent.getTileBuffer(pic);
            int numshades = this.parent.getPaletteManager().getShadeCount();
            this.parent.globalshade = Math.max(Math.min(sec.getFloorshade(), numshades - 1), 0);
            if ((this.globalorientation & 0x40) == 0) {
                this.parent.globalposx = dax;
                this.globalx1 = bakgxvect;
                this.globaly1 = bakgyvect;
                this.parent.globalposy = day;
                this.globalx2 = bakgxvect;
                this.globaly2 = bakgyvect;
            } else {
                ox = this.boardService.getWall(this.boardService.getWall(startwall).getPoint2()).getX() - this.boardService.getWall(startwall).getX();
                i = EngineUtils.sqrt(ox * ox + (oy = this.boardService.getWall(this.boardService.getWall(startwall).getPoint2()).getY() - this.boardService.getWall(startwall).getY()) * oy);
                if (i == 0) continue;
                i = 0x100000 / i;
                this.globalx1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgxvect, oy, bakgyvect, 10), i, 10);
                this.globaly1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgyvect, -oy, bakgxvect, 10), i, 10);
                ox = (bakx1 >> 4) - (this.xdim << 7);
                oy = (baky1 >> 4) - (this.ydim << 7);
                this.parent.globalposx = Pragmas.dmulscale(-oy, this.globalx1, -ox, this.globaly1, 28);
                this.parent.globalposy = Pragmas.dmulscale(-ox, this.globalx1, oy, this.globaly1, 28);
                this.globalx2 = -this.globalx1;
                this.globaly2 = -this.globaly1;
                short daslope = this.boardService.getSector(s).getFloorheinum();
                i = EngineUtils.sqrt(daslope * daslope + 0x1000000);
                this.parent.globalposy = Pragmas.mulscale(this.parent.globalposy, i, 12);
                this.globalx2 = Pragmas.mulscale(this.globalx2, i, 12);
                this.globaly2 = Pragmas.mulscale(this.globaly2, i, 12);
            }
            int globalxshift = 8 - pic.getSizex();
            int globalyshift = 8 - pic.getSizey();
            if ((this.globalorientation & 8) != 0) {
                ++globalxshift;
                ++globalyshift;
            }
            this.parent.globvis = this.parent.globalhisibility;
            if (sec.getVisibility() != 0) {
                this.parent.globvis = Pragmas.mulscale(this.parent.globvis, sec.getVisibility() + 16 & 0xFF, 4);
            }
            this.globalpolytype = 0;
            if ((this.globalorientation & 4) > 0) {
                i = this.parent.globalposx;
                this.parent.globalposx = -this.parent.globalposy;
                this.parent.globalposy = -i;
                i = this.globalx2;
                this.globalx2 = this.globaly1;
                this.globaly1 = i;
                i = this.globalx1;
                this.globalx1 = -this.globaly2;
                this.globaly2 = -i;
            }
            if ((this.globalorientation & 0x10) > 0) {
                this.globalx1 = -this.globalx1;
                this.globaly1 = -this.globaly1;
                this.parent.globalposx = -this.parent.globalposx;
            }
            if ((this.globalorientation & 0x20) > 0) {
                this.globalx2 = -this.globalx2;
                this.globaly2 = -this.globaly2;
                this.parent.globalposy = -this.parent.globalposy;
            }
            this.asm1 = this.globaly1 << globalxshift;
            this.asm2 = this.globalx2 << globalyshift;
            this.globalx1 <<= globalxshift;
            this.globaly2 <<= globalyshift;
            this.parent.globalposx = (this.parent.globalposx << 20 + globalxshift) + (sec.getFloorxpanning() << 24);
            this.parent.globalposy = (this.parent.globalposy << 20 + globalyshift) - (sec.getFloorypanning() << 24);
            this.fillpolygon(npoints);
        }
        if (this.mapSettings.isShowSprites(IOverheadMapSettings.MapView.Polygons) || this.mapSettings.isShowFloorSprites()) {
            int gap = 1;
            RenderedSpriteList tsprite = this.parent.getRenderedSprites();
            int sortnum = this.parent.getRenderedSprites().getSize();
            while (gap < sortnum) {
                gap = (gap << 1) + 1;
            }
            gap >>= 1;
            while (gap > 0) {
                block5: for (i = 0; i < sortnum - gap; ++i) {
                    for (j = i; j >= 0; j -= gap) {
                        TSprite tspr1 = (TSprite)tsprite.get(j);
                        TSprite tspr2 = (TSprite)tsprite.get(j + gap);
                        if (this.boardService.getSprite(tspr1.getOwner()).getZ() <= this.boardService.getSprite(tspr2.getOwner()).getZ()) continue block5;
                        short owner1 = tspr1.getOwner();
                        tspr1.setOwner(tspr2.getOwner());
                        tspr2.setOwner(owner1);
                    }
                }
                gap >>= 1;
            }
            for (s = sortnum - 1; s >= 0; --s) {
                Sprite spr = this.boardService.getSprite(((TSprite)tsprite.get(s)).getOwner());
                if ((spr.getCstat() & 0x30) != 32) continue;
                npoints = 0;
                if (spr.getPicnum() >= Engine.MAXTILES) {
                    spr.setPicnum(0);
                }
                ArtEntry pic = this.parent.getTile(spr.getPicnum());
                byte xoff = (byte)(pic.getOffsetX() + spr.getXoffset());
                byte yoff = (byte)(pic.getOffsetY() + spr.getYoffset());
                if ((spr.getCstat() & 4) > 0) {
                    xoff = -xoff;
                }
                if ((spr.getCstat() & 8) > 0) {
                    yoff = -yoff;
                }
                int k = spr.getAng() & 0x7FF;
                int cosang = EngineUtils.cos(k);
                int sinang = EngineUtils.sin(k);
                int xspan = pic.getWidth();
                short xrepeat = spr.getXrepeat();
                int yspan = pic.getHeight();
                short yrepeat = spr.getYrepeat();
                ox = ((xspan >> 1) + xoff) * xrepeat;
                oy = ((yspan >> 1) + yoff) * yrepeat;
                int x1 = spr.getX() + Pragmas.mulscale(sinang, ox, 16) + Pragmas.mulscale(cosang, oy, 16);
                int y1 = spr.getY() + Pragmas.mulscale(sinang, oy, 16) - Pragmas.mulscale(cosang, ox, 16);
                int l = xspan * xrepeat;
                int x2 = x1 - Pragmas.mulscale(sinang, l, 16);
                int y2 = y1 + Pragmas.mulscale(cosang, l, 16);
                l = yspan * yrepeat;
                k = -Pragmas.mulscale(cosang, l, 16);
                int x3 = x2 + k;
                int x4 = x1 + k;
                k = -Pragmas.mulscale(sinang, l, 16);
                int y3 = y2 + k;
                int y4 = y1 + k;
                this.xb1[0] = 1;
                this.xb1[1] = 2;
                this.xb1[2] = 3;
                this.xb1[3] = 0;
                npoints = 4;
                i = 0;
                ox = x1 - dax;
                oy = y1 - day;
                x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (this.xdim << 11);
                y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (this.ydim << 11);
                i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                this.rx1[0] = x;
                this.ry1[0] = y;
                ox = x2 - dax;
                oy = y2 - day;
                x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (this.xdim << 11);
                y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (this.ydim << 11);
                i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                this.rx1[1] = x;
                this.ry1[1] = y;
                ox = x3 - dax;
                oy = y3 - day;
                x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (this.xdim << 11);
                y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (this.ydim << 11);
                i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                this.rx1[2] = x;
                this.ry1[2] = y;
                x = this.rx1[0] + this.rx1[2] - this.rx1[1];
                y = this.ry1[0] + this.ry1[2] - this.ry1[1];
                this.rx1[3] = x;
                this.ry1[3] = y;
                if (((i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y)) & 0xF0) != 240) continue;
                bakx1 = this.rx1[0];
                baky1 = Pragmas.mulscale((long)this.ry1[0] - ((long)this.ydim << 11), this.parent.xyaspect, 16) + (this.ydim << 11);
                if ((i & 0xF) != 0 && (npoints = this.clippoly(npoints, i)) < 3) continue;
                this.globalpicnum = spr.getPicnum();
                this.parent.globalpal = spr.getPal();
                this.parent.setgotpic(this.globalpicnum);
                ArtEntry sprpic = this.parent.getTile(this.globalpicnum);
                if (!sprpic.hasSize()) continue;
                if (sprpic.getType() != AnimType.NONE) {
                    this.globalpicnum = (short)(this.globalpicnum + (short)this.parent.animateoffs(this.globalpicnum, s));
                    sprpic = this.parent.getTile(this.globalpicnum);
                }
                this.parent.globalbufplc = this.parent.getTileBuffer(sprpic);
                this.parent.globalshade = (this.boardService.getSector(spr.getSectnum()).getCeilingstat() & 1) > 0 ? (int)this.boardService.getSector(spr.getSectnum()).getCeilingshade() : (int)this.boardService.getSector(spr.getSectnum()).getFloorshade();
                int numshades = this.parent.getPaletteManager().getShadeCount();
                this.parent.globalshade = Math.max(Math.min(this.parent.globalshade + spr.getShade() + 6, numshades - 1), 0);
                this.parent.globvis = this.parent.globalhisibility;
                if (sec.getVisibility() != 0) {
                    this.parent.globvis = Pragmas.mulscale(this.parent.globvis, sec.getVisibility() + 16 & 0xFF, 4);
                }
                this.globalpolytype = ((spr.getCstat() & 2) >> 1) + 1;
                this.parent.getA().setuphline(this.parent.getPaletteManager().getPalookupBuffer()[spr.getPal()], this.parent.globalshade << 8);
                ox = x2 - x1;
                oy = y2 - y1;
                i = ox * ox + oy * oy;
                if (i == 0) continue;
                i = 0x40000000 / i;
                this.globalx1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgxvect, oy, bakgyvect, 10), i, 10);
                this.globaly1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgyvect, -oy, bakgxvect, 10), i, 10);
                ox = y1 - y4;
                oy = x4 - x1;
                i = ox * ox + oy * oy;
                if (i == 0) continue;
                i = 0x40000000 / i;
                this.globalx2 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgxvect, oy, bakgyvect, 10), i, 10);
                this.globaly2 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgyvect, -oy, bakgxvect, 10), i, 10);
                ox = pic.getSizex();
                oy = pic.getSizey();
                if (Engine.pow2long[ox] != xspan) {
                    this.globalx1 = Pragmas.mulscale(this.globalx1, xspan, ++ox);
                    this.globaly1 = Pragmas.mulscale(this.globaly1, xspan, ox);
                }
                bakx1 = (bakx1 >> 4) - (this.xdim << 7);
                baky1 = (baky1 >> 4) - (this.ydim << 7);
                this.parent.globalposx = Pragmas.dmulscale(-baky1, this.globalx1, -bakx1, this.globaly1, 28);
                this.parent.globalposy = Pragmas.dmulscale(bakx1, this.globalx2, -baky1, this.globaly2, 28);
                if ((spr.getCstat() & 2) == 0) {
                    this.parent.getA().msethlineshift(ox, oy);
                } else {
                    if ((spr.getCstat() & 0x200) != 0) {
                        this.parent.getA().settransreverse();
                    } else {
                        this.parent.getA().settransnormal();
                    }
                    this.parent.getA().tsethlineshift(ox, oy);
                }
                if ((spr.getCstat() & 4) > 0) {
                    this.globalx1 = -this.globalx1;
                    this.globaly1 = -this.globaly1;
                    this.parent.globalposx = -this.parent.globalposx;
                }
                this.asm1 = this.globaly1 << 2;
                this.globalx1 <<= 2;
                this.parent.globalposx <<= 22;
                this.asm2 = this.globalx2 << 2;
                this.globaly2 <<= 2;
                this.parent.globalposy <<= 22;
                this.globalorientation = (spr.getCstat() & 2) << 7 | (spr.getCstat() & 0x200) >> 2;
                this.fillpolygon(npoints);
            }
        }
    }

    private int clippoly(int npoints, int clipstat) {
        int t;
        int z4;
        short z3;
        int z2;
        short z1;
        int s1;
        int zz;
        int s2;
        int splitcnt;
        int z;
        int start2;
        int npoints2;
        int cx1 = this.parent.windowx1;
        int cy1 = this.parent.windowy1;
        int cx2 = this.parent.windowx2 + 1;
        int cy2 = this.parent.windowy2 + 1;
        cx1 <<= 12;
        cy1 <<= 12;
        cx2 <<= 12;
        cy2 <<= 12;
        if ((clipstat & 0xA) != 0) {
            npoints2 = 0;
            start2 = 0;
            z = 0;
            splitcnt = 0;
            do {
                s2 = cx1 - this.rx1[z];
                do {
                    zz = this.xb1[z];
                    this.xb1[z] = -1;
                    s1 = s2;
                    s2 = cx1 - this.rx1[zz];
                    if (s1 < 0) {
                        this.rx2[npoints2] = this.rx1[z];
                        this.ry2[npoints2] = this.ry1[z];
                        this.xb2[npoints2] = npoints2 + 1;
                        ++npoints2;
                    }
                    if ((s1 ^ s2) >= 0) continue;
                    this.rx2[npoints2] = this.rx1[z] + Pragmas.scale(this.rx1[zz] - this.rx1[z], s1, s1 - s2);
                    this.ry2[npoints2] = this.ry1[z] + Pragmas.scale(this.ry1[zz] - this.ry1[z], s1, s1 - s2);
                    if (s1 < 0) {
                        this.p2[splitcnt++] = (short)npoints2;
                    }
                    this.xb2[npoints2] = npoints2 + 1;
                    ++npoints2;
                } while (this.xb1[z = zz] >= 0);
                if (npoints2 >= start2 + 3) {
                    this.xb2[npoints2 - 1] = start2;
                    start2 = npoints2;
                } else {
                    npoints2 = start2;
                }
                for (z = 1; z < npoints && this.xb1[z] < 0; ++z) {
                }
            } while (z < npoints);
            if (npoints2 <= 2) {
                return 0;
            }
            for (z = 1; z < splitcnt; ++z) {
                for (zz = 0; zz < z; ++zz) {
                    z1 = this.p2[z];
                    z2 = this.xb2[z1];
                    z3 = this.p2[zz];
                    z4 = this.xb2[z3];
                    s1 = Pragmas.klabs(this.rx2[z1] - this.rx2[z2]) + Pragmas.klabs(this.ry2[z1] - this.ry2[z2]);
                    s2 = Pragmas.klabs(this.rx2[z1] - this.rx2[z4]) + Pragmas.klabs(this.ry2[z1] - this.ry2[z4]);
                    if ((s2 += Pragmas.klabs(this.rx2[z3] - this.rx2[z2]) + Pragmas.klabs(this.ry2[z3] - this.ry2[z2])) >= (s1 += Pragmas.klabs(this.rx2[z3] - this.rx2[z4]) + Pragmas.klabs(this.ry2[z3] - this.ry2[z4]))) continue;
                    t = this.xb2[this.p2[z]];
                    this.xb2[this.p2[z]] = this.xb2[this.p2[zz]];
                    this.xb2[this.p2[zz]] = t;
                }
            }
            npoints = 0;
            start2 = 0;
            z = 0;
            splitcnt = 0;
            do {
                s2 = cy1 - this.ry2[z];
                do {
                    zz = this.xb2[z];
                    this.xb2[z] = -1;
                    s1 = s2;
                    s2 = cy1 - this.ry2[zz];
                    if (s1 < 0) {
                        this.rx1[npoints] = this.rx2[z];
                        this.ry1[npoints] = this.ry2[z];
                        this.xb1[npoints] = npoints + 1;
                        ++npoints;
                    }
                    if ((s1 ^ s2) >= 0) continue;
                    this.rx1[npoints] = this.rx2[z] + Pragmas.scale(this.rx2[zz] - this.rx2[z], s1, s1 - s2);
                    this.ry1[npoints] = this.ry2[z] + Pragmas.scale(this.ry2[zz] - this.ry2[z], s1, s1 - s2);
                    if (s1 < 0) {
                        this.p2[splitcnt++] = (short)npoints;
                    }
                    this.xb1[npoints] = npoints + 1;
                    ++npoints;
                } while (this.xb2[z = zz] >= 0);
                if (npoints >= start2 + 3) {
                    this.xb1[npoints - 1] = start2;
                    start2 = npoints;
                } else {
                    npoints = start2;
                }
                for (z = 1; z < npoints2 && this.xb2[z] < 0; ++z) {
                }
            } while (z < npoints2);
            if (npoints <= 2) {
                return 0;
            }
            for (z = 1; z < splitcnt; ++z) {
                for (zz = 0; zz < z; ++zz) {
                    z1 = this.p2[z];
                    z2 = this.xb1[z1];
                    z3 = this.p2[zz];
                    z4 = this.xb1[z3];
                    s1 = Pragmas.klabs(this.rx1[z1] - this.rx1[z2]) + Pragmas.klabs(this.ry1[z1] - this.ry1[z2]);
                    s2 = Pragmas.klabs(this.rx1[z1] - this.rx1[z4]) + Pragmas.klabs(this.ry1[z1] - this.ry1[z4]);
                    if ((s2 += Pragmas.klabs(this.rx1[z3] - this.rx1[z2]) + Pragmas.klabs(this.ry1[z3] - this.ry1[z2])) >= (s1 += Pragmas.klabs(this.rx1[z3] - this.rx1[z4]) + Pragmas.klabs(this.ry1[z3] - this.ry1[z4]))) continue;
                    t = this.xb1[this.p2[z]];
                    this.xb1[this.p2[z]] = this.xb1[this.p2[zz]];
                    this.xb1[this.p2[zz]] = t;
                }
            }
        }
        if ((clipstat & 5) != 0) {
            npoints2 = 0;
            start2 = 0;
            z = 0;
            splitcnt = 0;
            do {
                s2 = this.rx1[z] - cx2;
                do {
                    zz = this.xb1[z];
                    this.xb1[z] = -1;
                    s1 = s2;
                    s2 = this.rx1[zz] - cx2;
                    if (s1 < 0) {
                        this.rx2[npoints2] = this.rx1[z];
                        this.ry2[npoints2] = this.ry1[z];
                        this.xb2[npoints2] = npoints2 + 1;
                        ++npoints2;
                    }
                    if ((s1 ^ s2) >= 0) continue;
                    this.rx2[npoints2] = this.rx1[z] + Pragmas.scale(this.rx1[zz] - this.rx1[z], s1, s1 - s2);
                    this.ry2[npoints2] = this.ry1[z] + Pragmas.scale(this.ry1[zz] - this.ry1[z], s1, s1 - s2);
                    if (s1 < 0) {
                        this.p2[splitcnt++] = (short)npoints2;
                    }
                    this.xb2[npoints2] = npoints2 + 1;
                    ++npoints2;
                } while (this.xb1[z = zz] >= 0);
                if (npoints2 >= start2 + 3) {
                    this.xb2[npoints2 - 1] = start2;
                    start2 = npoints2;
                } else {
                    npoints2 = start2;
                }
                for (z = 1; z < npoints && this.xb1[z] < 0; ++z) {
                }
            } while (z < npoints);
            if (npoints2 <= 2) {
                return 0;
            }
            for (z = 1; z < splitcnt; ++z) {
                for (zz = 0; zz < z; ++zz) {
                    z1 = this.p2[z];
                    z2 = this.xb2[z1];
                    z3 = this.p2[zz];
                    z4 = this.xb2[z3];
                    s1 = Pragmas.klabs(this.rx2[z1] - this.rx2[z2]) + Pragmas.klabs(this.ry2[z1] - this.ry2[z2]);
                    s2 = Pragmas.klabs(this.rx2[z1] - this.rx2[z4]) + Pragmas.klabs(this.ry2[z1] - this.ry2[z4]);
                    if ((s2 += Pragmas.klabs(this.rx2[z3] - this.rx2[z2]) + Pragmas.klabs(this.ry2[z3] - this.ry2[z2])) >= (s1 += Pragmas.klabs(this.rx2[z3] - this.rx2[z4]) + Pragmas.klabs(this.ry2[z3] - this.ry2[z4]))) continue;
                    t = this.xb2[this.p2[z]];
                    this.xb2[this.p2[z]] = this.xb2[this.p2[zz]];
                    this.xb2[this.p2[zz]] = t;
                }
            }
            npoints = 0;
            start2 = 0;
            z = 0;
            splitcnt = 0;
            do {
                s2 = this.ry2[z] - cy2;
                do {
                    zz = this.xb2[z];
                    this.xb2[z] = -1;
                    s1 = s2;
                    s2 = this.ry2[zz] - cy2;
                    if (s1 < 0) {
                        this.rx1[npoints] = this.rx2[z];
                        this.ry1[npoints] = this.ry2[z];
                        this.xb1[npoints] = npoints + 1;
                        ++npoints;
                    }
                    if ((s1 ^ s2) >= 0) continue;
                    this.rx1[npoints] = this.rx2[z] + Pragmas.scale(this.rx2[zz] - this.rx2[z], s1, s1 - s2);
                    this.ry1[npoints] = this.ry2[z] + Pragmas.scale(this.ry2[zz] - this.ry2[z], s1, s1 - s2);
                    if (s1 < 0) {
                        this.p2[splitcnt++] = (short)npoints;
                    }
                    this.xb1[npoints] = npoints + 1;
                    ++npoints;
                } while (this.xb2[z = zz] >= 0);
                if (npoints >= start2 + 3) {
                    this.xb1[npoints - 1] = start2;
                    start2 = npoints;
                } else {
                    npoints = start2;
                }
                for (z = 1; z < npoints2 && this.xb2[z] < 0; ++z) {
                }
            } while (z < npoints2);
            if (npoints <= 2) {
                return 0;
            }
            for (z = 1; z < splitcnt; ++z) {
                for (zz = 0; zz < z; ++zz) {
                    z1 = this.p2[z];
                    z2 = this.xb1[z1];
                    z3 = this.p2[zz];
                    z4 = this.xb1[z3];
                    s1 = Pragmas.klabs(this.rx1[z1] - this.rx1[z2]) + Pragmas.klabs(this.ry1[z1] - this.ry1[z2]);
                    s2 = Pragmas.klabs(this.rx1[z1] - this.rx1[z4]) + Pragmas.klabs(this.ry1[z1] - this.ry1[z4]);
                    if ((s2 += Pragmas.klabs(this.rx1[z3] - this.rx1[z2]) + Pragmas.klabs(this.ry1[z3] - this.ry1[z2])) >= (s1 += Pragmas.klabs(this.rx1[z3] - this.rx1[z4]) + Pragmas.klabs(this.ry1[z3] - this.ry1[z4]))) continue;
                    t = this.xb1[this.p2[z]];
                    this.xb1[this.p2[z]] = this.xb1[this.p2[zz]];
                    this.xb1[this.p2[zz]] = t;
                }
            }
        }
        return npoints;
    }

    private void fillpolygon(int npoints) {
        int x2;
        int x1;
        int day2;
        int zz;
        int day1;
        int y;
        int z;
        ArtEntry pic = this.parent.getTile(this.globalpicnum);
        this.parent.getA().sethlinesizes(pic.getSizex(), pic.getSizey(), this.parent.globalbufplc);
        int miny = Integer.MAX_VALUE;
        int maxy = Integer.MIN_VALUE;
        for (z = npoints - 1; z >= 0; --z) {
            y = this.ry1[z];
            miny = Math.min(miny, y);
            maxy = Math.max(maxy, y);
        }
        maxy >>= 12;
        if ((miny >>= 12) < 0) {
            miny = 0;
        }
        if (maxy >= this.ydim) {
            maxy = this.ydim - 1;
        }
        int ptr = 0;
        for (y = miny; y <= maxy; ++y) {
            this.dotp1[y] = ptr;
            this.dotp2[y] = ptr + 21;
            ptr += 42;
        }
        for (z = npoints - 1; z >= 0; --z) {
            int y1 = this.ry1[z];
            day1 = y1 >> 12;
            zz = this.xb1[z];
            int y2 = this.ry1[zz];
            day2 = y2 >> 12;
            if (day1 == day2) continue;
            x1 = this.rx1[z];
            x2 = this.rx1[zz];
            int xinc = Pragmas.divscale(x2 - x1, y2 - y1, 12);
            if (day2 > day1) {
                x1 += Pragmas.mulscale((day1 << 12) + 4095 - y1, xinc, 12);
                y = day1;
                while (y < day2) {
                    int n = y++;
                    int n2 = this.dotp2[n];
                    this.dotp2[n] = n2 + 1;
                    this.parent.smost[n2] = (short)(x1 >> 12);
                    x1 += xinc;
                }
                continue;
            }
            x2 += Pragmas.mulscale((day2 << 12) + 4095 - y2, xinc, 12);
            y = day2;
            while (y < day1) {
                int n = y++;
                int n3 = this.dotp1[n];
                this.dotp1[n] = n3 + 1;
                this.parent.smost[n3] = (short)(x2 >> 12);
                x2 += xinc;
            }
        }
        this.globalx1 = Pragmas.mulscale(this.globalx1, this.parent.xyaspect, 16);
        this.globaly2 = Pragmas.mulscale(this.globaly2, this.parent.xyaspect, 16);
        int oy = miny + 1 - (this.ydim >> 1);
        this.parent.globalposx += oy * this.globalx1;
        this.parent.globalposy += oy * this.globaly2;
        this.parent.getA().setuphlineasm4(this.asm1, this.asm2);
        ptr = 0;
        for (y = miny; y <= maxy; ++y) {
            int cnt = this.dotp1[y] - ptr;
            int ptr2 = ptr + 21;
            for (z = cnt - 1; z >= 0; --z) {
                int p;
                int by;
                int bx;
                int ox;
                day1 = 0;
                day2 = 0;
                for (zz = z; zz > 0; --zz) {
                    if (this.parent.smost[ptr + zz] < this.parent.smost[ptr + day1]) {
                        day1 = zz;
                    }
                    if (this.parent.smost[ptr2 + zz] >= this.parent.smost[ptr2 + day2]) continue;
                    day2 = zz;
                }
                x1 = this.parent.smost[ptr + day1];
                this.parent.smost[ptr + day1] = this.parent.smost[ptr + z];
                x2 = this.parent.smost[ptr2 + day2] - 1;
                this.parent.smost[ptr2 + day2] = this.parent.smost[ptr2 + z];
                if (x1 > x2) continue;
                if (this.globalpolytype < 1) {
                    ox = x2 + 1 - (this.xdim >> 1);
                    bx = ox * this.asm1 + this.parent.globalposx;
                    by = ox * this.asm2 - this.parent.globalposy;
                    p = this.parent.ylookup[y] + x2;
                    this.parent.getA().hlineasm4(x2 - x1, -1, this.parent.globalshade << 8, by, bx, p);
                    continue;
                }
                ox = x1 + 1 - (this.xdim >> 1);
                bx = ox * this.asm1 + this.parent.globalposx;
                by = ox * this.asm2 - this.parent.globalposy;
                p = this.parent.ylookup[y] + x1;
                if (this.globalpolytype == 1) {
                    this.parent.getA().mhline(this.parent.globalbufplc, bx, x2 - x1 << 16, 0, by, p);
                    continue;
                }
                this.parent.getA().thline(this.parent.globalbufplc, bx, x2 - x1 << 16, 0, by, p);
            }
            this.parent.globalposx += this.globalx1;
            this.parent.globalposy += this.globaly2;
            ptr += 42;
        }
    }

    @Override
    public void rotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        if (picnum >= Engine.MAXTILES) {
            return;
        }
        if (cx1 > cx2 || cy1 > cy2) {
            return;
        }
        if (z <= 16) {
            return;
        }
        ArtEntry pic = this.parent.getTile(picnum);
        if (pic.getType() != AnimType.NONE) {
            picnum += this.parent.animateoffs(picnum, 0);
            pic = this.parent.getTile(picnum);
        }
        if (!pic.hasSize()) {
            return;
        }
        if ((dastat & 0x80) == 0 || this.numpages < 2 || this.parent.beforedrawrooms != 0) {
            this.dorotatesprite(sx, sy, z, a, picnum, dashade, dapalnum, dastat, cx1, cy1, cx2, cy2, this.parent.guniqhudid);
        }
        if ((dastat & 0x40) != 0 && cx1 <= 0 && cy1 <= 0 && cx2 >= this.xdim - 1 && cy2 >= this.ydim - 1 && sx == 0xA00000 && sy == 0x640000 && (long)z == 65536L && a == 0 && (dastat & 1) == 0) {
            this.parent.permtail = 0;
            this.parent.permhead = 0;
        }
        if ((dastat & 0x80) == 0) {
            return;
        }
        if (this.numpages >= 2) {
            PermFifo per = this.parent.permfifo[this.parent.permhead];
            if (per == null) {
                per = new PermFifo();
            }
            per.sx = sx;
            per.sy = sy;
            per.z = z;
            per.a = (short)a;
            per.picnum = (short)picnum;
            per.dashade = (short)dashade;
            per.dapalnum = (short)dapalnum;
            per.dastat = (short)dastat;
            per.pagesleft = (short)(this.numpages + ((this.parent.beforedrawrooms & 1) << 7));
            per.cx1 = cx1;
            per.cy1 = cy1;
            per.cx2 = cx2;
            per.cy2 = cy2;
            per.uniqid = this.parent.guniqhudid;
            if ((dastat & 0x40) != 0) {
                ArtEntry pic2;
                PermFifo per2;
                int i = this.parent.permtail;
                while (i != this.parent.permhead) {
                    per2 = this.parent.permfifo[i];
                    if (per2 == null) {
                        per2 = new PermFifo();
                    }
                    if ((per2.pagesleft & 0x7F) != 0 && per2.sx == per.sx && per2.sy == per.sy && per2.z == per.z && per2.a == per.a && (pic2 = this.parent.getTile(per2.picnum)).getWidth() <= pic.getWidth() && pic2.getHeight() <= pic.getHeight() && per2.cx1 >= per.cx1 && per2.cy1 >= per.cy1 && per2.cx2 <= per.cx2 && per2.cy2 <= per.cy2) {
                        per2.pagesleft = 0;
                    }
                    i = i + 1 & this.MAXPERMS - 1;
                }
                if (per.z == 65536 && per.a == 0) {
                    i = this.parent.permtail;
                    while (i != this.parent.permhead) {
                        per2 = this.parent.permfifo[i];
                        if (per2 == null) {
                            per2 = new PermFifo();
                        }
                        if ((per2.pagesleft & 0x7F) != 0 && per2.z == 65536 && per2.a == 0 && per2.cx1 >= per.cx1 && per2.cy1 >= per.cy1 && per2.cx2 <= per.cx2 && per2.cy2 <= per.cy2 && per2.sx >> 16 >= per.sx >> 16 && per2.sy >> 16 >= per.sy >> 16 && (per2.sx >> 16) + (pic2 = this.parent.getTile(per2.picnum)).getWidth() <= (per.sx >> 16) + pic.getWidth() && (per2.sy >> 16) + pic2.getHeight() <= (per.sy >> 16) + pic.getHeight()) {
                            per2.pagesleft = 0;
                        }
                        i = i + 1 & this.MAXPERMS - 1;
                    }
                }
            }
            this.parent.permhead = this.parent.permhead + 1 & this.MAXPERMS - 1;
        }
    }

    private void dorotatesprite(int sx, int sy, int z, int ang, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2, int uniqid) {
        int yv2;
        int xv2;
        if (!this.parent.getPaletteManager().isValidPalette(dapalnum)) {
            dapalnum = 0;
        }
        if (cx1 < 0) {
            cx1 = 0;
        }
        if (cy1 < 0) {
            cy1 = 0;
        }
        if (cx2 > this.xdim - 1) {
            cx2 = this.xdim - 1;
        }
        if (cy2 > this.ydim - 1) {
            cy2 = this.ydim - 1;
        }
        ArtEntry pic = this.parent.getTile(picnum);
        int xsiz = pic.getWidth();
        int ysiz = pic.getHeight();
        int xoff = 0;
        int yoff = 0;
        if ((dastat & 0x10) == 0) {
            xoff = pic.getOffsetX() + (xsiz >> 1);
            yoff = pic.getOffsetY() + (ysiz >> 1);
        }
        if ((dastat & 4) != 0) {
            yoff = ysiz - yoff;
        }
        int cosang = EngineUtils.cos(ang);
        int sinang = EngineUtils.sin(ang);
        int ourxyaspect = this.parent.xyaspect;
        int ouryxaspect = this.parent.yxaspect;
        if ((dastat & 2) == 0) {
            if ((dastat & 0x400) == 0 && 4 * this.ydim <= 3 * this.xdim) {
                ouryxaspect = 78643;
                ourxyaspect = 54613;
            }
        } else {
            int zoomsc;
            int oxdim;
            int xdim = oxdim = this.xdim;
            int normxofs = sx - 0xA00000;
            int normyofs = sy - 0x640000;
            if ((dastat & 0x400) == 0 && 4 * this.ydim <= 3 * xdim) {
                xdim = 4 * this.ydim / 3;
                ouryxaspect = 78643;
                ourxyaspect = 54613;
            }
            if ((dastat & 8) == 0) {
                int twice_midcx = this.parent.windowx1 + this.parent.windowx2 + 2;
                int scaledxofs = Pragmas.scale(normxofs, Pragmas.scale(this.parent.xdimen, xdim, oxdim), 320L);
                int xbord = 0;
                if ((dastat & 0x300) != 0) {
                    xbord = Pragmas.scale(oxdim - xdim, twice_midcx, oxdim);
                    if ((dastat & 0x200) == 0) {
                        xbord = -xbord;
                    }
                }
                sx = (twice_midcx + xbord << 15) + scaledxofs;
                zoomsc = this.parent.xdimenscale;
                sy = (this.parent.windowy1 + this.parent.windowy2 + 2 << 15) + Pragmas.mulscale(normyofs, zoomsc, 16);
            } else {
                sx = (xdim << 15) + 32768 + Pragmas.scale(normxofs, xdim, 320L);
                if ((dastat & 0x200) != 0) {
                    sx += oxdim - xdim << 16;
                } else if ((dastat & 0x100) == 0) {
                    sx += oxdim - xdim << 15;
                }
                zoomsc = Pragmas.scale(xdim, ouryxaspect, 320L);
                sy = (this.ydim << 15) + 32768 + Pragmas.mulscale(normyofs, zoomsc, 16);
            }
            z = Pragmas.mulscale(z, zoomsc, 16);
        }
        int xv = Pragmas.mulscale(cosang, z, 14);
        int yv = Pragmas.mulscale(sinang, z, 14);
        if ((dastat & 2) != 0 || (dastat & 8) == 0 || this.drawtext) {
            xv2 = Pragmas.mulscale(xv, ourxyaspect, 16);
            yv2 = Pragmas.mulscale(yv, ourxyaspect, 16);
        } else {
            xv2 = xv;
            yv2 = yv;
        }
        this.nry1[0] = sy - (yv * xoff + xv * yoff);
        this.nry1[1] = this.nry1[0] + yv * xsiz;
        this.nry1[3] = this.nry1[0] + xv * ysiz;
        this.nry1[2] = this.nry1[1] + this.nry1[3] - this.nry1[0];
        int i = cy1 << 16;
        if (this.nry1[0] < i && this.nry1[1] < i && this.nry1[2] < i && this.nry1[3] < i) {
            return;
        }
        i = cy2 << 16;
        if (this.nry1[0] > i && this.nry1[1] > i && this.nry1[2] > i && this.nry1[3] > i) {
            return;
        }
        this.nrx1[0] = sx - (xv2 * xoff - yv2 * yoff);
        this.nrx1[1] = this.nrx1[0] + xv2 * xsiz;
        this.nrx1[3] = this.nrx1[0] - yv2 * ysiz;
        this.nrx1[2] = this.nrx1[1] + this.nrx1[3] - this.nrx1[0];
        i = cx1 << 16;
        if (this.nrx1[0] < i && this.nrx1[1] < i && this.nrx1[2] < i && this.nrx1[3] < i) {
            return;
        }
        i = cx2 << 16;
        if (this.nrx1[0] > i && this.nrx1[1] > i && this.nrx1[2] > i && this.nrx1[3] > i) {
            return;
        }
        int gx1 = this.nrx1[0];
        int gy1 = this.nry1[0];
        int npoints = this.clippoly4(cx1 << 16, cy1 << 16, cx2 + 1 << 16, cy2 + 1 << 16);
        if (npoints < 3) {
            return;
        }
        int lx = this.nrx1[0];
        int rx = this.nrx1[0];
        int nextv = 0;
        int v = npoints - 1;
        while (v >= 0) {
            int x1 = this.nrx1[v];
            int x2 = this.nrx1[nextv];
            int dax1 = x1 >> 16;
            if (x1 < lx) {
                lx = x1;
            }
            int dax2 = x2 >> 16;
            if (x1 > rx) {
                rx = x1;
            }
            if (dax1 != dax2) {
                int yplc;
                int y1 = this.nry1[v];
                int y2 = this.nry1[nextv];
                int yinc = Pragmas.divscale(y2 - y1, x2 - x1, 16);
                if (dax2 > dax1) {
                    yplc = y1 + Pragmas.mulscale((dax1 << 16) + 65535 - x1, yinc, 16);
                    this.parent.qinterpolatedown16short(this.parent.uplc, dax1, dax2 - dax1, yplc, yinc);
                } else {
                    yplc = y2 + Pragmas.mulscale((dax2 << 16) + 65535 - x2, yinc, 16);
                    this.parent.qinterpolatedown16short(this.parent.dplc, dax2, dax1 - dax2, yplc, yinc);
                }
            }
            nextv = v--;
        }
        this.parent.setgotpic(picnum);
        byte[] bufplc = this.parent.getTileBuffer(pic);
        int palookupshade = this.parent.getPaletteManager().getPalookup(0, dashade) << 8;
        i = Pragmas.divscale(1L, z, 32);
        xv = Pragmas.mulscale(sinang, i, 14);
        yv = Pragmas.mulscale(cosang, i, 14);
        if ((dastat & 2) != 0 || (dastat & 8) == 0 || this.drawtext) {
            yv2 = Pragmas.mulscale(-xv, ouryxaspect, 16);
            xv2 = Pragmas.mulscale(yv, ouryxaspect, 16);
        } else {
            yv2 = -xv;
            xv2 = yv;
        }
        int x1 = lx >> 16;
        int x2 = rx >> 16;
        short oy = 0;
        int x = (x1 << 16) - 1 - gx1;
        int y = 65535 - gy1;
        int bx = Pragmas.dmulscale(x, xv2, y, xv, 16);
        int by = Pragmas.dmulscale(x, yv2, y, yv, 16);
        if ((dastat & 4) != 0) {
            yv = -yv;
            yv2 = -yv2;
            by = (ysiz << 16) - 1 - by;
        }
        if ((dastat & 1) == 0) {
            if ((dastat & 0x40) != 0) {
                this.parent.getA().setupspritevline(this.parent.getPaletteManager().getPalookupBuffer()[dapalnum], palookupshade, xv, yv, ysiz);
            } else {
                this.parent.getA().msetupspritevline(this.parent.getPaletteManager().getPalookupBuffer()[dapalnum], palookupshade, xv, yv, ysiz);
            }
        } else {
            this.parent.getA().tsetupspritevline(this.parent.getPaletteManager().getPalookupBuffer()[dapalnum], palookupshade, xv, yv, ysiz);
            if ((dastat & 0x20) != 0) {
                this.parent.getA().settransreverse();
            } else {
                this.parent.getA().settransnormal();
            }
        }
        if (x1 < 0) {
            return;
        }
        for (x = x1; x < x2; ++x) {
            bx += xv2;
            by += yv2;
            short y1 = this.parent.uplc[x];
            short y2 = this.parent.dplc[x];
            if ((dastat & 8) == 0) {
                if (this.parent.startumost[x] > y1) {
                    y1 = this.parent.startumost[x];
                }
                if (this.parent.startdmost[x] < y2) {
                    y2 = this.parent.startdmost[x];
                }
            }
            if (y2 <= y1) continue;
            if (y1 - oy != 0) {
                bx += xv * (y1 - oy);
                by += yv * (y1 - oy);
                oy = y1;
            }
            int p = this.parent.ylookup[y1] + x;
            if ((dastat & 1) == 0) {
                if ((dastat & 0x40) != 0) {
                    this.parent.getA().spritevline(bx & 0xFFFF, by & 0xFFFF, y2 - y1 + 1, bufplc, (bx >> 16) * ysiz + (by >> 16), p);
                    continue;
                }
                this.parent.getA().mspritevline(bx & 0xFFFF, by & 0xFFFF, y2 - y1 + 1, bufplc, (bx >> 16) * ysiz + (by >> 16), p);
                continue;
            }
            this.parent.getA().tspritevline(bx & 0xFFFF, by & 0xFFFF, y2 - y1 + 1, bufplc, (bx >> 16) * ysiz + (by >> 16), p);
        }
    }

    private int clippoly4(int cx1, int cy1, int cx2, int cy2) {
        int t;
        int zz;
        int nn = 0;
        int z = 0;
        do {
            int x;
            zz = z + 1 & 3;
            int x1 = this.nrx1[z];
            int x2 = this.nrx1[zz] - x1;
            if (cx1 <= x1 && x1 <= cx2) {
                this.nrx2[nn] = x1;
                this.nry2[nn] = this.nry1[z];
                ++nn;
            }
            if (((t = (x = x2 <= 0 ? cx2 : cx1) - x1) - x2 ^ t) < 0) {
                this.nrx2[nn] = x;
                this.nry2[nn] = this.nry1[z] + Pragmas.scale(t, this.nry1[zz] - this.nry1[z], x2);
                ++nn;
            }
            if (((t = (x = x2 <= 0 ? cx1 : cx2) - x1) - x2 ^ t) >= 0) continue;
            this.nrx2[nn] = x;
            this.nry2[nn] = this.nry1[z] + Pragmas.scale(t, this.nry1[zz] - this.nry1[z], x2);
            ++nn;
        } while ((z = zz) != 0);
        if (nn < 3) {
            return 0;
        }
        int n = 0;
        z = 0;
        do {
            int y;
            if ((zz = z + 1) == nn) {
                zz = 0;
            }
            int y1 = this.nry2[z];
            int y2 = this.nry2[zz] - y1;
            if (cy1 <= y1 && y1 <= cy2) {
                this.nry1[n] = y1;
                this.nrx1[n] = this.nrx2[z];
                ++n;
            }
            if (((t = (y = y2 <= 0 ? cy2 : cy1) - y1) - y2 ^ t) < 0) {
                this.nry1[n] = y;
                this.nrx1[n] = this.nrx2[z] + Pragmas.scale(t, this.nrx2[zz] - this.nrx2[z], y2);
                ++n;
            }
            if (((t = (y = y2 <= 0 ? cy1 : cy2) - y1) - y2 ^ t) >= 0) continue;
            this.nry1[n] = y;
            this.nrx1[n] = this.nrx2[z] + Pragmas.scale(t, this.nrx2[zz] - this.nrx2[z], y2);
            ++n;
        } while ((z = zz) != 0);
        return n;
    }

    @Override
    public void nextpage() {
    }

    @Override
    public void init() {
    }

    @Override
    public void uninit() {
    }
}

