/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render;

import com.badlogic.gdx.graphics.Texture;

public enum TexFilter {
    NONE(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest, 1),
    BILINEAR(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear, 1),
    TRILINEAR(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear, 1),
    ANISOTROPY_2X(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear, 2),
    ANISOTROPY_4X(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear, 4),
    ANISOTROPY_8X(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear, 8),
    ANISOTROPY_16X(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear, 16);

    private final Texture.TextureFilter min;
    private final Texture.TextureFilter mag;
    private final boolean mipmaps;
    private final int anisotropy;

    private TexFilter(Texture.TextureFilter min, Texture.TextureFilter mag, int anisotropy) {
        this.min = min;
        this.mag = mag;
        this.mipmaps = min.isMipMap() || mag.isMipMap();
        this.anisotropy = anisotropy;
    }

    public int getAnisotropy() {
        return this.anisotropy;
    }

    public Texture.TextureFilter getMin() {
        return this.min;
    }

    public Texture.TextureFilter getMag() {
        return this.mag;
    }

    public boolean isMipmaps() {
        return this.mipmaps;
    }

    public static TexFilter valueOf(int ordinal) {
        if (ordinal < 0 || ordinal >= TexFilter.values().length) {
            return NONE;
        }
        return TexFilter.values()[ordinal];
    }
}

