/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;

public abstract class IndexedShader
extends ShaderProgram {
    public static final String defaultFragment = "uniform sampler2D u_texture;uniform sampler2D u_palette;uniform sampler2D u_palookup;uniform int u_shade;uniform int u_numshades;uniform float u_visibility;uniform float u_alpha;uniform int u_draw255;varying float v_dist;varying vec2 v_texCoords;float getpalookup(int dashade) {\tfloat davis = v_dist * u_visibility;\tfloat shade = (min(max(float(dashade) + davis, 0.0), float(u_numshades - 1)));\treturn shade / 64.0;}void main(){\tfloat fi = texture2D(u_texture, v_texCoords).r;\tif(fi == 1.0)\t{\t\tif(u_draw255 == 0) discard;\t\tfi -= 0.5 / 256.0;\t}\tfloat index = texture2D(u_palookup, vec2(fi, getpalookup(u_shade))).r;\tif(index == 1.0) index -= 0.5 / 256.0;\tvec4 src = vec4(texture2D(u_palette, vec2(index, 0.0)).rgb, u_alpha);\t\tgl_FragColor = src; }";
    public static final String defaultVertex = "varying float v_dist;varying vec2 v_texCoords;void main(){\tgl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;\tgl_ClipVertex = gl_ModelViewMatrix * gl_Vertex; v_dist = gl_ClipVertex.z / gl_ClipVertex.w;\tgl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0; v_texCoords = gl_TexCoord[0].xy;}";
    protected int paletteloc;
    protected int numshadesloc;
    protected int visibilityloc;
    protected int palookuploc;
    protected int shadeloc;
    protected int alphaloc;
    protected int draw255loc;
    protected int texsizeloc;
    protected int palettefilteredloc;
    protected int softshadingloc;
    protected boolean isBinded;
    protected int lastPal;
    protected int lastShade;
    protected int lastVisibility;
    protected float lastAlpha;
    protected boolean drawLastIndex;
    protected int numshades;

    public IndexedShader(String vertexShader, String fragmentShader, int numshades) throws Exception {
        super(vertexShader, fragmentShader);
        this.numshades = numshades;
        this.init(numshades);
    }

    protected void init(int numshades) throws Exception {
        if (!this.isCompiled()) {
            throw new Exception("Shader compile error: " + this.getLog());
        }
        this.paletteloc = this.getUniformLocation("u_palette");
        this.numshadesloc = this.getUniformLocation("u_numshades");
        this.visibilityloc = this.getUniformLocation("u_visibility");
        this.palookuploc = this.getUniformLocation("u_palookup");
        this.shadeloc = this.getUniformLocation("u_shade");
        this.alphaloc = this.getUniformLocation("u_alpha");
        this.draw255loc = this.getUniformLocation("u_draw255");
        this.texsizeloc = this.getUniformLocation("u_texSize");
        this.palettefilteredloc = this.getUniformLocation("u_paletteFiltering");
        this.softshadingloc = this.getUniformLocation("u_softShading");
    }

    public abstract void bindPalette(int var1);

    public abstract void bindPalookup(int var1, int var2);

    @Override
    public void bind() {
        super.bind();
        this.isBinded = true;
    }

    public void unbind() {
        Gdx.gl20.glUseProgram(0);
        this.isBinded = false;
    }

    public boolean isBinded() {
        return this.isBinded;
    }

    public void setTextureParams(int pal, int shade) {
        this.setUniformi(this.numshadesloc, this.numshades);
        this.bindPalette(33985);
        this.setUniformi(this.paletteloc, 1);
        this.bindPalookup(33986, pal);
        this.lastPal = pal;
        this.setUniformi(this.palookuploc, 2);
        this.setUniformi(this.shadeloc, shade);
        this.lastShade = shade;
        Gdx.gl.glActiveTexture(33984);
    }

    public void setTextureSize(int width, int height) {
        this.setUniformi(this.texsizeloc, width, height);
    }

    public void setPaletteFiltered(boolean enabled) {
        this.setUniformi(this.palettefilteredloc, enabled ? 1 : 0);
    }

    public void setSoftShading(boolean enabled) {
        this.setUniformi(this.softshadingloc, enabled ? 1 : 0);
    }

    public void setTransparent(float alpha) {
        this.setUniformf(this.alphaloc, alpha);
        this.lastAlpha = alpha;
    }

    public void setDrawLastIndex(boolean enable) {
        this.setUniformi(this.draw255loc, enable ? 1 : 0);
        this.drawLastIndex = enable;
    }

    public void setVisibility(int vis) {
        this.setUniformf(this.visibilityloc, (float)vis / 64.0f);
        this.lastVisibility = vis;
    }

    public int getPal() {
        return this.lastPal;
    }

    public int getShade() {
        return this.lastShade;
    }

    public int getVisibility() {
        return this.lastVisibility;
    }

    public float getTransparent() {
        return this.lastAlpha;
    }

    public boolean getDrawLastIndex() {
        return this.drawLastIndex;
    }
}

