/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class IndexedTileData
extends TileData {
    public final ByteBuffer data;
    public final boolean hasalpha;
    public final int width;
    public final int height;
    public final boolean clamped;

    public IndexedTileData(ArtEntry tile, boolean clamped, boolean alpha, int expflag) {
        byte[] data = tile.getBytes();
        int tsizx = tile.getWidth();
        int tsizy = tile.getHeight();
        if (data != null && (data.length == 0 || tile.getSize() > (long)data.length)) {
            data = null;
        }
        int xsiz = tsizx;
        int ysiz = tsizy;
        if ((expflag & 1) != 0) {
            xsiz = this.calcSize(tsizx);
        }
        if ((expflag & 2) != 0) {
            ysiz = this.calcSize(tsizy);
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(data != null ? xsiz * ysiz : 1).order(ByteOrder.LITTLE_ENDIAN);
        boolean hasalpha = false;
        if (data == null) {
            buffer.put(0, (byte)-1);
            hasalpha = true;
            ysiz = 1;
            xsiz = 1;
        } else {
            int sptr = 0;
            if (clamped) {
                int dptr;
                for (int y = ysiz - 1; y >= 0; --y) {
                    sptr = y >= tsizy ? 0 : tsizx;
                    dptr = xsiz * y + sptr;
                    for (int x = sptr; x < xsiz; ++x) {
                        buffer.put(dptr++, (byte)-1);
                    }
                }
                sptr = 0;
                for (int i = 0; i < tsizx; ++i) {
                    dptr = i;
                    for (int j = 0; j < tsizy; ++j) {
                        buffer.put(dptr, data[sptr++]);
                        dptr += xsiz;
                    }
                }
                hasalpha = true;
            } else {
                int len = data.length;
                for (int i = 0; i < xsiz; ++i) {
                    int p = 0;
                    int dptr = i;
                    for (int j = 0; j < ysiz; ++j) {
                        buffer.put(dptr, data[sptr + p++]);
                        dptr += xsiz;
                        if (p < tsizy) continue;
                        p = 0;
                    }
                    if ((sptr += tsizy) < len) continue;
                    sptr = 0;
                }
            }
        }
        this.width = xsiz;
        this.height = ysiz;
        this.hasalpha = hasalpha;
        this.data = buffer;
        this.clamped = clamped;
    }

    @Override
    public int getGLType() {
        return 5121;
    }

    @Override
    public ByteBuffer getPixels() {
        this.data.rewind();
        return this.data;
    }

    @Override
    public int getGLInternalFormat() {
        return this.hasalpha ? 6408 : 6407;
    }

    @Override
    public int getGLFormat() {
        return 6409;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public TileData.PixelFormat getPixelFormat() {
        return TileData.PixelFormat.Pal8;
    }

    @Override
    public boolean hasAlpha() {
        return this.hasalpha;
    }

    @Override
    public boolean isClamped() {
        return this.clamped;
    }

    @Override
    public boolean isHighTile() {
        return false;
    }
}

