/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class PixmapOutputStream
extends OutputStream {
    private final Pixmap pixmap;
    private final ByteBuffer pixelsBuffer;
    private final Path filePath;

    public PixmapOutputStream(Pixmap pixmap, Path filePath) {
        this.pixmap = pixmap;
        this.pixelsBuffer = pixmap.getPixels();
        this.filePath = filePath;
    }

    @Override
    public void write(int b) throws IOException {
        this.pixelsBuffer.put((byte)b);
    }

    @Override
    public void write(byte @NotNull [] b, int off, int len) throws IOException {
        if (b == null) {
            PixmapOutputStream.$$$reportNull$$$0(0);
        }
        this.pixelsBuffer.put(b, off, len);
    }

    @Override
    public void close() throws IOException {
        PixmapIO.writePNG(new FileHandle(this.filePath.toFile()), this.pixmap);
        this.pixmap.dispose();
        super.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "ru/m210projects/Build/Render/TextureHandle/PixmapOutputStream", "write"));
    }
}

