/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.filehandle.FileUtils;

public abstract class TileData {
    public abstract int getWidth();

    public abstract int getHeight();

    public abstract ByteBuffer getPixels();

    public abstract int getGLType();

    public abstract int getGLInternalFormat();

    public abstract int getGLFormat();

    public abstract PixelFormat getPixelFormat();

    public abstract boolean hasAlpha();

    public abstract boolean isClamped();

    public abstract boolean isHighTile();

    public void dispose() {
    }

    public void save(String name) {
        int width = this.getWidth();
        int height = this.getHeight();
        ByteBuffer pixels = this.getPixels();
        int bytes = this.getPixelFormat().getLength();
        if (bytes == 1) {
            Path path = FileUtils.getPath(name + ".raw", new String[0]);
            try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                while (pixels.position() < pixels.capacity()) {
                    os.write(pixels.get());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println(path + " saved!");
            return;
        }
        name = name + ".png";
        Pixmap pixmap = new Pixmap(width, height, this.getPixelFormat() == PixelFormat.Rgba ? Pixmap.Format.RGBA8888 : Pixmap.Format.RGB888);
        float[] color = new float[4];
        if (bytes == 3) {
            color[3] = 1.0f;
        }
        for (int i = 0; i < width * height; ++i) {
            for (int c = 0; c < bytes; ++c) {
                color[c] = (float)(pixels.get(i * bytes + c) & 0xFF) / 255.0f;
            }
            pixmap.setColor(color[0], color[1], color[2], color[3]);
            int row = i / width;
            int col = i % width;
            pixmap.drawPixel(col, row);
        }
        FileHandle f = new FileHandle(name);
        PixmapIO.writePNG(f, pixmap);
        System.out.println(f.file().getAbsolutePath() + " saved!");
        pixmap.dispose();
    }

    protected int calcSize(int size) {
        if (GLInfo.texnpot == 0) {
            int nsize;
            for (nsize = 1; nsize < size; nsize *= 2) {
            }
            return nsize;
        }
        return size == 0 ? 1 : size;
    }

    public static enum PixelFormat {
        Rgb(3),
        Rgba(4),
        Pal8(1),
        Bitmap(1);

        private final int bytes;

        private PixelFormat(int bytes) {
            this.bytes = bytes;
        }

        public int getLength() {
            return this.bytes;
        }
    }
}

