/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Script;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import ru.m210projects.Build.Render.Types.Spriteext;
import ru.m210projects.Build.Script.Maphack;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.MD4;
import ru.m210projects.Build.filehandle.Entry;

public class MapHackInfo {
    protected Maphack maphack;
    protected Map<String, Entry> hacklist;

    public MapHackInfo() {
        this.hacklist = new HashMap<String, Entry>();
    }

    public MapHackInfo(MapHackInfo src) {
        this.hacklist = new HashMap<String, Entry>(src.hacklist);
    }

    public boolean addMapInfo(Entry map, Entry mhkscript, String md4) {
        if (map.exists() && mhkscript.exists() && (md4 == null || MD4.getChecksum(map.getBytes()).equals(md4.toUpperCase()))) {
            this.hacklist.put(map.getName().toLowerCase(Locale.ROOT), mhkscript);
            return true;
        }
        return false;
    }

    public boolean load(Entry map) {
        this.unload();
        Entry mhk = this.hacklist.get(map.getName().toLowerCase(Locale.ROOT));
        if (mhk != null) {
            this.maphack = new Maphack(mhk);
            return true;
        }
        return false;
    }

    public boolean isLoaded() {
        return this.maphack != null;
    }

    public void load(Maphack info) {
        this.maphack = info;
    }

    public void unload() {
        this.maphack = null;
    }

    public boolean hasMaphack(String mapname) {
        return this.hacklist.get(Strhandler.toLowerCase(mapname)) != null;
    }

    public Spriteext getSpriteInfo(int spriteid) {
        if (this.maphack != null) {
            return this.maphack.getSpriteInfo(spriteid);
        }
        return null;
    }
}

