/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.osd.Console;

public class DefaultPaletteLoader
implements PaletteManager.PaletteLoader {
    private final byte[] basePalette;
    private final int shadesCount;
    private final byte[][] palookup;
    private final byte[] transluc;

    public DefaultPaletteLoader(Entry entry) throws IOException {
        if (!entry.exists()) {
            throw new FileNotFoundException("Failed to load \"palette.dat\"!");
        }
        try (InputStream is = entry.getInputStream();){
            Console.out.println("Loading palettes");
            this.basePalette = StreamUtils.readBytes(is, 768);
            Console.out.println("Loading palookup tables");
            this.shadesCount = StreamUtils.readShort(is);
            this.palookup = new byte[256][];
            this.palookup[0] = StreamUtils.readBytes(is, this.shadesCount << 8);
            Console.out.println("Loading translucency table");
            this.transluc = StreamUtils.readBytes(is, 65536);
        }
    }

    @Override
    public byte[] getBasePalette() {
        return this.basePalette;
    }

    @Override
    public int getShadeCount() {
        return this.shadesCount;
    }

    @Override
    public byte[][] getPalookup() {
        return this.palookup;
    }

    @Override
    public byte[] getTransluc() {
        return this.transluc;
    }
}

