/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Types.Color;
import ru.m210projects.Build.Render.listeners.PaletteListener;
import ru.m210projects.Build.Types.FastColorLookup;
import ru.m210projects.Build.Types.Palette;
import ru.m210projects.Build.Types.PaletteManager;

public class DefaultPaletteManager
implements PaletteManager {
    protected static final Color DEFAULT_COLOR = new Color(0, 0, 0, 0);
    protected final Palette currentPalette;
    protected final FastColorLookup fastColorLookup;
    protected final byte[] basePalette;
    protected final byte[][] palookup;
    protected final byte[] transluc;
    protected final int shadesCount;
    protected final byte[][] britable;
    protected final Color[] palookupfog;
    private final Engine engine;
    protected PaletteListener listener = PaletteListener.DUMMY_PALETTE_CHANGE_LISTENER;

    public DefaultPaletteManager(Engine engine, PaletteManager.PaletteLoader loader) {
        this.engine = engine;
        this.basePalette = loader.getBasePalette();
        this.shadesCount = loader.getShadeCount();
        this.palookup = loader.getPalookup();
        this.transluc = loader.getTransluc();
        this.britable = loader.getBritable();
        this.fastColorLookup = loader.getFastColorLookup();
        this.palookupfog = new Color[256];
        this.currentPalette = new Palette();
        byte[] currPalette = this.currentPalette.getBytes();
        for (int i = 0; i < this.basePalette.length; ++i) {
            currPalette[i] = (byte)((this.basePalette[i] & 0xFF) << 2);
        }
    }

    @Override
    public void setListener(PaletteListener listener) {
        this.listener = listener;
    }

    @Override
    public void setbrightness(int dabrightness, byte[] dapal) {
        int i;
        int curbrightness = Gameutils.BClipRange(dabrightness, 0, 15);
        byte[] temppal = new byte[768];
        if (curbrightness != 0) {
            for (i = 0; i < dapal.length; ++i) {
                temppal[i] = this.britable[curbrightness][(dapal[i] & 0xFF) << 2];
            }
        } else {
            System.arraycopy(dapal, 0, temppal, 0, dapal.length);
            i = 0;
            while (i < dapal.length) {
                int n = i++;
                temppal[n] = (byte)(temppal[n] << 2);
            }
        }
        int r = this.britable[curbrightness][1] >> 2;
        int g = this.britable[curbrightness][1] >> 2;
        int b = this.britable[curbrightness][1] >> 2;
        this.setFogColor(0, new Color(r, g, b, 0));
        this.changePalette(temppal);
    }

    @Override
    public int getPaletteGamma() {
        return this.engine.getConfig().getPaletteGamma();
    }

    @Override
    public Color getFogColor(int pal) {
        if (this.palookupfog[pal] == null) {
            return DEFAULT_COLOR;
        }
        return this.palookupfog[pal];
    }

    @Override
    public boolean isValidPalette(int paletteIndex) {
        if (paletteIndex < 0 || paletteIndex >= this.palookup.length) {
            return false;
        }
        return this.palookup[paletteIndex] != null;
    }

    @Override
    public boolean changePalette(byte[] palette) {
        if (!this.currentPalette.update(palette)) {
            return false;
        }
        this.fastColorLookup.invalidate();
        this.listener.onChangePalette(palette);
        return true;
    }

    @Override
    public byte[] makePalookup(int palnum, byte[] remapbuf, int r, int g, int b, int dastat) {
        if (!this.isValidPalette(palnum)) {
            this.palookup[palnum] = new byte[this.shadesCount << 8];
        }
        if (dastat == 0 || (r | g | b | 0x3F) != 63) {
            return this.palookup[palnum];
        }
        if (dastat == 2) {
            int len = Math.min(this.palookup[palnum].length, remapbuf.length);
            System.arraycopy(remapbuf, 0, this.palookup[palnum], 0, len);
        } else if ((r | g | b) == 0) {
            for (int i = 0; i < 256; ++i) {
                for (int j = 0; j < this.shadesCount; ++j) {
                    this.palookup[palnum][i + j * 256] = this.palookup[0][(remapbuf[i] & 0xFF) + j * 256];
                }
            }
        } else {
            byte[] palette = new byte[768];
            System.arraycopy(this.currentPalette.getBytes(), 0, palette, 0, 768);
            for (int j = 0; j < 768; ++j) {
                palette[j] = (byte)((palette[j] & 0xFF) >> 2);
            }
            for (int i = 0; i < this.shadesCount; ++i) {
                int palscale = Pragmas.divscale(i, this.shadesCount, 16);
                for (int j = 0; j < 256; ++j) {
                    int rptr = palette[3 * (remapbuf[j] & 0xFF)] & 0xFF;
                    int gptr = palette[3 * (remapbuf[j] & 0xFF) + 1] & 0xFF;
                    int bptr = palette[3 * (remapbuf[j] & 0xFF) + 2] & 0xFF;
                    this.palookup[palnum][j + i * 256] = this.fastColorLookup.getClosestColorIndex(palette, rptr + Pragmas.mulscale(r - rptr, palscale, 16), gptr + Pragmas.mulscale(g - gptr, palscale, 16), bptr + Pragmas.mulscale(b - bptr, palscale, 16));
                }
            }
        }
        this.setFogColor(palnum, new Color(r, g, b, 0));
        this.listener.onPalookupChanged(palnum);
        return this.palookup[palnum];
    }

    protected void setFogColor(int palnum, Color fogColor) {
        if (!fogColor.equals(this.palookupfog[palnum])) {
            this.palookupfog[palnum] = fogColor;
        }
    }

    @Override
    public byte[] getBasePalette() {
        return this.basePalette;
    }

    @Override
    public Palette getCurrentPalette() {
        return this.currentPalette;
    }

    @Override
    public FastColorLookup getFastColorLookup() {
        return this.fastColorLookup;
    }

    @Override
    public int getColorIndex(int pal, int colorIndex) {
        if (!this.isValidPalette(pal)) {
            pal = 0;
        }
        if (colorIndex >= this.palookup[pal].length) {
            return 0;
        }
        return this.palookup[pal][colorIndex] & 0xFF;
    }

    @Override
    public int getColorIndex(int pal, int color, int shade) {
        if (!this.isValidPalette(pal)) {
            pal = 0;
        }
        if (color >= this.palookup[pal].length) {
            return 0;
        }
        shade = Math.min(Math.max(shade, 0), this.shadesCount - 1);
        return this.palookup[pal][color + (shade << 8)] & 0xFF;
    }

    @Override
    public byte[][] getPalookupBuffer() {
        return this.palookup;
    }

    @Override
    public byte[] getTranslucBuffer() {
        return this.transluc;
    }

    @Override
    public int getShadeCount() {
        return this.shadesCount;
    }

    @Override
    public byte[][] getBritableBuffer() {
        return this.britable;
    }
}

