/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import ru.m210projects.Build.Render.Types.Color;
import ru.m210projects.Build.Render.listeners.PaletteListener;
import ru.m210projects.Build.Types.DefaultFastColorLookup;
import ru.m210projects.Build.Types.FastColorLookup;
import ru.m210projects.Build.Types.Palette;

public interface PaletteManager {
    public Color getFogColor(int var1);

    public boolean isValidPalette(int var1);

    public boolean changePalette(byte[] var1);

    public byte[] makePalookup(int var1, byte[] var2, int var3, int var4, int var5, int var6);

    default public int getPalookup(int davis, int dashade) {
        return Math.min(Math.max(dashade + (davis >> 8), 0), this.getShadeCount() - 1);
    }

    public int getPaletteGamma();

    public byte[] getBasePalette();

    public Palette getCurrentPalette();

    public FastColorLookup getFastColorLookup();

    public int getColorIndex(int var1, int var2);

    public int getColorIndex(int var1, int var2, int var3);

    public byte[][] getPalookupBuffer();

    public byte[] getTranslucBuffer();

    public int getShadeCount();

    public byte[][] getBritableBuffer();

    public void setListener(PaletteListener var1);

    public void setbrightness(int var1, byte[] var2);

    public static interface PaletteLoader {
        public byte[] getBasePalette();

        public int getShadeCount();

        public byte[][] getPalookup();

        public byte[] getTransluc();

        default public FastColorLookup getFastColorLookup() {
            return new DefaultFastColorLookup(this.getBasePalette(), 30, 59, 11);
        }

        default public byte[][] getBritable() {
            byte[][] britable = new byte[16][256];
            for (int i = 0; i < 16; ++i) {
                float a = 8.0f / (float)(i + 8);
                float b = (float)(255.0 / Math.pow(255.0, a));
                for (int j = 0; j < 256; ++j) {
                    britable[i][j] = (byte)(Math.pow(j, a) * (double)b);
                }
            }
            return britable;
        }
    }
}

