/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.LinkedList;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.StreamUtils;

public class Sector {
    public static final int sizeof = 40;
    private transient LinkedList<Wall> wallList = new LinkedList();
    private short wallptr;
    private short wallnum;
    private int ceilingz;
    private int floorz;
    private short ceilingstat;
    private short floorstat;
    private short ceilingpicnum;
    private short ceilingheinum;
    private byte ceilingshade;
    private short ceilingpal;
    private short ceilingxpanning;
    private short ceilingypanning;
    private short floorpicnum;
    private short floorheinum;
    private byte floorshade;
    private short floorpal;
    private short floorxpanning;
    private short floorypanning;
    private short visibility;
    private short filler;
    private short lotag;
    private short hitag;
    private short extra;

    public Sector() {
    }

    public Sector(byte[] data) throws IOException {
        this.readObject(new ByteArrayInputStream(data));
    }

    public Sector(InputStream data) throws IOException {
        this.readObject(data);
    }

    public static int getSizeof() {
        return 40;
    }

    public int getLoopNum(int wallnum) {
        int numloops = 0;
        for (ListNode<Wall> wn = this.wallList.getFirst(); wn != null; wn = wn.getNext()) {
            Wall wall = wn.get();
            int i = wn.getIndex();
            if (i == wallnum) {
                return numloops;
            }
            if (wall.getPoint2() >= i) continue;
            ++numloops;
        }
        return -1;
    }

    public int getEndWall() {
        return this.wallptr + this.wallnum - 1;
    }

    public boolean isParallaxCeiling() {
        return (this.getCeilingstat() & 1) != 0;
    }

    public boolean isCeilingSlope() {
        return (this.getCeilingstat() & 2) != 0;
    }

    public boolean isTexSwapedCeiling() {
        return (this.getCeilingstat() & 4) != 0;
    }

    public boolean isTexSmooshedCeiling() {
        return (this.getCeilingstat() & 8) != 0;
    }

    public boolean isTexXFlippedCeiling() {
        return (this.getCeilingstat() & 0x10) != 0;
    }

    public boolean isTexYFlippedCeiling() {
        return (this.getCeilingstat() & 0x20) != 0;
    }

    public boolean isRelativeTexCeiling() {
        return (this.getCeilingstat() & 0x40) != 0;
    }

    public boolean isMaskedTexCeiling() {
        return (this.getCeilingstat() & 0x80) != 0;
    }

    public boolean isTransparentCeiling() {
        return (this.getCeilingstat() & 0x100) != 0;
    }

    public boolean isTransparent2Ceiling() {
        return (this.getCeilingstat() & 0x180) != 0;
    }

    public boolean isParallaxFloor() {
        return (this.getFloorstat() & 1) != 0;
    }

    public boolean isFloorSlope() {
        return (this.getFloorstat() & 2) != 0;
    }

    public boolean isTexSwapedFloor() {
        return (this.getFloorstat() & 4) != 0;
    }

    public boolean isTexSmooshedFloor() {
        return (this.getFloorstat() & 8) != 0;
    }

    public boolean isTexXFlippedFloor() {
        return (this.getFloorstat() & 0x10) != 0;
    }

    public boolean isTexYFlippedFloor() {
        return (this.getFloorstat() & 0x20) != 0;
    }

    public boolean isRelativeTexFloor() {
        return (this.getFloorstat() & 0x40) != 0;
    }

    public boolean isMaskedTexFloor() {
        return (this.getFloorstat() & 0x80) != 0;
    }

    public boolean isTransparentFloor() {
        return (this.getFloorstat() & 0x100) != 0;
    }

    public boolean isTransparent2Floor() {
        return (this.getFloorstat() & 0x180) != 0;
    }

    public void setAsBroken() {
        this.setWallnum(0);
        this.setWallptr(0);
        this.setWallList(new LinkedList<Wall>());
    }

    public Sector readObject(InputStream is) throws IOException {
        this.setWallptr(StreamUtils.readShort(is));
        this.setWallnum(StreamUtils.readShort(is));
        this.setCeilingz(StreamUtils.readInt(is));
        this.setFloorz(StreamUtils.readInt(is));
        this.setCeilingstat(StreamUtils.readShort(is));
        this.setFloorstat(StreamUtils.readShort(is));
        this.setCeilingpicnum(StreamUtils.readShort(is));
        this.setCeilingheinum(StreamUtils.readShort(is));
        this.setCeilingshade(StreamUtils.readByte(is));
        this.setCeilingpal(StreamUtils.readUnsignedByte(is));
        this.setCeilingxpanning(StreamUtils.readUnsignedByte(is));
        this.setCeilingypanning(StreamUtils.readUnsignedByte(is));
        this.setFloorpicnum(StreamUtils.readShort(is));
        this.setFloorheinum(StreamUtils.readShort(is));
        this.setFloorshade(StreamUtils.readByte(is));
        this.setFloorpal(StreamUtils.readUnsignedByte(is));
        this.setFloorxpanning(StreamUtils.readUnsignedByte(is));
        this.setFloorypanning(StreamUtils.readUnsignedByte(is));
        this.setVisibility(StreamUtils.readUnsignedByte(is));
        this.setFiller(StreamUtils.readByte(is));
        this.setLotag(StreamUtils.readShort(is));
        this.setHitag(StreamUtils.readShort(is));
        this.setExtra(StreamUtils.readShort(is));
        return this;
    }

    public void writeObject(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, this.getWallptr());
        StreamUtils.writeShort(os, this.getWallnum());
        StreamUtils.writeInt(os, this.getCeilingz());
        StreamUtils.writeInt(os, this.getFloorz());
        StreamUtils.writeShort(os, this.getCeilingstat());
        StreamUtils.writeShort(os, this.getFloorstat());
        StreamUtils.writeShort(os, this.getCeilingpicnum());
        StreamUtils.writeShort(os, this.getCeilingheinum());
        os.write(this.getCeilingshade());
        os.write(this.getCeilingpal());
        os.write(this.getCeilingxpanning());
        os.write(this.getCeilingypanning());
        StreamUtils.writeShort(os, this.getFloorpicnum());
        StreamUtils.writeShort(os, this.getFloorheinum());
        os.write(this.getFloorshade());
        os.write(this.getFloorpal());
        os.write(this.getFloorxpanning());
        os.write(this.getFloorypanning());
        os.write(this.getVisibility());
        os.write(this.getFiller());
        StreamUtils.writeShort(os, this.getLotag());
        StreamUtils.writeShort(os, this.getHitag());
        StreamUtils.writeShort(os, this.getExtra());
    }

    public void set(Sector src) {
        this.setWallptr(src.getWallptr());
        this.setWallnum(src.getWallnum());
        this.setCeilingz(src.getCeilingz());
        this.setFloorz(src.getFloorz());
        this.setCeilingstat(src.getCeilingstat());
        this.setFloorstat(src.getFloorstat());
        this.setCeilingpicnum(src.getCeilingpicnum());
        this.setCeilingheinum(src.getCeilingheinum());
        this.setCeilingshade(src.getCeilingshade());
        this.setCeilingpal(src.getCeilingpal());
        this.setCeilingxpanning(src.getCeilingxpanning());
        this.setCeilingypanning(src.getCeilingypanning());
        this.setFloorpicnum(src.getFloorpicnum());
        this.setFloorheinum(src.getFloorheinum());
        this.setFloorshade(src.getFloorshade());
        this.setFloorpal(src.getFloorpal());
        this.setFloorxpanning(src.getFloorxpanning());
        this.setFloorypanning(src.getFloorypanning());
        this.setVisibility(src.getVisibility());
        this.setFiller(src.getFiller());
        this.setLotag(src.getLotag());
        this.setHitag(src.getHitag());
        this.setExtra(src.getExtra());
    }

    public String toString() {
        String out = "wallptr " + this.getWallptr() + " \r\n";
        out = out + "wallnum " + this.getWallnum() + " \r\n";
        out = out + "ceilingz " + this.getCeilingz() + " \r\n";
        out = out + "floorz " + this.getFloorz() + " \r\n";
        out = out + "ceilingstat " + this.getCeilingstat() + " \r\n";
        out = out + "floorstat " + this.getFloorstat() + " \r\n";
        out = out + "ceilingpicnum " + this.getCeilingpicnum() + " \r\n";
        out = out + "ceilingheinum " + this.getCeilingheinum() + " \r\n";
        out = out + "ceilingshade " + this.getCeilingshade() + " \r\n";
        out = out + "ceilingpal " + this.getCeilingpal() + " \r\n";
        out = out + "ceilingxpanning " + this.getCeilingxpanning() + " \r\n";
        out = out + "ceilingypanning " + this.getCeilingypanning() + " \r\n";
        out = out + "floorpicnum " + this.getFloorpicnum() + " \r\n";
        out = out + "floorheinum " + this.getFloorheinum() + " \r\n";
        out = out + "floorshade " + this.getFloorshade() + " \r\n";
        out = out + "floorpal " + this.getFloorpal() + " \r\n";
        out = out + "floorxpanning " + this.getFloorxpanning() + " \r\n";
        out = out + "floorypanning " + this.getFloorypanning() + " \r\n";
        out = out + "visibility " + this.getVisibility() + " \r\n";
        out = out + "filler " + this.getFiller() + " \r\n";
        out = out + "lotag " + this.getLotag() + " \r\n";
        out = out + "hitag " + this.getHitag() + " \r\n";
        out = out + "extra " + this.getExtra() + " \r\n";
        return out;
    }

    public boolean inside(int x, int y) {
        int cnt = 0;
        for (ListNode<Wall> wn = this.wallList.getFirst(); wn != null; wn = wn.getNext()) {
            int x2;
            int y2;
            Wall wal = wn.get();
            Wall wal2 = wal.getWall2();
            int y1 = wal.getY() - y;
            if ((y1 ^ (y2 = wal2.getY() - y)) >= 0) continue;
            int x1 = wal.getX() - x;
            if ((x1 ^ (x2 = wal2.getX() - x)) >= 0) {
                cnt ^= x1;
                continue;
            }
            cnt ^= x1 * y2 - x2 * y1 ^ y2;
        }
        return cnt >>> 31 != 0;
    }

    public boolean inside(int x, int y, int z) {
        int i = 0;
        int j = 0;
        if (this.isFloorSlope() || this.isCeilingSlope()) {
            int dy;
            ListNode<Wall> wn = this.wallList.getFirst();
            if (wn == null) {
                return false;
            }
            Wall wal = wn.get();
            Wall wal2 = wal.getWall2();
            int dx = wal2.getX() - wal.getX();
            i = EngineUtils.sqrt(dx * dx + (dy = wal2.getY() - wal.getY()) * dy) << 5;
            if (i != 0) {
                j = dx * (y - wal.getY()) - dy * (x - wal.getX()) >> 3;
            }
        }
        int cz = this.calcCeilingHeight(i, j);
        int fz = this.calcFloorHeight(i, j);
        if (z < cz || z > fz) {
            return false;
        }
        return this.inside(x, y);
    }

    private int calcFloorHeight(int i, int j) {
        int fz = this.floorz;
        if (this.isFloorSlope() && i != 0) {
            fz += (int)((long)this.floorheinum * (long)j / (long)i);
        }
        return fz;
    }

    private int calcCeilingHeight(int i, int j) {
        int cz = this.ceilingz;
        if (this.isCeilingSlope() && i != 0) {
            cz += (int)((long)this.ceilingheinum * (long)j / (long)i);
        }
        return cz;
    }

    public void getzsofslope(int x, int y, AtomicInteger floorZ, AtomicInteger ceilingZ) {
        boolean floorSlope = this.isFloorSlope() && floorZ != null;
        boolean ceilingSlope = this.isCeilingSlope() && ceilingZ != null;
        int i = 0;
        int j = 0;
        if (floorSlope || ceilingSlope) {
            int dy;
            ListNode<Wall> wn = this.wallList.getFirst();
            if (wn == null) {
                return;
            }
            Wall wal = wn.get();
            Wall wal2 = wal.getWall2();
            int dx = wal2.getX() - wal.getX();
            i = EngineUtils.sqrt(dx * dx + (dy = wal2.getY() - wal.getY()) * dy) << 5;
            if (i != 0) {
                j = dx * (y - wal.getY()) - dy * (x - wal.getX()) >> 3;
            }
        }
        if (floorZ != null) {
            floorZ.set(this.calcFloorHeight(i, j));
        }
        if (ceilingZ != null) {
            ceilingZ.set(this.calcCeilingHeight(i, j));
        }
    }

    public void alignSlope(int x, int y, int z, boolean isCeilingSlope) {
        if (this.wallList.getFirst() == null) {
            return;
        }
        Wall wal = this.wallList.getFirst().get();
        Wall wal2 = wal.getWall2();
        int dax = wal2.getX() - wal.getX();
        int day = wal2.getY() - wal.getY();
        int i = (y - wal.getY()) * dax - (x - wal.getX()) * day;
        if (i == 0) {
            return;
        }
        if (isCeilingSlope) {
            this.setCeilingheinum((int)(((long)(z - this.getCeilingz()) << 8) * (long)EngineUtils.sqrt(dax * dax + day * day) / (long)i));
            short ceilingstat = this.getCeilingstat();
            if (this.getCeilingheinum() == 0) {
                this.setCeilingstat(ceilingstat & 0xFFFFFFFD);
            } else {
                this.setCeilingstat(ceilingstat | 2);
            }
        } else {
            this.setFloorheinum((int)(((long)(z - this.getFloorz()) << 8) * (long)EngineUtils.sqrt(dax * dax + day * day) / (long)i));
            short floorstat = this.getFloorstat();
            if (this.getFloorheinum() == 0) {
                this.setFloorstat(floorstat & 0xFFFFFFFD);
            } else {
                this.setFloorstat(floorstat | 2);
            }
        }
    }

    @Nullable
    public ListNode<Wall> getWallNode() {
        return this.wallList.getFirst();
    }

    public void setWallList(LinkedList<Wall> wallList) {
        this.wallList = LinkedList.toImmutableList(wallList);
    }

    public short getWallptr() {
        return this.wallptr;
    }

    public void setWallptr(int wallptr) {
        this.wallptr = (short)wallptr;
    }

    public short getWallnum() {
        return this.wallnum;
    }

    public void setWallnum(int wallnum) {
        this.wallnum = (short)wallnum;
    }

    public int getCeilingz() {
        return this.ceilingz;
    }

    public void setCeilingz(int ceilingz) {
        this.ceilingz = ceilingz;
    }

    public int getFloorz() {
        return this.floorz;
    }

    public void setFloorz(int floorz) {
        this.floorz = floorz;
    }

    public short getCeilingstat() {
        return this.ceilingstat;
    }

    public void setCeilingstat(int ceilingstat) {
        this.ceilingstat = (short)ceilingstat;
    }

    public short getFloorstat() {
        return this.floorstat;
    }

    public void setFloorstat(int floorstat) {
        this.floorstat = (short)floorstat;
    }

    public short getCeilingpicnum() {
        return this.ceilingpicnum;
    }

    public void setCeilingpicnum(int ceilingpicnum) {
        this.ceilingpicnum = (short)ceilingpicnum;
    }

    public short getCeilingheinum() {
        return this.ceilingheinum;
    }

    public void setCeilingheinum(int ceilingheinum) {
        this.ceilingheinum = (short)ceilingheinum;
    }

    public byte getCeilingshade() {
        return this.ceilingshade;
    }

    public void setCeilingshade(int ceilingshade) {
        this.ceilingshade = (byte)ceilingshade;
    }

    public short getCeilingpal() {
        return this.ceilingpal;
    }

    public void setCeilingpal(int ceilingpal) {
        this.ceilingpal = (short)(ceilingpal & 0xFF);
    }

    public short getCeilingxpanning() {
        return this.ceilingxpanning;
    }

    public void setCeilingxpanning(int ceilingxpanning) {
        this.ceilingxpanning = (short)(ceilingxpanning & 0xFF);
    }

    public short getCeilingypanning() {
        return this.ceilingypanning;
    }

    public void setCeilingypanning(int ceilingypanning) {
        this.ceilingypanning = (short)(ceilingypanning & 0xFF);
    }

    public short getFloorpicnum() {
        return this.floorpicnum;
    }

    public void setFloorpicnum(int floorpicnum) {
        this.floorpicnum = (short)floorpicnum;
    }

    public short getFloorheinum() {
        return this.floorheinum;
    }

    public void setFloorheinum(int floorheinum) {
        this.floorheinum = (short)floorheinum;
    }

    public byte getFloorshade() {
        return this.floorshade;
    }

    public void setFloorshade(int floorshade) {
        this.floorshade = (byte)floorshade;
    }

    public short getFloorpal() {
        return this.floorpal;
    }

    public void setFloorpal(int floorpal) {
        this.floorpal = (short)(floorpal & 0xFF);
    }

    public short getFloorxpanning() {
        return this.floorxpanning;
    }

    public void setFloorxpanning(int floorxpanning) {
        this.floorxpanning = (short)(floorxpanning & 0xFF);
    }

    public short getFloorypanning() {
        return this.floorypanning;
    }

    public void setFloorypanning(int floorypanning) {
        this.floorypanning = (short)(floorypanning & 0xFF);
    }

    public short getVisibility() {
        return this.visibility;
    }

    public void setVisibility(int visibility) {
        this.visibility = (short)(visibility & 0xFF);
    }

    public short getFiller() {
        return this.filler;
    }

    public void setFiller(int filler) {
        this.filler = (short)filler;
    }

    public short getLotag() {
        return this.lotag;
    }

    public void setLotag(int lotag) {
        this.lotag = (short)lotag;
    }

    public short getHitag() {
        return this.hitag;
    }

    public void setHitag(int hitag) {
        this.hitag = (short)hitag;
    }

    public short getExtra() {
        return this.extra;
    }

    public void setExtra(int extra) {
        this.extra = (short)extra;
    }
}

