/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.listeners.TileListener;
import ru.m210projects.Build.filehandle.Cache;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.ArtFile;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;

public class TileManager {
    protected String tilesPath = "tilesXXX.art";
    protected ArtEntry[] tiles = new ArtEntry[Engine.MAXTILES];
    protected TileListener tileListener = TileListener.DUMMY_LISTENER;

    public void setTileListener(TileListener tileListener) {
        this.tileListener = tileListener;
        for (ArtEntry entry : this.tiles) {
            if (!(entry instanceof DynamicArtEntry)) continue;
            this.allocatepermanenttile(entry);
        }
    }

    public String getTilesPath() {
        return this.tilesPath;
    }

    public boolean loadpic(Entry artFile) {
        if (artFile.exists()) {
            ArtFile art = new ArtFile(artFile.getName(), artFile::getInputStream);
            for (Entry artEntry : art.getEntries()) {
                ArtEntry tile;
                this.tiles[tile.getNum()] = tile = (ArtEntry)artEntry;
            }
            return true;
        }
        return false;
    }

    public int loadpics(Cache cache) {
        int k;
        String name;
        char[] artFileName = this.tilesPath.toCharArray();
        Arrays.fill(this.tiles, null);
        int numtilefiles = 0;
        do {
            k = numtilefiles++;
            artFileName[7] = (char)(k % 10 + 48);
            artFileName[6] = (char)(k / 10 % 10 + 48);
            artFileName[5] = (char)(k / 100 % 10 + 48);
        } while (this.loadpic(cache.getEntry(name = String.copyValueOf(artFileName), true)) && k != numtilefiles);
        return numtilefiles;
    }

    @Deprecated
    public byte[] loadtile(int tilenume) {
        ArtEntry pic = this.getTile(tilenume);
        return pic.getBytes();
    }

    @NotNull
    public DynamicArtEntry allocatepermanenttile(int tilenume, int xsiz, int ysiz) {
        if (xsiz < 0 || ysiz < 0 || tilenume >= Engine.MAXTILES) {
            DynamicArtEntry dynamicArtEntry = ArtFile.DUMMY_ART_FILE;
            if (dynamicArtEntry == null) {
                TileManager.$$$reportNull$$$0(0);
            }
            return dynamicArtEntry;
        }
        int dasiz = xsiz * ysiz;
        byte[] data = new byte[dasiz];
        DynamicArtEntry entry = new DynamicArtEntry(this.tileListener, tilenume, data, xsiz, ysiz, 0);
        this.tiles[tilenume] = entry;
        DynamicArtEntry dynamicArtEntry = entry;
        if (dynamicArtEntry == null) {
            TileManager.$$$reportNull$$$0(1);
        }
        return dynamicArtEntry;
    }

    @NotNull
    public DynamicArtEntry allocatepermanenttile(ArtEntry artEntry) {
        if (!artEntry.exists() || !artEntry.hasSize()) {
            DynamicArtEntry dynamicArtEntry = ArtFile.DUMMY_ART_FILE;
            if (dynamicArtEntry == null) {
                TileManager.$$$reportNull$$$0(2);
            }
            return dynamicArtEntry;
        }
        int tilenume = artEntry.getNum();
        DynamicArtEntry entry = new DynamicArtEntry(this.tileListener, artEntry.getNum(), artEntry.getBytes(), artEntry.getWidth(), artEntry.getHeight(), artEntry.getFlags());
        this.tiles[tilenume] = entry;
        DynamicArtEntry dynamicArtEntry = entry;
        if (dynamicArtEntry == null) {
            TileManager.$$$reportNull$$$0(3);
        }
        return dynamicArtEntry;
    }

    @NotNull
    public ArtEntry getTile(int tilenum) {
        if (tilenum < 0 || tilenum >= this.tiles.length) {
            DynamicArtEntry dynamicArtEntry = ArtFile.DUMMY_ART_FILE;
            if (dynamicArtEntry == null) {
                TileManager.$$$reportNull$$$0(4);
            }
            return dynamicArtEntry;
        }
        if (this.tiles[tilenum] == null) {
            this.tiles[tilenum] = new DynamicArtEntry(null, tilenum, new byte[0], 0, 0, 0);
        }
        ArtEntry artEntry = this.tiles[tilenum];
        if (artEntry == null) {
            TileManager.$$$reportNull$$$0(5);
        }
        return artEntry;
    }

    @NotNull
    public DynamicArtEntry getDynamicTile(int tilenum) {
        ArtEntry pic = this.getTile(tilenum);
        if (!(pic instanceof DynamicArtEntry) || !pic.exists()) {
            pic = this.allocatepermanenttile(pic);
        }
        DynamicArtEntry dynamicArtEntry = (DynamicArtEntry)pic;
        if (dynamicArtEntry == null) {
            TileManager.$$$reportNull$$$0(6);
        }
        return dynamicArtEntry;
    }

    public void copytilepiece(ArtEntry pic1, int sx1, int sy1, int xsiz, int ysiz, DynamicArtEntry pic2, int sx2, int sy2) {
        int xsiz1 = pic1.getWidth();
        int ysiz1 = pic1.getHeight();
        int xsiz2 = pic2.getWidth();
        int ysiz2 = pic2.getHeight();
        if (xsiz1 > 0 && ysiz1 > 0 && xsiz2 > 0 && ysiz2 > 0) {
            byte[] data1 = pic1.getBytes();
            byte[] data2 = pic2.getBytes();
            int x1 = sx1;
            for (int i = 0; i < xsiz; ++i) {
                int y1 = sy1;
                for (int j = 0; j < ysiz; ++j) {
                    byte ptr;
                    int x2 = sx2 + i;
                    int y2 = sy2 + j;
                    if (x2 >= 0 && y2 >= 0 && x2 < xsiz2 && y2 < ysiz2 && (ptr = data1[x1 * ysiz1 + y1]) != -1) {
                        data2[x2 * ysiz2 + y2] = ptr;
                    }
                    if (++y1 < ysiz1) continue;
                    y1 = 0;
                }
                if (++x1 < xsiz1) continue;
                x1 = 0;
            }
        }
    }

    public void squarerotatetile(DynamicArtEntry pic) {
        int xsiz = pic.getWidth();
        int ysiz = pic.getHeight();
        if (pic.exists() && xsiz == ysiz) {
            int k = xsiz << 1;
            for (int i = xsiz - 1; i >= 0; --i) {
                int ptr1 = i * (xsiz + 1);
                int ptr2 = ptr1--;
                if ((i & 1) != 0) {
                    this.squarerotatetileswap(pic, ptr1, ptr2 -= xsiz);
                }
                for (int j = (i >> 1) - 1; j >= 0; --j) {
                    this.squarerotatetileswap(pic, ptr1 -= 2, ptr2 -= k);
                    this.squarerotatetileswap(pic, ptr1 + 1, ptr2 + xsiz);
                }
            }
        }
    }

    private void squarerotatetileswap(DynamicArtEntry pic, int p1, int p2) {
        byte[] data;
        if (pic != null && pic.exists() && p1 < (data = pic.getBytes()).length && p2 < data.length) {
            byte tmp = data[p1];
            data[p1] = data[p2];
            data[p2] = tmp;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "ru/m210projects/Build/Types/TileManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "allocatepermanenttile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDynamicTile";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

