/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import com.badlogic.gdx.utils.FloatArray;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;

public class ValueChart {
    private final FloatArray valueList = new FloatArray();
    private final Font font = EngineUtils.getLargeFont();
    private final StringBuilder stringBuilder = new StringBuilder();
    private final char[] charBuffer = new char[32];
    private final int width;
    private final int height;
    private final String name;
    private final String measUnit;
    private float minValue = Float.MAX_VALUE;
    private float maxValue = Float.MIN_VALUE;
    private float averageValue = 0.0f;
    private float maxAllowedValue;
    private int pointsCount;
    private int chartColor = 31;
    private boolean showAverage = true;

    public ValueChart(String name, int width, int height, float maxAllowedValue, String measUnit) {
        this.width = width;
        this.height = height;
        this.name = name;
        this.maxAllowedValue = maxAllowedValue;
        this.measUnit = measUnit;
        this.pointsCount = height;
    }

    public ValueChart setPointsCount(int pointsCount) {
        this.pointsCount = pointsCount;
        return this;
    }

    public void addValue(float value) {
        float removedValue;
        if (this.valueList.size >= this.pointsCount && ((removedValue = this.valueList.removeIndex(0)) == this.minValue || removedValue == this.maxValue)) {
            this.recalculateMinMax();
        }
        this.updateMinMax(value);
        this.valueList.add(value);
        if (this.showAverage) {
            this.averageValue = 0.0f;
            for (int i = 0; i < this.valueList.size; ++i) {
                this.averageValue += this.valueList.items[i];
            }
            this.averageValue /= (float)this.valueList.size;
        }
    }

    public void render(Renderer renderer, int chartX, int chartY) {
        this.font.drawText(renderer, chartX, chartY, this.name, 1.0f, 0, this.chartColor, TextAlign.Left, Transparent.None, false);
        float pointWidth = (float)this.width / (float)this.pointsCount;
        int y = chartY + this.height;
        for (int i = 1; i < this.valueList.size; ++i) {
            if (!(this.valueList.items[i] <= this.maxAllowedValue) || !(this.valueList.items[i - 1] <= this.maxAllowedValue)) continue;
            int y1 = y - this.scaleValue(this.valueList.items[i]);
            int y2 = y - this.scaleValue(this.valueList.items[i - 1]);
            renderer.drawline256((int)(((float)chartX + (float)(i - 1) * pointWidth) * 4096.0f), y2 * 4096, (int)(((float)chartX + (float)i * pointWidth) * 4096.0f), y1 * 4096, this.chartColor);
        }
        this.drawMinMax(renderer, chartX + this.width + 5, chartY);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private int scaleValue(float value) {
        return (int)(value / this.maxAllowedValue * (float)this.height);
    }

    private void drawMinMax(Renderer renderer, int chartX, int chartY) {
        this.font.drawText(renderer, chartX, chartY, this.buildString("Min: ", this.minValue), 1.0f, 0, this.chartColor, TextAlign.Left, Transparent.None, false);
        this.font.drawText(renderer, chartX, chartY + this.font.getSize() + 2, this.buildString("Max: ", this.maxValue), 1.0f, 0, this.chartColor, TextAlign.Left, Transparent.None, false);
        if (this.showAverage) {
            this.font.drawText(renderer, chartX, chartY + 2 * this.font.getSize() + 4, this.buildString("Avg: ", this.averageValue), 1.0f, 0, this.chartColor, TextAlign.Left, Transparent.None, false);
        }
    }

    private char[] buildString(String name, float value) {
        this.stringBuilder.delete(0, this.stringBuilder.length());
        this.stringBuilder.append(name).append((double)Math.round(value * 10.0f) / 10.0).append(this.measUnit);
        this.stringBuilder.getChars(0, this.stringBuilder.length(), this.charBuffer, 0);
        this.charBuffer[this.stringBuilder.length()] = '\u0000';
        return this.charBuffer;
    }

    private void updateMinMax(float value) {
        if (value < this.minValue) {
            this.minValue = value;
        }
        if (value > this.maxValue) {
            this.maxValue = value;
        }
    }

    public ValueChart setChartColor(int chartColor) {
        this.chartColor = chartColor;
        return this;
    }

    public ValueChart setShowAverage(boolean showAverage) {
        this.showAverage = showAverage;
        return this;
    }

    private void recalculateMinMax() {
        this.minValue = this.maxValue = this.valueList.first();
        for (int i = 0; i < this.valueList.size; ++i) {
            float value = this.valueList.items[i];
            if (value < this.minValue) {
                this.minValue = value;
            }
            if (!(value > this.maxValue)) continue;
            this.maxValue = value;
        }
    }
}

