/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types.collections;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.ReflectionException;

public class DynamicArray<T>
extends Array<T> {
    private final Class<T> arrayType;
    private final boolean createInstances;

    public DynamicArray(int capacity, Class<T> arrayType) {
        this(capacity, arrayType, true);
    }

    public DynamicArray(int capacity, Class<T> arrayType, boolean createInstances) {
        super(true, capacity, arrayType);
        this.arrayType = arrayType;
        this.createInstances = createInstances;
        this.fill(0);
    }

    public T newInstance() {
        try {
            return ClassReflection.newInstance(this.arrayType);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    protected void fill(int from) {
        for (int j = from; j < this.items.length; ++j) {
            if (!this.createInstances) continue;
            this.items[j] = this.newInstance();
        }
        this.size = this.items.length;
    }

    public T getInstance(int i) {
        if (i < 0) {
            return null;
        }
        this.checkCapacity(i);
        if (this.items[i] == null) {
            this.items[i] = this.newInstance();
        }
        return (T)this.items[i];
    }

    @Override
    public void clear() {
        super.clear();
        if (this.createInstances) {
            this.fill(0);
        }
        this.size = this.items.length;
    }

    @Override
    public T get(int i) {
        if (i < 0) {
            return null;
        }
        this.checkCapacity(i);
        return (T)this.items[i];
    }

    @Override
    public void set(int i, T value) {
        this.checkCapacity(i);
        this.items[i] = value;
    }

    @Override
    public void insert(int i, T value) {
        this.checkCapacity(i);
        super.insert(i, value);
    }

    protected void checkCapacity(int i) {
        if (this.size != this.items.length) {
            throw new RuntimeException("DynamicArray always should be filled to full size (by null or new objects)");
        }
        if (i >= this.items.length) {
            int from = i - this.items.length;
            this.ensureCapacity((int)((float)i * 1.75f));
            this.fill(from);
        }
    }
}

