/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types.collections;

import com.badlogic.gdx.utils.IntArray;
import ru.m210projects.Build.Types.collections.BitMap;

public class IntSet {
    private final BitMap bitmap;
    private final IntArray array;

    public IntSet(int capacity) {
        this.bitmap = new BitMap(capacity);
        this.array = new IntArray(capacity);
    }

    public int size() {
        return this.array.size;
    }

    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    public boolean contains(int value) {
        return this.bitmap.getBit(value);
    }

    public boolean addValue(int value) {
        if (!this.bitmap.getBit(value)) {
            this.bitmap.setBit(value);
            this.array.add(value);
            return true;
        }
        return false;
    }

    public int getValue(int index) {
        return this.array.get(index);
    }

    public boolean removeValue(int value) {
        if (this.bitmap.getBit(value)) {
            this.array.removeValue(value);
            this.bitmap.clearBit(value);
            return true;
        }
        return false;
    }

    public void clear() {
        this.array.clear();
        this.bitmap.clear();
    }

    public String toString() {
        return this.array.toString();
    }
}

