/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.m210projects.Build.Types.collections.LinkedList;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.collections.ValueSetter;

public abstract class LinkedMap<T> {
    protected final LinkedList<T>[] basket;
    protected final int poolIndex;
    protected ListNode<T>[] nodeMap;
    protected final List<T> list;
    protected final ValueSetter<T> valueSetter;

    public LinkedMap(int stateCount, int initialCount) {
        this(stateCount, new ArrayList(), initialCount, null);
    }

    public LinkedMap(int stateCount, List<T> list, int initialCount, ValueSetter<T> valueSetter) {
        this.list = list;
        this.poolIndex = stateCount;
        this.basket = new LinkedList[this.poolIndex + 1];
        this.valueSetter = valueSetter;
        this.nodeMap = new ListNode[Math.max(1, initialCount)];
        for (int i = 0; i < this.basket.length; ++i) {
            this.basket[i] = new LinkedList();
        }
        this.fill(0);
    }

    protected abstract T getInstance();

    public int insert(int value) {
        if (value < 0 || value >= this.basket.length) {
            value = this.poolIndex;
        }
        return this.insert(this.obtain(), value);
    }

    public boolean set(int element, int value) {
        ListNode<T> node;
        LinkedList<T> list;
        if (value < 0 || value >= this.basket.length) {
            value = this.poolIndex;
        }
        if (element < 0 || element >= this.nodeMap.length) {
            this.increase(element);
        }
        if (this.basket[value] == (list = (node = this.nodeMap[element]).getParent())) {
            this.setValue(node, value);
            return false;
        }
        list.unlink(node);
        this.insert(node, value);
        return true;
    }

    public boolean remove(int element) {
        ListNode<T> node;
        LinkedList<T> list;
        if (element < 0) {
            return false;
        }
        if (element >= this.nodeMap.length) {
            this.increase(element);
        }
        if ((list = (node = this.nodeMap[element]).getParent()) == this.basket[this.poolIndex]) {
            this.setValue(node, -1);
            return false;
        }
        list.unlink(node);
        list = this.basket[this.poolIndex];
        list.addFirst(node);
        this.setValue(node, -1);
        return true;
    }

    public LinkedList<T> get(int value) {
        return this.basket[value];
    }

    public ListNode<T> getFirst(int value) {
        if (value < 0 || value >= this.basket.length) {
            return null;
        }
        return this.basket[value].getFirst();
    }

    protected int insert(ListNode<T> node, int value) {
        LinkedList<T> list = this.basket[value];
        list.addFirst(node);
        this.setValue(node, value);
        return node.index;
    }

    protected void setValue(ListNode<T> node, int value) {
        this.valueSetter.setValue(node.get(), value);
    }

    protected ListNode<T> obtain() {
        LinkedList<T> list = this.basket[this.poolIndex];
        if (list.getSize() == 0) {
            this.increase(0);
        }
        return list.removeFirst();
    }

    protected void fill(int from) {
        LinkedList<T> list = this.basket[this.poolIndex];
        for (int i = from; i < this.nodeMap.length; ++i) {
            ListNode newNode = new ListNode<T>(i){

                @Override
                public T get() {
                    return LinkedMap.this.list.get(this.index);
                }
            };
            list.addLast(newNode);
            if (i >= this.list.size()) {
                this.list.add(this.getInstance());
                this.setValue(newNode, -1);
            }
            this.nodeMap[i] = newNode;
        }
    }

    protected void increase(int toIndex) {
        int size = this.nodeMap.length;
        int requiredSize = Math.max(toIndex + (toIndex >> 1), size + (size >> 1));
        this.nodeMap = Arrays.copyOf(this.nodeMap, requiredSize);
        this.fill(size);
    }
}

