/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types.collections;

import java.lang.reflect.Array;
import java.util.Arrays;

public class Pool<T> {
    protected int objectsCount;
    protected int size;
    protected T[] instances;
    private final ObjectCreator<T> objectCreator;

    public Pool(ObjectCreator<T> objectCreator) {
        this(objectCreator, 512);
    }

    public Pool(ObjectCreator<T> objectCreator, int length) {
        this.objectCreator = objectCreator;
        this.instances = (Object[])Array.newInstance(objectCreator.newInstance().getClass(), length);
        this.reset();
    }

    public T[] getArray() {
        return this.instances;
    }

    public void reset() {
        this.size = 0;
    }

    public T obtain() {
        T object;
        if (this.size == this.objectsCount) {
            object = this.objectCreator.newInstance();
            this.addObject(object);
        } else {
            object = this.get(this.size);
            if (object instanceof Poolable) {
                ((Poolable)object).reset();
            }
        }
        ++this.size;
        return object;
    }

    public T get(int index) {
        return this.instances[index];
    }

    public int getSize() {
        return this.size;
    }

    protected void addObject(T value) {
        if (this.objectsCount == this.instances.length) {
            this.grow(this.objectsCount + 1);
        }
        this.instances[this.objectsCount++] = value;
    }

    protected void grow(int minCapacity) {
        int oldCapacity = this.instances.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        this.instances = Arrays.copyOf(this.instances, newCapacity);
    }

    public String toString() {
        String text = "Pool {";
        text = text + "[free / size]: " + (this.objectsCount - this.size) + " / " + this.objectsCount;
        text = text + "used : " + this.size * 100 / this.objectsCount + "% }";
        return text;
    }

    public static interface ObjectCreator<T> {
        public T newInstance();
    }

    public static interface Poolable {
        public void reset();
    }
}

