/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types.font;

import ru.m210projects.Build.Types.font.CharInfo;
import ru.m210projects.Build.Types.font.Font;

public class AtlasCharInfo
extends CharInfo {
    protected float tx1;
    protected float ty1;
    protected float tx2;
    protected float ty2;

    public AtlasCharInfo(Font parent, char ch, int atlasTile, float tileScale, int atlasWidth, int atlasHeight, int cols, int rows) {
        super(parent, atlasTile, tileScale, atlasWidth / cols);
        int height = atlasHeight / rows;
        this.tx1 = (float)(ch % cols) / (float)cols;
        this.ty1 = (float)(ch / cols) / (float)rows;
        this.tx2 = this.tx1 + (float)this.width / ((float)atlasWidth * tileScale);
        this.ty2 = this.ty1 + (float)height / (float)atlasHeight;
    }

    public AtlasCharInfo(Font parent, char ch, int atlasTile, int atlasWidth, int atlasHeight, int cols, int rows) {
        this(parent, ch, atlasTile, 1.0f, atlasWidth, atlasHeight, cols, rows);
    }

    @Override
    public int getHeight() {
        return this.cellSize;
    }

    public float getTx1() {
        return this.tx1;
    }

    public float getTy1() {
        return this.ty1;
    }

    public float getTx2() {
        return this.tx2;
    }

    public float getTy2() {
        return this.ty2;
    }
}

