/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types.font;

import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.FontType;

public class CharInfo {
    public static final CharInfo DUMMY_CHAR_INFO = new CharInfo(null, -1, 1.0f, 1){

        @Override
        public int getHeight() {
            return 1;
        }

        @Override
        public FontType getFontType() {
            return FontType.NULL_FONT;
        }
    };
    public final int tile;
    public final int width;
    public final short cellSize;
    public final short xOffset;
    public final short yOffset;
    protected final float tileScale;
    protected final Font parent;

    public CharInfo(Font parent, int tile, float tileScale, int cellSize, int width, int xOffset, int yOffset) {
        this.parent = parent;
        this.tile = tile;
        this.xOffset = (short)xOffset;
        this.yOffset = (short)yOffset;
        this.cellSize = (short)((float)cellSize * tileScale);
        this.width = (int)((float)width * tileScale);
        this.tileScale = tileScale;
    }

    public CharInfo(Font parent, int tile, int cellSize, int width) {
        this(parent, tile, 1.0f, cellSize, width, 0, 0);
    }

    public CharInfo(Font parent, int tile, float tileScale, int cellSize) {
        this(parent, tile, tileScale, cellSize, cellSize, 0, 0);
    }

    public CharInfo(Font parent, int tile, int cellSize, int xOffset, int yOffset) {
        this(parent, tile, 1.0f, cellSize, cellSize, xOffset, yOffset);
    }

    public FontType getFontType() {
        return this.parent.getFontType();
    }

    public Font getParent() {
        return this.parent;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.parent.getSize();
    }

    public short getCellSize() {
        return this.cellSize;
    }

    public int getTile() {
        return this.tile;
    }

    public float getTileScale() {
        return this.tileScale;
    }
}

