/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types.font;

import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.CharInfo;
import ru.m210projects.Build.Types.font.FontType;
import ru.m210projects.Build.Types.font.TextAlign;

public class Font {
    protected CharInfo[] charInfo = new CharInfo[256];
    protected int size = 1;
    protected boolean verticalScaled = true;

    public Font() {
        this.charInfo[0] = CharInfo.DUMMY_CHAR_INFO;
    }

    protected void addCharInfo(char ch, CharInfo charInfo) {
        this.charInfo[ch] = charInfo;
    }

    public FontType getFontType() {
        return FontType.TILE_FONT;
    }

    public CharInfo getCharInfo(char ch) {
        if (ch >= this.charInfo.length || this.charInfo[ch] == null) {
            return this.charInfo[0];
        }
        return this.charInfo[ch];
    }

    public boolean isVerticalScaled() {
        return this.verticalScaled;
    }

    public void setVerticalScaled(boolean verticalScaled) {
        this.verticalScaled = verticalScaled;
    }

    public int getWidth(char[] text, float scale) {
        int width = 0;
        for (int pos = 0; text != null && pos < text.length && text[pos] != '\u0000'; ++pos) {
            width += (int)((float)this.getCharInfo(text[pos]).getCellSize() * scale);
        }
        return width;
    }

    public int getWidth(String text, float scale) {
        return this.getWidth(Strhandler.toCharArray(text), scale);
    }

    public int getSize() {
        return this.size;
    }

    public int drawText(Renderer renderer, int x, int y, char[] text, float scale, int shade, int palnum, TextAlign align, Transparent transparent, boolean shadow) {
        return renderer.printext(this, x, y, text, scale, shade, palnum, align, transparent, shadow);
    }

    public int drawText(Renderer renderer, int x, int y, String text, float scale, int shade, int palnum, TextAlign align, Transparent transparent, boolean shadow) {
        return this.drawText(renderer, x, y, Strhandler.toCharArray(text), scale, shade, palnum, align, transparent, shadow);
    }

    public int drawTextScaled(Renderer renderer, int x, int y, char[] text, float scale, int shade, int palnum, TextAlign align, Transparent transparent, ConvertType type, boolean shadow) {
        x = Gameutils.coordsConvertXScaled(x, type);
        y = Gameutils.coordsConvertYScaled(y);
        int xdim = 4 * renderer.getHeight() / 3;
        return this.drawText(renderer, x, y, text, scale * (float)xdim / 320.0f, shade, palnum, align, transparent, shadow);
    }

    public int drawTextScaled(Renderer renderer, int x, int y, String text, float scale, int shade, int palnum, TextAlign align, Transparent transparent, ConvertType type, boolean shadow) {
        return this.drawTextScaled(renderer, x, y, Strhandler.toCharArray(text), scale, shade, palnum, align, transparent, type, shadow);
    }

    public int drawCharScaled(Renderer renderer, int x, int y, char symb, float scale, int shade, int palnum, Transparent transparent, ConvertType type, boolean shadow) {
        CharInfo charInfo = this.getCharInfo(symb);
        this.drawTextScaled(renderer, x, y, new char[]{symb}, scale, shade, palnum, TextAlign.Left, transparent, type, shadow);
        return (int)((float)charInfo.getCellSize() * scale);
    }
}

