/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle;

import java.util.LinkedHashMap;
import java.util.Map;
import ru.m210projects.Build.Types.collections.LinkedList;
import ru.m210projects.Build.Types.collections.LinkedMap;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;

public class CacheResourceMap
extends LinkedMap<Group> {
    protected final Map<String, Integer> groupMap = new LinkedHashMap<String, Integer>();

    public CacheResourceMap() {
        super(3, null, 16, null);
    }

    public void addGroup(Group group, CachePriority priority) {
        if (group.getSize() > 0) {
            GroupNode node = (GroupNode)this.obtain();
            node.group = group;
            node.priority = priority;
            this.groupMap.put(group.getName().toUpperCase(), node.getIndex());
            this.insert(node, priority.getLevel());
        }
    }

    public void removeGroup(Group group) {
        String key = group.getName().toUpperCase();
        int index = this.groupMap.getOrDefault(key, -1);
        if (index != -1) {
            this.groupMap.remove(key);
            this.remove(index);
        }
    }

    public CachePriority getPriority(Group group) {
        String key = group.getName().toUpperCase();
        int index = this.groupMap.getOrDefault(key, -1);
        if (index != -1) {
            GroupNode node = (GroupNode)this.nodeMap[index];
            return node.priority;
        }
        return CachePriority.NULL;
    }

    public Group getGroup(String groupName) {
        int index = this.groupMap.getOrDefault(groupName.toUpperCase(), -1);
        if (index != -1) {
            return (Group)this.nodeMap[index].get();
        }
        return Directory.DUMMY_DIRECTORY;
    }

    Group getGroup(int index) {
        return (Group)this.nodeMap[index].get();
    }

    @Override
    protected Group getInstance() {
        return Directory.DUMMY_DIRECTORY;
    }

    @Override
    protected void fill(int from) {
        LinkedList list = this.basket[this.poolIndex];
        for (int i = from; i < this.nodeMap.length; ++i) {
            GroupNode newNode = new GroupNode(i);
            list.addLast(newNode);
            this.nodeMap[i] = newNode;
        }
    }

    @Override
    protected void setValue(ListNode<Group> node, int value) {
        if (value == -1) {
            ((GroupNode)node).group = Directory.DUMMY_DIRECTORY;
            ((GroupNode)node).priority = CachePriority.NULL;
        }
    }

    private static final class GroupNode
    extends ListNode<Group> {
        private Group group = Directory.DUMMY_DIRECTORY;
        private CachePriority priority = CachePriority.NULL;

        private GroupNode(int index) {
            super(index);
        }

        @Override
        public Group get() {
            return this.group;
        }
    }

    public static enum CachePriority {
        NULL(-1),
        NORMAL(0),
        HIGH(1),
        HIGHEST(2);

        private final int level;

        private CachePriority(int level) {
            this.level = level;
        }

        public final int getLevel() {
            return this.level;
        }
    }
}

