/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.CRC32;
import ru.m210projects.Build.Pattern.Tools.NaturalComparator;
import ru.m210projects.Build.filehandle.EntryLoader;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public interface Entry
extends Comparable<Entry> {
    public InputStream getInputStream() throws IOException;

    public String getName();

    public String getExtension();

    public long getSize();

    public boolean exists();

    public Group getParent();

    public void setParent(Group var1);

    default public long getChecksum() {
        return CRC32.getChecksum(this);
    }

    default public boolean isExtension(String fmt) {
        return this.getExtension().equalsIgnoreCase(fmt);
    }

    default public boolean isDirectory() {
        return false;
    }

    default public byte[] getBytes() {
        byte[] data = new byte[(int)this.getSize()];
        if (!this.load(is -> StreamUtils.readBytes(is, data))) {
            return new byte[0];
        }
        return data;
    }

    default public void save(Path path) {
        try (InputStream inputStream = this.getInputStream();
             OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            int len;
            byte[] data = new byte[1024];
            while ((len = inputStream.read(data)) != -1) {
                outputStream.write(data, 0, len);
            }
        }
        catch (Exception e) {
            Console.out.println(String.format("Failed to load entry %s: %s", this.getName(), e), OsdColor.RED);
        }
    }

    default public boolean load(EntryLoader loader) {
        if (this.exists() && this.getSize() > 0L) {
            boolean bl;
            block9: {
                InputStream is = this.getInputStream();
                try {
                    loader.loadEntry(is);
                    bl = true;
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        Console.out.println(String.format("Failed to load entry %s: %s", this.getName(), e), OsdColor.RED);
                    }
                }
                is.close();
            }
            return bl;
        }
        return false;
    }

    @Override
    default public int compareTo(@NotNull Entry f) {
        if (f == null) {
            Entry.$$$reportNull$$$0(0);
        }
        String s1 = this.getName().toLowerCase(Locale.ROOT);
        String s2 = f.getName().toLowerCase(Locale.ROOT);
        return NaturalComparator.compare(s1, s2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "ru/m210projects/Build/filehandle/Entry", "compareTo"));
    }
}

