/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import ru.m210projects.Build.filehandle.fs.FileEntry;

public class FileUtils {
    public static boolean isExtension(String filename, String ext) {
        return filename.endsWith("." + ext);
    }

    public static String getExtension(String filename) {
        if (filename == null || filename.isEmpty()) {
            return null;
        }
        return filename.substring(filename.lastIndexOf(46) + 1);
    }

    public static String getNameWithoutExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (index != -1) {
            return filename.substring(0, filename.lastIndexOf(46));
        }
        return filename;
    }

    public static String getFullName(String path) {
        int index;
        if (path != null && ((index = path.lastIndexOf(File.separator)) != -1 || (index = path.lastIndexOf("\\")) != -1 || (index = path.lastIndexOf("/")) != -1)) {
            path = path.substring(index + 1);
        }
        return path;
    }

    public static String getCorrectPath(String path) {
        if (path != null) {
            String[] separators;
            for (String separator : separators = new String[]{"/", "\\"}) {
                if (separator.equals(File.separator) || !path.contains(separator)) continue;
                path = path.replace(separator, File.separator);
            }
            path = path.replaceAll("(\\\\){2,}", "$1");
        }
        return path;
    }

    public static Path getPath(String path, String ... more) {
        if (path != null) {
            try {
                return Paths.get(FileUtils.getCorrectPath(path), more);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return FileEntry.DUMMY_PATH;
    }
}

