/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle;

import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class StreamUtils {
    public static String readString(InputStream in, int length) throws IOException {
        byte[] buf = StreamUtils.readBytes(in, length);
        for (length = 0; length < buf.length && buf[length] != 0; ++length) {
        }
        return new String(buf, 0, length);
    }

    public static String readDataString(InputStream in) throws IOException {
        int length = StreamUtils.readInt(in);
        if (length == 0) {
            return "";
        }
        if (length > in.available()) {
            throw new EOFException();
        }
        byte[] buf = StreamUtils.readBytes(in, length);
        return new String(buf, 0, length);
    }

    public static int readUnsignedByte(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b;
    }

    public static byte readByte(InputStream in) throws IOException {
        return (byte)StreamUtils.readUnsignedByte(in);
    }

    public static boolean readBoolean(InputStream in) throws IOException {
        return in.read() == 1;
    }

    public static float readFloat(InputStream in) throws IOException {
        return Float.intBitsToFloat(StreamUtils.readInt(in));
    }

    public static long readLong(InputStream in) throws IOException {
        long ch8;
        long ch7;
        long ch6;
        long ch5;
        long ch4;
        long ch3;
        long ch2;
        long ch1 = in.read();
        if ((ch1 | (ch2 = (long)in.read()) | (ch3 = (long)in.read()) | (ch4 = (long)in.read()) | (ch5 = (long)in.read()) | (ch6 = (long)in.read()) | (ch7 = (long)in.read()) | (ch8 = (long)in.read())) < 0L) {
            throw new EOFException();
        }
        return ch1 | ch2 << 8 | ch3 << 16 | ch4 << 24 | ch5 << 32 | ch6 << 40 | ch7 << 48 | ch8 << 56;
    }

    public static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return ch1 | ch2 << 8 | ch3 << 16 | ch4 << 24;
    }

    public static int readUnsignedShort(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return ch1 | ch2 << 8;
    }

    public static short readShort(InputStream in) throws IOException {
        return (short)StreamUtils.readUnsignedShort(in);
    }

    public static byte[] readBytes(InputStream in, int len) throws IOException {
        return StreamUtils.readBytes(in, new byte[len]);
    }

    public static byte[] readBytes(InputStream in, byte[] data, int len) throws IOException {
        int pos = 0;
        while (len > 0) {
            int l = in.read(data, pos, len);
            if (l == -1) {
                throw new EOFException();
            }
            len -= l;
            pos += l;
        }
        return data;
    }

    public static byte[] readBytes(InputStream in, byte[] data) throws IOException {
        return StreamUtils.readBytes(in, data, data.length);
    }

    public static int readBuffer(InputStream is, ByteBuffer buffer) throws IOException {
        int l;
        int len = 0;
        int remaining = buffer.remaining();
        byte[] data = new byte[8192];
        while (remaining > 0 && (l = is.read(data, 0, Math.min(remaining, 8192))) > 0) {
            buffer.put(data, 0, l);
            remaining -= l;
            len += l;
        }
        buffer.rewind();
        return len;
    }

    public static void skip(InputStream in, int n) throws IOException {
        while (n > 0) {
            long i = in.skip(n);
            if (i == 0L) {
                throw new EOFException();
            }
            n -= (int)i;
        }
    }

    public static void writeByte(OutputStream out, int v) throws IOException {
        out.write(v & 0xFF);
    }

    public static void writeInt(OutputStream out, long v) throws IOException {
        out.write((int)(v & 0xFFL));
        out.write((int)(v >>> 8 & 0xFFL));
        out.write((int)(v >>> 16 & 0xFFL));
        out.write((int)(v >>> 24 & 0xFFL));
    }

    public static void writeShort(OutputStream out, int v) throws IOException {
        out.write(v & 0xFF);
        out.write(v >>> 8 & 0xFF);
    }

    public static void writeLong(OutputStream out, long v) throws IOException {
        out.write((int)(v & 0xFFL));
        out.write((int)(v >>> 8 & 0xFFL));
        out.write((int)(v >>> 16 & 0xFFL));
        out.write((int)(v >>> 24 & 0xFFL));
        out.write((int)(v >>> 32 & 0xFFL));
        out.write((int)(v >>> 40 & 0xFFL));
        out.write((int)(v >>> 48 & 0xFFL));
        out.write((int)(v >>> 56 & 0xFFL));
    }

    public static void writeDataString(OutputStream out, String v) throws IOException {
        StreamUtils.writeInt(out, v != null ? (long)v.length() : 0L);
        if (v != null && !v.isEmpty()) {
            StreamUtils.writeString(out, v);
        }
    }

    public static void writeString(OutputStream out, String v) throws IOException {
        out.write(v.getBytes());
    }

    public static void writeString(OutputStream out, String v, int len) throws IOException {
        if (v == null) {
            StreamUtils.writeBytes(out, new byte[len], len);
            return;
        }
        StreamUtils.writeBytes(out, v.getBytes(), len);
    }

    public static void writeBytes(OutputStream out, byte[] data) throws IOException {
        out.write(data);
    }

    public static void writeFloat(OutputStream os, float v) throws IOException {
        StreamUtils.writeInt(os, Float.floatToRawIntBits(v));
    }

    public static void writeBytes(OutputStream out, byte[] data, int len) throws IOException {
        byte[] buf = new byte[len];
        System.arraycopy(data, 0, buf, 0, Math.min(len, data.length));
        out.write(buf);
    }

    public static void writeBoolean(OutputStream out, boolean val) throws IOException {
        out.write(val ? 1 : 0);
    }

    public static void seek(FileOutputStream out, int n) throws IOException {
        FileChannel channel = out.getChannel();
        channel.position(n);
    }
}

