/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle.art;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.AnimType;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.EntryInputStream;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.InputStreamProvider;

public class ArtEntry
implements Entry {
    protected final int num;
    protected final int offset;
    protected final int width;
    protected final int height;
    protected final int sizex;
    protected final int sizey;
    protected int flags;
    private final InputStreamProvider provider;
    protected final int size;

    public ArtEntry(InputStreamProvider provider, int num, int offset, int width, int height, int flags) {
        int sizey;
        int sizex;
        this.provider = provider;
        this.num = num;
        this.offset = offset;
        this.width = width;
        for (sizex = 15; sizex > 1 && Engine.pow2long[sizex] > width; --sizex) {
        }
        this.sizex = sizex;
        this.height = height;
        for (sizey = 15; sizey > 1 && Engine.pow2long[sizey] > height; --sizey) {
        }
        this.sizey = sizey;
        this.flags = flags;
        this.size = width * height;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.provider.newInputStream();
        if (is.skip(this.offset) != (long)this.offset) {
            throw new EOFException();
        }
        return new EntryInputStream(is, this.size);
    }

    public boolean hasSize() {
        return this.size != 0;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getExtension() {
        return "";
    }

    @Override
    public boolean exists() {
        return this.size != 0;
    }

    @Override
    public Group getParent() {
        return null;
    }

    @Override
    public void setParent(Group parent) {
    }

    public int getNum() {
        return this.num;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getSizex() {
        return this.sizex;
    }

    public int getSizey() {
        return this.sizey;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public byte getOffsetX() {
        return (byte)(this.flags >> 8 & 0xFF);
    }

    public byte getOffsetY() {
        return (byte)(this.flags >> 16 & 0xFF);
    }

    public int getAnimFrames() {
        return this.flags & 0x3F;
    }

    public int getAnimSpeed() {
        return this.flags >> 24 & 0xF;
    }

    public AnimType getType() {
        return AnimType.findAnimType(this.flags);
    }

    public void setAnimType(AnimType type) {
        if (type == AnimType.NONE) {
            this.flags &= 0x80FFFFFF;
        }
        this.flags |= type.getBit();
    }

    public void setAnimFrames(int frames) {
        this.flags |= frames & 0x3F;
    }

    public void setAnimSpeed(int speed) {
        this.flags |= (speed & 0xF) << 24;
    }

    public void disableAnimation() {
        this.flags &= 0x8FFFFF00;
    }

    public boolean hasXOffset() {
        return (this.flags & 0xFF00) != 0;
    }

    public boolean hasYOffset() {
        return (this.flags & 0xFF0000) != 0;
    }

    public void setOffset(int x, int y) {
        this.flags &= 0xFF0000FF;
        this.flags |= (x & 0xFF) << 8;
        this.flags |= (y & 0xFF) << 16;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String toString() {
        return String.format("tile %d, %dx%d, size=%d", this.num, this.width, this.height, this.size);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArtEntry)) {
            return false;
        }
        ArtEntry artEntry = (ArtEntry)o;
        return this.num == artEntry.num && this.offset == artEntry.offset && this.width == artEntry.width && this.height == artEntry.height && this.flags == artEntry.flags && this.size == artEntry.size && Objects.equals(this.provider, artEntry.provider);
    }

    public int hashCode() {
        return Objects.hash(this.num, this.offset, this.width, this.height, this.flags, this.provider, this.size);
    }
}

