/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle.art;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.InputStreamProvider;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class ArtFile
implements Group {
    public static final DynamicArtEntry DUMMY_ART_FILE = new DynamicArtEntry(null, Engine.MAXTILES, new byte[0], 0, 0, 0){

        @Override
        public boolean exists() {
            return false;
        }
    };
    protected static final String HEADER = "BUILDART";
    protected final int tileStart;
    protected final String name;
    protected final List<ArtEntry> entries;

    public ArtFile(String name, InputStreamProvider provider) {
        int tileStart;
        List<ArtEntry> entries;
        block12: {
            this.name = name;
            entries = null;
            tileStart = -1;
            try (BufferedInputStream is = new BufferedInputStream(provider.newInputStream());){
                int i;
                int version = this.checkVersion(is);
                if (version == -1) {
                    throw new RuntimeException("Unsupported ART file");
                }
                StreamUtils.readInt(is);
                tileStart = StreamUtils.readInt(is);
                int tileEnd = StreamUtils.readInt(is);
                int numTiles = tileEnd - tileStart + 1;
                entries = new ArrayList(numTiles);
                int[] sizx = new int[numTiles];
                int[] sizy = new int[numTiles];
                int[] flags = new int[numTiles];
                for (i = 0; i < numTiles; ++i) {
                    sizx[i] = StreamUtils.readShort(is);
                }
                for (i = 0; i < numTiles; ++i) {
                    sizy[i] = StreamUtils.readShort(is);
                }
                for (i = 0; i < numTiles; ++i) {
                    flags[i] = StreamUtils.readInt(is);
                }
                int num = tileStart;
                int offset = 16 + (tileEnd - tileStart + 1 << 3);
                for (int i2 = 0; i2 < numTiles; ++i2) {
                    int width = sizx[i2];
                    int height = sizy[i2];
                    ArtEntry entry = this.createArtEntry(provider, num++, offset, width, height, flags[i2]);
                    entries.add(entry);
                    offset += (int)entry.getSize();
                }
            }
            catch (Exception e) {
                Console.out.println("Can't load ART file: " + name + ", " + e, OsdColor.RED);
                if (entries != null) break block12;
                entries = Collections.unmodifiableList(new ArrayList(0));
            }
        }
        this.entries = entries;
        this.tileStart = tileStart;
    }

    protected ArtEntry createArtEntry(InputStreamProvider provider, int num, int offset, int width, int height, int flags) {
        return new ArtEntry(provider, num, offset, width, height, flags);
    }

    @Override
    public int getSize() {
        return this.entries.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Entry getEntry(String fileName) {
        return Directory.DUMMY_ENTRY;
    }

    @Override
    public List<Entry> getEntries() {
        return new ArrayList<Entry>(this.entries);
    }

    public Entry getEntry(int tileNum) {
        int index = tileNum - this.tileStart;
        if (index < 0 || index >= this.entries.size()) {
            return Directory.DUMMY_ENTRY;
        }
        return this.entries.get(index);
    }

    private int checkVersion(InputStream is) throws IOException {
        byte b = StreamUtils.readByte(is);
        if (b == 1) {
            if ((StreamUtils.readByte(is) | StreamUtils.readByte(is) | StreamUtils.readByte(is)) == 0) {
                return 1;
            }
        } else if (b == HEADER.charAt(0)) {
            int c;
            for (c = 1; c < HEADER.length() && HEADER.charAt(c) == StreamUtils.readByte(is); ++c) {
            }
            if (c == HEADER.length()) {
                return StreamUtils.readInt(is);
            }
        }
        return -1;
    }
}

