/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle.grp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.EntryInputStream;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.InputStreamProvider;

public class GrpEntry
implements Entry {
    private final int offset;
    private final int size;
    private final String name;
    private final String extension;
    private final InputStreamProvider provider;
    Group parent;

    public GrpEntry(InputStreamProvider provider, String name, int offset, int size) {
        this.provider = provider;
        this.offset = offset;
        this.size = size;
        this.name = name;
        this.extension = name.contains(".") ? name.substring(name.lastIndexOf(".") + 1).toUpperCase() : "";
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.provider.newInputStream();
        if (is.skip(this.offset) != (long)this.offset) {
            throw new EOFException();
        }
        return new EntryInputStream(is, this.size);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public Group getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Group parent) {
        this.parent = parent;
    }

    public String toString() {
        return String.format("%s size=%d", this.name, this.size);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GrpEntry)) {
            return false;
        }
        GrpEntry grpEntry = (GrpEntry)o;
        return this.offset == grpEntry.offset && this.size == grpEntry.size && Objects.equals(this.name, grpEntry.name) && Objects.equals(this.provider, grpEntry.provider);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.size, this.name, this.provider);
    }
}

