/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle.grp;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Predicate;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.InputStreamProvider;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.grp.GrpEntry;

public class GrpFile
implements Group {
    private static final String GRP_HEADER = "KenSilverman";
    protected final Map<String, Entry> entries;
    private final String name;

    public GrpFile(String name) {
        this.entries = new LinkedHashMap<String, Entry>();
        this.name = name.toUpperCase();
    }

    public GrpFile(String name, InputStreamProvider provider) throws IOException {
        this.name = name.toUpperCase();
        try (BufferedInputStream is = new BufferedInputStream(provider.newInputStream());){
            String header = StreamUtils.readString(is, 12);
            if (header.compareTo(GRP_HEADER) != 0) {
                throw new RuntimeException("GRP header corrupted");
            }
            int numFiles = StreamUtils.readInt(is);
            int headerSize = numFiles + 1 << 4;
            this.entries = new LinkedHashMap<String, Entry>(numFiles);
            if (numFiles != 0) {
                int offset = headerSize;
                for (int i = 0; i < numFiles; ++i) {
                    String fileName = StreamUtils.readString(is, 12);
                    int size = StreamUtils.readInt(is);
                    GrpEntry entry = new GrpEntry(provider, fileName, offset, size);
                    entry.parent = this;
                    this.entries.put(fileName.toUpperCase(), entry);
                    offset += size;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrpEntry addEntry(String name, byte[] data) {
        GrpEntry entry;
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(data, "data");
        GrpFile grpFile = this;
        synchronized (grpFile) {
            entry = new GrpEntry(() -> new ByteArrayInputStream(data), name, -1, data.length);
            entry.parent = this;
            this.entries.put(name.toUpperCase(), entry);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEntry(Entry entry) {
        Objects.requireNonNull(entry, "entry");
        GrpFile grpFile = this;
        synchronized (grpFile) {
            if (entry.exists()) {
                this.entries.put(entry.getName().toUpperCase(), entry);
                entry.setParent(this);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry removeEntry(String name) {
        Entry entry;
        Objects.requireNonNull(name, "name");
        GrpFile grpFile = this;
        synchronized (grpFile) {
            entry = this.entries.remove(name.toUpperCase());
            entry.setParent(Directory.DUMMY_DIRECTORY);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry getEntry(String name) {
        Entry entry;
        Objects.requireNonNull(name, "name");
        GrpFile grpFile = this;
        synchronized (grpFile) {
            entry = this.entries.getOrDefault(name.toUpperCase(), Directory.DUMMY_ENTRY);
        }
        return entry;
    }

    @Override
    public synchronized int getSize() {
        return this.entries.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized List<Entry> getEntries() {
        return new ArrayList<Entry>(this.entries.values());
    }

    public boolean addEntryIf(Entry entry, Predicate<? super Entry> filter) {
        Objects.requireNonNull(filter);
        if (filter.test(entry)) {
            this.addEntry(entry);
            return true;
        }
        return false;
    }

    public boolean save(Path savePath) {
        boolean bl;
        block16: {
            OutputStream os = Files.newOutputStream(savePath, new OpenOption[0]);
            try {
                os.write(GRP_HEADER.getBytes(StandardCharsets.UTF_8));
                StreamUtils.writeInt(os, this.getSize());
                Collection<Entry> files = this.entries.values();
                int maxNameLength = 12;
                byte[] tmpBuf = new byte[8192];
                for (Entry entry : files) {
                    String name = entry.getName();
                    Arrays.fill(tmpBuf, 0, 12, (byte)0);
                    System.arraycopy(name.getBytes(StandardCharsets.UTF_8), 0, tmpBuf, 0, Math.min(name.length(), 12));
                    os.write(tmpBuf, 0, 12);
                    StreamUtils.writeInt(os, entry.getSize());
                }
                for (Entry entry : files) {
                    InputStream is = entry.getInputStream();
                    try {
                        while (is.available() != 0) {
                            int len = is.read(tmpBuf);
                            os.write(tmpBuf, 0, len);
                        }
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                bl = true;
                if (os == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            os.close();
        }
        return bl;
    }

    public String toString() {
        StringJoiner files = new StringJoiner(", ");
        for (Entry e : this.entries.values()) {
            files.add(e.getName());
        }
        return "GrpFile{entries=" + files + '}';
    }
}

