/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle.zip;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.EntryInputStream;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.InputStreamProvider;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.zip.FastZipInputStream;
import ru.m210projects.Build.osd.Console;

public class ZipEntry
implements Entry {
    private final InputStreamProvider provider;
    private final long size;
    private final String name;
    private final String entryName;
    private final String extension;
    private final boolean directory;
    Group parent;
    private byte[] cache;

    public ZipEntry(InputStreamProvider provider, String name, java.util.zip.ZipEntry entry) {
        this.provider = provider;
        this.size = entry.getSize();
        this.entryName = entry.getName();
        this.name = name;
        this.directory = entry.isDirectory();
        this.extension = name.contains(".") ? name.substring(name.lastIndexOf(".") + 1).toUpperCase() : "";
    }

    private EntryInputStream getZipInputStream() throws IOException {
        java.util.zip.ZipEntry entry;
        FastZipInputStream zis = new FastZipInputStream(new BufferedInputStream(this.provider.newInputStream()));
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.getName().equalsIgnoreCase(this.entryName)) {
                return new EntryInputStream(zis, (int)this.size);
            }
            zis.skipEntry();
        }
        return new EntryInputStream(new ByteArrayInputStream(new byte[0]), 0);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.cache == null) {
            this.load();
        }
        return new ByteArrayInputStream(this.cache);
    }

    public void load() {
        if (this.cache != null) {
            return;
        }
        try (EntryInputStream is = this.getZipInputStream();){
            this.cache = StreamUtils.readBytes((InputStream)is, (int)this.size);
        }
        catch (Exception e) {
            Console.out.println(String.format("File %s can't be loaded: %s", this.name, e));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public Group getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Group parent) {
        this.parent = parent;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    public String toString() {
        if (this.directory) {
            return this.name;
        }
        return String.format("%s size=%d", this.name, this.size);
    }
}

