/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle.zip;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.InputStreamProvider;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.filehandle.zip.FastZipInputStream;
import ru.m210projects.Build.filehandle.zip.ZipEntry;

public class ZipFile
implements Group {
    private final Map<String, Entry> entries;
    private final Map<String, ZipFile> directories;
    private final String name;

    private ZipFile(String name) {
        this.name = name;
        this.entries = new LinkedHashMap<String, Entry>();
        this.directories = new LinkedHashMap<String, ZipFile>();
    }

    public ZipFile(String name, InputStreamProvider provider) throws IOException {
        this.name = name;
        try (FastZipInputStream zis = new FastZipInputStream(new BufferedInputStream(provider.newInputStream()));){
            java.util.zip.ZipEntry entry;
            this.entries = new LinkedHashMap<String, Entry>();
            this.directories = new LinkedHashMap<String, ZipFile>();
            while ((entry = zis.getNextEntry()) != null) {
                Path path = FileUtils.getPath(entry.getName(), new String[0]);
                if (path.equals(FileEntry.DUMMY_PATH)) continue;
                Path file = path.getFileName();
                Entry zipEntry = this.newEntry(provider, file.toString(), entry, zis);
                if (path.getParent() == null) {
                    this.entries.put(file.toString().toUpperCase(), zipEntry);
                    zipEntry.setParent(this);
                } else {
                    ZipFile dir = this;
                    for (Path p : path) {
                        if (p.equals(file)) break;
                        String dirName = p.toString();
                        Map<String, ZipFile> directories = dir.directories;
                        String key = dirName.toUpperCase();
                        dir = directories.getOrDefault(key, new ZipFile(dirName));
                        directories.putIfAbsent(key, dir);
                    }
                    dir.entries.put(zipEntry.getName().toUpperCase(), zipEntry);
                    zipEntry.setParent(dir);
                }
                zis.skipEntry();
            }
        }
    }

    protected Entry newEntry(InputStreamProvider provider, String name, java.util.zip.ZipEntry entry, ZipInputStream zis) throws IOException {
        return new ZipEntry(provider, name, entry);
    }

    @Override
    public synchronized int getSize() {
        return this.entries.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Entry getEntry(Path path) {
        ZipFile dir = this;
        Entry result = Directory.DUMMY_ENTRY;
        for (Path p : path) {
            Entry entry = dir.entries.getOrDefault(p.toString().toUpperCase(), Directory.DUMMY_ENTRY);
            if (!entry.exists()) {
                FileEntry fileEntry = Directory.DUMMY_ENTRY;
                if (fileEntry == null) {
                    ZipFile.$$$reportNull$$$0(0);
                }
                return fileEntry;
            }
            if (entry.isDirectory()) {
                dir = dir.directories.getOrDefault(entry.getName().toUpperCase(), this);
            }
            result = entry;
        }
        FileEntry fileEntry = result;
        if (fileEntry == null) {
            ZipFile.$$$reportNull$$$0(1);
        }
        return fileEntry;
    }

    @Override
    @NotNull
    public Entry getEntry(String name) {
        Entry entry = this.getEntry(FileUtils.getPath(name, new String[0]));
        if (entry == null) {
            ZipFile.$$$reportNull$$$0(2);
        }
        return entry;
    }

    private void fillList(ZipFile dir, List<Entry> list) {
        list.addAll(dir.entries.values());
        for (ZipFile zip : dir.directories.values()) {
            this.fillList(zip, list);
        }
    }

    @Override
    public synchronized List<Entry> getEntries() {
        ArrayList<Entry> list = new ArrayList<Entry>();
        this.fillList(this, list);
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/m210projects/Build/filehandle/zip/ZipFile", "getEntry"));
    }
}

