/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.ObjectSet;
import java.util.Arrays;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.InputListener;
import ru.m210projects.Build.input.keymap.ControllerAxis;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.ControllerMapping;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Build.settings.MouseAxis;

public abstract class GameProcessor
implements InputListener {
    public static float keyRepeatInitialTime = 0.4f;
    public static float keyRepeatTime = 0.05f;
    float deltaTime;
    long lastTime;
    protected final BuildGame game;
    protected final boolean[] justPressedGameKeys;
    protected final boolean[] justPressedKeys;
    protected final Vector2 mouseDelta;
    protected final Vector2 moveStick;
    protected final Vector2 lookStick;
    private final Vector2 leftStick;
    private final Vector2 rightStick;
    protected int lastKeyPressed;
    protected boolean[] gameKeyState;
    protected boolean[] keyState;
    protected boolean keyJustPressed;
    float keyRepeatTimer;
    protected ObjectSet<GameKey> mouseAxisKey = new ObjectSet(4);

    public GameProcessor(BuildGame game) {
        this.game = game;
        int lastIndex = Arrays.stream(game.pCfg.getKeymap()).map(GameKey::getNum).max(Integer::compareTo).orElse(0);
        this.gameKeyState = new boolean[lastIndex + 1];
        this.justPressedKeys = new boolean[256];
        this.keyState = new boolean[256];
        this.justPressedGameKeys = new boolean[lastIndex + 1];
        this.mouseDelta = new Vector2();
        this.rightStick = new Vector2();
        this.leftStick = new Vector2();
        this.moveStick = new Vector2();
        this.lookStick = new Vector2();
    }

    public abstract void fillInput(BuildNet.NetInput var1);

    public void processInput(BuildNet.NetInput input) {
        input.reset();
        this.fillInput(input);
        this.prepareNext();
    }

    public void update() {
        GameConfig config;
        InputListener inputListener = this.getInputListener();
        if (inputListener != null) {
            inputListener.processInput(this);
        }
        long thisTime = System.nanoTime();
        this.deltaTime = (float)(thisTime - this.lastTime) / 1.0E9f;
        this.lastTime = thisTime;
        if (this.lastKeyPressed != -1) {
            this.keyRepeatTimer -= this.deltaTime;
            if (this.keyRepeatTimer < 0.0f) {
                this.keyRepeatTimer = keyRepeatTime;
                this.keyRepeat(this.lastKeyPressed);
            }
        }
        if (!(config = this.game.pCfg).getControllerName().isEmpty()) {
            this.updateStickValue(this.moveStick.set(this.leftStick), config.getJoyDeadZone());
            this.updateStickValue(this.lookStick.set(this.rightStick), config.getJoyDeadZone());
            if (config.isJoyInvert()) {
                this.lookStick.y *= -1.0f;
            }
        }
        if (!this.mouseAxisKey.isEmpty()) {
            for (GameKey key : this.mouseAxisKey) {
                this.gameKeyDown(key);
            }
        }
    }

    public void prepareNext() {
        this.mouseDelta.setZero();
        if (this.keyJustPressed) {
            Arrays.fill(this.justPressedGameKeys, false);
            Arrays.fill(this.justPressedKeys, false);
            this.keyJustPressed = false;
        }
        if (!this.mouseAxisKey.isEmpty()) {
            for (GameKey key : this.mouseAxisKey) {
                this.gameKeyUp(key);
            }
            this.mouseAxisKey.clear();
        }
    }

    public boolean isKeyPressed(int keyCode) {
        if (keyCode < 0 || keyCode > this.keyState.length) {
            return false;
        }
        return this.keyState[keyCode];
    }

    public boolean isKeyJustPressed(int key) {
        if (key == -1) {
            return this.keyJustPressed;
        }
        if (key < 0 || key > this.justPressedKeys.length) {
            return false;
        }
        return this.justPressedKeys[key];
    }

    public boolean isGameKeyJustPressed(GameKey gameKey) {
        int key = gameKey.getNum();
        if (key < 0 || key > this.justPressedGameKeys.length) {
            return false;
        }
        return this.justPressedGameKeys[key];
    }

    public boolean isGameKeyPressed(GameKey gameKey) {
        int key = gameKey.getNum();
        if (key < 0 || key >= this.gameKeyState.length) {
            return false;
        }
        return this.gameKeyState[key];
    }

    @Override
    public InputListener getInputListener() {
        Screen screen = this.game.getScreen();
        if (screen instanceof InputListener) {
            return ((InputListener)((Object)screen)).getInputListener();
        }
        if (Console.out.isShowing()) {
            return Console.out;
        }
        return null;
    }

    public void resetPollingStates() {
        this.prepareNext();
        Arrays.fill(this.gameKeyState, false);
        Arrays.fill(this.keyState, false);
        this.leftStick.setZero();
        this.rightStick.setZero();
        this.lastKeyPressed = -1;
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (gameKey.equals(GameKey.UNKNOWN_KEY)) {
            return false;
        }
        int key = gameKey.getNum();
        this.gameKeyState[key] = true;
        this.justPressedGameKeys[key] = true;
        this.keyJustPressed = true;
        return true;
    }

    public void gameKeyUp(GameKey gameKey) {
        if (gameKey.equals(GameKey.UNKNOWN_KEY)) {
            return;
        }
        this.gameKeyState[gameKey.getNum()] = false;
    }

    @Override
    public boolean keyRepeat(int keycode) {
        InputListener inputListener = this.getInputListener();
        return inputListener != null && inputListener.keyRepeat(keycode);
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 0) {
            return false;
        }
        if (this.lastKeyPressed == -1) {
            this.keyRepeatTimer = keyRepeatInitialTime;
            this.lastKeyPressed = keycode;
        }
        this.justPressedKeys[keycode] = true;
        this.keyJustPressed = true;
        this.keyState[keycode] = true;
        GameKey gameKey = this.game.pCfg.convertToGameKey(keycode);
        this.gameKeyDown(gameKey);
        InputListener inputListener = this.getInputListener();
        if (inputListener != null) {
            if (inputListener.gameKeyDown(gameKey)) {
                return true;
            }
            return inputListener.keyDown(keycode);
        }
        return false;
    }

    @Override
    public boolean keyUp(int i) {
        if (i == 0) {
            return false;
        }
        this.lastKeyPressed = -1;
        this.keyState[i] = false;
        this.gameKeyUp(this.game.pCfg.convertToGameKey(i));
        InputListener inputListener = this.getInputListener();
        if (inputListener != null) {
            return inputListener.keyUp(i);
        }
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        this.gameKeyDown(this.game.pCfg.convertToGameKey(226 + button));
        InputListener inputListener = this.getInputListener();
        if (inputListener != null) {
            return inputListener.touchDown(screenX, screenY, pointer, button);
        }
        return true;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        this.gameKeyUp(this.game.pCfg.convertToGameKey(226 + button));
        InputListener inputListener = this.getInputListener();
        if (inputListener != null) {
            return inputListener.touchUp(screenX, screenY, pointer, button);
        }
        return true;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        InputListener inputListener;
        GameKey axisKey;
        this.mouseDelta.add(screenX, screenY);
        if (this.mouseDelta.x != 0.0f && (axisKey = this.game.pCfg.getMouseAxis(this.mouseDelta.x < 0.0f ? MouseAxis.LEFT : MouseAxis.RIGHT)) != GameKey.UNKNOWN_KEY) {
            this.mouseAxisKey.add(axisKey);
        }
        if (this.mouseDelta.y != 0.0f && (axisKey = this.game.pCfg.getMouseAxis(this.mouseDelta.y < 0.0f ? MouseAxis.UP : MouseAxis.DOWN)) != GameKey.UNKNOWN_KEY) {
            this.mouseAxisKey.add(axisKey);
        }
        if ((inputListener = this.getInputListener()) != null) {
            return inputListener.mouseMoved(Gdx.input.getX(), Gdx.input.getY());
        }
        return false;
    }

    @Override
    public boolean scrolled(float amountX, float amount) {
        int keyCode = amount < 0.0f ? 224 : 225;
        this.keyDown(keyCode);
        this.keyUp(keyCode);
        InputListener inputListener = this.getInputListener();
        if (inputListener != null) {
            return inputListener.scrolled(amountX, amount);
        }
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        this.mouseMoved(screenX, screenY);
        InputListener inputListener = this.getInputListener();
        if (inputListener != null) {
            return inputListener.touchDragged(Gdx.input.getX(), Gdx.input.getY(), pointer);
        }
        return false;
    }

    @Override
    public boolean keyTyped(char c) {
        InputListener inputListener = this.getInputListener();
        if (inputListener != null) {
            return inputListener.keyTyped(c);
        }
        return false;
    }

    public float ctrlGetMouseMove() {
        return this.mouseDelta.y * this.getCommonMouseSensitivity() * (float)this.game.pCfg.getgMouseMoveSpeed() / 65536.0f;
    }

    public float ctrlGetMouseLook(boolean invert) {
        float value = this.mouseDelta.y * this.getCommonMouseSensitivity() * (float)this.game.pCfg.getgMouseLookSpeed() / 65536.0f;
        return invert ? -value : value;
    }

    public float ctrlGetMouseTurn() {
        return this.mouseDelta.x * this.getCommonMouseSensitivity() * (float)this.game.pCfg.getgMouseTurnSpeed() / 65536.0f;
    }

    public float ctrlGetMouseStrafe() {
        return this.mouseDelta.x * this.getCommonMouseSensitivity() * (float)this.game.pCfg.getgMouseStrafeSpeed() / 2097152.0f;
    }

    public Vector2 ctrlGetStick(JoyStick stick) {
        if (stick == JoyStick.LOOKING) {
            return this.lookStick;
        }
        return this.moveStick;
    }

    public float getCommonMouseSensitivity() {
        return (float)this.game.pCfg.getSensitivity() / 65536.0f;
    }

    @Override
    public void connected(Controller controller) {
        Console.out.println(String.format("Controller %s is connected", controller.getName()), OsdColor.BLUE);
        if (this.game.pCfg.getControllerName().isEmpty()) {
            this.game.pCfg.setControllerName(controller.getName());
        }
    }

    @Override
    public void disconnected(Controller controller) {
        Console.out.println(String.format("Controller %s is disconnected", controller.getName()), OsdColor.BLUE);
        if (controller.getName().equalsIgnoreCase(this.game.pCfg.getControllerName())) {
            this.game.pCfg.setControllerName("");
        }
    }

    @Override
    public boolean buttonDown(Controller controller, int buttonCode) {
        if (controller.getName().equalsIgnoreCase(this.game.pCfg.getControllerName())) {
            InputListener inputListener = this.getInputListener();
            if (inputListener != null && inputListener.buttonDown(controller, buttonCode)) {
                return true;
            }
            ControllerMapping controllerMapping = this.game.pCfg.getControllerMapping(controller.getName());
            return this.keyDown(controllerMapping.getKeyCode(buttonCode));
        }
        return false;
    }

    @Override
    public boolean buttonUp(Controller controller, int buttonCode) {
        if (controller.getName().equalsIgnoreCase(this.game.pCfg.getControllerName())) {
            InputListener inputListener = this.getInputListener();
            if (inputListener != null && inputListener.buttonUp(controller, buttonCode)) {
                return true;
            }
            ControllerMapping controllerMapping = this.game.pCfg.getControllerMapping(controller.getName());
            return this.keyUp(controllerMapping.getKeyCode(buttonCode));
        }
        return false;
    }

    @Override
    public boolean axisMoved(Controller controller, int axisCode, float value) {
        if (controller.getName().equalsIgnoreCase(this.game.pCfg.getControllerName())) {
            ControllerMapping controllerMapping = this.game.pCfg.getControllerMapping(controller.getName());
            ControllerAxis axis = controllerMapping.getAxis(axisCode);
            switch (axis) {
                case LEFT_STICK_X: {
                    this.leftStick.x = value;
                    break;
                }
                case LEFT_STICK_Y: {
                    this.leftStick.y = value;
                    break;
                }
                case RIGHT_STICK_X: {
                    this.rightStick.x = value;
                    break;
                }
                case RIGHT_STICK_Y: {
                    this.rightStick.y = value;
                }
            }
            InputListener inputListener = this.getInputListener();
            return inputListener != null && inputListener.axisMoved(controller, axisCode, value);
        }
        return false;
    }

    protected void updateStickValue(Vector2 stick, float deadZone) {
        float mag = stick.len();
        if (mag > deadZone) {
            stick.scl(1.0f / mag);
            mag = Math.min(1.0f, mag) - deadZone;
            stick.scl(mag / (1.0f - deadZone));
        } else {
            stick.setZero();
        }
    }

    public static enum JoyStick {
        LOOKING,
        MOVING;

    }
}

