/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.osd;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.m210projects.Build.Render.DummyRenderer;
import ru.m210projects.Build.StringUtils;
import ru.m210projects.Build.Types.collections.LinkedList;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.InputListener;
import ru.m210projects.Build.osd.CommandFinder;
import ru.m210projects.Build.osd.CommandResponse;
import ru.m210projects.Build.osd.ConsoleLogger;
import ru.m210projects.Build.osd.DefaultOsdFunc;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.OsdCommandPrompt;
import ru.m210projects.Build.osd.OsdFunc;
import ru.m210projects.Build.osd.OsdString;
import ru.m210projects.Build.osd.commands.OsdCallback;
import ru.m210projects.Build.osd.commands.OsdCommand;
import ru.m210projects.Build.osd.commands.OsdValue;
import ru.m210projects.Build.osd.commands.OsdValueRange;
import ru.m210projects.Build.osd.commands.RegisterException;
import ru.m210projects.Build.osd.commands.UnknownCommand;
import ru.m210projects.Build.settings.GameKeys;

public class Console
implements InputListener {
    private static final int MAX_LINES = 512;
    private static final OsdCommand UNKNOWN_COMMAND = new UnknownCommand();
    public static Console out = new Console();
    final Map<String, OsdCommand> osdVars;
    OsdFunc func = new DefaultOsdFunc(DummyRenderer.DUMMY_RENDERER);
    private final LinkedList<OsdString> osdTextList = new LinkedList();
    protected final OsdCommandPrompt prompt;
    protected final CommandFinder finder;
    int osdCols = 65;
    int osdTextScale = 65536;
    int osdRowsCur = -1;
    private boolean osdDraw = false;
    private int osdCharacterPos = 0;
    private ListNode<OsdString> osdHead;
    private int osdRows = 20;
    private int osdMaxRows = 20;
    private int osdScroll = 0;
    private long osdScrTime = 0L;
    private OsdColor osdTextPal = OsdColor.DEFAULT;
    private int osdTextShade = 0;
    private ConsoleLogger logger;

    public Console() {
        this.osdVars = new HashMap<String, OsdCommand>();
        this.prompt = new OsdCommandPrompt(512, 32);
        this.prompt.registerDefaultCommands(this);
        this.registerDefaultCommands();
        this.finder = new CommandFinder(this.osdVars);
        this.prompt.setActionListener(input -> {
            if (!input.isEmpty()) {
                this.dispatch(input);
            }
            this.setFirstLine();
        });
    }

    protected void registerDefaultCommands() {
        this.registerCommand(new OsdCallback("osd_color_test", "", args -> {
            int len = 256;
            if (args.length != 0 && StringUtils.isNumeric(args[0])) {
                len = Integer.parseInt(args[0]);
            }
            for (int i = 0; i < len; ++i) {
                out.println(String.format("pal%d: ^%dThe quick brown fox jumps over the lazy dog", i, i));
            }
            return CommandResponse.SILENT_RESPONSE;
        }));
        this.registerCommand(new OsdCommand("help", "lists all registered functions, cvars and aliases"){

            @Override
            public CommandResponse execute(String[] argv) {
                List<String> commands = Console.this.osdVars.keySet().stream().filter(e -> !e.equals(this.getName())).sorted().collect(Collectors.toList());
                if (!commands.isEmpty()) {
                    Console.this.printCommandList(commands, "Symbol listing:", String.format("Found %d symbols", commands.size()));
                    return CommandResponse.SILENT_RESPONSE;
                }
                return CommandResponse.DESCRIPTION_RESPONSE;
            }
        });
        this.registerCommand(new OsdValueRange("osdtextpal", "osdtextpal: sets the palette of the OSD text", 0.0f, 255.0f){

            @Override
            public float getValue() {
                return Console.this.osdTextPal.getPal();
            }

            @Override
            protected void setCheckedValue(float value) {
                Console.this.osdTextPal = OsdColor.findColor((int)value);
            }
        });
        this.registerCommand(new OsdValueRange("osdtextshade", "osdtextshade: sets the shade of the OSD text", 0.0f, 255.0f){

            @Override
            public float getValue() {
                return Console.this.osdTextShade;
            }

            @Override
            protected void setCheckedValue(float value) {
                Console.this.osdTextShade = (int)value;
            }
        });
        this.registerCommand(new OsdValue("osdtextscale", "osdtextscale: sets the OSD text scale", value -> value >= 0.5f){

            @Override
            public float getValue() {
                return (float)Console.this.osdTextScale / 65536.0f;
            }

            @Override
            protected void setCheckedValue(float value) {
                Console.this.setOsdTextScale(value);
            }
        });
        this.registerCommand(new OsdValue("osdrows", "osdrows: sets the number of visible lines of the OSD", value -> value >= 0.0f && value <= (float)this.osdMaxRows){

            @Override
            public float getValue() {
                return Console.this.osdRows;
            }

            @Override
            protected void setCheckedValue(float value) {
                Console.this.osdRows = (int)value;
                Console.this.stopMoving();
            }
        });
    }

    public void setFunc(OsdFunc func) {
        this.func = func;
        this.osdRows = 20;
    }

    public void registerCommand(OsdCommand cmd) {
        cmd.setParent(this);
        String name = cmd.getName();
        if (name.isEmpty()) {
            throw new RegisterException("Can't register null command");
        }
        if (Character.isDigit(name.charAt(0))) {
            throw new RegisterException(String.format("first character of command name \"%s\" must not be a numeral", name));
        }
        for (char ch : name.toCharArray()) {
            if (Character.isLetterOrDigit(ch) || ch == '_') continue;
            throw new RegisterException(String.format("Illegal character in command name \"%s\"", name));
        }
        this.osdVars.put(name, cmd);
    }

    public float getValue(String cmd) {
        OsdCommand command = this.osdVars.getOrDefault(cmd, UNKNOWN_COMMAND);
        if (command instanceof OsdValue) {
            return ((OsdValue)command).getValue();
        }
        return Float.NaN;
    }

    public boolean setValue(String cmd, float value) {
        OsdCommand command = this.osdVars.getOrDefault(cmd, UNKNOWN_COMMAND);
        if (command instanceof OsdValue) {
            return ((OsdValue)command).setValue(value);
        }
        return false;
    }

    public OsdCommandPrompt getPrompt() {
        return this.prompt;
    }

    void dispatch(String text) {
        try {
            if (text.isEmpty()) {
                return;
            }
            String[] argv = text.split(" ");
            OsdCommand command = UNKNOWN_COMMAND;
            if (argv.length > 0) {
                command = this.osdVars.getOrDefault(argv[0], UNKNOWN_COMMAND);
                argv = Arrays.copyOfRange(argv, 1, argv.length);
            }
            switch (command.execute(argv)) {
                case OUT_OF_RANGE: {
                    this.println(String.format("\"%s\" value out of range", command.getName()));
                    break;
                }
                case BAD_ARGUMENT_RESPONSE: {
                    this.println(String.format("\"%s\" wrong value \"%s\"", command.getName(), text.substring(command.getName().length()).trim()));
                    break;
                }
                case SILENT_RESPONSE: {
                    return;
                }
                case OK_RESPONSE: {
                    this.println(text);
                    break;
                }
                case DESCRIPTION_RESPONSE: {
                    this.println(command.getDescription());
                    break;
                }
                case UNKNOWN_RESPONSE: {
                    if (this.func.textHandler(text)) {
                        return;
                    }
                    this.println(String.format("\"%s^O\" is not a valid command or cvar", text), OsdColor.RED);
                }
            }
        }
        catch (Exception e) {
            this.println(e.toString(), OsdColor.RED);
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement element : e.getStackTrace()) {
                sb.append("\t").append(element.toString());
                sb.append("\r\n");
            }
            this.logger.write(sb.toString());
        }
    }

    public boolean isMoving() {
        return this.osdRowsCur != -1 && this.osdRowsCur != this.osdRows;
    }

    public boolean isShowing() {
        return this.osdDraw;
    }

    public void revalidate() {
        this.osdCols = this.func.getcolumnwidth(this.osdTextScale);
        this.osdRows = Math.max(this.osdRows, 1);
        this.osdMaxRows = Math.max(1, this.func.getrowheight(this.osdTextScale) - 2);
        if (this.osdRows < 0 || this.osdRows > this.osdMaxRows) {
            this.osdRows = this.osdMaxRows;
        }
        if (this.osdDraw) {
            this.osdRowsCur = this.osdRows;
        }
        this.prompt.onResize();
        this.osdCharacterPos = 0;
        this.setFirstLine();
    }

    public void draw() {
        if (this.osdRowsCur == 0) {
            boolean bl = this.osdDraw = !this.osdDraw;
        }
        if (this.osdRowsCur == this.osdRows || this.osdRowsCur == this.osdMaxRows) {
            this.osdScroll = 0;
        } else {
            long j;
            if (this.osdRowsCur < this.osdRows && this.osdScroll == 1 || this.osdRowsCur < -1) {
                for (j = this.getTicks() - this.osdScrTime; j > -1L; j -= (long)(200 / this.osdRows)) {
                    ++this.osdRowsCur;
                    if (this.osdRowsCur <= this.osdRows - 1) continue;
                }
            }
            if (this.osdRowsCur > -1 && this.osdScroll == -1 || this.osdRowsCur > this.osdRows) {
                for (j = this.getTicks() - this.osdScrTime; j > -1L; j -= (long)(200 / this.osdRows)) {
                    --this.osdRowsCur;
                    if (this.osdRowsCur >= 1) continue;
                }
            }
            if (this.osdRowsCur == -1 && this.osdScroll == -1) {
                this.osdDraw = false;
            }
            this.osdScrTime = this.getTicks();
        }
        if (!this.osdDraw || this.osdRowsCur <= 0) {
            return;
        }
        this.func.clearbg(this.osdCols, (int)((float)((this.osdRowsCur + 1) * this.osdTextScale) / 65536.0f));
        ListNode<OsdString> node = this.osdHead;
        for (int row = this.osdRowsCur - 2; node != null && row > 0; row -= this.func.drawosdstr(0, row, node.get(), this.osdCols, this.osdTextShade, this.osdTextPal, this.osdTextScale), node = node.getNext()) {
        }
        this.drawPrompt();
    }

    private void drawPrompt() {
        int osdEditShade = this.prompt.osdEditShade;
        int osdPromptShade = this.prompt.osdPromptShade;
        OsdColor osdPromptPal = this.prompt.osdPromptPal;
        OsdColor osdEditPal = this.prompt.osdEditPal;
        OsdColor osdVersionPal = this.prompt.osdVersionPal;
        int ypos = this.osdRowsCur;
        int textScale = this.osdTextScale;
        int shade = osdPromptShade;
        if (shade == 0) {
            shade = this.func.getPulseShade(4);
        }
        if (this.isOnLastLine()) {
            this.func.drawchar(0, ypos, '~', shade, osdPromptPal, textScale);
        } else if (!this.isOnFirstLine()) {
            this.func.drawchar(0, ypos, '^', shade, osdPromptPal, textScale);
        }
        int offset = 0;
        if (this.prompt.isCapsLockPressed()) {
            if (this.isOnFirstLine()) {
                offset = 1;
            }
            this.func.drawchar(offset, ypos, 'C', shade, osdPromptPal, textScale);
        }
        if (this.prompt.isShiftPressed()) {
            offset = 1;
            if (this.prompt.isCapsLockPressed() && this.isOnFirstLine()) {
                offset = 2;
            }
            this.func.drawchar(offset, ypos, 'H', shade, osdPromptPal, textScale);
        }
        offset = 0;
        if (this.prompt.isCapsLockPressed() && this.prompt.isShiftPressed() && this.isOnFirstLine()) {
            offset = 1;
        }
        this.func.drawchar(2 + offset, ypos, '>', shade, osdPromptPal, textScale);
        String inputText = this.prompt.getTextInput();
        int len = Math.min(this.osdCols - 1 - 3 - offset, inputText.length());
        for (int x = len - 1; x >= 0; --x) {
            this.func.drawchar(3 + x + offset, ypos, inputText.charAt(x), osdEditShade << 1, osdEditPal, textScale);
        }
        this.func.drawcursor(offset += 3 + this.prompt.getCursorPosition(), ypos, this.prompt.isOsdOverType(), textScale);
        String osdVersionText = this.prompt.osdVersionText;
        if (osdVersionText != null) {
            int xpos;
            this.func.drawstr(xpos, ypos - (offset >= (xpos = this.osdCols - osdVersionText.length() + 2) ? 1 : 0), osdVersionText, this.func.getPulseShade(4), osdVersionPal, textScale);
        }
    }

    public boolean isCaptured() {
        return this.prompt.isCaptured();
    }

    public void print(String text, OsdColor color) {
        if (text == null || text.isEmpty()) {
            return;
        }
        if (color == this.osdTextPal || color == OsdColor.DEFAULT) {
            System.out.println(text);
        } else {
            System.out.printf("%s%s%s\n", new Object[]{color, text, OsdColor.RESET});
        }
        if (this.logger != null) {
            this.logger.write(text);
        }
        OsdString osdString = this.newLine().get();
        int chp = 0;
        int s = this.osdTextShade;
        int pal = color.getPal();
        do {
            if (text.charAt(chp) == '\n') {
                this.osdCharacterPos = 0;
                osdString = this.newLine().get();
                continue;
            }
            if (text.charAt(chp) == '\r') {
                this.osdCharacterPos = 0;
                continue;
            }
            if (text.charAt(chp) == '\t') {
                for (int i = 0; i < 2; ++i) {
                    osdString.insert(this.osdCharacterPos++, ' ', pal, s);
                }
            } else {
                if (text.charAt(chp) == '^') {
                    char num1;
                    StringBuilder number = new StringBuilder();
                    int pos = chp + 1;
                    if (pos >= text.length()) continue;
                    if (Character.isDigit(num1 = text.charAt(pos++))) {
                        number.append(num1);
                        while (pos < text.length() && Character.isDigit(text.charAt(pos)) && number.length() < 3) {
                            number.append(text.charAt(pos));
                            ++pos;
                        }
                        if (number.length() > 0) {
                            pal = Integer.parseInt(number.toString(), 10);
                            chp = pos - 1;
                            continue;
                        }
                    } else if (num1 == 'S' || num1 == 's') {
                        char num;
                        ++chp;
                        if (Character.isDigit(num = text.charAt(++chp))) {
                            number.append(num);
                            s = Integer.parseInt(number.toString(), 10);
                            continue;
                        }
                    } else if (num1 == 'O' || num1 == 'o') {
                        pal = color.getPal();
                        s = this.osdTextShade;
                        ++chp;
                        continue;
                    }
                }
                osdString.insert(this.osdCharacterPos++, text.charAt(chp), pal, s);
            }
        } while (++chp < text.length());
    }

    public void println(String text) {
        this.print(text, this.osdTextPal);
        this.osdCharacterPos = 0;
    }

    public void println(String text, OsdColor color) {
        this.print(text, color);
        this.osdCharacterPos = 0;
    }

    private ListNode<OsdString> newLine() {
        ListNode<OsdString> last;
        if (this.osdTextList.getSize() < 512) {
            last = new ListNode<OsdString>(this.osdTextList.getSize()){
                final OsdString value;
                {
                    this.value = new OsdString();
                }

                @Override
                public OsdString get() {
                    return this.value;
                }
            };
        } else {
            last = this.osdTextList.removeLast();
            last.get().clear();
        }
        this.osdTextList.addFirst(last);
        this.onPageDown();
        return last;
    }

    void printCommandList(List<String> list, String header, String footer) {
        if (!list.isEmpty()) {
            int maxLength = 0;
            for (String s : list) {
                maxLength = Math.max(maxLength, s.length());
            }
            maxLength += 3;
            this.println(header, OsdColor.RED);
            StringBuilder msg = new StringBuilder();
            int currentLength = 0;
            for (String s : list) {
                msg.append("  ");
                msg.append(s);
                if ((currentLength += maxLength + 2) <= this.osdCols) continue;
                msg.append("\n");
                currentLength = 0;
            }
            this.println(msg.toString());
            this.println(footer, OsdColor.RED);
        }
    }

    public void setOsdTextScale(float value) {
        value = Math.max(0.5f, value);
        boolean isFullscreen = this.osdRowsCur == this.osdMaxRows;
        this.osdTextScale = (int)(value * 65536.0f);
        this.revalidate();
        if (isFullscreen) {
            this.setFullscreen(true);
        } else {
            this.stopMoving();
        }
    }

    public void setFullscreen(boolean fullscreen) {
        this.osdRowsCur = fullscreen ? this.osdMaxRows : -1;
        this.osdDraw = fullscreen;
        this.func.showOsd(fullscreen);
    }

    private void stopMoving() {
        if (this.osdRowsCur != -1) {
            this.osdRowsCur = Math.max(-1, this.osdRows);
        }
    }

    public boolean isOnLastLine() {
        return this.osdHead == this.osdTextList.getLast();
    }

    public boolean isOnFirstLine() {
        return this.osdHead == this.osdTextList.getFirst();
    }

    public void setFirstLine() {
        this.osdHead = this.osdTextList.getFirst();
    }

    public void setLogger(ConsoleLogger logger) {
        this.logger = logger;
    }

    public ConsoleLogger getLogger() {
        return this.logger;
    }

    private long getTicks() {
        return System.currentTimeMillis();
    }

    public void onToggle() {
        this.osdScroll = this.osdDraw ? -1 : 1;
        this.osdRowsCur += this.osdScroll;
        this.prompt.setCaptureInput(!this.osdDraw);
        this.func.showOsd(!this.osdDraw);
        this.osdScrTime = this.getTicks();
    }

    void onClose() {
        this.osdScroll = -1;
        --this.osdRowsCur;
        this.prompt.setCaptureInput(false);
        this.osdScrTime = this.getTicks();
    }

    void onPageUp() {
        if (!this.isOnLastLine() && this.osdHead != null && this.osdHead.getNext() != null) {
            this.osdHead = this.osdHead.getNext();
        }
    }

    void onPageDown() {
        if (!this.isOnFirstLine() && this.osdHead != null && this.osdHead.getPrev() != null) {
            this.osdHead = this.osdHead.getPrev();
        }
    }

    void onFirstPage() {
        this.osdHead = this.osdTextList.getLast();
    }

    void onLastPage() {
        this.osdHead = this.osdTextList.getFirst();
    }

    void onTabPressed() {
        String input = this.prompt.getTextInput();
        if (!this.finder.isListPresent()) {
            List<String> commands = this.finder.getCommands(input);
            if (commands.size() > 1) {
                this.printCommandList(commands, String.format("Found %d possible completions for \"%s\"", commands.size(), input), "Press TAB again to cycle through matches");
            } else if (commands.size() == 1) {
                this.prompt.setTextInput(commands.get(0));
            }
        } else {
            this.prompt.setTextInput(this.finder.getNextTabCommand());
        }
    }

    public void onKeyReleased(int keyId) {
        this.prompt.keyUp(keyId);
    }

    public boolean onKeyPressed(int keyId) {
        if (!this.isCaptured()) {
            return false;
        }
        if (this.prompt.keyDown(keyId)) {
            this.finder.reset();
            return true;
        }
        switch (keyId) {
            case 111: {
                this.onClose();
                return true;
            }
            case 61: {
                this.onTabPressed();
                return true;
            }
            case 123: {
                if (!this.prompt.isCtrlPressed()) break;
                this.onLastPage();
                return true;
            }
            case 3: {
                if (!this.prompt.isCtrlPressed()) break;
                this.onFirstPage();
                return true;
            }
            case 92: {
                this.onPageUp();
                return true;
            }
            case 93: {
                this.onPageDown();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        if (!this.isMoving() && this.prompt.keyTyped(character)) {
            this.finder.reset();
            return true;
        }
        return false;
    }

    @Override
    public boolean keyDown(int keycode) {
        return out.onKeyPressed(keycode);
    }

    @Override
    public boolean keyUp(int keycode) {
        out.onKeyReleased(keycode);
        return true;
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (GameKeys.Show_Console.equals(gameKey)) {
            this.onToggle();
            return true;
        }
        return false;
    }

    @Override
    public boolean scrolled(float amountX, float amount) {
        if (amount < 0.0f) {
            this.onPageUp();
            return true;
        }
        if (amount > 0.0f) {
            this.onPageDown();
            return true;
        }
        return false;
    }
}

