/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.osd;

import java.util.ArrayList;
import java.util.List;

public class ConsoleHistory {
    private final List<String> history;
    private final int depth;
    private int pos;

    public ConsoleHistory(int depth) {
        this.depth = depth;
        this.history = new ArrayList<String>(depth);
    }

    public boolean add(String text) {
        this.pos = -1;
        if (!this.history.isEmpty() && text.equals(this.history.get(0))) {
            return false;
        }
        if (this.history.size() >= this.depth) {
            this.history.remove(this.depth - 1);
        }
        this.history.add(0, text);
        return true;
    }

    public boolean hasPrev() {
        return this.pos < this.history.size() - 1;
    }

    public String prev() {
        if (!this.hasPrev()) {
            if (this.history.isEmpty()) {
                return "";
            }
            return this.history.get(this.pos);
        }
        ++this.pos;
        return this.history.get(this.pos);
    }

    public boolean hasNext() {
        return this.pos > 0;
    }

    public String next() {
        if (!this.hasNext()) {
            this.pos = -1;
            return "";
        }
        --this.pos;
        return this.history.get(this.pos);
    }
}

