/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.settings;

import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.Controllers;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.m210projects.Build.Architecture.common.audio.AudioDriver;
import ru.m210projects.Build.Architecture.common.audio.BuildAudio;
import ru.m210projects.Build.Architecture.common.audio.MidiDevice;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.ConfigContext;
import ru.m210projects.Build.settings.Properties;

public class ApplicationContext
implements ConfigContext {
    private static final String NAME = "ScreenSetup";
    private static final String SOUND_BANKS_SETUP = "SoundBanksSetup";
    protected final transient Map<AudioDriver, BuildAudio> audioDrivers = new LinkedHashMap<AudioDriver, BuildAudio>();
    protected final transient Set<MidiDevice> midiDevices = new LinkedHashSet<MidiDevice>();
    protected final Set<Path> soundBanks = new LinkedHashSet<Path>();
    protected boolean fullscreen = false;
    protected int screenWidth = 320;
    protected boolean borderless = false;
    protected int screenHeight = 200;
    protected Renderer.RenderType renderType = Renderer.RenderType.Polymost;
    protected AudioDriver audioDriver = AudioDriver.DUMMY_AUDIO;
    protected String midiDevice = MidiDevice.DUMMY.getName();
    private ApplicationChangeListener applicationChangeListener = ApplicationChangeListener.DUMMY_LISTENER;
    protected boolean resizable = true;

    @Override
    public void load(Properties prop) {
        if (prop.setContext(SOUND_BANKS_SETUP)) {
            Path path;
            int count = 1;
            String valueName = "SoundBankPath";
            while (!(path = prop.getPathValue(valueName + count++, FileEntry.DUMMY_PATH)).equals(FileEntry.DUMMY_PATH)) {
                this.soundBanks.add(path);
                if (count < 1000) continue;
            }
        }
        if (prop.setContext(NAME)) {
            this.renderType = Renderer.RenderType.parseType(prop.getStringValue("Render", this.renderType.getName()));
            this.audioDriver = AudioDriver.parseType(prop.getStringValue("Audio", this.audioDriver.getName()));
            this.midiDevice = prop.getStringValue("MidiDriver", this.midiDevice);
            this.fullscreen = prop.getBooleanValue("Fullscreen", this.fullscreen);
            this.screenWidth = Math.max(320, prop.getIntValue("ScreenWidth", this.screenWidth));
            this.screenHeight = Math.max(200, prop.getIntValue("ScreenHeight", this.screenHeight));
            this.borderless = prop.getBooleanValue("BorderlessMode", this.borderless);
        }
    }

    public void setControllerListener(GameProcessor processor) {
        Controllers.addListener(processor);
    }

    public List<Controller> getControllers() {
        return Arrays.asList(Controllers.getControllers().toArray(Controller.class));
    }

    public BuildAudio getAudio() {
        return this.audioDrivers.get((Object)this.audioDriver);
    }

    @Override
    public void save(OutputStream outputStream) throws IOException {
        this.putString(outputStream, String.format("[%s]\r\n", SOUND_BANKS_SETUP));
        int count = 1;
        for (MidiDevice device : this.midiDevices) {
            if (!(device instanceof MidiDevice.SoundBank)) continue;
            this.putPath(outputStream, "SoundBankPath" + count++, ((MidiDevice.SoundBank)device).getPath());
        }
        this.putString(outputStream, String.format("[%s]\r\n", NAME));
        this.putString(outputStream, "Render", this.renderType.getName());
        this.putString(outputStream, "Audio", this.audioDriver.getName());
        this.putString(outputStream, "MidiDriver", this.getMidiDevice().getName());
        this.putBoolean(outputStream, "Fullscreen", this.fullscreen);
        this.putInteger(outputStream, "ScreenWidth", this.screenWidth);
        this.putInteger(outputStream, "ScreenHeight", this.screenHeight);
        this.putBoolean(outputStream, "BorderlessMode", this.borderless);
        this.putString(outputStream, ";\r\n;\r\n");
    }

    ApplicationContext init(ApplicationContext frameContext) {
        if (frameContext != null) {
            this.midiDevices.addAll(frameContext.midiDevices);
            this.audioDrivers.putAll(frameContext.audioDrivers);
            this.soundBanks.addAll(frameContext.soundBanks);
            this.audioDriver = frameContext.audioDriver;
            this.midiDevice = frameContext.midiDevice;
            this.fullscreen = frameContext.fullscreen;
            this.screenWidth = frameContext.screenWidth;
            this.screenHeight = frameContext.screenHeight;
            this.borderless = frameContext.borderless;
            this.renderType = frameContext.renderType;
            this.resizable = frameContext.resizable;
        }
        return this;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public void setFullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public void setScreenMode(int width, int height, boolean fullscreen) {
        this.screenWidth = width;
        this.screenHeight = height;
        this.fullscreen = fullscreen;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public boolean isBorderless() {
        return this.borderless;
    }

    public void setBorderless(boolean borderless) {
        this.borderless = borderless;
    }

    public Renderer.RenderType getRenderType() {
        return this.renderType;
    }

    public void setRenderType(Renderer.RenderType renderType) {
        this.renderType = renderType;
        this.applicationChangeListener.onChangeApplication(renderType);
    }

    public AudioDriver getAudioDriver() {
        return this.audioDriver;
    }

    public void setAudioDriver(AudioDriver audioDriver) {
        if (this.audioDrivers.isEmpty()) {
            throw new RuntimeException("No audio drivers registered in config file");
        }
        BuildAudio currentAudio = this.audioDrivers.get((Object)this.audioDriver);
        boolean currentOpened = currentAudio.isOpen();
        if (this.audioDrivers.get((Object)audioDriver).equals(currentAudio) && currentOpened) {
            return;
        }
        if (currentOpened) {
            currentAudio.dispose();
        }
        try {
            this.audioDrivers.get((Object)audioDriver).open();
            this.audioDriver = audioDriver;
        }
        catch (Throwable t) {
            Console.out.println(t.toString(), OsdColor.RED);
            if (currentOpened) {
                try {
                    currentAudio.open();
                    this.audioDriver = currentAudio.getAudioDriver();
                    return;
                }
                catch (Throwable t1) {
                    Console.out.println(t1.toString(), OsdColor.RED);
                }
            }
            this.audioDriver = AudioDriver.DUMMY_AUDIO;
        }
    }

    public Map<String, List<Graphics.DisplayMode>> getResolutions() {
        return new HashMap<String, List<Graphics.DisplayMode>>();
    }

    public void setApplicationChangeListener(ApplicationChangeListener applicationChangeListener) {
        this.applicationChangeListener = applicationChangeListener;
    }

    public Set<Path> getSoundBankPaths() {
        return this.soundBanks;
    }

    public void addSoundBank(MidiDevice.SoundBank soundBank) {
        if (this.midiDevices.contains(soundBank)) {
            return;
        }
        this.midiDevices.add(soundBank);
        this.soundBanks.add(soundBank.getPath());
    }

    public void addMidiDevices(List<MidiDevice> midiDevices) {
        this.midiDevices.addAll(midiDevices);
    }

    public Set<MidiDevice> getMidiDevices() {
        return this.midiDevices;
    }

    public MidiDevice getMidiDevice() {
        return this.midiDevices.stream().filter(e -> e.getName().equalsIgnoreCase(this.midiDevice)).findAny().orElse(MidiDevice.DUMMY);
    }

    public void setMidiDevice(MidiDevice midiDevice) {
        MidiDevice currentMidiDevice = this.getMidiDevice();
        boolean currentOpened = currentMidiDevice.isOpen();
        if (currentMidiDevice.equals(midiDevice) && currentOpened) {
            return;
        }
        if (currentOpened) {
            currentMidiDevice.close();
        }
        if (midiDevice.open()) {
            this.midiDevice = midiDevice.getName();
            return;
        }
        if (currentOpened) {
            currentMidiDevice.open();
        }
    }

    public boolean isRawInputSupported() {
        return false;
    }

    public boolean onRawInputChanged(boolean rawInput) {
        return false;
    }

    public static interface ApplicationChangeListener {
        public static final ApplicationChangeListener DUMMY_LISTENER = renderType -> {};

        public void onChangeApplication(Renderer.RenderType var1);
    }
}

