/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.settings;

import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.controllers.Controller;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.m210projects.Build.Architecture.common.audio.AudioDriver;
import ru.m210projects.Build.Architecture.common.audio.AudioResampler;
import ru.m210projects.Build.Architecture.common.audio.BuildAudio;
import ru.m210projects.Build.Architecture.common.audio.MidiDevice;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.TexFilter;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.ApplicationContext;
import ru.m210projects.Build.settings.AudioContext;
import ru.m210projects.Build.settings.ConfigContext;
import ru.m210projects.Build.settings.ControllerMapping;
import ru.m210projects.Build.settings.InputContext;
import ru.m210projects.Build.settings.MouseAxis;
import ru.m210projects.Build.settings.Properties;
import ru.m210projects.Build.settings.VideoContext;

public abstract class GameConfig
implements ConfigContext {
    public static GameConfig DUMMY_CONFIG = new GameConfig(null){

        @Override
        protected InputContext createDefaultInputContext() {
            return null;
        }

        @Override
        protected ConfigContext createDefaultGameContext() {
            return null;
        }
    };
    public static final int VERSION = 2401;
    protected final Path cfgPath;
    protected ApplicationContext applicationContext;
    protected VideoContext videoContext;
    protected AudioContext audioContext;
    protected final InputContext inputContext;
    protected final ConfigContext gameContext;
    protected Path gamePath = FileEntry.DUMMY_PATH;
    protected boolean startup = true;
    protected boolean autoloadFolder = true;
    protected int gMouseCursor = 0;
    protected int gMouseCursorSize = 65536;
    protected boolean legacyTimer = false;
    protected String pName = "";
    protected String mAddress = "localhost";
    protected int mPort = 23513;

    public GameConfig(Path cfgPath) {
        this.cfgPath = cfgPath;
        this.applicationContext = new ApplicationContext();
        this.videoContext = this.createDefaultVideoContext();
        this.audioContext = new AudioContext();
        this.inputContext = this.createDefaultInputContext();
        this.gameContext = this.createDefaultGameContext();
    }

    public void load() {
        try (FileInputStream is = new FileInputStream(this.cfgPath.toFile());){
            this.load(new Properties(new InputStreamReader(is)));
            return;
        }
        catch (FileNotFoundException e) {
            Console.out.println("File not found: " + this.cfgPath, OsdColor.RED);
        }
        catch (Exception e) {
            e.printStackTrace();
            Console.out.println("Read file error: " + e, OsdColor.RED);
        }
        this.inputContext.resetInput(false);
    }

    protected abstract InputContext createDefaultInputContext();

    protected abstract ConfigContext createDefaultGameContext();

    protected VideoContext createDefaultVideoContext() {
        return new VideoContext();
    }

    @Override
    public void load(Properties prop) {
        int version = 2401;
        if (prop.setContext("Main")) {
            version = prop.getIntValue("ConfigVersion", 0);
            this.startup = prop.getBooleanValue("Startup", this.startup);
            this.autoloadFolder = prop.getBooleanValue("AutoloadFolder", this.autoloadFolder);
            this.gamePath = prop.getPathValue("Path", FileEntry.DUMMY_PATH);
            Console.out.setValue("osdtextscale", prop.getFloatValue("ConsoleTextScale", 1.0f));
            this.gMouseCursor = prop.getIntValue("MouseCursor", this.gMouseCursor);
            this.gMouseCursorSize = prop.getIntValue("MouseCursorSize", this.gMouseCursorSize);
            this.legacyTimer = prop.getBooleanValue("UseLegacyTimer", this.legacyTimer);
            this.pName = prop.getStringValue("Player_name", this.pName);
            this.mAddress = prop.getStringValue("IP_Address", this.mAddress);
            this.mPort = prop.getIntValue("Port", this.mPort);
        }
        this.applicationContext.load(prop);
        if (version == 2401) {
            this.videoContext.load(prop);
            this.audioContext.load(prop);
            this.inputContext.load(prop);
            this.gameContext.load(prop);
        } else {
            this.inputContext.resetInput(false);
        }
    }

    @Override
    public void save(OutputStream os) throws IOException {
        this.putString(os, "[Main]\r\n");
        this.putInteger(os, "ConfigVersion", 2401);
        this.putBoolean(os, "Startup", this.startup);
        this.putBoolean(os, "AutoloadFolder", this.autoloadFolder);
        this.putPath(os, "Path", this.gamePath);
        this.putString(os, ";\r\n");
        this.putFloat(os, "ConsoleTextScale", Console.out.getValue("osdtextscale"));
        this.putInteger(os, "MouseCursor", this.gMouseCursor);
        this.putInteger(os, "MouseCursorSize", this.gMouseCursorSize);
        this.putBoolean(os, "UseLegacyTimer", this.legacyTimer);
        this.putString(os, "Player_name", this.pName);
        this.putString(os, "IP_Address", this.mAddress);
        this.putInteger(os, "Port", this.mPort);
        this.applicationContext.save(os);
        this.videoContext.save(os);
        this.audioContext.save(os);
        this.inputContext.save(os);
        this.gameContext.save(os);
    }

    public boolean isResizable() {
        return this.applicationContext.isResizable();
    }

    public Map<String, List<Graphics.DisplayMode>> getResolutions() {
        return this.applicationContext.getResolutions();
    }

    public void addMidiDevices(List<MidiDevice> midiDevices) {
        this.applicationContext.addMidiDevices(midiDevices);
    }

    public void registerAudioDriver(AudioDriver audioDriver, BuildAudio audio) {
        this.applicationContext.audioDrivers.put(audioDriver, audio);
    }

    public void addSoundBank(MidiDevice.SoundBank soundBank) {
        this.applicationContext.addSoundBank(soundBank);
    }

    public List<MidiDevice> getMidiDevices() {
        return new ArrayList<MidiDevice>(this.applicationContext.getMidiDevices());
    }

    public List<BuildAudio> getAudioDevices() {
        return new ArrayList<BuildAudio>(this.applicationContext.audioDrivers.values());
    }

    public AudioResampler getResampler() {
        return this.audioContext.getResampler();
    }

    public void setResampler(AudioResampler resampler) {
        this.audioContext.setResampler(resampler);
    }

    public GameKey convertToGameKey(int keycode) {
        GameKey gameKey = this.inputContext.arrayPressedKey[keycode];
        if (gameKey != null) {
            return gameKey;
        }
        return GameKey.UNKNOWN_KEY;
    }

    public ControllerMapping getControllerMapping(String controllerName) {
        return this.inputContext.getControllerMapping(controllerName);
    }

    public void resetInput(boolean classicKeys) {
        this.inputContext.resetInput(classicKeys);
    }

    public List<Controller> getControllers() {
        return this.applicationContext.getControllers();
    }

    public String getControllerName() {
        return this.inputContext.getControllerName();
    }

    public void setControllerName(String controllerName) {
        this.inputContext.setControllerName(controllerName);
    }

    public void setVideoContext(VideoContext videoContext) {
        this.videoContext = videoContext.init(this.videoContext);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext.init(this.applicationContext);
    }

    public Path getGamePath() {
        return this.gamePath;
    }

    public void setGamePath(Path gamePath) {
        this.gamePath = gamePath;
    }

    public Path getCfgPath() {
        return this.cfgPath;
    }

    public void bindKey(GameKey gameKey, int keyCode) {
        this.inputContext.bindKey(gameKey, keyCode);
    }

    public void bindMouse(GameKey gameKey, int keyCode) {
        this.inputContext.bindMouse(gameKey, keyCode);
    }

    public void unbindAll(GameKey gameKey) {
        this.inputContext.unbindAll(gameKey);
    }

    public boolean isLegacyTimer() {
        return this.legacyTimer;
    }

    public void setLegacyTimer(boolean legacyTimer) {
        this.legacyTimer = legacyTimer;
    }

    public int getKeyCode(GameKey gameKey, int index) {
        return this.inputContext.getKeyCode(gameKey, index);
    }

    public GameKey[] getKeymap() {
        return this.inputContext.keymap;
    }

    public GameKey getMouseAxis(MouseAxis mouseAxis) {
        GameKey gameKey = this.inputContext.mouseaxis[mouseAxis.ordinal()];
        if (gameKey != null) {
            return gameKey;
        }
        return GameKey.UNKNOWN_KEY;
    }

    public void setMouseAxis(MouseAxis mouseAxis, GameKey key) {
        this.inputContext.mouseaxis[mouseAxis.ordinal()] = key;
    }

    public boolean isStartup() {
        return this.startup;
    }

    public void setStartup(boolean startup) {
        this.startup = startup;
    }

    public boolean isAutoloadFolder() {
        return this.autoloadFolder;
    }

    public void setAutoloadFolder(boolean autoloadFolder) {
        this.autoloadFolder = autoloadFolder;
    }

    public Set<Path> getSoundBankPaths() {
        return this.applicationContext.getSoundBankPaths();
    }

    public boolean isFullscreen() {
        return this.applicationContext.isFullscreen();
    }

    public int getScreenWidth() {
        return this.applicationContext.getScreenWidth();
    }

    public void setScreenMode(int width, int height, boolean fullscreen) {
        this.applicationContext.setScreenMode(width, height, fullscreen);
    }

    public int getScreenHeight() {
        return this.applicationContext.getScreenHeight();
    }

    public boolean isVSync() {
        return this.videoContext.isgVSync();
    }

    public void setgVSync(boolean gVSync) {
        this.videoContext.setgVSync(gVSync);
    }

    public int getFpslimit() {
        return this.videoContext.getFpslimit();
    }

    public void setFpslimit(int fpslimit) {
        this.videoContext.setFpslimit(fpslimit);
    }

    public boolean isBorderless() {
        return this.applicationContext.isBorderless();
    }

    public void setBorderless(boolean borderless) {
        this.applicationContext.setBorderless(borderless);
    }

    public BuildAudio getAudio() {
        return this.applicationContext.getAudio();
    }

    public AudioDriver getAudioDriver() {
        return this.applicationContext.getAudioDriver();
    }

    public void setAudioDriver(AudioDriver audioDriver) {
        this.applicationContext.setAudioDriver(audioDriver);
    }

    public void setAudioContext(AudioContext audioContext) {
        this.audioContext = audioContext.init(this.audioContext);
    }

    public MidiDevice getMidiDevice() {
        return this.applicationContext.getMidiDevice();
    }

    public boolean setMidiDevice(MidiDevice middrv) {
        this.applicationContext.setMidiDevice(middrv);
        MidiDevice currentMidi = this.applicationContext.getMidiDevice();
        if (currentMidi.isOpen()) {
            currentMidi.setMasterVolume(this.audioContext.musicVolume);
        }
        return currentMidi == middrv;
    }

    public int getPaletteGamma() {
        return this.videoContext.getPaletteGamma();
    }

    public void setPaletteGamma(int paletteGamma) {
        this.videoContext.setPaletteGamma(paletteGamma);
    }

    public float getFgamma() {
        return this.videoContext.getFgamma();
    }

    public void setFgamma(float fgamma) {
        this.videoContext.setFgamma(fgamma);
    }

    public float getgFpsScale() {
        return this.videoContext.getgFpsScale();
    }

    public void setgFpsScale(float gFpsScale) {
        this.videoContext.setgFpsScale(gFpsScale);
    }

    public boolean isUseMouse() {
        return this.inputContext.useMouse;
    }

    public void setUseMouse(boolean useMouse) {
        this.inputContext.useMouse = useMouse;
    }

    public boolean isMenuMouse() {
        return this.inputContext.menuMouse;
    }

    public void setMenuMouse(boolean menuMouse) {
        this.inputContext.menuMouse = menuMouse;
    }

    public int getSensitivity() {
        return this.inputContext.gSensitivity;
    }

    public void setgSensitivity(int gSensitivity) {
        this.inputContext.gSensitivity = gSensitivity;
    }

    public int getgMouseTurnSpeed() {
        return this.inputContext.gMouseTurnSpeed;
    }

    public void setgMouseTurnSpeed(int gMouseTurnSpeed) {
        this.inputContext.gMouseTurnSpeed = gMouseTurnSpeed;
    }

    public int getgMouseLookSpeed() {
        return this.inputContext.gMouseLookSpeed;
    }

    public void setgMouseLookSpeed(int gMouseLookSpeed) {
        this.inputContext.gMouseLookSpeed = gMouseLookSpeed;
    }

    public int getgMouseMoveSpeed() {
        return this.inputContext.gMouseMoveSpeed;
    }

    public void setgMouseMoveSpeed(int gMouseMoveSpeed) {
        this.inputContext.gMouseMoveSpeed = gMouseMoveSpeed;
    }

    public int getgMouseStrafeSpeed() {
        return this.inputContext.gMouseStrafeSpeed;
    }

    public void setgMouseStrafeSpeed(int gMouseStrafeSpeed) {
        this.inputContext.gMouseStrafeSpeed = gMouseStrafeSpeed;
    }

    public int getgMouseCursor() {
        return this.gMouseCursor;
    }

    public void setgMouseCursor(int gMouseCursor) {
        this.gMouseCursor = gMouseCursor;
    }

    public int getgMouseCursorSize() {
        return this.gMouseCursorSize;
    }

    public void setgMouseCursorSize(int gMouseCursorSize) {
        this.gMouseCursorSize = gMouseCursorSize;
    }

    public boolean isgMouseAim() {
        return this.inputContext.gMouseAim;
    }

    public void setgMouseAim(boolean gMouseAim) {
        this.inputContext.gMouseAim = gMouseAim;
    }

    public boolean isgInvertmouse() {
        return this.inputContext.gInvertmouse;
    }

    public void setgInvertmouse(boolean gInvertmouse) {
        this.inputContext.gInvertmouse = gInvertmouse;
    }

    public boolean isRawInput() {
        return this.inputContext.isRawInput();
    }

    public void setRawInput(boolean rawInput) {
        this.inputContext.setRawInput(this.isRawInputSupported() && this.applicationContext.onRawInputChanged(rawInput));
    }

    public boolean isRawInputSupported() {
        return this.applicationContext.isRawInputSupported();
    }

    public float getSoundVolume() {
        return this.audioContext.getSoundVolume();
    }

    public void setSoundVolume(float soundVolume) {
        this.audioContext.setSoundVolume(soundVolume);
    }

    public float getMusicVolume() {
        return this.audioContext.getMusicVolume();
    }

    public void setMusicVolume(float musicVolume) {
        this.audioContext.setMusicVolume(musicVolume);
        MidiDevice midiDevice = this.applicationContext.getMidiDevice();
        if (!midiDevice.isOpen()) {
            throw new RuntimeException("Midi device is not opened!");
        }
        midiDevice.setMasterVolume(musicVolume);
    }

    public boolean isNoSound() {
        return this.audioContext.isNoSound();
    }

    public void setNoSound(boolean noSound) {
        this.audioContext.setNoSound(noSound);
    }

    public boolean isMuteMusic() {
        return this.audioContext.isMuteMusic();
    }

    public void setMuteMusic(boolean muteMusic) {
        this.audioContext.setMuteMusic(muteMusic);
    }

    public int getMaxvoices() {
        return this.audioContext.getMaxVoices();
    }

    public boolean setMaxvoices(int maxvoices) {
        return this.audioContext.setMaxVoices(maxvoices);
    }

    public int getMusicType() {
        return this.audioContext.musicType;
    }

    public void setMusicType(int musicType) {
        this.audioContext.musicType = musicType;
    }

    public boolean isPaletteEmulation() {
        return this.videoContext.isPaletteEmulation();
    }

    public void setPaletteEmulation(boolean paletteEmulation) {
        this.videoContext.setPaletteEmulation(paletteEmulation);
    }

    public int getWidescreen() {
        return this.videoContext.isWidescreen() ? 1 : 0;
    }

    public void setWidescreen(int widescreen) {
        this.videoContext.setWidescreen(widescreen == 1);
    }

    public TexFilter getGlfilter() {
        return this.videoContext.getTextureFilter();
    }

    public void setGlfilter(TexFilter glfilter) {
        this.videoContext.setTextureFilter(glfilter);
    }

    public boolean getPaletteFiltered() {
        return this.videoContext.paletteFiltered;
    }

    public void setPaletteFiltered(boolean enabled) {
        this.videoContext.paletteFiltered = enabled;
    }

    public boolean getSoftShading() {
        return this.videoContext.softShading;
    }

    public void setSoftShading(boolean enabled) {
        this.videoContext.softShading = enabled;
    }

    public boolean isgShowFPS() {
        return this.videoContext.isgShowFPS();
    }

    public void setgShowFPS(boolean gShowFPS) {
        this.videoContext.setgShowFPS(gShowFPS);
    }

    public int getgFov() {
        return this.videoContext.getgFov();
    }

    public void setgFov(int gFov) {
        this.videoContext.setgFov(gFov);
    }

    public String getpName() {
        return this.pName;
    }

    public void setpName(String pName) {
        this.pName = pName;
    }

    public String getmAddress() {
        return this.mAddress;
    }

    public void setmAddress(String mAddress) {
        this.mAddress = mAddress;
    }

    public int getPort() {
        return this.mPort;
    }

    public void setPort(int mPort) {
        this.mPort = mPort;
    }

    public Renderer.RenderType getRenderType() {
        return this.applicationContext.getRenderType();
    }

    public void setRenderType(Renderer.RenderType renderType) {
        this.applicationContext.setRenderType(renderType);
    }

    public boolean isUseVoxels() {
        return this.videoContext.isUseVoxels();
    }

    public void setUseVoxels(boolean useVoxels) {
        this.videoContext.setUseVoxels(useVoxels);
    }

    public boolean isDetailMapping() {
        return this.videoContext.isDetailMapping();
    }

    public void setDetailMapping(boolean detailMapping) {
        this.videoContext.setDetailMapping(detailMapping);
    }

    public boolean isGlowMapping() {
        return this.videoContext.isGlowMapping();
    }

    public void setGlowMapping(boolean glowMapping) {
        this.videoContext.setGlowMapping(glowMapping);
    }

    public boolean isUseHighTiles() {
        return this.videoContext.isUseHighTiles();
    }

    public void setUseHighTiles(boolean useHighTiles) {
        this.videoContext.setUseHighTiles(useHighTiles);
    }

    public boolean isUseModels() {
        return this.videoContext.isUseModels();
    }

    public void setUseModels(boolean useModels) {
        this.videoContext.setUseModels(useModels);
    }

    public boolean isAnimSmoothing() {
        return this.videoContext.isAnimSmoothing();
    }

    public void setAnimSmoothing(boolean animSmoothing) {
        this.videoContext.setAnimSmoothing(animSmoothing);
    }

    public boolean isJoyInvert() {
        return this.inputContext.isJoyInvert();
    }

    public void setJoyInvert(boolean value) {
        this.inputContext.setJoyInvert(value);
    }

    public float getJoyLookSpeed() {
        return this.inputContext.getJoyLookSpeed();
    }

    public float getJoyTurnSpeed() {
        return this.inputContext.getJoyTurnSpeed();
    }

    public float getJoyDeadZone() {
        return this.inputContext.getJoyDeadZone();
    }

    public void setJoyDeadZone(float joyDeadZone) {
        this.inputContext.setJoyDeadZone(joyDeadZone);
    }

    public void setJoyTurnSpeed(float joyTurnSpeed) {
        this.inputContext.setJoyTurnSpeed(joyTurnSpeed);
    }

    public void setJoyLookSpeed(float joyLookSpeed) {
        this.inputContext.setJoyLookSpeed(joyLookSpeed);
    }
}

