/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.settings;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.keymap.ControllerAxis;
import ru.m210projects.Build.input.keymap.ControllerButton;
import ru.m210projects.Build.input.keymap.Keymap;
import ru.m210projects.Build.settings.ConfigContext;
import ru.m210projects.Build.settings.ControllerMapping;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Build.settings.MouseAxis;
import ru.m210projects.Build.settings.Properties;

public class InputContext
implements ConfigContext {
    public static final int PRIMARY_KEYS_INDEX = 0;
    public static final int SECONDARY_KEYS_INDEX = 1;
    public static final int MOUSE_KEYS_INDEX = 2;
    public static final int GAMEPAD_KEYS_INDEX = 3;
    protected final int[][] primarykeys;
    final int[] defkeys;
    final int[] defclassickeys;
    protected final GameKey[] keymap;
    GameKey[] arrayPressedKey = new GameKey[256];
    boolean useMouse = true;
    boolean menuMouse = true;
    int gSensitivity = 69632;
    int gMouseTurnSpeed = 65536;
    int gMouseLookSpeed = 65536;
    int gMouseMoveSpeed = 65536;
    int gMouseStrafeSpeed = 131072;
    boolean gMouseAim = true;
    boolean gInvertmouse = false;
    GameKey[] mouseaxis = new GameKey[MouseAxis.values().length];
    boolean rawInput = true;
    String controllerName = "";
    float joyDeadZone = 0.1f;
    float joyTurnSpeed = 2.5f;
    float joyLookSpeed = 1.0f;
    boolean joyInvert = false;
    Map<String, ControllerMapping> controllerMappingMap = new HashMap<String, ControllerMapping>();

    public InputContext(GameKey[] keymap, int[] defkeys, int[] defclassickeys) {
        this.keymap = keymap;
        this.defkeys = defkeys;
        this.defclassickeys = defclassickeys;
        this.primarykeys = new int[4][defkeys.length];
    }

    @Override
    public void load(Properties prop) {
        String name;
        this.clearInput();
        if (prop.setContext("KeyDefinitions")) {
            for (GameKey gameKey : this.keymap) {
                for (int j = 0; j <= 3; ++j) {
                    String keyValue = prop.getStringValue(gameKey.getName(), j, "");
                    int keyCode = Keymap.valueOf(keyValue);
                    if (keyCode == 0) continue;
                    if (j != 2) {
                        this.bindKey(gameKey, keyCode);
                        continue;
                    }
                    this.bindMouse(gameKey, keyCode);
                }
            }
            int menuToggle = GameKeys.Menu_Toggle.getNum();
            if (menuToggle != -1 && this.primarykeys[0][menuToggle] == 0) {
                this.bindKey((GameKey)GameKeys.Menu_Toggle, this.defclassickeys[menuToggle]);
            }
            for (int j = MouseAxis.LEFT.ordinal(); j <= MouseAxis.DOWN.ordinal(); ++j) {
                String keyName = prop.getStringValue("MouseDigitalAxes", j, "N/A");
                this.mouseaxis[j] = Arrays.stream(this.keymap).filter(e -> e.getName().equalsIgnoreCase(keyName)).findFirst().orElse(GameKey.UNKNOWN_KEY);
            }
        } else {
            this.resetInput(false);
        }
        if (prop.setContext("Controls")) {
            this.rawInput = prop.getBooleanValue("RawMouseInput", this.rawInput);
            this.useMouse = prop.getBooleanValue("UseMouse", this.useMouse);
            this.menuMouse = prop.getBooleanValue("UseMouseInMenu", this.menuMouse);
            this.gSensitivity = prop.getIntValue("MouseSensitivity", this.gSensitivity);
            this.gMouseAim = prop.getBooleanValue("MouseAiming", this.gMouseAim);
            this.gInvertmouse = prop.getBooleanValue("MouseAimingFlipped", this.gInvertmouse);
            this.gMouseTurnSpeed = prop.getIntValue("MouseTurnSpeed", this.gMouseTurnSpeed);
            this.gMouseLookSpeed = prop.getIntValue("MouseLookSpeed", this.gMouseLookSpeed);
            this.gMouseMoveSpeed = prop.getIntValue("MouseMoveSpeed", this.gMouseMoveSpeed);
            this.gMouseStrafeSpeed = prop.getIntValue("MouseStrafeSpeed", this.gMouseStrafeSpeed);
            this.controllerName = prop.getStringValue("ControllerName", this.controllerName);
            this.joyTurnSpeed = prop.getFloatValue("JoyTurnSpeed", this.joyTurnSpeed);
            this.joyLookSpeed = prop.getFloatValue("JoyLookSpeed", this.joyLookSpeed);
            this.joyInvert = prop.getBooleanValue("JoyInvertLook", this.joyInvert);
            this.joyDeadZone = prop.getFloatValue("JoyDeadZone", this.joyDeadZone);
        }
        int count = 1;
        String valueName = "ControllerMapping";
        while (prop.setContext("ControllerMapping" + count++) && !(name = prop.getStringValue("ControllerName", "")).isEmpty()) {
            int id;
            ControllerMapping controllerMapping = new ControllerMapping(name);
            for (ControllerAxis controllerAxis : ControllerAxis.values()) {
                id = prop.getIntValue(controllerAxis.name(), -1);
                if (id == -1) continue;
                controllerMapping.putAxis(controllerAxis, id);
            }
            for (Enum enum_ : ControllerButton.values()) {
                id = prop.getIntValue(enum_.name(), -1);
                if (id == -1) continue;
                controllerMapping.putButton((ControllerButton)enum_, id);
            }
            this.controllerMappingMap.put(name.toUpperCase(), controllerMapping);
            if (count < 16) continue;
        }
    }

    @Override
    public void save(OutputStream os) throws IOException {
        this.putString(os, "[KeyDefinitions]\r\n");
        for (GameKey gameKey : this.keymap) {
            StringJoiner keyValue = new StringJoiner(", ");
            for (int j = 0; j <= 3; ++j) {
                keyValue.add("\"" + Keymap.toString(this.primarykeys[j][gameKey.getNum()]) + "\"");
            }
            this.putString(os, gameKey.getName(), keyValue.toString());
        }
        this.putString(os, ";Left, Right, Up, Down\r\n");
        StringJoiner keyValue = new StringJoiner(", ");
        for (int j = MouseAxis.LEFT.ordinal(); j <= MouseAxis.DOWN.ordinal(); ++j) {
            keyValue.add("\"" + this.mouseaxis[j].getName() + "\"");
        }
        this.putString(os, "MouseDigitalAxes", keyValue.toString());
        this.putString(os, ";\r\n");
        this.putString(os, "[Controls]\r\n");
        this.putBoolean(os, "RawMouseInput", this.rawInput);
        this.putBoolean(os, "UseMouse", this.useMouse);
        this.putBoolean(os, "UseMouseInMenu", this.menuMouse);
        this.putInteger(os, "MouseSensitivity", this.gSensitivity);
        this.putBoolean(os, "MouseAiming", this.gMouseAim);
        this.putBoolean(os, "MouseAimingFlipped", this.gInvertmouse);
        this.putInteger(os, "MouseTurnSpeed", this.gMouseTurnSpeed);
        this.putInteger(os, "MouseLookSpeed", this.gMouseLookSpeed);
        this.putInteger(os, "MouseMoveSpeed", this.gMouseMoveSpeed);
        this.putInteger(os, "MouseStrafeSpeed", this.gMouseStrafeSpeed);
        this.putString(os, "ControllerName", this.controllerName);
        this.putFloat(os, "JoyTurnSpeed", this.joyTurnSpeed);
        this.putFloat(os, "JoyLookSpeed", this.joyLookSpeed);
        this.putBoolean(os, "JoyInvertLook", this.joyInvert);
        this.putFloat(os, "JoyDeadZone", this.joyDeadZone);
        this.putString(os, ";\r\n");
        int mappingCount = 1;
        for (String controllerName : this.controllerMappingMap.keySet()) {
            this.putString(os, "[ControllerMapping" + mappingCount + "]\r\n");
            this.putString(os, "ControllerName", controllerName);
            ControllerMapping controllerMapping = this.controllerMappingMap.get(controllerName);
            for (ControllerAxis controllerAxis : ControllerAxis.values()) {
                if (controllerAxis == ControllerAxis.NULL) continue;
                this.putInteger(os, controllerAxis.name(), controllerMapping.getAxisCode(controllerAxis));
            }
            for (Enum enum_ : ControllerButton.values()) {
                if (enum_ == ControllerButton.NULL) continue;
                this.putInteger(os, enum_.name(), controllerMapping.getButtonCode((ControllerButton)enum_));
            }
            ++mappingCount;
        }
        this.putString(os, ";\r\n;\r\n");
    }

    protected void clearInput() {
        Arrays.fill(this.primarykeys[0], -1);
        Arrays.fill(this.primarykeys[1], -1);
        Arrays.fill(this.primarykeys[2], -1);
        Arrays.fill(this.primarykeys[3], -1);
        Arrays.fill(this.arrayPressedKey, GameKey.UNKNOWN_KEY);
        Arrays.fill(this.mouseaxis, GameKey.UNKNOWN_KEY);
    }

    public void resetInput(boolean classicKeys) {
        int[] keys = classicKeys ? this.defclassickeys : this.defkeys;
        this.clearInput();
        for (GameKey gameKey : this.keymap) {
            int num = gameKey.getNum();
            if (num == -1) continue;
            this.bind(gameKey, keys[num], 0);
        }
        this.bindMouse(GameKeys.Weapon_Fire, 226);
        this.bindMouse(GameKeys.Open, 228);
        this.bindMouse(GameKeys.Next_Weapon, 224);
        this.bindMouse(GameKeys.Previous_Weapon, 225);
        this.bindKey((GameKey)GameKeys.Jump, ControllerButton.BUTTON_A);
        this.bindKey((GameKey)GameKeys.Crouch, ControllerButton.BUTTON_B);
        this.bindKey((GameKey)GameKeys.Open, ControllerButton.BUTTON_Y);
        this.bindKey((GameKey)GameKeys.Weapon_Fire, ControllerButton.RIGHT_TRIGGER);
        this.bindKey((GameKey)GameKeys.Menu_Toggle, ControllerButton.START);
        this.bindKey((GameKey)GameKeys.Next_Weapon, ControllerButton.DPAD_UP);
        this.bindKey((GameKey)GameKeys.Previous_Weapon, ControllerButton.DPAD_DOWN);
    }

    public int getKeyCode(GameKey gameKey, int index) {
        return this.primarykeys[index][gameKey.getNum()];
    }

    public void bindKey(GameKey gameKey, int keyCode) {
        if (keyCode == 0) {
            return;
        }
        ControllerButton controllerButton = ControllerButton.valueOf(keyCode);
        if (controllerButton != ControllerButton.NULL) {
            this.bindKey(gameKey, controllerButton);
            return;
        }
        int index = gameKey.getNum();
        if (index == -1) {
            return;
        }
        GameKey oldBindKey = this.getBindKey(keyCode);
        if (oldBindKey != GameKey.UNKNOWN_KEY) {
            if (oldBindKey == gameKey && this.primarykeys[0][index] > 0 && this.primarykeys[1][index] > 0) {
                this.bind(gameKey, keyCode, 0);
                this.unbind(gameKey, 1);
                return;
            }
            this.unbind(keyCode);
        }
        if (this.primarykeys[0][index] <= 0 && this.primarykeys[1][index] <= 0) {
            this.bind(gameKey, keyCode, 0);
        } else {
            this.unbind(gameKey, 1);
            this.bind(gameKey, this.primarykeys[0][index], 1);
            this.bind(gameKey, keyCode, 0);
        }
    }

    public void bindMouse(GameKey gameKey, int keyCode) {
        GameKey oldBindKey = this.getBindKey(keyCode);
        if (oldBindKey != GameKey.UNKNOWN_KEY) {
            this.unbind(keyCode);
        }
        this.bind(gameKey, keyCode, 2);
    }

    protected void bindKey(GameKey gameKey, ControllerButton button) {
        int keyCode = button.getKeyCode();
        GameKey oldBindKey = this.getBindKey(keyCode);
        if (oldBindKey != GameKey.UNKNOWN_KEY) {
            this.unbind(keyCode);
        }
        this.bind(gameKey, keyCode, 3);
    }

    public ControllerMapping getControllerMapping(String controllerName) {
        return this.controllerMappingMap.computeIfAbsent(controllerName.toUpperCase(), e -> new ControllerMapping(controllerName));
    }

    public void unbindAll(GameKey gameKey) {
        for (int j = 0; j <= 3; ++j) {
            this.unbind(gameKey, j);
        }
    }

    public boolean isRawInput() {
        return this.rawInput;
    }

    public void setRawInput(boolean rawInput) {
        this.rawInput = rawInput;
    }

    public float getJoyDeadZone() {
        return this.joyDeadZone;
    }

    public void setJoyDeadZone(float joyDeadZone) {
        this.joyDeadZone = joyDeadZone;
    }

    public float getJoyTurnSpeed() {
        return this.joyTurnSpeed;
    }

    public void setJoyTurnSpeed(float joyTurnSpeed) {
        this.joyTurnSpeed = joyTurnSpeed;
    }

    public float getJoyLookSpeed() {
        return this.joyLookSpeed;
    }

    public void setJoyLookSpeed(float joyLookSpeed) {
        this.joyLookSpeed = joyLookSpeed;
    }

    public boolean isJoyInvert() {
        return this.joyInvert;
    }

    public void setJoyInvert(boolean joyInvert) {
        this.joyInvert = joyInvert;
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public void setControllerName(String controllerName) {
        this.controllerName = controllerName;
    }

    protected GameKey getBindKey(int keyCode) {
        return keyCode != -1 ? this.arrayPressedKey[keyCode] : GameKey.UNKNOWN_KEY;
    }

    protected void unbind(int keyCode) {
        int index = this.getBindKey(keyCode).getNum();
        if (index >= 0) {
            for (int j = 0; j <= 3; ++j) {
                if (this.primarykeys[j][index] != keyCode) continue;
                this.primarykeys[j][index] = -1;
                this.arrayPressedKey[keyCode] = GameKey.UNKNOWN_KEY;
            }
        }
    }

    protected void unbind(GameKey gameKey, int keyIndex) {
        int index = gameKey.getNum();
        int keyCode = this.primarykeys[keyIndex][index];
        if (keyCode > 0) {
            this.primarykeys[keyIndex][index] = -1;
            this.arrayPressedKey[keyCode] = GameKey.UNKNOWN_KEY;
        }
    }

    protected void bind(GameKey gameKey, int keyCode, int keyIndex) {
        int num = gameKey.getNum();
        if (num == -1) {
            return;
        }
        if (keyCode > 0 && keyCode < this.arrayPressedKey.length) {
            this.primarykeys[keyIndex][num] = keyCode;
            this.arrayPressedKey[keyCode] = gameKey;
        }
    }
}

