/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.settings;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.filehandle.FileUtils;

public class Properties {
    private final Map<String, java.util.Properties> contextMap = new HashMap<String, java.util.Properties>();
    private java.util.Properties currentContext = new java.util.Properties();

    public Properties(Reader r) throws IOException {
        try (BufferedReader reader = new BufferedReader(r);){
            String lastContext = "";
            while (reader.ready()) {
                String line = reader.readLine();
                if (this.isContext(line)) {
                    String context = Strhandler.toLowerCase(line.replaceAll("[^a-zA-Z0-9_-]", ""));
                    this.contextMap.put(context, new java.util.Properties());
                    lastContext = context;
                    continue;
                }
                if (lastContext.isEmpty() || line.startsWith(";")) continue;
                if (!line.contains("\\\\")) {
                    line = line.replace("\\", "\\\\");
                }
                this.contextMap.get(lastContext).load(new StringReader(line));
            }
        }
    }

    public Path getPathValue(String key, Path defaultValue) {
        String valuePath = this.getStringValue(key, "");
        if (valuePath.isEmpty()) {
            return defaultValue;
        }
        return FileUtils.getPath(valuePath, new String[0]);
    }

    public boolean getBooleanValue(String key, boolean defaultValue) {
        String s = this.getStringValue(key, "");
        if (!s.isEmpty()) {
            if (s.equalsIgnoreCase("true")) {
                return true;
            }
            if (s.equalsIgnoreCase("false")) {
                return false;
            }
            if (!(s = s.replaceAll("[^0-9-]", "")).isEmpty()) {
                return Integer.parseInt(s) == 1;
            }
        }
        return defaultValue;
    }

    public float getFloatValue(String key, float defaultValue) {
        String s = this.getStringValue(key, "");
        if (!s.isEmpty() && !(s = s.replaceAll("[^0-9-.,]", "")).isEmpty()) {
            return Float.parseFloat(s);
        }
        return defaultValue;
    }

    public int getIntValue(String key, int defaultValue) {
        String s = this.getStringValue(key, "");
        if (!s.isEmpty() && !(s = s.replaceAll("[^0-9-]", "")).isEmpty()) {
            return Integer.parseInt(s);
        }
        return defaultValue;
    }

    public String getStringValue(String key, String defaultValue) {
        String value = this.currentContext.getProperty(key);
        if (value != null) {
            return value.trim();
        }
        for (Map.Entry<Object, Object> entry : this.currentContext.entrySet()) {
            if (!key.equalsIgnoreCase((String)entry.getKey())) continue;
            return ((String)entry.getValue()).trim();
        }
        return defaultValue;
    }

    public String getStringValue(String key, int arrayIndex, String defaultValue) {
        String line = this.getStringValue(key, "");
        if (line.isEmpty()) {
            return defaultValue;
        }
        String[] values = line.split(",");
        if (values.length <= arrayIndex) {
            return defaultValue;
        }
        line = values[arrayIndex];
        line = line.replaceAll("\"", "");
        line = line.trim();
        return line;
    }

    public boolean setContext(String context) {
        context = Strhandler.toLowerCase(context);
        this.currentContext = this.contextMap.getOrDefault(context, new java.util.Properties());
        return !this.currentContext.isEmpty();
    }

    private boolean isContext(String line) {
        return (line = line.trim()).startsWith("[") && line.endsWith("]");
    }
}

